/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.dfaassist;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public enum DfaHint {
    NONE(null),
    ANY_VALUE(null, true),
    TRUE("= true", true),
    FALSE("= false", true),
    NULL("= null", true),
    NPE("[NullPointerException]"),
    NULL_AS_NOT_NULL("[Null passed where not-null expected]"),
    CCE("[ClassCastException]"),
    ASE("[ArrayStoreException]"),
    AIOOBE("[ArrayIndexOutOfBoundsException]"),
    FAIL("[Method will fail]", true);

    private final String myTitle;
    private final boolean myValue;

    private DfaHint(String title) {
        this(title, false);
    }

    private DfaHint(String title, boolean value) {
        this.myTitle = title;
        this.myValue = value;
    }

    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public DfaHint merge(@NotNull DfaHint other) {
        if (other == null) {
            DfaHint.$$$reportNull$$$0(0);
        }
        if (other == this) {
            DfaHint dfaHint = this;
            if (dfaHint == null) {
                DfaHint.$$$reportNull$$$0(1);
            }
            return dfaHint;
        }
        if (this.myValue && other.myValue) {
            DfaHint dfaHint = ANY_VALUE;
            if (dfaHint == null) {
                DfaHint.$$$reportNull$$$0(2);
            }
            return dfaHint;
        }
        if (this.myValue) {
            DfaHint dfaHint = other;
            if (dfaHint == null) {
                DfaHint.$$$reportNull$$$0(3);
            }
            return dfaHint;
        }
        if (other.myValue) {
            DfaHint dfaHint = this;
            if (dfaHint == null) {
                DfaHint.$$$reportNull$$$0(4);
            }
            return dfaHint;
        }
        if (this == CCE && other == NPE || this == NPE && other == CCE) {
            DfaHint dfaHint = NPE;
            if (dfaHint == null) {
                DfaHint.$$$reportNull$$$0(5);
            }
            return dfaHint;
        }
        DfaHint dfaHint = NONE;
        if (dfaHint == null) {
            DfaHint.$$$reportNull$$$0(6);
        }
        return dfaHint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/dfaassist/DfaHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/dfaassist/DfaHint";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

