/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.platform.debugger.impl.ui.DebuggerUIUtilShared;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XDebuggerTreePanel
implements DnDSource {
    private final XDebuggerTree myTree;
    private final JPanel myMainPanel;
    @NotNull
    private final JComponent myContentComponent;

    public XDebuggerTreePanel(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull Disposable parentDisposable, @Nullable XSourcePosition sourcePosition, @NotNull @NonNls String popupActionGroupId, @Nullable XValueMarkers<?, ?> markers) {
        if (project == null) {
            XDebuggerTreePanel.$$$reportNull$$$0(0);
        }
        if (editorsProvider == null) {
            XDebuggerTreePanel.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            XDebuggerTreePanel.$$$reportNull$$$0(2);
        }
        if (popupActionGroupId == null) {
            XDebuggerTreePanel.$$$reportNull$$$0(3);
        }
        this.myTree = new XDebuggerTree(project, editorsProvider, sourcePosition, popupActionGroupId, markers);
        this.myMainPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree), (boolean)true);
        this.myContentComponent = DebuggerUIUtilShared.wrapWithAntiFlickeringPanel((JComponent)scrollPane);
        this.myMainPanel.add((Component)this.myContentComponent, "Center");
        Disposer.register((Disposable)parentDisposable, (Disposable)this.myTree);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                XDebuggerTreePanel.this.myMainPanel.removeAll();
            }
        });
    }

    @NotNull
    public XDebuggerTree getTree() {
        XDebuggerTree xDebuggerTree = this.myTree;
        if (xDebuggerTree == null) {
            XDebuggerTreePanel.$$$reportNull$$$0(4);
        }
        return xDebuggerTree;
    }

    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            XDebuggerTreePanel.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @ApiStatus.Internal
    @NotNull
    public JComponent getContentComponent() {
        JComponent jComponent = this.myContentComponent;
        if (jComponent == null) {
            XDebuggerTreePanel.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    public boolean canStartDragging(DnDAction action, @NotNull Point dragOrigin) {
        if (dragOrigin == null) {
            XDebuggerTreePanel.$$$reportNull$$$0(7);
        }
        return this.getNodesToDrag().length > 0;
    }

    private XValueNodeImpl[] getNodesToDrag() {
        return (XValueNodeImpl[])this.myTree.getSelectedNodes(XValueNodeImpl.class, null);
    }

    public DnDDragStartBean startDragging(DnDAction action, @NotNull Point dragOrigin) {
        if (dragOrigin == null) {
            XDebuggerTreePanel.$$$reportNull$$$0(8);
        }
        return new DnDDragStartBean((Object)this.getNodesToDrag());
    }

    public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin, @NotNull DnDDragStartBean bean) {
        XValueNodeImpl[] nodes;
        if (bean == null) {
            XDebuggerTreePanel.$$$reportNull$$$0(9);
        }
        if ((nodes = this.getNodesToDrag()).length == 1) {
            return DnDAwareTree.getDragImage((Tree)this.myTree, (TreePath)nodes[0].getPath(), (Point)dragOrigin);
        }
        return DnDAwareTree.getDragImage((Tree)this.myTree, (String)XDebuggerBundle.message((String)"xdebugger.drag.text.0.elements", (Object[])new Object[]{nodes.length}), (Point)dragOrigin);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupActionGroupId";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreePanel";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragOrigin";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreePanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canStartDragging";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startDragging";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDraggedImage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

