/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.visualizedtext.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.ui.visualizedtext.TextVisualizerContentType;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedContentTabWithStats;
import com.intellij.xdebugger.impl.ui.visualizedtext.common.JsonEncodingUtil;
import com.intellij.xdebugger.ui.TextValueVisualizer;
import com.intellij.xdebugger.ui.VisualizedContentTab;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/xdebugger/impl/ui/visualizedtext/common/JwtTextVisualizer;", "Lcom/intellij/xdebugger/ui/TextValueVisualizer;", "<init>", "()V", "visualize", "", "Lcom/intellij/xdebugger/ui/VisualizedContentTab;", "value", "", "Lcom/intellij/openapi/util/NlsSafe;", "tryParse", "Lcom/intellij/xdebugger/impl/ui/visualizedtext/common/JwtTextVisualizer$JWT;", "prettify", "jwt", "tryDecodeBase64", "s", "JWT", "intellij.platform.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nJwtTextVisualizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JwtTextVisualizer.kt\ncom/intellij/xdebugger/impl/ui/visualizedtext/common/JwtTextVisualizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class JwtTextVisualizer
implements TextValueVisualizer {
    @NotNull
    public List<VisualizedContentTab> visualize(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JWT jwt = this.tryParse(value);
        if (jwt == null) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new VisualizedContentTabWithStats(this, jwt){
            final /* synthetic */ JwtTextVisualizer this$0;
            final /* synthetic */ JWT $jwt;
            {
                this.this$0 = $receiver;
                this.$jwt = $jwt;
            }

            public String getName() {
                String string = XDebuggerBundle.message((String)"xdebugger.visualized.text.name.jwt", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public String getId() {
                String string = Reflection.getOrCreateKotlinClass(JwtTextVisualizer.class).getQualifiedName();
                Intrinsics.checkNotNull((Object)string);
                return string;
            }

            public TextVisualizerContentType getContentTypeForStats() {
                return TextVisualizerContentType.JWT;
            }

            public String formatText() {
                return JwtTextVisualizer.access$prettify(this.this$0, this.$jwt);
            }

            protected FileType getFileType() {
                FileType fileType = FileTypeManager.getInstance().getStdFileType("JSON");
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getStdFileType(...)");
                return fileType;
            }
        });
    }

    private final JWT tryParse(String value) {
        char[] cArray = new char[]{'.'};
        List parts = StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() != 3) {
            return null;
        }
        JsonNode jsonNode = JwtTextVisualizer.tryParse$parsePart(this, parts, 0);
        if (jsonNode == null) {
            return null;
        }
        JsonNode jsonNode2 = JwtTextVisualizer.tryParse$parsePart(this, parts, 1);
        if (jsonNode2 == null) {
            return null;
        }
        return new JWT(jsonNode, jsonNode2, (String)parts.get(2));
    }

    private final String prettify(JWT jwt) {
        ObjectNode objectNode;
        JsonNodeFactory factory = JsonNodeFactory.instance;
        ObjectNode $this$prettify_u24lambda_u240 = objectNode = factory.objectNode();
        boolean bl = false;
        $this$prettify_u24lambda_u240.set("header", jwt.getHeader());
        $this$prettify_u24lambda_u240.set("payload", jwt.getPayload());
        $this$prettify_u24lambda_u240.put("signature", jwt.getSignature());
        ObjectNode json = objectNode;
        Intrinsics.checkNotNull((Object)json);
        return JsonEncodingUtil.INSTANCE.prettifyJson((JsonNode)json);
    }

    private final String tryDecodeBase64(String s) {
        byte[] byArray;
        try {
            byArray = Base64.decode$default((Base64)Base64.Default.withPadding(Base64.PaddingOption.ABSENT_OPTIONAL), (CharSequence)s, (int)0, (int)0, (int)6, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        byte[] decoded = byArray;
        return new String(decoded, Charsets.UTF_8);
    }

    private static final JsonNode tryParse$parsePart(JwtTextVisualizer this$0, List<String> parts, int i) {
        JsonNode jsonNode;
        String string = this$0.tryDecodeBase64(parts.get(i));
        if (string != null) {
            String it = string;
            boolean bl = false;
            jsonNode = JsonEncodingUtil.INSTANCE.tryParseJson(it);
        } else {
            jsonNode = null;
        }
        return jsonNode;
    }

    public static final /* synthetic */ String access$prettify(JwtTextVisualizer $this, JWT jwt) {
        return $this.prettify(jwt);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004J\n\u0010\u0017\u001a\u00020\u0006H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/xdebugger/impl/ui/visualizedtext/common/JwtTextVisualizer$JWT;", "", "header", "Lcom/fasterxml/jackson/databind/JsonNode;", "payload", "signature", "", "<init>", "(Lcom/fasterxml/jackson/databind/JsonNode;Lcom/fasterxml/jackson/databind/JsonNode;Ljava/lang/String;)V", "getHeader", "()Lcom/fasterxml/jackson/databind/JsonNode;", "getPayload", "getSignature", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.debugger.impl"})
    private static final class JWT {
        @NotNull
        private final JsonNode header;
        @NotNull
        private final JsonNode payload;
        @NotNull
        private final String signature;

        public JWT(@NotNull JsonNode header, @NotNull JsonNode payload, @NotNull String signature) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            this.header = header;
            this.payload = payload;
            this.signature = signature;
        }

        @NotNull
        public final JsonNode getHeader() {
            return this.header;
        }

        @NotNull
        public final JsonNode getPayload() {
            return this.payload;
        }

        @NotNull
        public final String getSignature() {
            return this.signature;
        }

        @NotNull
        public final JsonNode component1() {
            return this.header;
        }

        @NotNull
        public final JsonNode component2() {
            return this.payload;
        }

        @NotNull
        public final String component3() {
            return this.signature;
        }

        @NotNull
        public final JWT copy(@NotNull JsonNode header, @NotNull JsonNode payload, @NotNull String signature) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            return new JWT(header, payload, signature);
        }

        public static /* synthetic */ JWT copy$default(JWT jWT, JsonNode jsonNode, JsonNode jsonNode2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                jsonNode = jWT.header;
            }
            if ((n & 2) != 0) {
                jsonNode2 = jWT.payload;
            }
            if ((n & 4) != 0) {
                string = jWT.signature;
            }
            return jWT.copy(jsonNode, jsonNode2, string);
        }

        @NotNull
        public String toString() {
            return "JWT(header=" + this.header + ", payload=" + this.payload + ", signature=" + this.signature + ")";
        }

        public int hashCode() {
            int result2 = this.header.hashCode();
            result2 = result2 * 31 + this.payload.hashCode();
            result2 = result2 * 31 + this.signature.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JWT)) {
                return false;
            }
            JWT jWT = (JWT)other;
            if (!Intrinsics.areEqual((Object)this.header, (Object)jWT.header)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.payload, (Object)jWT.payload)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.signature, (Object)jWT.signature);
        }
    }
}

