/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.fs;

import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.channels.EelDelicateApi;
import com.intellij.platform.eel.fs.EelFileInfo;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelFsError;
import com.intellij.platform.eel.fs.EelOpenedFile;
import com.intellij.platform.eel.impl.fs.EelFsResultImpl;
import com.intellij.platform.eel.impl.fs.LocalEelFileSystemApiKt;
import com.intellij.platform.eel.impl.fs.NioBasedEelFileSystemApi;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.path.EelPathException;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\"\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0017J*\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001aJ\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u0012H\u0096@\u00a2\u0006\u0002\u0010\u001eJ\"\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020 0\u00122\u0006\u0010!\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010\"J\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020'0\u0012H\u0096@\u00a2\u0006\u0002\u0010\u001eJ\u001a\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020)0\u0012H\u0096@\u00a2\u0006\u0002\u0010\u001eJ*\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020+0\u00122\u0006\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020.H\u0096@\u00a2\u0006\u0002\u0010/J\u001a\u00100\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u0002020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\n8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\u0010R\u0014\u0010#\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u00063"}, d2={"Lcom/intellij/platform/eel/impl/fs/LocalEelOpenedFileWriter;", "Lcom/intellij/platform/eel/fs/EelOpenedFile$Writer;", "eelFs", "Lcom/intellij/platform/eel/impl/fs/NioBasedEelFileSystemApi;", "byteChannel", "Ljava/nio/channels/SeekableByteChannel;", "path_", "Lcom/intellij/platform/eel/path/EelPath;", "isClosed_", "Ljava/util/concurrent/atomic/AtomicReference;", "", "<init>", "(Lcom/intellij/platform/eel/impl/fs/NioBasedEelFileSystemApi;Ljava/nio/channels/SeekableByteChannel;Lcom/intellij/platform/eel/path/EelPath;Ljava/util/concurrent/atomic/AtomicReference;)V", "isClosed", "isClosed$annotations", "()V", "()Ljava/lang/Boolean;", "write", "Lcom/intellij/platform/eel/EelResult;", "", "Lcom/intellij/platform/eel/fs/EelOpenedFile$Writer$WriteError;", "buf", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pos", "", "(Ljava/nio/ByteBuffer;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "flush", "", "Lcom/intellij/platform/eel/fs/EelOpenedFile$Writer$FlushError;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "truncate", "Lcom/intellij/platform/eel/fs/EelOpenedFile$Writer$TruncateError;", "size", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "path", "getPath", "()Lcom/intellij/platform/eel/path/EelPath;", "close", "Lcom/intellij/platform/eel/fs/EelOpenedFile$CloseError;", "tell", "Lcom/intellij/platform/eel/fs/EelOpenedFile$TellError;", "seek", "Lcom/intellij/platform/eel/fs/EelOpenedFile$SeekError;", "offset", "whence", "Lcom/intellij/platform/eel/fs/EelOpenedFile$SeekWhence;", "(JLcom/intellij/platform/eel/fs/EelOpenedFile$SeekWhence;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stat", "Lcom/intellij/platform/eel/fs/EelFileInfo;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$StatError;", "intellij.platform.eel.impl"})
@SourceDebugExtension(value={"SMAP\nLocalEelFileSystemApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalEelFileSystemApi.kt\ncom/intellij/platform/eel/impl/fs/LocalEelOpenedFileWriter\n+ 2 LocalEelFileSystemApi.kt\ncom/intellij/platform/eel/impl/fs/NioBasedEelFileSystemApi\n*L\n1#1,1096:1\n55#2,28:1097\n55#2,28:1125\n55#2,28:1153\n*S KotlinDebug\n*F\n+ 1 LocalEelFileSystemApi.kt\ncom/intellij/platform/eel/impl/fs/LocalEelOpenedFileWriter\n*L\n316#1:1097,28\n321#1:1125,28\n334#1:1153,28\n*E\n"})
final class LocalEelOpenedFileWriter
implements EelOpenedFile.Writer {
    @NotNull
    private final NioBasedEelFileSystemApi eelFs;
    @NotNull
    private final SeekableByteChannel byteChannel;
    @NotNull
    private final EelPath path_;
    @NotNull
    private final AtomicReference<Boolean> isClosed_;
    @NotNull
    private final EelPath path;

    public LocalEelOpenedFileWriter(@NotNull NioBasedEelFileSystemApi eelFs, @NotNull SeekableByteChannel byteChannel, @NotNull EelPath path_, @NotNull AtomicReference<Boolean> isClosed_) {
        Intrinsics.checkNotNullParameter((Object)eelFs, (String)"eelFs");
        Intrinsics.checkNotNullParameter((Object)byteChannel, (String)"byteChannel");
        Intrinsics.checkNotNullParameter((Object)path_, (String)"path_");
        Intrinsics.checkNotNullParameter(isClosed_, (String)"isClosed_");
        this.eelFs = eelFs;
        this.byteChannel = byteChannel;
        this.path_ = path_;
        this.isClosed_ = isClosed_;
        this.path = this.path_;
    }

    @Nullable
    public Boolean isClosed() {
        return this.isClosed_.get();
    }

    @EelDelicateApi
    public static /* synthetic */ void isClosed$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object write(@NotNull ByteBuffer buf, @NotNull Continuation<? super EelResult<Integer, ? extends EelOpenedFile.Writer.WriteError>> $completion) {
        EelResult eelResult;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this.eelFs;
        AtomicReference<Boolean> isClosed$iv = this.isClosed_;
        boolean $i$f$wrapIntoEelResult = false;
        try {
            boolean bl = false;
            Integer n = Boxing.boxInt((int)this.byteChannel.write(buf));
            EelFsResultImpl.Ok<Integer> result$iv = new EelFsResultImpl.Ok<Integer>(n);
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.updateAndGet(NioBasedEelFileSystemApi.wrapIntoEelResult.1.INSTANCE);
            }
            eelResult = (EelResult)result$iv;
        }
        catch (FileSystemException err$iv) {
            EelFsError eelFsError;
            EelFsError err$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath eelPath;
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.set(Boxing.boxBoolean((boolean)true));
            }
            try {
                eelPath = EelPath.Companion.parse(err$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv;
                Iterable<Path> iterable = this_$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv = eelPath;
            FileSystemException fileSystemException = err$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            }
            if (!((eelFsError2 = (err$iv2 = eelFsError3)) instanceof EelOpenedFile.Writer.WriteError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelOpenedFile.Writer.WriteError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelOpenedFile.Writer.WriteError)new EelFsResultImpl.Other(path$iv, err$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object write(@NotNull ByteBuffer buf, long pos, @NotNull Continuation<? super EelResult<Integer, ? extends EelOpenedFile.Writer.WriteError>> $completion) {
        EelResult eelResult;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this.eelFs;
        AtomicReference<Boolean> isClosed$iv = this.isClosed_;
        boolean $i$f$wrapIntoEelResult = false;
        try {
            boolean bl = false;
            long oldPosition = this.byteChannel.position();
            this.byteChannel.position(pos);
            int written = this.byteChannel.write(buf);
            this.byteChannel.position(oldPosition);
            Integer n = Boxing.boxInt((int)written);
            EelFsResultImpl.Ok<Integer> result$iv = new EelFsResultImpl.Ok<Integer>(n);
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.updateAndGet(NioBasedEelFileSystemApi.wrapIntoEelResult.1.INSTANCE);
            }
            eelResult = (EelResult)result$iv;
        }
        catch (FileSystemException err$iv) {
            EelFsError eelFsError;
            EelFsError err$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath eelPath;
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.set(Boxing.boxBoolean((boolean)true));
            }
            try {
                eelPath = EelPath.Companion.parse(err$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv;
                Iterable<Path> iterable = this_$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv = eelPath;
            FileSystemException fileSystemException = err$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            }
            if (!((eelFsError2 = (err$iv2 = eelFsError3)) instanceof EelOpenedFile.Writer.WriteError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelOpenedFile.Writer.WriteError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelOpenedFile.Writer.WriteError)new EelFsResultImpl.Other(path$iv, err$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    @Nullable
    public Object flush(@NotNull Continuation<? super EelResult<Unit, ? extends EelOpenedFile.Writer.FlushError>> $completion) {
        return new EelFsResultImpl.Ok<Unit>(Unit.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object truncate(long size, @NotNull Continuation<? super EelResult<Unit, ? extends EelOpenedFile.Writer.TruncateError>> $completion) {
        EelResult eelResult;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this.eelFs;
        AtomicReference<Boolean> isClosed$iv = this.isClosed_;
        boolean $i$f$wrapIntoEelResult = false;
        try {
            boolean bl = false;
            this.byteChannel.truncate(size);
            Unit unit = Unit.INSTANCE;
            EelFsResultImpl.Ok<Unit> result$iv = new EelFsResultImpl.Ok<Unit>(unit);
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.updateAndGet(NioBasedEelFileSystemApi.wrapIntoEelResult.1.INSTANCE);
            }
            eelResult = (EelResult)result$iv;
        }
        catch (FileSystemException err$iv) {
            EelFsError eelFsError;
            EelFsError err$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath bl;
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.set(Boxing.boxBoolean((boolean)true));
            }
            try {
                bl = EelPath.Companion.parse(err$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv;
                Iterable<Path> iterable = this_$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                bl = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv = bl;
            FileSystemException fileSystemException = err$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            }
            if (!((eelFsError2 = (err$iv2 = eelFsError3)) instanceof EelOpenedFile.Writer.TruncateError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelOpenedFile.Writer.TruncateError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelOpenedFile.Writer.TruncateError)new EelFsResultImpl.Other(path$iv, err$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    @NotNull
    public EelPath getPath() {
        return this.path;
    }

    @Nullable
    public Object close(@NotNull Continuation<? super EelResult<Unit, ? extends EelOpenedFile.CloseError>> $completion) {
        this.isClosed_.set(Boxing.boxBoolean((boolean)true));
        return LocalEelFileSystemApiKt.access$doClose(this.eelFs, this.byteChannel, this.path_);
    }

    @Nullable
    public Object tell(@NotNull Continuation<? super EelResult<Long, ? extends EelOpenedFile.TellError>> $completion) {
        return LocalEelFileSystemApiKt.access$doTell(this.eelFs, this.byteChannel, this.isClosed_);
    }

    @Nullable
    public Object seek(long offset, @NotNull EelOpenedFile.SeekWhence whence, @NotNull Continuation<? super EelResult<Long, ? extends EelOpenedFile.SeekError>> $completion) {
        return LocalEelFileSystemApiKt.access$doSeek(this.eelFs, this.byteChannel, this.path_, whence, offset, this.isClosed_);
    }

    @Nullable
    public Object stat(@NotNull Continuation<? super EelResult<? extends EelFileInfo, ? extends EelFileSystemApi.StatError>> $completion) {
        return this.eelFs.stat(this.path_, EelFileSystemApi.SymlinkPolicy.RESOLVE_AND_FOLLOW, $completion);
    }
}

