/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.jvm;

import com.jetbrains.fus.reporting.FileHandle;
import com.jetbrains.fus.reporting.FileStorageMode;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001b\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\u001fH\u0016J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u001fH\u0016R#\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR#\u0010\u000e\u001a\n \t*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/fus/reporting/jvm/JvmFileHandle;", "Lcom/jetbrains/fus/reporting/FileHandle;", "path", "Ljava/nio/file/Path;", "mode", "Lcom/jetbrains/fus/reporting/FileStorageMode;", "(Ljava/nio/file/Path;Lcom/jetbrains/fus/reporting/FileStorageMode;)V", "channel", "Ljava/nio/channels/FileChannel;", "kotlin.jvm.PlatformType", "getChannel", "()Ljava/nio/channels/FileChannel;", "channel$delegate", "Lkotlin/Lazy;", "memoryMapped", "Ljava/nio/MappedByteBuffer;", "getMemoryMapped", "()Ljava/nio/MappedByteBuffer;", "memoryMapped$delegate", "randomAccessFile", "Ljava/io/RandomAccessFile;", "close", "", "exists", "", "length", "", "read", "", "index", "", "", "dstBuffer", "readAll", "write", "bytes", "Companion", "api-jvm-defaults"})
public final class JvmFileHandle
implements FileHandle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    @NotNull
    private final RandomAccessFile randomAccessFile;
    @NotNull
    private final Lazy channel$delegate;
    @NotNull
    private final Lazy memoryMapped$delegate;

    public JvmFileHandle(@NotNull Path path, @NotNull FileStorageMode mode) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.path = path;
        this.randomAccessFile = new RandomAccessFile(this.path.toFile(), JvmFileHandle.Companion.toRandomAccessString(mode));
        this.channel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FileChannel>(this){
            final /* synthetic */ JvmFileHandle this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final FileChannel invoke() {
                return JvmFileHandle.access$getRandomAccessFile$p(this.this$0).getChannel();
            }
        }));
        this.memoryMapped$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MappedByteBuffer>(this){
            final /* synthetic */ JvmFileHandle this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final MappedByteBuffer invoke() {
                return JvmFileHandle.access$getChannel(this.this$0).map(FileChannel.MapMode.READ_ONLY, 0L, this.this$0.length());
            }
        }));
    }

    private final FileChannel getChannel() {
        Lazy lazy = this.channel$delegate;
        return (FileChannel)lazy.getValue();
    }

    private final MappedByteBuffer getMemoryMapped() {
        Lazy lazy = this.memoryMapped$delegate;
        return (MappedByteBuffer)lazy.getValue();
    }

    @Override
    public void close() {
        this.getChannel().close();
    }

    @Override
    public boolean exists() {
        return this.path.toFile().exists();
    }

    @Override
    public long length() {
        return this.randomAccessFile.length();
    }

    @Override
    @NotNull
    public byte[] readAll() {
        File file = this.path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path.toFile()");
        return FilesKt.readBytes((File)file);
    }

    @Override
    @NotNull
    public byte[] read(int index, @NotNull byte[] dstBuffer) {
        Intrinsics.checkNotNullParameter((Object)dstBuffer, (String)"dstBuffer");
        int n = dstBuffer.length;
        for (int i = 0; i < n; ++i) {
            dstBuffer[i] = this.getMemoryMapped().get(index + i);
        }
        return dstBuffer;
    }

    @Override
    public byte read(int index) {
        return this.getMemoryMapped().get(index);
    }

    @Override
    public void write(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.randomAccessFile.write(bytes);
    }

    public static final /* synthetic */ RandomAccessFile access$getRandomAccessFile$p(JvmFileHandle $this) {
        return $this.randomAccessFile;
    }

    public static final /* synthetic */ FileChannel access$getChannel(JvmFileHandle $this) {
        return $this.getChannel();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/fus/reporting/jvm/JvmFileHandle$Companion;", "", "()V", "toRandomAccessString", "", "Lcom/jetbrains/fus/reporting/FileStorageMode;", "api-jvm-defaults"})
    public static final class Companion {
        private Companion() {
        }

        private final String toRandomAccessString(FileStorageMode $this$toRandomAccessString) {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[$this$toRandomAccessString.ordinal()]) {
                case 1: {
                    string = "r";
                    break;
                }
                case 2: {
                    string = "rw";
                    break;
                }
                case 3: {
                    string = "rwd";
                    break;
                }
                case 4: {
                    string = "rws";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FileStorageMode.values().length];
                try {
                    nArray[FileStorageMode.READ.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FileStorageMode.READ_WRITE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FileStorageMode.READ_WRITE_SYNC_CONTENT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FileStorageMode.READ_WRITE_SYNC_CONTENT_AND_METADATA.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

