/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyCellUtil {
    public static final String[] CELL_SEPARATORS = new String[]{"# %%", "#%%", "# <codecell>", "# In[", "# COMMAND ----------"};

    public static boolean hasCells(@NotNull PsiFile file) {
        if (file == null) {
            PyCellUtil.$$$reportNull$$$0(0);
        }
        for (PsiElement el = file.getFirstChild(); el != null; el = el.getNextSibling()) {
            if (!PyCellUtil.isBlockCell(el)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiElement getCellStart(@NotNull PsiElement element2) {
        if (element2 == null) {
            PyCellUtil.$$$reportNull$$$0(1);
        }
        PsiElement el = element2;
        while (el != null && !PyCellUtil.isBlockCell(el)) {
            el = PsiTreeUtil.prevLeaf((PsiElement)el);
        }
        if (el == null) {
            return element2.getContainingFile().getFirstChild();
        }
        return PsiTreeUtil.nextLeaf((PsiElement)el);
    }

    public static boolean isBlockDefinition(String text) {
        for (String separator : CELL_SEPARATORS) {
            if (!text.startsWith(separator)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockCell(PsiElement element2) {
        return element2 instanceof PsiComment && PyCellUtil.isBlockDefinition(element2.getText());
    }

    @NotNull
    public static String getCodeInCell(@Nullable PsiElement element2) {
        StringBuilder text = new StringBuilder();
        while (element2 != null && !PyCellUtil.isBlockCell(element2)) {
            text.append(element2.getText());
            element2 = element2.getNextSibling();
        }
        String string = StringUtil.trim((String)text.toString());
        if (string == null) {
            PyCellUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static CellRange getCellTextRangeIncludingSeparators(@NotNull PsiElement element2) {
        if (element2 == null) {
            PyCellUtil.$$$reportNull$$$0(3);
        }
        PsiElement el = element2;
        while (el != null && !PyCellUtil.isBlockCell(el)) {
            el = PsiTreeUtil.prevLeaf((PsiElement)el);
        }
        int startOffset = el == null ? element2.getContainingFile().getFirstChild().getTextOffset() : el.getTextRange().getStartOffset();
        PsiElement nextCell = PyCellUtil.findNextCell(element2);
        int endOffset = nextCell == null ? element2.getContainingFile().getLastChild().getTextRange().getEndOffset() : nextCell.getTextRange().getStartOffset();
        return new CellRange(new TextRange(startOffset, endOffset), nextCell == null);
    }

    @Nullable
    public static PsiElement findNextCell(PsiElement startElement) {
        PsiElement el = PsiTreeUtil.nextLeaf((PsiElement)PsiTreeUtil.getDeepestFirst((PsiElement)startElement));
        while (el != null) {
            if (PyCellUtil.isBlockCell(el)) {
                return el;
            }
            el = PsiTreeUtil.nextLeaf((PsiElement)el);
        }
        return null;
    }

    @Nullable
    public static PsiElement findSeparatorOfPrevCell(PsiElement startElement) {
        PsiElement currentCellSeparator = PsiTreeUtil.prevLeaf((PsiElement)PsiTreeUtil.getDeepestFirst((PsiElement)startElement));
        while (currentCellSeparator != null && !PyCellUtil.isBlockCell(currentCellSeparator)) {
            currentCellSeparator = PsiTreeUtil.prevLeaf((PsiElement)currentCellSeparator);
        }
        if (currentCellSeparator == null) {
            return null;
        }
        return PyCellUtil.findPrevCell(currentCellSeparator);
    }

    @Nullable
    public static PsiElement findPrevCell(PsiElement startElement) {
        PsiElement el = PsiTreeUtil.prevLeaf((PsiElement)PsiTreeUtil.getDeepestFirst((PsiElement)startElement));
        while (el != null) {
            if (PyCellUtil.isBlockCell(el)) {
                return el;
            }
            el = PsiTreeUtil.prevLeaf((PsiElement)el);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PyCellUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PyCellUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeInCell";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasCells";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCellStart";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCellTextRangeIncludingSeparators";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static final class CellRange {
        public final TextRange textRange;
        public final Boolean lastCell;

        public CellRange(TextRange textRange, Boolean lastCell) {
            this.textRange = textRange;
            this.lastCell = lastCell;
        }
    }
}

