/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurationKt;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.jetbrains.python.configuration.PythonLocalInterpreterConfigurable;
import com.jetbrains.python.configuration.PythonTargetInterpreterDetailsConfigurable;
import com.jetbrains.python.configuration.UnsupportedPythonInterpreterConfigurable;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import com.jetbrains.python.target.PythonLanguageRuntimeConfiguration;
import com.jetbrains.python.target.PythonLanguageRuntimeType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0001H\u0002\u00a8\u0006\u000b"}, d2={"createPythonInterpreterConfigurable", "Lcom/intellij/openapi/options/Configurable;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "parentConfigurable", "sdkAdditionalData", "Lcom/jetbrains/python/target/PyTargetAwareAdditionalData;", "intellij.python.community.impl"})
public final class PythonInterpreterDetailsConfigurablesKt {
    @NotNull
    public static final Configurable createPythonInterpreterConfigurable(@NotNull Project project, @Nullable Module module2, @NotNull Sdk sdk2, @NotNull Configurable parentConfigurable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)parentConfigurable, (String)"parentConfigurable");
        SdkAdditionalData sdkAdditionalData = sdk2.getSdkAdditionalData();
        return !PythonSdkUtil.isRemote((Sdk)sdk2) ? (Configurable)new PythonLocalInterpreterConfigurable(project, module2, sdk2) : (sdkAdditionalData instanceof PyTargetAwareAdditionalData ? PythonInterpreterDetailsConfigurablesKt.createPythonInterpreterConfigurable(project, sdk2, (PyTargetAwareAdditionalData)sdkAdditionalData, parentConfigurable) : (Configurable)new UnsupportedPythonInterpreterConfigurable(sdk2));
    }

    private static final Configurable createPythonInterpreterConfigurable(Project project, Sdk sdk2, PyTargetAwareAdditionalData sdkAdditionalData, Configurable parentConfigurable) {
        Configurable configurable;
        Configurable targetConfigurable;
        TargetEnvironmentType targetType;
        TargetEnvironmentConfiguration targetEnvironmentConfiguration;
        TargetEnvironmentConfiguration targetEnvironmentConfiguration2 = targetEnvironmentConfiguration = sdkAdditionalData.getTargetEnvironmentConfiguration();
        TargetEnvironmentType targetEnvironmentType = targetType = targetEnvironmentConfiguration2 != null ? TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)targetEnvironmentConfiguration2) : null;
        Configurable configurable2 = targetConfigurable = targetEnvironmentType != null ? targetEnvironmentType.createConfigurable(project, targetEnvironmentConfiguration, (LanguageRuntimeType)PythonLanguageRuntimeType.Companion.getInstance(), parentConfigurable) : null;
        if (targetConfigurable != null) {
            PythonLanguageRuntimeConfiguration pythonLanguageRuntimeConfiguration = new PythonLanguageRuntimeConfiguration();
            String string = sdkAdditionalData.getInterpreterPath();
            if (string == null) {
                string = "";
            }
            pythonLanguageRuntimeConfiguration.setPythonInterpreterPath(string);
            configurable = (Configurable)new PythonTargetInterpreterDetailsConfigurable(project, sdk2, sdkAdditionalData, targetConfigurable);
        } else {
            configurable = (Configurable)new UnsupportedPythonInterpreterConfigurable(sdk2);
        }
        return configurable;
    }
}

