/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMapper;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.console.PyConsoleCustomizer;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleType;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevConsoleRunnerFactory;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PydevConsoleRunnerUtil;
import com.jetbrains.python.console.PydevConsoleWithFileRunnerImpl;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.console.ReplaceSubstringsFunction;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.EnvironmentController;
import com.jetbrains.python.run.PlainEnvironmentController;
import com.jetbrains.python.run.PythonConsoleScripts;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.TargetedPythonPaths;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.run.target.PathMapping;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0014J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/console/PydevConsoleRunnerFactory;", "Lcom/jetbrains/python/console/PythonConsoleRunnerFactory;", "<init>", "()V", "createConsoleParameters", "Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConsoleParameters;", "project", "Lcom/intellij/openapi/project/Project;", "contextModule", "Lcom/intellij/openapi/module/Module;", "createConsoleRunner", "Lcom/jetbrains/python/console/PydevConsoleRunner;", "createConsoleRunnerWithFile", "config", "Lcom/jetbrains/python/run/PythonRunConfiguration;", "ConsoleParameters", "ConstantConsoleParameters", "TargetedConsoleParameters", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPydevConsoleRunnerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PydevConsoleRunnerFactory.kt\ncom/jetbrains/python/console/PydevConsoleRunnerFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1#2:212\n*E\n"})
public class PydevConsoleRunnerFactory
extends PythonConsoleRunnerFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected ConsoleParameters createConsoleParameters(@NotNull Project project, @Nullable Module contextModule) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        com.intellij.openapi.util.Pair<Sdk, Module> sdkAndModule = PydevConsoleRunnerUtil.findPythonSdkAndModule(project, contextModule);
        Module module2 = (Module)sdkAndModule.second;
        Sdk sdk2 = (Sdk)sdkAndModule.first;
        PyConsoleOptions.PyConsoleSettings pyConsoleSettings = PyConsoleOptions.getInstance(project).getPythonConsoleSettings();
        Intrinsics.checkNotNullExpressionValue((Object)pyConsoleSettings, (String)"getPythonConsoleSettings(...)");
        PyConsoleOptions.PyConsoleSettings settingsProvider = pyConsoleSettings;
        PyRemotePathMapper pathMapper = PydevConsoleRunnerUtil.getPathMapper(project, sdk2, settingsProvider);
        Map<String, String> map2 = settingsProvider.getEnvs();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getEnvs(...)");
        Map envs = MapsKt.toMutableMap(map2);
        Companion.putIPythonEnvFlag(project, envs);
        Function<TargetEnvironment, String> workingDirFunction = Companion.getWorkingDirFunction(project, module2, (PathMapper)pathMapper, settingsProvider);
        Function setupScriptFunction = PydevConsoleRunnerFactory.Companion.createSetupScriptFunction(project, module2, workingDirFunction, pathMapper, settingsProvider);
        PyConsoleType pyConsoleType = PyConsoleType.PYTHON;
        Intrinsics.checkNotNullExpressionValue((Object)pyConsoleType, (String)"PYTHON");
        return new TargetedConsoleParameters(project, sdk2, workingDirFunction, (Map<String, String>)envs, pyConsoleType, settingsProvider, setupScriptFunction);
    }

    @Override
    @NotNull
    public PydevConsoleRunner createConsoleRunner(@NotNull Project project, @Nullable Module contextModule) {
        PydevConsoleRunner pydevConsoleRunner;
        Module module2;
        block5: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            for (PyConsoleCustomizer it : (Iterable)PyConsoleCustomizer.Companion.getEP_NAME().getExtensionList()) {
                boolean bl = false;
                Module module3 = it.guessConsoleModule(project, contextModule);
                if (module3 == null) continue;
                module2 = module3;
                break block5;
            }
            module2 = null;
        }
        Module module4 = module2;
        ConsoleParameters consoleParameters = this.createConsoleParameters(project, module4);
        if (consoleParameters instanceof ConstantConsoleParameters) {
            String[] stringArray = ((ConstantConsoleParameters)consoleParameters).getSetupFragment();
            pydevConsoleRunner = new PydevConsoleRunnerImpl(project, consoleParameters.getSdk(), consoleParameters.getConsoleType(), ((ConstantConsoleParameters)consoleParameters).getWorkingDir(), consoleParameters.getEnvs(), consoleParameters.getSettingsProvider(), Arrays.copyOf(stringArray, stringArray.length));
        } else if (consoleParameters instanceof TargetedConsoleParameters) {
            pydevConsoleRunner = new PydevConsoleRunnerImpl(project, consoleParameters.getSdk(), consoleParameters.getConsoleType(), consoleParameters.getConsoleType().getTitle(), ((TargetedConsoleParameters)consoleParameters).getWorkingDirFunction(), consoleParameters.getEnvs(), consoleParameters.getSettingsProvider(), ((TargetedConsoleParameters)consoleParameters).getSetupScript());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pydevConsoleRunner;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PydevConsoleRunner createConsoleRunnerWithFile(@NotNull Project project, @NotNull PythonRunConfiguration config) {
        PydevConsoleRunner pydevConsoleRunner;
        block5: {
            block6: {
                Object object;
                String string;
                PyConsoleType pyConsoleType;
                Sdk sdk2;
                Project project2;
                Map consoleEnvs;
                ConsoleParameters consoleParameters;
                block8: {
                    block7: {
                        void it;
                        ConsoleParameters consoleParameters2;
                        Sdk sdk3;
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                            consoleParameters = this.createConsoleParameters(project, config.getModule());
                            sdk3 = config.getSdk() != null ? config.getSdk() : consoleParameters.getSdk();
                            consoleEnvs = new LinkedHashMap();
                            consoleEnvs.putAll(consoleParameters.getEnvs());
                            Map map2 = config.getEnvs();
                            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvs(...)");
                            consoleEnvs.putAll(map2);
                            consoleParameters2 = consoleParameters;
                            if (!(consoleParameters2 instanceof ConstantConsoleParameters)) break block4;
                            PyConsoleType pyConsoleType2 = consoleParameters.getConsoleType();
                            String string2 = config.getName();
                            String string3 = config.getWorkingDirectory();
                            if (string3 == null) {
                                string3 = ((ConstantConsoleParameters)consoleParameters).getWorkingDir();
                            }
                            String[] stringArray = ((ConstantConsoleParameters)consoleParameters).getSetupFragment();
                            pydevConsoleRunner = new PydevConsoleWithFileRunnerImpl(project, sdk3, pyConsoleType2, string2, string3, (Map<String, String>)consoleEnvs, consoleParameters.getSettingsProvider(), config, Arrays.copyOf(stringArray, stringArray.length));
                            break block5;
                        }
                        if (!(consoleParameters2 instanceof TargetedConsoleParameters)) break block6;
                        project2 = project;
                        sdk2 = sdk3;
                        pyConsoleType = consoleParameters.getConsoleType();
                        string = config.getName();
                        object = config.getWorkingDirectory();
                        if (object == null) break block7;
                        String string4 = object;
                        String string5 = string;
                        PyConsoleType pyConsoleType3 = pyConsoleType;
                        Sdk sdk4 = sdk2;
                        Project project3 = project2;
                        boolean bl = false;
                        Path path2 = Path.of((String)it, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
                        Function function = TargetEnvironmentFunctions.targetPath((Path)path2);
                        project2 = project3;
                        sdk2 = sdk4;
                        pyConsoleType = pyConsoleType3;
                        string = string5;
                        Function function2 = function;
                        object = function2;
                        if (function2 != null) break block8;
                    }
                    object = ((TargetedConsoleParameters)consoleParameters).getWorkingDirFunction();
                }
                Function<TargetEnvironment, String> function = ((TargetedConsoleParameters)consoleParameters).getSetupScript();
                PythonRunConfiguration pythonRunConfiguration = config;
                PyConsoleOptions.PyConsoleSettings pyConsoleSettings = consoleParameters.getSettingsProvider();
                Map map3 = consoleEnvs;
                Object object2 = object;
                String string6 = string;
                PyConsoleType pyConsoleType4 = pyConsoleType;
                Sdk sdk5 = sdk2;
                Project project4 = project2;
                pydevConsoleRunner = new PydevConsoleWithFileRunnerImpl(project4, sdk5, pyConsoleType4, string6, (Function<TargetEnvironment, String>)object2, (Map<String, String>)map3, pyConsoleSettings, pythonRunConfiguration, function);
                break block5;
            }
            throw new NoWhenBranchMatchedException();
        }
        return pydevConsoleRunner;
    }

    @JvmStatic
    public static final void putIPythonEnvFlag(@NotNull Project project, @NotNull EnvironmentController environmentController) {
        Companion.putIPythonEnvFlag(project, environmentController);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tJ\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J,\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013JD\u0010\u0014\u001a\u001c\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\n\u0018\u00010\u0015j\n\u0012\u0004\u0012\u00020\n\u0018\u0001`\u00172\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J$\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0002Jd\u0010\u001b\u001a\u0018\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\n0\u0015j\b\u0012\u0004\u0012\u00020\n`\u00172\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2 \u0010\u001c\u001a\u001c\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\n\u0018\u00010\u0015j\n\u0012\u0004\u0012\u00020\n\u0018\u0001`\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J<\u0010\u001e\u001a\u0018\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\n0\u0015j\b\u0012\u0004\u0012\u00020\n`\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\""}, d2={"Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$Companion;", "", "<init>", "()V", "putIPythonEnvFlag", "", "project", "Lcom/intellij/openapi/project/Project;", "envs", "", "", "environmentController", "Lcom/jetbrains/python/run/EnvironmentController;", "getWorkingDir", "module", "Lcom/intellij/openapi/module/Module;", "pathMapper", "Lcom/intellij/util/PathMapper;", "settingsProvider", "Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "getWorkingDirFunction", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "getWorkingDirFromSettings", "makeStartWithEmptyLine", "line", "createSetupScriptFunction", "workingDir", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "createSetupScriptWithHelpersAndProjectRoot", "projectRoot", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nPydevConsoleRunnerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PydevConsoleRunnerFactory.kt\ncom/jetbrains/python/console/PydevConsoleRunnerFactory$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,211:1\n1#2:212\n23#3:213\n23#3:214\n*S KotlinDebug\n*F\n+ 1 PydevConsoleRunnerFactory.kt\ncom/jetbrains/python/console/PydevConsoleRunnerFactory$Companion\n*L\n143#1:213\n146#1:214\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void putIPythonEnvFlag(@NotNull Project project, @NotNull Map<String, String> envs) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(envs, (String)"envs");
            this.putIPythonEnvFlag(project, new PlainEnvironmentController(envs));
        }

        @JvmStatic
        public final void putIPythonEnvFlag(@NotNull Project project, @NotNull EnvironmentController environmentController) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)environmentController, (String)"environmentController");
            String ipythonEnabled = PyConsoleOptions.getInstance(project).isIpythonEnabled() ? "True" : "False";
            environmentController.putFixedValue("IPYTHONENABLE", ipythonEnabled);
        }

        @Nullable
        public final String getWorkingDir(@NotNull Project project, @Nullable Module module2, @Nullable PathMapper pathMapper, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
            String workingDir = this.getWorkingDirFromSettings(project, module2, settingsProvider);
            if (pathMapper != null && workingDir != null) {
                workingDir = pathMapper.convertToRemote(workingDir);
            }
            return workingDir;
        }

        @Nullable
        public final Function<TargetEnvironment, String> getWorkingDirFunction(@NotNull Project project, @Nullable Module module2, @Nullable PathMapper pathMapper, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider) {
            Function function;
            block11: {
                CharSequence charSequence;
                String workingDir;
                block10: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
                    workingDir = this.getWorkingDirFromSettings(project, module2, settingsProvider);
                    if (pathMapper != null && workingDir != null && pathMapper.canReplaceLocal(workingDir)) {
                        return TargetEnvironmentFunctions.constant((Object)pathMapper.convertToRemote(workingDir));
                    }
                    Path path2 = null;
                    try {
                        Path path3;
                        String string = workingDir;
                        if (string != null) {
                            String it = string;
                            boolean bl = false;
                            path3 = Path.of(it, new String[0]);
                        } else {
                            path3 = null;
                        }
                        path2 = path3;
                    }
                    catch (InvalidPathException e) {
                        Companion $this$thisLogger$iv = this;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(Companion.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.warn((Throwable)e);
                    }
                    if (path2 != null) {
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                            Companion $this$thisLogger$iv = this;
                            boolean $i$f$thisLogger = false;
                            Logger logger = Logger.getInstance(Companion.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                            logger.warn("Can't find " + path2);
                            path2 = null;
                        }
                    }
                    if ((function = path2) == null) break block10;
                    Path it = function;
                    boolean bl = false;
                    Function function2 = TargetEnvironmentFunctions.targetPath((Path)it);
                    function = function2;
                    if (function2 != null) break block11;
                }
                function = !((charSequence = (CharSequence)workingDir) == null || StringsKt.isBlank((CharSequence)charSequence)) ? TargetEnvironmentFunctions.constant((Object)workingDir) : null;
            }
            return function;
        }

        private final String getWorkingDirFromSettings(Project project, Module module2, PyConsoleOptions.PyConsoleSettings settingsProvider) {
            String workingDirectoryInSettings = settingsProvider.getWorkingDirectory();
            CharSequence charSequence = workingDirectoryInSettings;
            if (!(charSequence == null || charSequence.length() == 0)) {
                return workingDirectoryInSettings;
            }
            if (module2 != null) {
                VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getContentRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
                if (!(((Object[])virtualFileArray).length == 0)) {
                    return ModuleRootManager.getInstance((Module)module2).getContentRoots()[0].getPath();
                }
            }
            VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)project).getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            for (VirtualFile root : virtualFileArray) {
                if (!(root.getFileSystem() instanceof LocalFileSystem)) continue;
                return root.getPath();
            }
            return SystemProperties.getUserHome();
        }

        private final String makeStartWithEmptyLine(String line) {
            if (StringsKt.startsWith$default((String)line, (String)"\n", (boolean)false, (int)2, null) || StringsKt.isBlank((CharSequence)line)) {
                return line;
            }
            return "\n" + line;
        }

        private final Function<TargetEnvironment, String> createSetupScriptFunction(Project project, Module module2, Function<TargetEnvironment, String> workingDir, PyRemotePathMapper pathMapper, PyConsoleOptions.PyConsoleSettings settingsProvider) {
            String string = settingsProvider.getCustomStartScript();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCustomStartScript(...)");
            String customStartScript = this.makeStartWithEmptyLine(string);
            Set pythonPathFuns = CollectionsKt.toMutableSet((Iterable)TargetedPythonPaths.collectPythonPath(project, module2, settingsProvider.mySdkHome, pathMapper, settingsProvider.shouldAddContentRoots(), settingsProvider.shouldAddSourceRoots(), false));
            return PydevConsoleRunnerUtil.constructPyPathAndWorkingDirCommand(pythonPathFuns, workingDir, customStartScript);
        }

        @NotNull
        public final Function<TargetEnvironment, String> createSetupScriptWithHelpersAndProjectRoot(@NotNull Project project, @NotNull String projectRoot, @NotNull Sdk sdk2, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider) {
            Object v1;
            Object[] objectArray;
            ArrayList<Function> paths;
            block4: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
                paths = new ArrayList<Function>();
                Path path2 = Path.of(projectRoot, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
                paths.add(TargetEnvironmentFunctions.getTargetEnvironmentValueForLocalPath((Path)path2));
                HelpersAwareTargetEnvironmentRequest targetEnvironmentRequest = PythonInterpreterTargetEnvironmentFactory.Companion.findPythonTargetInterpreter(sdk2, project);
                objectArray = (Object[])targetEnvironmentRequest.preparePyCharmHelpers().getHelpers();
                for (Object object2 : objectArray) {
                    PathMapping it = (PathMapping)object2;
                    boolean bl = false;
                    if (!it.getLocalPath().endsWith("helpers")) continue;
                    v1 = object2;
                    break block4;
                }
                v1 = null;
            }
            PathMapping communityHelpers = v1;
            if (communityHelpers != null) {
                objectArray = new String[]{"pycharm", "pydev"};
                for (String helper : CollectionsKt.listOf((Object[])objectArray)) {
                    paths.add(TargetEnvironmentFunctions.getRelativeTargetPath(communityHelpers.getTargetPathFun(), (String)helper));
                }
            } else {
                Logger.getInstance(PydevConsoleRunnerFactory.class).error("Python Community helpers dir path not found");
            }
            Function pathStr2 = TargetEnvironmentFunctions.joinToStringFunction((Iterable)paths, (CharSequence)", ", (Function1)createSetupScriptWithHelpersAndProjectRoot.pathStr.1.INSTANCE);
            Path path3 = Path.of(projectRoot, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"of(...)");
            Function<TargetEnvironment, String> projectRootStr = PythonConsoleScripts.toStringLiteral(TargetEnvironmentFunctions.getTargetEnvironmentValueForLocalPath((Path)path3));
            Object[] objectArray2 = new Pair[]{TuplesKt.to((Object)"WORKING_DIR_AND_PYTHON_PATHS", (Object)pathStr2), TuplesKt.to((Object)"PROJECT_ROOT", projectRootStr)};
            List replaces = CollectionsKt.listOf((Object[])objectArray2);
            String string = settingsProvider.getCustomStartScript();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCustomStartScript(...)");
            return (Function)((Object)new ReplaceSubstringsFunction(this.makeStartWithEmptyLine(string), replaces));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b5\u0018\u00002\u00020\u0001BI\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u0082\u0001\u0002\u001e\u001f\u00a8\u0006 "}, d2={"Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConsoleParameters;", "", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "workingDir", "", "envs", "", "consoleType", "Lcom/jetbrains/python/console/PyConsoleType;", "settingsProvider", "Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Ljava/util/Map;Lcom/jetbrains/python/console/PyConsoleType;Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getWorkingDir$annotations", "()V", "getWorkingDir", "()Ljava/lang/String;", "getEnvs", "()Ljava/util/Map;", "getConsoleType", "()Lcom/jetbrains/python/console/PyConsoleType;", "getSettingsProvider", "()Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConstantConsoleParameters;", "Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$TargetedConsoleParameters;", "intellij.python.community.impl"})
    @ApiStatus.Experimental
    protected static abstract sealed class ConsoleParameters
    permits ConstantConsoleParameters, TargetedConsoleParameters {
        @NotNull
        private final Project project;
        @Nullable
        private final Sdk sdk;
        @ApiStatus.ScheduledForRemoval
        @Nullable
        private final String workingDir;
        @NotNull
        private final Map<String, String> envs;
        @NotNull
        private final PyConsoleType consoleType;
        @NotNull
        private final PyConsoleOptions.PyConsoleSettings settingsProvider;

        private ConsoleParameters(Project project, Sdk sdk2, String workingDir, Map<String, String> envs, PyConsoleType consoleType, PyConsoleOptions.PyConsoleSettings settingsProvider) {
            this.project = project;
            this.sdk = sdk2;
            this.workingDir = workingDir;
            this.envs = envs;
            this.consoleType = consoleType;
            this.settingsProvider = settingsProvider;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Nullable
        public final Sdk getSdk() {
            return this.sdk;
        }

        @Nullable
        public String getWorkingDir() {
            return this.workingDir;
        }

        @Deprecated(message="Use `ConstantConsoleParameters.workingDir`")
        public static /* synthetic */ void getWorkingDir$annotations() {
        }

        @NotNull
        public final Map<String, String> getEnvs() {
            return this.envs;
        }

        @NotNull
        public final PyConsoleType getConsoleType() {
            return this.consoleType;
        }

        @NotNull
        public final PyConsoleOptions.PyConsoleSettings getSettingsProvider() {
            return this.settingsProvider;
        }

        public /* synthetic */ ConsoleParameters(Project project, Sdk sdk2, String workingDir, Map envs, PyConsoleType consoleType, PyConsoleOptions.PyConsoleSettings settingsProvider, DefaultConstructorMarker $constructor_marker) {
            this(project, sdk2, workingDir, envs, consoleType, settingsProvider);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\b\b\u0005\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConstantConsoleParameters;", "Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConsoleParameters;", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "workingDir", "", "envs", "", "consoleType", "Lcom/jetbrains/python/console/PyConsoleType;", "settingsProvider", "Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "setupFragment", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Ljava/util/Map;Lcom/jetbrains/python/console/PyConsoleType;Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;[Ljava/lang/String;)V", "getWorkingDir", "()Ljava/lang/String;", "getSetupFragment", "()[Ljava/lang/String;", "[Ljava/lang/String;", "intellij.python.community.impl"})
    @ApiStatus.Experimental
    protected static final class ConstantConsoleParameters
    extends ConsoleParameters {
        @Nullable
        private final String workingDir;
        @NotNull
        private final String[] setupFragment;

        public ConstantConsoleParameters(@NotNull Project project, @Nullable Sdk sdk2, @Nullable String workingDir, @NotNull Map<String, String> envs, @NotNull PyConsoleType consoleType, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull String[] setupFragment) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(envs, (String)"envs");
            Intrinsics.checkNotNullParameter((Object)consoleType, (String)"consoleType");
            Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
            Intrinsics.checkNotNullParameter((Object)setupFragment, (String)"setupFragment");
            super(project, sdk2, workingDir, envs, consoleType, settingsProvider, null);
            this.workingDir = workingDir;
            this.setupFragment = setupFragment;
        }

        @Override
        @Nullable
        public String getWorkingDir() {
            return this.workingDir;
        }

        @NotNull
        public final String[] getSetupFragment() {
            return this.setupFragment;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0005\u0018\u00002\u00020\u0001B\u0089\u0001\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012 \u0010\b\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\tj\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u001c\u0010\u0012\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tj\b\u0012\u0004\u0012\u00020\u0007`\u000b\u00a2\u0006\u0004\b\u0013\u0010\u0014B\u007f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012 \u0010\b\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\tj\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u001c\u0010\u0012\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tj\b\u0012\u0004\u0012\u00020\u0007`\u000b\u00a2\u0006\u0004\b\u0013\u0010\u0015R+\u0010\b\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\tj\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R'\u0010\u0012\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tj\b\u0012\u0004\u0012\u00020\u0007`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$TargetedConsoleParameters;", "Lcom/jetbrains/python/console/PydevConsoleRunnerFactory$ConsoleParameters;", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "workingDir", "", "workingDirFunction", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "envs", "", "consoleType", "Lcom/jetbrains/python/console/PyConsoleType;", "settingsProvider", "Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "setupScript", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Ljava/util/function/Function;Ljava/util/Map;Lcom/jetbrains/python/console/PyConsoleType;Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;Ljava/util/function/Function;)V", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/util/function/Function;Ljava/util/Map;Lcom/jetbrains/python/console/PyConsoleType;Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;Ljava/util/function/Function;)V", "getWorkingDirFunction", "()Ljava/util/function/Function;", "getSetupScript", "intellij.python.community.impl"})
    @ApiStatus.Experimental
    protected static final class TargetedConsoleParameters
    extends ConsoleParameters {
        @Nullable
        private final Function<TargetEnvironment, String> workingDirFunction;
        @NotNull
        private final Function<TargetEnvironment, String> setupScript;

        private TargetedConsoleParameters(Project project, Sdk sdk2, String workingDir, Function<TargetEnvironment, String> workingDirFunction, Map<String, String> envs, PyConsoleType consoleType, PyConsoleOptions.PyConsoleSettings settingsProvider, Function<TargetEnvironment, String> setupScript) {
            super(project, sdk2, workingDir, envs, consoleType, settingsProvider, null);
            this.workingDirFunction = workingDirFunction;
            this.setupScript = setupScript;
        }

        @Nullable
        public final Function<TargetEnvironment, String> getWorkingDirFunction() {
            return this.workingDirFunction;
        }

        @NotNull
        public final Function<TargetEnvironment, String> getSetupScript() {
            return this.setupScript;
        }

        public TargetedConsoleParameters(@NotNull Project project, @Nullable Sdk sdk2, @Nullable Function<TargetEnvironment, String> workingDirFunction, @NotNull Map<String, String> envs, @NotNull PyConsoleType consoleType, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull Function<TargetEnvironment, String> setupScript) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(envs, (String)"envs");
            Intrinsics.checkNotNullParameter((Object)consoleType, (String)"consoleType");
            Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
            Intrinsics.checkNotNullParameter(setupScript, (String)"setupScript");
            this(project, sdk2, null, workingDirFunction, envs, consoleType, settingsProvider, setupScript);
        }
    }
}

