/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ReflectionUtil;
import com.jetbrains.python.console.PyConsoleProcessFinishedException;
import com.jetbrains.python.console.PythonConsoleBackendServiceDisposable;
import com.jetbrains.python.console.protocol.CompletionOption;
import com.jetbrains.python.console.protocol.DebugValue;
import com.jetbrains.python.console.protocol.GetArrayResponse;
import com.jetbrains.python.console.protocol.PythonConsoleBackendService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a1\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0010\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"PYTHON_CONSOLE_COMMAND_THREAD_FACTORY_NAME", "", "synchronizedPythonConsoleClient", "Lcom/jetbrains/python/console/PythonConsoleBackendServiceDisposable;", "loader", "Ljava/lang/ClassLoader;", "delegate", "Lcom/jetbrains/python/console/protocol/PythonConsoleBackendService$Iface;", "pythonConsoleProcess", "Ljava/lang/Process;", "invokeOriginalMethod", "", "args", "", "method", "Ljava/lang/reflect/Method;", "([Ljava/lang/Object;Ljava/lang/reflect/Method;Ljava/lang/Object;)Ljava/lang/Object;", "intellij.python.community.impl"})
@JvmName(name="PythonConsoleClientUtil")
public final class PythonConsoleClientUtil {
    @NotNull
    private static final String PYTHON_CONSOLE_COMMAND_THREAD_FACTORY_NAME = "Python Console Command Executor";

    @NotNull
    public static final PythonConsoleBackendServiceDisposable synchronizedPythonConsoleClient(@NotNull ClassLoader loader, @NotNull PythonConsoleBackendService.Iface delegate, @NotNull Process pythonConsoleProcess) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)pythonConsoleProcess, (String)"pythonConsoleProcess");
        ThreadPoolExecutor threadPoolExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)PYTHON_CONSOLE_COMMAND_THREAD_FACTORY_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)threadPoolExecutor, (String)"newSingleThreadExecutor(...)");
        ThreadPoolExecutor executorService = threadPoolExecutor;
        Object object = ReflectionUtil.proxy((ClassLoader)loader, PythonConsoleBackendService.Iface.class, (arg_0, arg_1, arg_2) -> PythonConsoleClientUtil.synchronizedPythonConsoleClient$lambda$0(executorService, pythonConsoleProcess, delegate, arg_0, arg_1, arg_2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"proxy(...)");
        PythonConsoleBackendService.Iface proxy = (PythonConsoleBackendService.Iface)object;
        return new PythonConsoleBackendServiceDisposable(proxy, executorService){
            private final /* synthetic */ PythonConsoleBackendService.Iface $$delegate_0;
            final /* synthetic */ ThreadPoolExecutor $executorService;
            {
                this.$executorService = $executorService;
                this.$$delegate_0 = $proxy;
            }

            public void dispose() {
                this.$executorService.shutdownNow();
                try {
                    while (!this.$executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }

            public boolean execLine(String line) {
                return this.$$delegate_0.execLine(line);
            }

            public boolean execMultipleLines(String lines) {
                return this.$$delegate_0.execMultipleLines(lines);
            }

            public List<CompletionOption> getCompletions(String text, String actTok) {
                return this.$$delegate_0.getCompletions(text, actTok);
            }

            public String getDescription(String text) {
                return this.$$delegate_0.getDescription(text);
            }

            public List<DebugValue> getFrame(int type2) {
                return this.$$delegate_0.getFrame(type2);
            }

            public List<DebugValue> getVariable(String variable) {
                return this.$$delegate_0.getVariable(variable);
            }

            public boolean setUserTypeRenderers(String renderers) {
                return this.$$delegate_0.setUserTypeRenderers(renderers);
            }

            public void changeVariable(String evaluationExpression, String value) {
                this.$$delegate_0.changeVariable(evaluationExpression, value);
            }

            public void connectToDebugger(int localPort, String host, Map<String, Boolean> opts, Map<String, String> extraEnvs) {
                this.$$delegate_0.connectToDebugger(localPort, host, opts, extraEnvs);
            }

            public void interrupt() {
                this.$$delegate_0.interrupt();
            }

            public String handshake() {
                return this.$$delegate_0.handshake();
            }

            public void close() {
                this.$$delegate_0.close();
            }

            public List<DebugValue> evaluate(String expression, boolean doTrunc) {
                return this.$$delegate_0.evaluate(expression, doTrunc);
            }

            public GetArrayResponse getArray(String vars, int rowOffset, int colOffset, int rows, int cols, String format) {
                return this.$$delegate_0.getArray(vars, rowOffset, colOffset, rows, cols, format);
            }

            public void execDataViewerAction(String varName, String action, String myArgs) {
                this.$$delegate_0.execDataViewerAction(varName, action, myArgs);
            }

            public void loadFullValue(int seq, List<String> variables) {
                this.$$delegate_0.loadFullValue(seq, variables);
            }

            public String execRaw(String command) {
                return this.$$delegate_0.execRaw(command);
            }

            public String execTableCommand(String tableVariable, String commandType, String startIndex, String endIndex, String format) {
                return this.$$delegate_0.execTableCommand(tableVariable, commandType, startIndex, endIndex, format);
            }

            public String execTableImageCommand(String tableVariable, String commandType, String offset, String imageId) {
                return this.$$delegate_0.execTableImageCommand(tableVariable, commandType, offset, imageId);
            }
        };
    }

    private static final Object invokeOriginalMethod(Object[] args, Method method, Object delegate) {
        Object object;
        try {
            Object object2;
            if (args != null) {
                object = args;
                object2 = method.invoke(delegate, Arrays.copyOf(object, ((Object[])object).length));
            } else {
                object2 = method.invoke(delegate, new Object[0]);
            }
            object = object2;
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
        return object;
    }

    private static final Object synchronizedPythonConsoleClient$lambda$0$0(Object[] $args, Method $method, PythonConsoleBackendService.Iface $delegate) {
        Intrinsics.checkNotNull((Object)$method);
        return PythonConsoleClientUtil.invokeOriginalMethod($args, $method, $delegate);
    }

    private static final Object synchronizedPythonConsoleClient$lambda$0(ThreadPoolExecutor $executorService, Process $pythonConsoleProcess, PythonConsoleBackendService.Iface $delegate, Object object, Method method, Object[] args) {
        Future<Object> future = $executorService.submit(() -> PythonConsoleClientUtil.synchronizedPythonConsoleClient$lambda$0$0(args, method, $delegate));
        while (true) {
            try {
                return future.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                if ($pythonConsoleProcess.isAlive()) continue;
                int exitValue = $pythonConsoleProcess.exitValue();
                throw new PyConsoleProcessFinishedException(exitValue);
            }
            catch (ExecutionException e) {
                if (!$pythonConsoleProcess.isAlive()) {
                    int exitValue = $pythonConsoleProcess.exitValue();
                    throw new PyConsoleProcessFinishedException(exitValue);
                }
                Throwable throwable = e.getCause();
                if (throwable == null) {
                    throwable = e;
                }
                throw throwable;
            }
            break;
        }
    }
}

