/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console.transport;

import com.intellij.openapi.diagnostic.Logger;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b&\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\rJ\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0010H&J\b\u0010\u0017\u001a\u00020\rH\u0016J\u001e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/python/console/transport/TCumulativeTransport;", "Lorg/apache/thrift/transport/TTransport;", "<init>", "()V", "outputStream", "Ljava/io/PipedOutputStream;", "getOutputStream", "()Ljava/io/PipedOutputStream;", "pipedInputStream", "Ljava/io/PipedInputStream;", "messageBuffer", "Lio/netty/buffer/ByteBuf;", "open", "", "write", "buf", "", "off", "", "len", "flush", "writeMessage", "content", "close", "read", "Companion", "intellij.python.community.impl"})
public abstract class TCumulativeTransport
extends TTransport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PipedOutputStream outputStream = new PipedOutputStream();
    @NotNull
    private final PipedInputStream pipedInputStream = new PipedInputStream(this.outputStream);
    @NotNull
    private final ByteBuf messageBuffer;
    @NotNull
    private static final Logger LOG;

    public TCumulativeTransport() {
        ByteBuf byteBuf = Unpooled.buffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"buffer(...)");
        this.messageBuffer = byteBuf;
    }

    @NotNull
    public final PipedOutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void open() {
    }

    @Override
    public final void write(@NotNull byte[] buf, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.messageBuffer.writeBytes(buf, off, len);
    }

    @Override
    public final void flush() {
        int length = this.messageBuffer.readableBytes();
        byte[] content = new byte[length];
        this.messageBuffer.readBytes(content);
        this.messageBuffer.clear();
        this.writeMessage(content);
    }

    public abstract void writeMessage(@NotNull byte[] var1);

    @Override
    public void close() {
        LOG.debug("Closing cumulative transport");
        this.outputStream.close();
        this.pipedInputStream.close();
    }

    @Override
    public final int read(@NotNull byte[] buf, int off, int len) throws TTransportException {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        try {
            return this.pipedInputStream.read(buf, off, len);
        }
        catch (IOException e) {
            throw new TTransportException(0, (Throwable)e);
        }
    }

    static {
        Logger logger = Logger.getInstance(TCumulativeTransport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/console/transport/TCumulativeTransport$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

