/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fJ(\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001aH\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u00182\b\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/python/debugger/PySourcePositionResolver;", "", "currentFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/xdebugger/frame/XStackFrame;Lcom/intellij/openapi/project/Project;)V", "getCurrentFrame", "()Lcom/intellij/xdebugger/frame/XStackFrame;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSourcePositionForName", "Lcom/intellij/xdebugger/XSourcePosition;", "name", "", "parentType", "getSourcePositionForType", "typeName", "resolveInCurrentFrame", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "currentPosition", "file", "Lcom/intellij/psi/PsiFile;", "resolveTypeFromString", "Lcom/jetbrains/python/psi/types/PyType;", "typeToPosition", "pyType", "getPsiFile", "intellij.python.community.impl"})
@ApiStatus.Internal
public final class PySourcePositionResolver {
    @NotNull
    private final XStackFrame currentFrame;
    @NotNull
    private final Project project;

    public PySourcePositionResolver(@NotNull XStackFrame currentFrame, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)currentFrame, (String)"currentFrame");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.currentFrame = currentFrame;
        this.project = project;
    }

    @NotNull
    public final XStackFrame getCurrentFrame() {
        return this.currentFrame;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final XSourcePosition getSourcePositionForName(@Nullable String name2, @Nullable String parentType) {
        if (name2 == null) {
            return null;
        }
        XSourcePosition xSourcePosition = this.currentFrame.getSourcePosition();
        if (xSourcePosition == null) {
            return null;
        }
        XSourcePosition currentPosition = xSourcePosition;
        PsiFile psiFile = this.getPsiFile(currentPosition);
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        CharSequence charSequence = parentType;
        if (charSequence == null || charSequence.length() == 0) {
            Ref<PsiElement> elementRef = this.resolveInCurrentFrame(name2, currentPosition, file);
            return elementRef.isNull() ? null : XDebuggerUtil.getInstance().createPositionByElement((PsiElement)elementRef.get());
        }
        PyType parentDef = this.resolveTypeFromString(parentType, file);
        if (parentDef == null) {
            return null;
        }
        TypeEvalContext context = TypeEvalContext.codeInsightFallback((Project)file.getProject());
        List results = parentDef.resolveMember(name2, null, AccessDirection.READ, PyResolveContext.defaultContext((TypeEvalContext)context));
        Collection collection = results;
        if (!(collection == null || collection.isEmpty())) {
            return XDebuggerUtil.getInstance().createPositionByElement(((RatedResolveResult)CollectionsKt.first((List)results)).getElement());
        }
        return this.typeToPosition(parentDef);
    }

    @Nullable
    public final XSourcePosition getSourcePositionForType(@Nullable String typeName) {
        PyType pyType;
        XSourcePosition currentPosition = this.currentFrame.getSourcePosition();
        PsiFile file = this.getPsiFile(currentPosition);
        if (typeName == null || !(file instanceof PyFile)) {
            return null;
        }
        PyType pyType2 = pyType = this.resolveTypeFromString(typeName, file);
        return pyType2 == null ? null : this.typeToPosition(pyType2);
    }

    private final Ref<PsiElement> resolveInCurrentFrame(String name2, XSourcePosition currentPosition, PsiFile file) {
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref elementRef = ref;
        PsiElement currentElement = file.findElementAt(currentPosition.getOffset());
        if (currentElement == null) {
            return elementRef;
        }
        PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)new PsiScopeProcessor(name2, (Ref<PsiElement>)elementRef){
            final /* synthetic */ String $name;
            final /* synthetic */ Ref<PsiElement> $elementRef;
            {
                this.$name = $name;
                this.$elementRef = $elementRef;
            }

            public boolean execute(PsiElement element2, ResolveState state) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                if (element2 instanceof PyImportElement) {
                    if (Intrinsics.areEqual((Object)this.$name, (Object)((PyImportElement)element2).getVisibleName())) {
                        if (this.$elementRef.isNull()) {
                            this.$elementRef.set((Object)element2);
                        }
                        return false;
                    }
                    return true;
                }
                if (this.$elementRef.isNull()) {
                    this.$elementRef.set((Object)element2);
                }
                return false;
            }
        }, (PsiElement)currentElement, (String)name2, null);
        return elementRef;
    }

    private final PyType resolveTypeFromString(String typeName, PsiFile file) {
        String typeName2 = typeName;
        typeName2 = StringsKt.replace$default((String)typeName2, (String)"__builtin__.", (String)"", (boolean)false, (int)4, null);
        PyType pyType = null;
        if (!StringsKt.contains$default((CharSequence)typeName2, (CharSequence)".", (boolean)false, (int)2, null)) {
            pyType = PyTypeParser.getTypeByName((PsiElement)((PsiElement)file), (String)typeName2);
        }
        if (pyType == null) {
            PyElementGenerator generator = PyElementGenerator.getInstance((Project)this.project);
            PyPsiFacade psiFacade = PyPsiFacade.getInstance((Project)this.project);
            PsiFile dummyFile = generator.createDummyFile(LanguageLevel.forElement((PsiElement)((PsiElement)file)), "");
            Module moduleForFile = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file));
            dummyFile.putUserData(ModuleUtilCore.KEY_MODULE, (Object)moduleForFile);
            pyType = psiFacade.parseTypeAnnotation(typeName2, (PsiElement)dummyFile);
        }
        return pyType;
    }

    private final XSourcePosition typeToPosition(PyType pyType) {
        PyClassType classType = (PyClassType)PyUtil.as((Object)pyType, PyClassType.class);
        if (classType != null) {
            return XDebuggerUtil.getInstance().createPositionByElement((PsiElement)classType.getPyClass());
        }
        PyModuleType moduleType = (PyModuleType)PyUtil.as((Object)pyType, PyModuleType.class);
        if (moduleType != null) {
            return XDebuggerUtil.getInstance().createPositionByElement((PsiElement)moduleType.getModule());
        }
        return null;
    }

    private final PsiFile getPsiFile(XSourcePosition currentPosition) {
        if (currentPosition == null) {
            return null;
        }
        return PsiManager.getInstance((Project)this.project).findFile(currentPosition.getFile());
    }
}

