/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentPaths;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.remote.PyRemotePathMapper;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/python/debugger/PyTargetPathMapper;", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "targetEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "pathMappingSettings", "Lcom/intellij/util/PathMappingSettings;", "<init>", "(Lcom/intellij/execution/target/TargetEnvironment;Lcom/intellij/util/PathMappingSettings;)V", "convertToLocal", "", "remotePath", "convertToRemote", "localPath", "isEmpty", "", "intellij.python.community.impl"})
@ApiStatus.Internal
public final class PyTargetPathMapper
extends PyRemotePathMapper {
    @NotNull
    private final TargetEnvironment targetEnvironment;
    @NotNull
    private final PathMappingSettings pathMappingSettings;

    public PyTargetPathMapper(@NotNull TargetEnvironment targetEnvironment2, @NotNull PathMappingSettings pathMappingSettings) {
        Intrinsics.checkNotNullParameter((Object)targetEnvironment2, (String)"targetEnvironment");
        Intrinsics.checkNotNullParameter((Object)pathMappingSettings, (String)"pathMappingSettings");
        this.targetEnvironment = targetEnvironment2;
        this.pathMappingSettings = pathMappingSettings;
    }

    @Override
    @NotNull
    public String convertToLocal(@NotNull String remotePath) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        String string = AbstractPathMapper.convertToLocal((String)remotePath, (Iterable)this.pathMappingSettings.getPathMappings());
        if (string == null && (string = (String)CollectionsKt.firstOrNull((List)TargetEnvironmentPaths.getLocalPaths((TargetEnvironment)this.targetEnvironment, (String)remotePath))) == null) {
            String string2 = super.convertToLocal(remotePath);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"convertToLocal(...)");
        }
        return string;
    }

    @Override
    @NotNull
    public String convertToRemote(@NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        String string = AbstractPathMapper.convertToRemote((String)localPath, (Collection)this.pathMappingSettings.getPathMappings());
        if (string == null) {
            String string2 = FileUtil.toSystemDependentName((String)localPath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
            string = (String)CollectionsKt.firstOrNull((List)TargetEnvironmentPaths.getTargetPaths((TargetEnvironment)this.targetEnvironment, (String)string2));
            if (string == null) {
                String string3 = super.convertToRemote(localPath);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"convertToRemote(...)");
            }
        }
        return string;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

