/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyPandasTruthValueIsAmbiguousInspectionKt;
import com.jetbrains.python.psi.PyAssertStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyConditionalStatementPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.types.TypeEvalContext;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/inspections/PyPandasTruthValueIsAmbiguousInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "BinaryExpressionRecursiveVisitor", "intellij.python.community.impl"})
@ApiStatus.Internal
public final class PyPandasTruthValueIsAmbiguousInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext((LocalInspectionToolSession)session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return (PsiElementVisitor)new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyPandasTruthValueIsAmbiguousInspection$BinaryExpressionRecursiveVisitor;", "Lcom/jetbrains/python/psi/PyRecursiveElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPyBinaryExpression", "", "node", "Lcom/jetbrains/python/psi/PyBinaryExpression;", "intellij.python.community.impl"})
    private static final class BinaryExpressionRecursiveVisitor
    extends PyRecursiveElementVisitor {
        @NotNull
        private final ProblemsHolder holder;
        @NotNull
        private final TypeEvalContext context;

        public BinaryExpressionRecursiveVisitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.holder = holder;
            this.context = context;
        }

        public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
            boolean isIdentity;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            boolean bl = isIdentity = node.isOperator("is") || node.isOperator("isnot");
            if (!isIdentity) {
                boolean suggestedQuickFixes = node.isOperator("and") || node.isOperator("or") || node.isOperator("==");
                PyExpression pyExpression = node.getLeftExpression();
                if (pyExpression != null) {
                    PyPandasTruthValueIsAmbiguousInspectionKt.access$reportProblemIfPandasAmbiguousTarget(pyExpression, this.holder, this.context, suggestedQuickFixes);
                }
                PyExpression pyExpression2 = node.getRightExpression();
                if (pyExpression2 != null) {
                    PyPandasTruthValueIsAmbiguousInspectionKt.access$reportProblemIfPandasAmbiguousTarget(pyExpression2, this.holder, this.context, suggestedQuickFixes);
                }
            }
            super.visitPyBinaryExpression(node);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/inspections/PyPandasTruthValueIsAmbiguousInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPyAssertStatement", "", "node", "Lcom/jetbrains/python/psi/PyAssertStatement;", "visitPyConditionalStatementPart", "Lcom/jetbrains/python/psi/PyConditionalStatementPart;", "reportProblems", "expression", "Lcom/jetbrains/python/psi/PyExpression;", "intellij.python.community.impl"})
    private static final class Visitor
    extends PyInspectionVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
            this.holder = holder;
        }

        public void visitPyAssertStatement(@NotNull PyAssertStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyAssertStatement(node);
            PyExpression[] pyExpressionArray = node.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getArguments(...)");
            PyExpression pyExpression = (PyExpression)ArraysKt.firstOrNull((Object[])pyExpressionArray);
            if (pyExpression == null) {
                return;
            }
            PyExpression expression = pyExpression;
            this.reportProblems(expression);
        }

        public void visitPyConditionalStatementPart(@NotNull PyConditionalStatementPart node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyConditionalStatementPart(node);
            PyExpression pyExpression = node.getCondition();
            if (pyExpression == null) {
                return;
            }
            PyExpression condition = pyExpression;
            this.reportProblems(condition);
        }

        private final void reportProblems(PyExpression expression) {
            if (expression instanceof PyBinaryExpression) {
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                expression.accept((PsiElementVisitor)new BinaryExpressionRecursiveVisitor(this.holder, typeEvalContext));
            } else {
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                PyPandasTruthValueIsAmbiguousInspectionKt.reportProblemIfPandasAmbiguousTarget$default(expression, this.holder, typeEvalContext, false, 4, null);
            }
        }
    }
}

