/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.idea.ActionsBundle;
import com.intellij.model.SideEffectGuard;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyPackageRequirementsInspection;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/inspections/quickfix/IgnoreRequirementFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "packagesToIgnore", "", "", "<init>", "(Ljava/util/Set;)V", "getFamilyName", "Lorg/jetbrains/annotations/Nls;", "startInWriteAction", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "createUndoAction", "Lcom/intellij/notification/NotificationAction;", "inspection", "Lcom/jetbrains/python/inspections/PyPackageRequirementsInspection;", "profileManager", "Lcom/intellij/profile/codeInspection/ProjectInspectionProfileManager;", "createEditSettingsAction", "Companion", "intellij.python.community.impl"})
public final class IgnoreRequirementFix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> packagesToIgnore;
    @NotNull
    private static final String NOTIFICATION_GROUP_ID = "Package requirements";
    @NotNull
    private static final NotificationGroup BALLOON_NOTIFICATIONS;

    public IgnoreRequirementFix(@NotNull Set<String> packagesToIgnore) {
        Intrinsics.checkNotNullParameter(packagesToIgnore, (String)"packagesToIgnore");
        this.packagesToIgnore = packagesToIgnore;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.packagesToIgnore.size()};
        String string = PyPsiBundle.message((String)"QFIX.NAME.ignore.requirements", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        if (psiElement == null) {
            return;
        }
        PsiElement element2 = psiElement;
        SideEffectGuard.Companion.checkSideEffectAllowed(SideEffectGuard.EffectType.PROJECT_MODEL);
        PyPackageRequirementsInspection pyPackageRequirementsInspection = PyPackageRequirementsInspection.Companion.getInstance(element2);
        if (pyPackageRequirementsInspection == null) {
            return;
        }
        PyPackageRequirementsInspection inspection = pyPackageRequirementsInspection;
        inspection.setIgnoredPackages(CollectionsKt.toMutableList((Collection)CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)inspection.getIgnoredPackages(), (Iterable)this.packagesToIgnore))));
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.Companion.getInstance(project);
        profileManager.fireProfileChanged();
        if (this.packagesToIgnore.size() == 1) {
            Object[] objectArray = new Object[]{CollectionsKt.first((Iterable)this.packagesToIgnore)};
            string = PyPsiBundle.message((String)"INSP.package.requirements.requirement.has.been.ignored", (Object[])objectArray);
        } else {
            string = PyPsiBundle.message((String)"INSP.package.requirements.requirements.have.been.ignored", (Object[])new Object[0]);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String notificationMessage = string2;
        Notification notification2 = BALLOON_NOTIFICATIONS.createNotification(notificationMessage, NotificationType.INFORMATION).setDisplayId("requirements.have.been.ignored");
        Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"setDisplayId(...)");
        Notification notification3 = notification2;
        notification3.addAction((AnAction)this.createUndoAction(inspection, this.packagesToIgnore, profileManager));
        notification3.addAction((AnAction)this.createEditSettingsAction(project));
        notification3.notify(project);
    }

    private final NotificationAction createUndoAction(PyPackageRequirementsInspection inspection, Set<String> packagesToIgnore, ProjectInspectionProfileManager profileManager) {
        NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)ActionsBundle.message((String)"action.$Undo.text", (Object[])new Object[0]), () -> IgnoreRequirementFix.createUndoAction$lambda$0(inspection, packagesToIgnore, profileManager));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimpleExpiring(...)");
        return notificationAction;
    }

    private final NotificationAction createEditSettingsAction(Project project) {
        NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)PyBundle.message("notification.action.edit.settings", new Object[0]), () -> IgnoreRequirementFix.createEditSettingsAction$lambda$0(project));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimpleExpiring(...)");
        return notificationAction;
    }

    private static final void createUndoAction$lambda$0(PyPackageRequirementsInspection $inspection, Set $packagesToIgnore, ProjectInspectionProfileManager $profileManager) {
        $inspection.setIgnoredPackages(CollectionsKt.toMutableList((Collection)CollectionsKt.minus((Iterable)$inspection.getIgnoredPackages(), (Iterable)$packagesToIgnore)));
        $profileManager.fireProfileChanged();
    }

    private static final void createEditSettingsAction$lambda$0(Project $project) {
        InspectionProfileImpl profile = ProjectInspectionProfileManager.Companion.getInstance($project).getCurrentProfile();
        String toolName = PyPackageRequirementsInspection.class.getSimpleName();
        EditInspectionToolsSettingsAction.editToolSettings((Project)$project, (InspectionProfileImpl)profile, (String)toolName);
    }

    private static final NotificationGroup BALLOON_NOTIFICATIONS$lambda$0() {
        return NotificationGroupManager.getInstance().getNotificationGroup(NOTIFICATION_GROUP_ID);
    }

    static {
        Object object = Cancellation.forceNonCancellableSectionInClassInitializer(IgnoreRequirementFix::BALLOON_NOTIFICATIONS$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"forceNonCancellableSectionInClassInitializer(...)");
        BALLOON_NOTIFICATIONS = (NotificationGroup)object;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/inspections/quickfix/IgnoreRequirementFix$Companion;", "", "<init>", "()V", "NOTIFICATION_GROUP_ID", "", "BALLOON_NOTIFICATIONS", "Lcom/intellij/notification/NotificationGroup;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

