/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.conda.environmentYml.format;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.conda.environmentYml.format.CondaEnvironmentYmlParser;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001d\u0010\u000f\u001a\u00020\u000e2\u000b\u0010\u0010\u001a\u00070\u000e\u00a2\u0006\u0002\b\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/python/packaging/conda/environmentYml/format/EnvironmentYmlModifier;", "", "<init>", "()V", "INDENT_PATTERN", "Lkotlin/text/Regex;", "NEXT_SESSION_PATTERN", "addRequirement", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageName", "", "insertDependency", "text", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.python.community.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEnvironmentYmlModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvironmentYmlModifier.kt\ncom/jetbrains/python/packaging/conda/environmentYml/format/EnvironmentYmlModifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1807#2,3:81\n*S KotlinDebug\n*F\n+ 1 EnvironmentYmlModifier.kt\ncom/jetbrains/python/packaging/conda/environmentYml/format/EnvironmentYmlModifier\n*L\n22#1:81,3\n*E\n"})
public final class EnvironmentYmlModifier {
    @NotNull
    public static final EnvironmentYmlModifier INSTANCE = new EnvironmentYmlModifier();
    @NotNull
    private static final Regex INDENT_PATTERN = new Regex("\\n(\\s+)- ", RegexOption.MULTILINE);
    @NotNull
    private static final Regex NEXT_SESSION_PATTERN = new Regex("\\n\\w+:", RegexOption.MULTILINE);

    private EnvironmentYmlModifier() {
    }

    public final boolean addRequirement(@NotNull Project project, @NotNull VirtualFile file, @NotNull String packageName) {
        boolean bl;
        Document document;
        block6: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Document document2 = FileDocumentManager.getInstance().getDocument(file);
            if (document2 == null) {
                return false;
            }
            document = document2;
            List<PyRequirement> list = CondaEnvironmentYmlParser.INSTANCE.fromFile(file);
            if (list == null) {
                return false;
            }
            List<PyRequirement> pyRequirements = list;
            Iterable $this$any$iv = pyRequirements;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PyRequirement it = (PyRequirement)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)packageName)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        String modifiedText = this.insertDependency(text, packageName);
        PsiFile[] psiFileArray = new PsiFile[]{PsiManager.getInstance((Project)project).findFile(file)};
        WriteCommandAction.runWriteCommandAction((Project)project, (String)PyBundle.message("command.name.add.package.to.conda.environments.yml", new Object[0]), null, () -> EnvironmentYmlModifier.addRequirement$lambda$1(document, modifiedText), (PsiFile[])psiFileArray);
        return true;
    }

    private final String insertDependency(String text, String packageName) {
        StringBuilder modifiedContent = new StringBuilder(text);
        String dependenciesText = "dependencies:";
        int dependenciesIndex = StringsKt.indexOf$default((CharSequence)text, (String)dependenciesText, (int)0, (boolean)false, (int)6, null);
        if (dependenciesIndex < 0) {
            modifiedContent.append("\ndependencies:\n  - " + packageName);
        }
        if (dependenciesIndex >= 0) {
            Regex indentPattern = INDENT_PATTERN;
            String string = text.substring(dependenciesIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            MatchResult indentMatch = Regex.find$default((Regex)indentPattern, (CharSequence)string, (int)0, (int)2, null);
            Object object = indentMatch;
            if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
                object = "  ";
            }
            Object indent = object;
            Regex nextSectionPattern = NEXT_SESSION_PATTERN;
            int insertIndex = dependenciesIndex + dependenciesText.length();
            MatchResult nextSectionMatch = nextSectionPattern.find((CharSequence)text, insertIndex);
            insertIndex = nextSectionMatch != null ? nextSectionMatch.getRange().getFirst() : text.length();
            String newDependencyLine = "\n" + (String)indent + "- " + packageName;
            modifiedContent.insert(insertIndex, newDependencyLine);
        }
        String string = modifiedContent.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void addRequirement$lambda$1(Document $document, String $modifiedText) {
        $document.setText((CharSequence)$modifiedText);
        FileDocumentManager.getInstance().saveDocument($document);
    }
}

