/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.pip;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.SafeFileOutputStream;
import com.jetbrains.python.Result;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackageName;
import com.jetbrains.python.packaging.cache.PythonPackageCache;
import com.jetbrains.python.packaging.pip.PypiPackageCache;
import com.jetbrains.python.packaging.pip.PypiPackageCacheKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002&'B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0096\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002J\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0002J$\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\b\b\u0002\u0010\u001f\u001a\u00020\nH\u0097@\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010\"J\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cH\u0083@\u00a2\u0006\u0002\u0010\"J\b\u0010$\u001a\u00020\u001dH\u0002J\b\u0010%\u001a\u00020\nH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lcom/jetbrains/python/packaging/pip/PypiPackageCache;", "Lcom/jetbrains/python/packaging/cache/PythonPackageCache;", "", "<init>", "()V", "packages", "", "getPackages", "()Ljava/util/Set;", "contains", "", "key", "lookup", "Lcom/intellij/spellchecker/dictionary/Dictionary$LookupStatus;", "word", "isEmpty", "cache", "lock", "Lkotlinx/coroutines/sync/Mutex;", "loadInProgress", "gson", "Lcom/google/gson/Gson;", "filePath", "Ljava/nio/file/Path;", "getFilePath", "()Ljava/nio/file/Path;", "getCachePath", "reloadCache", "Lcom/jetbrains/python/Result;", "", "Ljava/io/IOException;", "force", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryLoadFromFile", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "refresh", "store", "isFileCacheExpired", "PypiPackageLoader", "Companion", "intellij.python.community.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPypiPackageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PypiPackageCache.kt\ncom/jetbrains/python/packaging/pip/PypiPackageCache\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,218:1\n23#2:219\n23#2:220\n23#2:243\n116#3,11:221\n116#3,11:232\n*S KotlinDebug\n*F\n+ 1 PypiPackageCache.kt\ncom/jetbrains/python/packaging/pip/PypiPackageCache\n*L\n66#1:219\n71#1:220\n215#1:243\n77#1:221,11\n97#1:232,11\n*E\n"})
public class PypiPackageCache
implements PythonPackageCache<String> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private volatile Set<String> cache = SetsKt.emptySet();
    @NotNull
    private final Mutex lock = MutexKt.Mutex$default((boolean)false, (int)1, null);
    private boolean loadInProgress;
    @NotNull
    private final Gson gson = new Gson();
    @NotNull
    private final Path filePath = this.getCachePath();
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String PACKAGE_INDEX_CACHE_PROPERTY = "python.packages.cache.index.path";

    @Override
    @NotNull
    public Set<String> getPackages() {
        return this.cache;
    }

    @Override
    public boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.cache.contains(key);
    }

    @NotNull
    public final Dictionary.LookupStatus lookup(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (this.cache.contains(word)) {
            return Dictionary.LookupStatus.Present;
        }
        Regex regex = PypiPackageCacheKt.access$getALPHABET_REGEX$p();
        String string = word.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (!regex.matches((CharSequence)string)) {
            return Dictionary.LookupStatus.Alien;
        }
        return Dictionary.LookupStatus.Absent;
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @NotNull
    public final Path getFilePath() {
        return this.filePath;
    }

    private final Path getCachePath() {
        String overridePath = System.getProperty(PACKAGE_INDEX_CACHE_PROPERTY);
        if (overridePath != null) {
            PypiPackageCache $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PypiPackageCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Using package index cache path from property: " + overridePath);
            Path path2 = Paths.get(overridePath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            return path2;
        }
        String[] $i$f$thisLogger = new String[]{"python_packages", "packages_v2.json"};
        Path path3 = Paths.get(PathManager.getSystemPath(), $i$f$thisLogger);
        PypiPackageCache $this$thisLogger$iv = this;
        boolean $i$f$thisLogger2 = false;
        Logger logger = Logger.getInstance(PypiPackageCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Using package index cache path: " + path3);
        Intrinsics.checkNotNull((Object)path3);
        return path3;
    }

    @CheckReturnValue
    @Nullable
    public Object reloadCache(boolean force, @NotNull Continuation<? super Result<Unit, ? extends IOException>> $completion) {
        return PypiPackageCache.reloadCache$suspendImpl(this, force, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @CheckReturnValue
    static /* synthetic */ Object reloadCache$suspendImpl(PypiPackageCache $this, boolean force, Continuation<? super Result<Unit, ? extends IOException>> $completion) {
        if (!($completion instanceof reloadCache.1)) ** GOTO lbl-1000
        var11_3 = $completion;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                boolean Z$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ PypiPackageCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PypiPackageCache.reloadCache$suspendImpl(this.this$0, false, (Continuation<? super Result<Unit, ? extends IOException>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = $this.lock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.Z$0 = force;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl32
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                force = $continuation.Z$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                $this = (PypiPackageCache)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                try {
                    $i$a$-withLock$default-PypiPackageCache$reloadCache$2 = false;
                    if (((Collection)$this.cache).isEmpty() == false && !force || $this.loadInProgress) {
                        var9_16 = Result.Companion.success((Object)Unit.INSTANCE);
                        return var9_16;
                    }
                    $this.loadInProgress = true;
                    var7_17 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                PypiPackageCache.LOG.info("Reloading Pypi package cache");
                $continuation.L$0 = $this;
                $continuation.L$1 = null;
                $continuation.Z$0 = force;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>($this, null){
                    int label;
                    final /* synthetic */ PypiPackageCache this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = PypiPackageCache.access$tryLoadFromFile(this.this$0, (Continuation)this);
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                if (((Boolean)v0).booleanValue()) break;
                                this.label = 2;
                                v1 = PypiPackageCache.access$refresh(this.this$0, (Continuation)this);
                                if (v1 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl22
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl22:
                                // 2 sources

                                return v1;
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<Object> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var12_5) goto lbl55
lbl54:
                // 1 sources

                return var12_5;
lbl55:
                // 1 sources

                ** GOTO lbl63
            }
            case 2: {
                force = $continuation.Z$0;
                $this = (PypiPackageCache)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl63:
                // 2 sources

                if ($this.getPackages().isEmpty()) {
                    PypiPackageCache.LOG.warn("Empty Pypi loaded package cache");
                }
                $this$withLock_u24default$iv = $this.lock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.Z$0 = force;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 3;
                v2 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v2 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl85
            }
            case 3: {
                $i$f$withLock = $continuation.I$0;
                force = $continuation.Z$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                $this = (PypiPackageCache)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl85:
                // 2 sources

                try {
                    $i$a$-withLock$default-PypiPackageCache$reloadCache$4 = false;
                    $this.loadInProgress = false;
                    var7_17 = Unit.INSTANCE;
                    break;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
            }
        }
        catch (Throwable var3_7) {
            $this$withLock_u24default$iv = $this.lock;
            owner$iv = null;
            $i$f$withLock = 0;
            $continuation.L$0 = $this;
            $continuation.L$1 = var3_7;
            $continuation.L$2 = $this$withLock_u24default$iv;
            $continuation.Z$0 = force;
            $continuation.I$0 = $i$f$withLock;
            $continuation.label = 4;
            v3 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
            if (v3 == var12_5) {
                return var12_5;
            }
            ** GOTO lbl118
        }
        {
            case 4: {
                $i$f$withLock = $continuation.I$0;
                force = $continuation.Z$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                var3_8 = (Throwable)$continuation.L$1;
                $this = (PypiPackageCache)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl118:
                // 2 sources

                try {
                    $i$a$-withLock$default-PypiPackageCache$reloadCache$4 = false;
                    $this.loadInProgress = false;
                    var8_21 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                throw var3_8;
            }
        }
        return Result.Companion.success((Object)Unit.INSTANCE);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object reloadCache$default(PypiPackageCache pypiPackageCache, boolean bl, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reloadCache");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return pypiPackageCache.reloadCache(bl, (Continuation<? super Result<Unit, ? extends IOException>>)continuation);
    }

    private final Object tryLoadFromFile(Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PypiPackageCache this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        PypiPackageCache pypiPackageCache;
                        ResultKt.throwOnFailure((Object)$result);
                        if (PypiPackageCache.access$isFileCacheExpired(this.this$0)) {
                            void $this$withContext;
                            void $this$thisLogger$iv = $this$withContext;
                            boolean $i$f$thisLogger = false;
                            Logger logger = Logger.getInstance(CoroutineScope.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                            logger.debug("Pypi package cache file is expired");
                            return Boxing.boxBoolean((boolean)false);
                        }
                        Set packageList = null;
                        try {
                            Object it;
                            Type type2 = new TypeToken<LinkedHashSet<String>>(){}.getType();
                            BufferedReader bufferedReader = Files.newBufferedReader(this.this$0.getFilePath(), StandardCharsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"newBufferedReader(...)");
                            Closeable closeable = bufferedReader;
                            pypiPackageCache = this.this$0;
                            Throwable throwable = null;
                            try {
                                it = (BufferedReader)closeable;
                                boolean bl = false;
                                Object object = PypiPackageCache.access$getGson$p(pypiPackageCache).fromJson((Reader)it, type2);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                                it = (LinkedHashSet)object;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            packageList = (Set)it;
                            PypiPackageCache.access$getLOG$cp().info("Package list loaded from file " + this.this$0.getFilePath() + " with " + Files.size(this.this$0.getFilePath()) / (long)1024 + "Kb size with " + ((LinkedHashSet)packageList).size() + " entries");
                        }
                        catch (JsonSyntaxException e) {
                            PypiPackageCache.access$getLOG$cp().warn("Corrupted pypi cache file: " + e);
                            return Boxing.boxBoolean((boolean)false);
                        }
                        Iterable e = packageList;
                        PypiPackageCache pypiPackageCache2 = this.this$0;
                        boolean $i$f$map = false;
                        pypiPackageCache = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            String string = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(PyPackageName.Companion.normalizePackageName((String)it));
                        }
                        PypiPackageCache.access$setCache$p(pypiPackageCache2, CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
                        return Boxing.boxBoolean((boolean)true);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * Unable to fully structure code
     */
    @CheckReturnValue
    private final Object refresh(Continuation<? super Result<Unit, ? extends IOException>> $completion) {
        if (!($completion instanceof refresh.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ PypiPackageCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PypiPackageCache.access$refresh(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(this, null){
                    int label;
                    final /* synthetic */ PypiPackageCache this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                PypiPackageCache.access$getLOG$cp().info("Loading python packages from PyPi Repository");
                                boolean $i$f$service = false;
                                Class<PypiPackageLoader> serviceClass$iv = PypiPackageLoader.class;
                                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                                if (object == null) {
                                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                                }
                                Result<Collection<String>, IOException> this_$iv = ((PypiPackageLoader)object).loadPackages();
                                boolean $i$f$getOr = false;
                                Result<Collection<String>, IOException> result2 = this_$iv;
                                if (result2 instanceof Result.Failure) {
                                    Result.Failure it = (Result.Failure)this_$iv;
                                    boolean bl = false;
                                    return it;
                                }
                                if (!(result2 instanceof Result.Success)) {
                                    throw new NoWhenBranchMatchedException();
                                }
                                Collection pypiList = (Collection)((Result.Success)this_$iv).getResult();
                                PypiPackageCache.access$getLOG$cp().info("Loaded " + pypiList.size() + " python packages from PyPi Repository");
                                PypiPackageCache.access$setCache$p(this.this$0, CollectionsKt.toSet((Iterable)pypiList));
                                PypiPackageCache.access$store(this.this$0);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<Object> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                return Result.Companion.success((Object)Unit.INSTANCE);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void store() {
        Files.createDirectories(this.filePath.getParent(), new FileAttribute[0]);
        Closeable closeable = (OutputStream)new SafeFileOutputStream(this.filePath);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Object object = charset;
        closeable = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        object = null;
        try {
            OutputStreamWriter writer = (OutputStreamWriter)closeable;
            boolean bl = false;
            this.gson.toJson((Object)CollectionsKt.toList((Iterable)this.cache), (Appendable)writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    private final boolean isFileCacheExpired() {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(this.filePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return true;
        }
        FileTime fileTime = Files.getLastModifiedTime(this.filePath, new LinkOption[0]);
        Instant expirationTime = fileTime.toInstant().plus(Duration.ofDays(1L));
        return expirationTime.isBefore(Instant.now());
    }

    public static final /* synthetic */ Object access$tryLoadFromFile(PypiPackageCache $this, Continuation $completion) {
        return $this.tryLoadFromFile((Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$refresh(PypiPackageCache $this, Continuation $completion) {
        return $this.refresh((Continuation<? super Result<Unit, ? extends IOException>>)$completion);
    }

    public static final /* synthetic */ boolean access$isFileCacheExpired(PypiPackageCache $this) {
        return $this.isFileCacheExpired();
    }

    public static final /* synthetic */ Gson access$getGson$p(PypiPackageCache $this) {
        return $this.gson;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$setCache$p(PypiPackageCache $this, Set set) {
        $this.cache = set;
    }

    public static final /* synthetic */ void access$store(PypiPackageCache $this) {
        $this.store();
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/packaging/pip/PypiPackageCache$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PACKAGE_INDEX_CACHE_PROPERTY", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005H\u0007J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/python/packaging/pip/PypiPackageCache$PypiPackageLoader;", "", "<init>", "()V", "loadPackages", "Lcom/jetbrains/python/Result;", "", "", "Ljava/io/IOException;", "loadPackagesFromPypi", "", "intellij.python.community.impl"})
    @ApiStatus.Internal
    @SourceDebugExtension(value={"SMAP\nPypiPackageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PypiPackageCache.kt\ncom/jetbrains/python/packaging/pip/PypiPackageCache$PypiPackageLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,218:1\n1586#2:219\n1661#2,3:220\n23#3:223\n23#3:224\n23#3:225\n23#3:226\n23#3:227\n23#3:228\n*S KotlinDebug\n*F\n+ 1 PypiPackageCache.kt\ncom/jetbrains/python/packaging/pip/PypiPackageCache$PypiPackageLoader\n*L\n167#1:219\n167#1:220,3\n174#1:223\n187#1:224\n195#1:225\n199#1:226\n203#1:227\n208#1:228\n*E\n"})
    public static final class PypiPackageLoader {
        /*
         * WARNING - void declaration
         */
        @RequiresBackgroundThread
        @NotNull
        public final Result<Collection<String>, IOException> loadPackages() {
            Result result2;
            try {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.loadPackagesFromPypi();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(PyPackageName.Companion.normalizePackageName((String)it));
                }
                Set pypiPackages = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                result2 = (Result)Result.Companion.success((Object)pypiPackages);
            }
            catch (IOException e) {
                result2 = (Result)Result.Companion.failure((Object)e);
            }
            catch (Throwable t) {
                PypiPackageLoader $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(PypiPackageLoader.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Cannot load pypiList from internet", t);
                throw t;
            }
            return result2;
        }

        private final List<String> loadPackagesFromPypi() {
            Throwable error = null;
            int maxAttempts = 3;
            for (int i = 0; i < maxAttempts; ++i) {
                List<String> list;
                int it = i;
                boolean bl = false;
                PypiPackageLoader $this$thisLogger$iv = this;
                boolean $i$f$thisLogger22 = false;
                Logger logger = Logger.getInstance(PypiPackageLoader.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Attempt " + (it + 1) + " to load Pypi packages list");
                try {
                    list = PyPIPackageUtil.parsePyPIListFromWeb("https://pypi.org/simple/");
                }
                catch (CancellationException t) {
                    throw t;
                }
                catch (Throwable t) {
                    PypiPackageLoader $this$thisLogger$iv2 = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger2 = Logger.getInstance(PypiPackageLoader.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                    logger2.warn("Attempt " + (it + 1) + " Cannot load Pypi packages list", t);
                    error = t;
                    continue;
                }
                List<String> $i$f$thisLogger22 = list;
                Intrinsics.checkNotNull($i$f$thisLogger22);
                List<String> loaded = $i$f$thisLogger22;
                PypiPackageLoader $this$thisLogger$iv3 = this;
                boolean $i$f$thisLogger = false;
                Logger logger3 = Logger.getInstance(PypiPackageLoader.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
                logger3.debug("Attempt " + (it + 1) + " Loaded " + loaded.size() + " Pypi packages");
                if (loaded.size() > 2) {
                    return loaded;
                }
                $this$thisLogger$iv3 = this;
                $i$f$thisLogger = false;
                Logger logger4 = Logger.getInstance(PypiPackageLoader.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getInstance(...)");
                logger4.debug("Attempt " + (it + 1) + " Return TOO SMALL Pypi packages list. Loaded " + loaded);
            }
            if (error != null) {
                throw error;
            }
            PypiPackageLoader $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PypiPackageLoader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Return empty Pypi packages list after " + maxAttempts + " attempts");
            return CollectionsKt.emptyList();
        }
    }
}

