/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.setupPy;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.setupPy.SetupTask;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SetupTaskIntrospector {
    private static final Logger LOG = Logger.getInstance(SetupTaskIntrospector.class);
    private static final Map<String, List<SetupTask>> ourDistutilsTaskCache = new HashMap<String, List<SetupTask>>();
    private static final Map<String, List<SetupTask>> ourSetuptoolsTaskCache = new HashMap<String, List<SetupTask>>();
    private static final Set<String> SKIP_NAMES = ImmutableSet.of((Object)"__init__.py", (Object)"alias.py", (Object)"setopt.py", (Object)"savecfg.py");

    @Nullable
    public static List<SetupTask.Option> getSetupTaskOptions(Module module2, String taskName) {
        for (SetupTask task2 : SetupTaskIntrospector.getTaskList(module2)) {
            if (!task2.getName().equals(taskName)) continue;
            return task2.getOptions();
        }
        return null;
    }

    @NotNull
    public static List<SetupTask> getTaskList(Module module2) {
        PyFile setupPy = PyPackageUtil.findSetupPy(module2);
        return SetupTaskIntrospector.getTaskList(module2, setupPy != null && PyPsiUtils.containsImport((PyFile)setupPy, (String)"setuptools"));
    }

    @NotNull
    private static List<SetupTask> getTaskList(@NotNull Module module2, boolean setuptools) {
        PsiDirectory commandDir;
        QualifiedName name2;
        PsiElement install2;
        if (module2 == null) {
            SetupTaskIntrospector.$$$reportNull$$$0(0);
        }
        if ((install2 = PyResolveImportUtil.resolveTopLevelMember((QualifiedName)(name2 = QualifiedName.fromDottedString((String)((setuptools ? "setuptools" : "distutils") + ".command.install.install"))), (PyQualifiedNameResolveContext)PyResolveImportUtil.fromModule((Module)module2))) instanceof PyClass && (commandDir = install2.getContainingFile().getParent()) != null) {
            String path2;
            Map<String, List<SetupTask>> cache2 = setuptools ? ourSetuptoolsTaskCache : ourDistutilsTaskCache;
            List<SetupTask> tasks = cache2.get(path2 = commandDir.getVirtualFile().getPath());
            if (tasks == null) {
                tasks = SetupTaskIntrospector.collectTasks(module2, commandDir, setuptools);
                cache2.put(path2, tasks);
            }
            List<SetupTask> list = tasks;
            if (list == null) {
                SetupTaskIntrospector.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<SetupTask> list = Collections.emptyList();
        if (list == null) {
            SetupTaskIntrospector.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private static List<SetupTask> collectTasks(@NotNull Module module2, @NotNull PsiDirectory commandDir, boolean setuptools) {
        PsiFile file;
        QualifiedName name2;
        PsiElement bdistWheel;
        if (module2 == null) {
            SetupTaskIntrospector.$$$reportNull$$$0(3);
        }
        if (commandDir == null) {
            SetupTaskIntrospector.$$$reportNull$$$0(4);
        }
        ArrayList<SetupTask> result2 = new ArrayList<SetupTask>();
        for (PsiFile commandFile : commandDir.getFiles()) {
            if (!(commandFile instanceof PyFile) || SKIP_NAMES.contains(commandFile.getName())) continue;
            String taskName = FileUtilRt.getNameWithoutExtension((String)commandFile.getName());
            result2.add(SetupTaskIntrospector.createTaskFromFile((PyFile)commandFile, taskName, setuptools));
        }
        if (setuptools && (bdistWheel = PyResolveImportUtil.resolveTopLevelMember((QualifiedName)(name2 = QualifiedName.fromComponents((String[])new String[]{"wheel", "bdist_wheel", "bdist_wheel"})), (PyQualifiedNameResolveContext)PyResolveImportUtil.fromModule((Module)module2))) instanceof PyClass && (file = bdistWheel.getContainingFile()) instanceof PyFile) {
            result2.add(SetupTaskIntrospector.createTaskFromFile((PyFile)file, "bdist_wheel", true));
        }
        ArrayList<SetupTask> arrayList = result2;
        if (arrayList == null) {
            SetupTaskIntrospector.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static SetupTask createTaskFromFile(@NotNull PyFile file, @NotNull @NlsSafe String name2, boolean setuptools) {
        PyClass taskClass;
        if (file == null) {
            SetupTaskIntrospector.$$$reportNull$$$0(6);
        }
        if (name2 == null) {
            SetupTaskIntrospector.$$$reportNull$$$0(7);
        }
        SetupTask task2 = new SetupTask(name2);
        PyClass pyClass = taskClass = name2.equals("build_ext") && setuptools ? PyPsiFacade.getInstance((Project)file.getProject()).createClassByQName("distutils.command.build_ext.build_ext", (PsiElement)file) : file.findTopLevelClass(name2);
        if (taskClass != null) {
            String descriptionText;
            PyTargetExpression description = taskClass.findClassAttribute("description", true, null);
            if (description != null && (descriptionText = PyPsiUtils.strValue((PyExpression)PyPsiUtils.flattenParens((PyExpression)description.findAssignedValue()))) != null) {
                task2.setDescription(descriptionText);
            }
            List<PyExpression> booleanOptions = SetupTaskIntrospector.resolveSequenceValue(taskClass, "boolean_options");
            ArrayList<String> booleanOptionsList = new ArrayList<String>();
            for (PyExpression option : booleanOptions) {
                String s = PyPsiUtils.strValue((PyExpression)option);
                if (s == null) continue;
                booleanOptionsList.add(s);
            }
            PyTargetExpression negativeOpt = taskClass.findClassAttribute("negative_opt", true, null);
            Map<String, String> negativeOptMap = negativeOpt == null ? Collections.emptyMap() : SetupTaskIntrospector.parseNegativeOpt(negativeOpt.findAssignedValue());
            List<PyExpression> userOptions = SetupTaskIntrospector.resolveSequenceValue(taskClass, "user_options");
            for (PyExpression element2 : userOptions) {
                SetupTask.Option option = SetupTaskIntrospector.createOptionFromTuple(element2, booleanOptionsList, negativeOptMap);
                if (option == null) continue;
                task2.addOption(option);
            }
        }
        return task2;
    }

    private static List<PyExpression> resolveSequenceValue(PyClass aClass, String name2) {
        ArrayList<PyExpression> result2 = new ArrayList<PyExpression>();
        SetupTaskIntrospector.collectSequenceElements((PsiElement)aClass.findClassAttribute(name2, true, null), result2);
        return result2;
    }

    private static void collectSequenceElements(PsiElement value, List<PyExpression> result2) {
        if (value instanceof PySequenceExpression) {
            Collections.addAll(result2, ((PySequenceExpression)value).getElements());
        } else if (value instanceof PyBinaryExpression) {
            PyBinaryExpression binaryExpression = (PyBinaryExpression)value;
            if (binaryExpression.isOperator("+")) {
                SetupTaskIntrospector.collectSequenceElements((PsiElement)binaryExpression.getLeftExpression(), result2);
                SetupTaskIntrospector.collectSequenceElements((PsiElement)binaryExpression.getRightExpression(), result2);
            }
        } else if (value instanceof PyReferenceExpression) {
            TypeEvalContext context = TypeEvalContext.codeInsightFallback((Project)value.getProject());
            PsiElement resolveResult = ((PyReferenceExpression)value).getReference(PyResolveContext.defaultContext((TypeEvalContext)context)).resolve();
            SetupTaskIntrospector.collectSequenceElements(resolveResult, result2);
        } else if (value instanceof PyTargetExpression) {
            SetupTaskIntrospector.collectSequenceElements((PsiElement)((PyTargetExpression)value).findAssignedValue(), result2);
        }
    }

    private static Map<String, String> parseNegativeOpt(PyExpression dict) {
        HashMap<String, String> result2 = new HashMap<String, String>();
        if ((dict = PyPsiUtils.flattenParens((PyExpression)dict)) instanceof PyDictLiteralExpression) {
            PyKeyValueExpression[] elements;
            for (PyKeyValueExpression element2 : elements = ((PyDictLiteralExpression)dict).getElements()) {
                String key = PyPsiUtils.strValue((PyExpression)PyPsiUtils.flattenParens((PyExpression)element2.getKey()));
                String value = PyPsiUtils.strValue((PyExpression)PyPsiUtils.flattenParens((PyExpression)element2.getValue()));
                if (key == null || value == null) continue;
                result2.put(key, value);
            }
        }
        return result2;
    }

    @Nullable
    private static SetupTask.Option createOptionFromTuple(PyExpression tuple, List<String> booleanOptions, Map<String, String> negativeOptMap) {
        PyExpression[] elements;
        if ((tuple = PyPsiUtils.flattenParens((PyExpression)tuple)) instanceof PyTupleExpression && (elements = ((PyTupleExpression)tuple).getElements()).length == 3) {
            String name2 = PyPsiUtils.strValue((PyExpression)elements[0]);
            String description = PyPsiUtils.strValue((PyExpression)elements[2]);
            if (name2 != null && description != null) {
                if (negativeOptMap.containsKey(name2)) {
                    return null;
                }
                if (description.contains("don't use") || description.contains("deprecated")) {
                    return null;
                }
                boolean checkbox = booleanOptions.contains(name2);
                boolean negative = false;
                if (negativeOptMap.containsValue(name2)) {
                    negative = true;
                    for (Map.Entry<String, String> entry : negativeOptMap.entrySet()) {
                        if (!entry.getValue().equals(name2)) continue;
                        name2 = entry.getKey();
                        break;
                    }
                }
                return new SetupTask.Option(name2, StringUtil.capitalize((String)description), checkbox, negative);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/setupPy/SetupTaskIntrospector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/setupPy/SetupTaskIntrospector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTaskList";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectTasks";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTaskFromFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5 -> new IllegalStateException(string);
        };
    }
}

