/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.introduce.constant;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import com.jetbrains.python.refactoring.introduce.IntroduceHandler;
import com.jetbrains.python.refactoring.introduce.IntroduceOperation;
import com.jetbrains.python.refactoring.introduce.IntroduceValidator;
import com.jetbrains.python.refactoring.introduce.constant.ConstantValidator;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyIntroduceConstantHandler
extends IntroduceHandler {
    public PyIntroduceConstantHandler() {
        super((IntroduceValidator)new ConstantValidator(), PyPsiBundle.message((String)"refactoring.introduce.constant.dialog.title", (Object[])new Object[0]));
    }

    protected PsiElement replaceExpression(PsiElement expression, PyExpression newExpression, IntroduceOperation operation) {
        if (PsiTreeUtil.getParentOfType((PsiElement)expression, ScopeOwner.class) instanceof PyFile) {
            return super.replaceExpression(expression, newExpression, operation);
        }
        return PyReplaceExpressionUtil.replaceExpression((PsiElement)expression, (PsiElement)newExpression);
    }

    protected PsiElement addDeclaration(@NotNull PsiElement expression, @NotNull PsiElement declaration, @NotNull IntroduceOperation operation) {
        if (expression == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(0);
        }
        if (declaration == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(1);
        }
        if (operation == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(2);
        }
        PsiFile containingFile = expression.getContainingFile();
        assert (containingFile instanceof PyFile);
        PsiElement initialPosition = AddImportHelper.getFileInsertPosition((PsiFile)((PyFile)containingFile));
        List sameFileRefs = PyIntroduceConstantHandler.collectReferencedDefinitionsInSameFile((PsiElement)operation.getElement(), (PsiFile)operation.getFile());
        PsiElement maxPosition = PyIntroduceConstantHandler.getLowermostTopLevelStatement(sameFileRefs);
        if (maxPosition == null) {
            return containingFile.addBefore(declaration, initialPosition);
        }
        assert (PyUtil.isTopLevel((PsiElement)maxPosition));
        return containingFile.addAfter(declaration, maxPosition);
    }

    protected Collection<String> generateSuggestedNames(@NotNull PyExpression expression) {
        if (expression == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(3);
        }
        HashSet<String> names = new HashSet<String>();
        for (String name2 : super.generateSuggestedNames(expression)) {
            names.add(StringUtil.toUpperCase((String)name2));
        }
        return names;
    }

    protected boolean isValidIntroduceContext(PsiElement element2) {
        return super.isValidIntroduceContext(element2) || PsiTreeUtil.getParentOfType((PsiElement)element2, PyParameterList.class) != null;
    }

    protected boolean checkEnabled(@NotNull IntroduceOperation operation) {
        PsiElement selectionElement;
        PsiFile containingFile;
        if (operation == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(4);
        }
        if (!((containingFile = (selectionElement = PyIntroduceConstantHandler.getOriginalSelectionCoveringElement((PsiElement)operation.getElement())).getContainingFile()) instanceof PyFile)) {
            return false;
        }
        Editor editor2 = operation.getEditor();
        if (editor2 == null) {
            return false;
        }
        List sameFileRefs = PyIntroduceConstantHandler.collectReferencedDefinitionsInSameFile((PsiElement)operation.getElement(), (PsiFile)operation.getFile());
        if (!ContainerUtil.all((Collection)sameFileRefs, it -> PyUtil.isTopLevel((PsiElement)it))) {
            return false;
        }
        PsiElement maxPosition = PyIntroduceConstantHandler.getLowermostTopLevelStatement(sameFileRefs);
        if (maxPosition == null) {
            return true;
        }
        return PsiUtilCore.compareElementsByPosition((PsiElement)maxPosition, (PsiElement)selectionElement) <= 0 && !PsiTreeUtil.isAncestor((PsiElement)maxPosition, (PsiElement)selectionElement, (boolean)false);
    }

    @Nullable
    private static PsiElement getLowermostTopLevelStatement(@NotNull List<PsiElement> elements) {
        if (elements == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(5);
        }
        return StreamEx.of(elements).map(it -> PyPsiUtils.getParentRightBefore((PsiElement)it, (PsiElement)it.getContainingFile())).select(PyStatement.class).max(PsiUtilCore::compareElementsByPosition).orElse(null);
    }

    protected void showCanNotIntroduceErrorHint(@NotNull Project project, @NotNull Editor editor2) {
        if (project == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            PyIntroduceConstantHandler.$$$reportNull$$$0(7);
        }
        String message = RefactoringBundle.getCannotRefactorMessage((String)PyPsiBundle.message((String)"refactoring.introduce.constant.cannot.extract.selected.expression", (Object[])new Object[0]));
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message, (String)this.myDialogTitle, (String)this.getHelpId());
    }

    protected String getHelpId() {
        return "python.reference.introduceConstant";
    }

    protected String getRefactoringId() {
        return "refactoring.python.introduce.constant";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/introduce/constant/PyIntroduceConstantHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "generateSuggestedNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getLowermostTopLevelStatement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showCanNotIntroduceErrorHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

