/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move.moduleMembers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyMoveModuleMembersHelper {
    private PyMoveModuleMembersHelper() {
    }

    public static boolean isMovableModuleMember(@NotNull PsiElement element2) {
        if (element2 == null) {
            PyMoveModuleMembersHelper.$$$reportNull$$$0(0);
        }
        if (!PyMoveModuleMembersHelper.hasMovableElementType(element2) || !PyUtil.isTopLevel((PsiElement)element2)) {
            return false;
        }
        if (element2 instanceof PyTargetExpression) {
            return !"__all__".equals(((PyTargetExpression)element2).getName()) && PyMoveModuleMembersHelper.isTargetOfSimpleAssignment(element2);
        }
        return true;
    }

    public static boolean hasMovableElementType(@NotNull PsiElement element2) {
        if (element2 == null) {
            PyMoveModuleMembersHelper.$$$reportNull$$$0(1);
        }
        return element2 instanceof PyClass || element2 instanceof PyFunction || element2 instanceof PyTargetExpression;
    }

    public static boolean isTargetOfSimpleAssignment(@NotNull PsiElement element2) {
        PyTargetExpression target;
        if (element2 == null) {
            PyMoveModuleMembersHelper.$$$reportNull$$$0(2);
        }
        if ((target = (PyTargetExpression)PyUtil.as((Object)element2, PyTargetExpression.class)) == null || target.isQualified()) {
            return false;
        }
        PyAssignmentStatement assignment = (PyAssignmentStatement)PyUtil.as((Object)target.getParent(), PyAssignmentStatement.class);
        return assignment != null && assignment.getTargets().length == 1;
    }

    public static List<PyElement> getTopLevelModuleMembers(@NotNull PyFile pyFile) {
        if (pyFile == null) {
            PyMoveModuleMembersHelper.$$$reportNull$$$0(3);
        }
        ArrayList<PyElement> result2 = new ArrayList<PyElement>();
        for (PyTargetExpression attr : pyFile.getTopLevelAttributes()) {
            if (!PyMoveModuleMembersHelper.isMovableModuleMember((PsiElement)attr)) continue;
            result2.add((PyElement)attr);
        }
        result2.addAll(pyFile.getTopLevelClasses());
        result2.addAll(pyFile.getTopLevelFunctions());
        return result2;
    }

    @Nullable
    public static PsiElement expandNamedElementBody(@NotNull PsiNamedElement element2) {
        if (element2 == null) {
            PyMoveModuleMembersHelper.$$$reportNull$$$0(4);
        }
        if (element2 instanceof PyClass || element2 instanceof PyFunction) {
            return element2;
        }
        if (element2 instanceof PyTargetExpression && element2.getParent() instanceof PyAssignmentStatement) {
            return element2.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiNamedElement extractNamedElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            PyMoveModuleMembersHelper.$$$reportNull$$$0(5);
        }
        if (element2 instanceof PyClass || element2 instanceof PyFunction || element2 instanceof PyTargetExpression) {
            return (PsiNamedElement)element2;
        }
        PyAssignmentStatement assignment = (PyAssignmentStatement)PyUtil.as((Object)element2, PyAssignmentStatement.class);
        if (assignment != null) {
            return (PsiNamedElement)PyUtil.as((Object)assignment.getTargets()[0], PyTargetExpression.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/move/moduleMembers/PyMoveModuleMembersHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isMovableModuleMember";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMovableElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isTargetOfSimpleAssignment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTopLevelModuleMembers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "expandNamedElementBody";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "extractNamedElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

