/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.AbstractRunConfiguration;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PyCommonOptionsFormData;
import com.jetbrains.python.run.PythonExtendedConfigurationEditor;
import com.jetbrains.python.run.PythonRunConfigurationExtensionsManager;
import com.jetbrains.python.run.PythonScriptCommandLineState;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPythonRunConfiguration<T extends AbstractPythonRunConfiguration<T>>
extends AbstractRunConfiguration
implements AbstractPythonRunConfigurationParams,
CommandLinePatcher,
RunProfileWithCompileBeforeLaunchOption {
    private static final String RUN_TOOL = "RUN_TOOL";
    @Nullable
    private Boolean useRunTool;
    private String myInterpreterOptions;
    private String myWorkingDirectory;
    private String mySdkHome;
    private Sdk mySdk;
    private boolean myUseModuleSdk;
    private boolean myAddContentRoots;
    private boolean myAddSourceRoots;
    protected PathMappingSettings myMappingSettings;
    protected boolean mySkipModuleSerialization;
    @NotNull
    private List<String> myEnvFiles;

    public AbstractPythonRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory) {
        if (project == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(1);
        }
        super(project, factory);
        this.useRunTool = null;
        this.myInterpreterOptions = "";
        this.myWorkingDirectory = "";
        this.mySdkHome = "";
        this.mySdk = null;
        this.myAddContentRoots = true;
        this.myAddSourceRoots = true;
        this.myEnvFiles = Collections.emptyList();
        this.getConfigurationModule().setModuleToAnyFirstIfNotSpecified();
    }

    public List<Module> getValidModules() {
        return AbstractPythonRunConfiguration.getValidModules(this.getProject());
    }

    @Override
    public PathMappingSettings getMappingSettings() {
        return this.myMappingSettings;
    }

    @Override
    public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
        this.myMappingSettings = mappingSettings;
    }

    public boolean isIdTestBased() {
        return false;
    }

    public static List<Module> getValidModules(Project project) {
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        ArrayList<Module> result2 = new ArrayList<Module>();
        for (Module module2 : modules) {
            if (PythonSdkUtil.findPythonSdk((Module)module2) == null) continue;
            result2.add(module2);
        }
        return result2;
    }

    public PyCommonOptionsFormData getCommonOptionsFormData() {
        return new PyCommonOptionsFormData(){

            @Override
            public Project getProject() {
                return AbstractPythonRunConfiguration.this.getProject();
            }

            @Override
            public List<Module> getValidModules() {
                return AbstractPythonRunConfiguration.this.getValidModules();
            }

            @Override
            public boolean showConfigureInterpretersLink() {
                return false;
            }
        };
    }

    @NotNull
    public final SettingsEditor<T> getConfigurationEditor() {
        if (Registry.is((String)"python.new.run.config", (boolean)false) && this.isNewUiSupported()) {
            SettingsEditor<T> settingsEditor = this.createConfigurationEditor();
            if (settingsEditor == null) {
                AbstractPythonRunConfiguration.$$$reportNull$$$0(2);
            }
            return settingsEditor;
        }
        PythonExtendedConfigurationEditor<T> runConfigurationEditor = PythonExtendedConfigurationEditor.create(this.createConfigurationEditor());
        SettingsEditorGroup group2 = new SettingsEditorGroup();
        group2.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), runConfigurationEditor);
        PythonRunConfigurationExtensionsManager.Companion.getInstance().appendEditors((RunConfigurationBase)this, group2);
        group2.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group2;
        if (settingsEditorGroup == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(3);
        }
        return settingsEditorGroup;
    }

    protected boolean isNewUiSupported() {
        return false;
    }

    protected abstract SettingsEditor<T> createConfigurationEditor();

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        this.checkSdk();
        this.checkExtensions();
    }

    private void checkExtensions() throws RuntimeConfigurationException {
        try {
            PythonRunConfigurationExtensionsManager.Companion.getInstance().validateConfiguration((RunConfigurationBase)this, false);
        }
        catch (RuntimeConfigurationException e) {
            throw e;
        }
        catch (Exception ee) {
            throw new RuntimeConfigurationException(ee.getMessage());
        }
    }

    private void checkSdk() throws RuntimeConfigurationError {
        if (PlatformUtils.isPyCharm()) {
            String path2 = this.getInterpreterPath();
            if (StringUtil.isEmptyOrSpaces((String)path2)) {
                throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_valid_sdk", new Object[0]));
            }
        } else if (!this.myUseModuleSdk) {
            if (StringUtil.isEmptyOrSpaces((String)this.getSdkHome())) {
                Sdk projectSdk = ProjectRootManager.getInstance((Project)this.getProject()).getProjectSdk();
                if (projectSdk == null || !PythonSdkUtil.isPythonSdk((Sdk)projectSdk)) {
                    throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_sdk", new Object[0]));
                }
            } else if (this.mySdk == null || !PySdkExtKt.getSdkSeemsValid(this.mySdk)) {
                throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_valid_sdk", new Object[0]));
            }
        } else {
            Sdk sdk2 = PythonSdkUtil.findPythonSdk((Module)this.getModule());
            if (sdk2 == null) {
                throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_module_sdk", new Object[0]));
            }
        }
    }

    @Override
    public String getSdkHome() {
        Sdk projectJdk;
        if (this.mySdk != null) {
            return this.mySdk.getHomePath();
        }
        String sdkHome = this.mySdkHome;
        if (StringUtil.isEmptyOrSpaces((String)this.mySdkHome) && (projectJdk = PythonSdkUtil.findPythonSdk((Module)this.getModule())) != null) {
            sdkHome = projectJdk.getHomePath();
        }
        return sdkHome;
    }

    @Nullable
    public String getInterpreterPath() {
        String sdkHome;
        if (this.myUseModuleSdk) {
            Sdk sdk2 = PythonSdkUtil.findPythonSdk((Module)this.getModule());
            if (sdk2 == null) {
                return null;
            }
            sdkHome = sdk2.getHomePath();
        } else {
            sdkHome = this.mySdk != null ? this.mySdk.getHomePath() : this.getSdkHome();
        }
        return sdkHome;
    }

    @Override
    @Transient
    @Nullable
    public Sdk getSdk() {
        if (this.myUseModuleSdk) {
            return PythonSdkUtil.findPythonSdk((Module)this.getModule());
        }
        if (this.mySdk != null) {
            return this.mySdk;
        }
        return PythonSdkUtil.findSdkByPath((String)this.getSdkHome());
    }

    @NotNull
    public List<String> getEnvFilePaths() {
        List<String> list = this.myEnvFiles;
        if (list == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void setEnvFilePaths(@NotNull List<String> envFiles) {
        if (envFiles == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(5);
        }
        this.myEnvFiles = envFiles;
    }

    public void readExternal(@NotNull Element element2) throws InvalidDataException {
        String output2;
        if (element2 == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(6);
        }
        super.readExternal(element2);
        this.myInterpreterOptions = JDOMExternalizerUtil.readField((Element)element2, (String)"INTERPRETER_OPTIONS");
        this.readEnvs(element2);
        this.mySdkHome = JDOMExternalizerUtil.readField((Element)element2, (String)"SDK_HOME");
        String sdkName2 = JDOMExternalizerUtil.readField((Element)element2, (String)"SDK_NAME");
        if (sdkName2 != null) {
            this.mySdk = PythonSdkUtil.findSdkByKey((String)sdkName2);
        }
        this.myEnvFiles = (output2 = JDOMExternalizerUtil.readField((Element)element2, (String)"ENV_FILES")) != null ? StringUtil.split((String)output2, (String)File.pathSeparator) : Collections.emptyList();
        this.myWorkingDirectory = JDOMExternalizerUtil.readField((Element)element2, (String)"WORKING_DIRECTORY");
        this.myUseModuleSdk = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element2, (String)"IS_MODULE_SDK"));
        String addContentRoots = JDOMExternalizerUtil.readField((Element)element2, (String)"ADD_CONTENT_ROOTS");
        this.myAddContentRoots = addContentRoots == null || Boolean.parseBoolean(addContentRoots);
        String addSourceRoots = JDOMExternalizerUtil.readField((Element)element2, (String)"ADD_SOURCE_ROOTS");
        boolean bl = this.myAddSourceRoots = addSourceRoots == null || Boolean.parseBoolean(addSourceRoots);
        if (!this.mySkipModuleSerialization) {
            this.getConfigurationModule().readExternal(element2);
        }
        this.setMappingSettings(PathMappingSettings.readExternal((Element)element2));
        PythonRunConfigurationExtensionsManager.Companion.getInstance().readExternal((RunConfigurationBase)this, element2);
        String runToolValue = JDOMExternalizerUtil.readField((Element)element2, (String)RUN_TOOL);
        this.useRunTool = StringUtil.isEmpty((String)runToolValue) ? null : Boolean.valueOf(Boolean.parseBoolean(runToolValue));
    }

    protected void readEnvs(Element element2) {
        String parentEnvs = JDOMExternalizerUtil.readField((Element)element2, (String)"PARENT_ENVS");
        if (parentEnvs != null) {
            this.setPassParentEnvs(Boolean.parseBoolean(parentEnvs));
        }
        EnvironmentVariablesComponent.readExternal((Element)element2, (Map)this.getEnvs());
    }

    public void writeExternal(@NotNull Element element2) throws WriteExternalException {
        if (element2 == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(7);
        }
        super.writeExternal(element2);
        JDOMExternalizerUtil.writeField((Element)element2, (String)"ENV_FILES", (String)String.join((CharSequence)File.pathSeparator, this.myEnvFiles));
        JDOMExternalizerUtil.writeField((Element)element2, (String)"INTERPRETER_OPTIONS", (String)this.myInterpreterOptions);
        this.writeEnvs(element2);
        JDOMExternalizerUtil.writeField((Element)element2, (String)"SDK_HOME", (String)this.mySdkHome);
        if (this.mySdk != null) {
            JDOMExternalizerUtil.writeField((Element)element2, (String)"SDK_NAME", (String)this.mySdk.getName());
        }
        JDOMExternalizerUtil.writeField((Element)element2, (String)"WORKING_DIRECTORY", (String)this.myWorkingDirectory);
        JDOMExternalizerUtil.writeField((Element)element2, (String)"IS_MODULE_SDK", (String)Boolean.toString(this.myUseModuleSdk));
        JDOMExternalizerUtil.writeField((Element)element2, (String)"ADD_CONTENT_ROOTS", (String)Boolean.toString(this.myAddContentRoots));
        JDOMExternalizerUtil.writeField((Element)element2, (String)"ADD_SOURCE_ROOTS", (String)Boolean.toString(this.myAddSourceRoots));
        if (!this.mySkipModuleSerialization) {
            this.getConfigurationModule().writeExternal(element2);
        }
        PythonRunConfigurationExtensionsManager.Companion.getInstance().writeExternal((RunConfigurationBase)this, element2);
        PathMappingSettings.writeExternal((Element)element2, (PathMappingSettings)this.getMappingSettings());
        JDOMExternalizerUtil.writeField((Element)element2, (String)RUN_TOOL, this.useRunTool == null ? null : Boolean.toString(this.useRunTool));
    }

    protected void writeEnvs(Element element2) {
        JDOMExternalizerUtil.writeField((Element)element2, (String)"PARENT_ENVS", (String)Boolean.toString(this.isPassParentEnvs()));
        EnvironmentVariablesComponent.writeExternal((Element)element2, (Map)this.getEnvs());
    }

    @Override
    public String getInterpreterOptions() {
        return this.myInterpreterOptions;
    }

    @Override
    public void setInterpreterOptions(String interpreterOptions) {
        this.myInterpreterOptions = interpreterOptions;
    }

    @Override
    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    @Override
    public void setWorkingDirectory(String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    @Override
    public void setSdkHome(String sdkHome) {
        this.mySdkHome = sdkHome;
    }

    @Override
    @Transient
    public void setSdk(@Nullable Sdk sdk2) {
        this.mySdk = sdk2;
    }

    @Override
    @Transient
    @Nullable
    public Module getModule() {
        return this.getConfigurationModule().getModule();
    }

    @Override
    public boolean isUseModuleSdk() {
        return this.myUseModuleSdk;
    }

    @Override
    public void setUseModuleSdk(boolean useModuleSdk) {
        this.myUseModuleSdk = useModuleSdk;
    }

    @Override
    public boolean shouldAddContentRoots() {
        return this.myAddContentRoots;
    }

    @Override
    public boolean shouldAddSourceRoots() {
        return this.myAddSourceRoots;
    }

    @Override
    public void setAddSourceRoots(boolean flag) {
        this.myAddSourceRoots = flag;
    }

    @Override
    public void setAddContentRoots(boolean flag) {
        this.myAddContentRoots = flag;
    }

    public static void copyParams(AbstractPythonRunConfigurationParams source, AbstractPythonRunConfigurationParams target) {
        target.setEnvFilePaths(source.getEnvFilePaths());
        target.setEnvs(new LinkedHashMap<String, String>(source.getEnvs()));
        target.setInterpreterOptions(source.getInterpreterOptions());
        target.setPassParentEnvs(source.isPassParentEnvs());
        target.setSdkHome(source.getSdkHome());
        target.setSdk(source.getSdk());
        target.setWorkingDirectory(source.getWorkingDirectory());
        target.setModule(source.getModule());
        target.setUseModuleSdk(source.isUseModuleSdk());
        target.setMappingSettings(source.getMappingSettings());
        target.setAddContentRoots(source.shouldAddContentRoots());
        target.setAddSourceRoots(source.shouldAddSourceRoots());
        target.setUseRunTool(source.getUseRunTool());
    }

    public void patchCommandLine(GeneralCommandLine commandLine) {
        String interpreterPath = this.getInterpreterPath();
        Sdk sdk2 = this.getSdk();
        if (sdk2 != null && interpreterPath != null) {
            this.patchCommandLineFirst(commandLine, interpreterPath);
            this.patchCommandLineForVirtualenv(commandLine, sdk2);
            this.patchCommandLineLast(commandLine, interpreterPath);
        }
    }

    protected void patchCommandLineFirst(GeneralCommandLine commandLine, String sdkHome) {
    }

    protected void patchCommandLineLast(GeneralCommandLine commandLine, String sdkHome) {
    }

    protected void patchCommandLineForVirtualenv(@NotNull GeneralCommandLine commandLine, @NotNull Sdk sdk2) {
        if (commandLine == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(8);
        }
        if (sdk2 == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(9);
        }
        PythonSdkType.patchCommandLineForVirtualenv(commandLine, sdk2);
    }

    protected void setUnbufferedEnv() {
        Map envs = this.getEnvs();
        PythonEnvUtil.setPythonUnbuffered((Map)envs);
    }

    public boolean isExcludeCompileBeforeLaunchOption() {
        Module module2 = this.getModule();
        return module2 == null || ModuleType.get((Module)module2) instanceof PythonModuleTypeBase;
    }

    public boolean canRunWithCoverage() {
        return true;
    }

    @NotNull
    public String getWorkingDirectorySafe() {
        String result2;
        String string = result2 = StringUtil.isEmpty((String)this.myWorkingDirectory) ? this.getProject().getBasePath() : PythonScriptCommandLineState.getExpandedWorkingDir(this);
        if (result2 != null) {
            String string2 = result2;
            if (string2 == null) {
                AbstractPythonRunConfiguration.$$$reportNull$$$0(10);
            }
            return string2;
        }
        String firstModuleRoot = this.getFirstModuleRoot();
        if (firstModuleRoot != null) {
            String string3 = firstModuleRoot;
            if (string3 == null) {
                AbstractPythonRunConfiguration.$$$reportNull$$$0(11);
            }
            return string3;
        }
        String string4 = new File(".").getAbsolutePath();
        if (string4 == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(12);
        }
        return string4;
    }

    @Nullable
    private String getFirstModuleRoot() {
        Module module2 = this.getModule();
        if (module2 == null) {
            return null;
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        return roots.length > 0 ? roots[0].getPath() : null;
    }

    @Override
    public String getModuleName() {
        Module module2 = this.getModule();
        return module2 != null ? module2.getName() : null;
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public final Boolean getUseRunTool() {
        return this.useRunTool;
    }

    @Override
    @ApiStatus.Internal
    public final void setUseRunTool(@Nullable Boolean useRunTool) {
        this.useRunTool = useRunTool;
    }

    public boolean isBuildBeforeLaunchAddedByDefault() {
        return false;
    }

    public void addTestSpecsAsParameters(@NotNull ParamsGroup paramsGroup, @NotNull List<String> testSpecs) {
        if (paramsGroup == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(13);
        }
        if (testSpecs == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(14);
        }
        paramsGroup.addParameters(testSpecs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/AbstractPythonRunConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envFiles";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramsGroup";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testSpecs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/AbstractPythonRunConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvFilePaths";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectorySafe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setEnvFilePaths";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLineForVirtualenv";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addTestSpecsAsParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

