/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.PythonScriptCommandLineState;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import com.jetbrains.python.testing.AbstractPythonTestRunConfigurationParams;
import java.io.File;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPythonLegacyTestRunConfiguration<T extends AbstractPythonTestRunConfiguration<T>>
extends AbstractPythonTestRunConfiguration<T>
implements AbstractPythonRunConfigurationParams,
AbstractPythonTestRunConfigurationParams,
RefactoringListenerProvider {
    @NlsSafe
    protected String myClassName = "";
    @NlsSafe
    protected String myScriptName = "";
    @NlsSafe
    protected String myMethodName = "";
    @NlsSafe
    protected String myFolderName = "";
    protected TestType myTestType = TestType.TEST_SCRIPT;
    @NlsSafe
    private String myPattern = "";
    private boolean usePattern = false;

    protected AbstractPythonLegacyTestRunConfiguration(Project project, ConfigurationFactory configurationFactory) {
        super(project, configurationFactory);
    }

    @Override
    @NotNull
    public String getWorkingDirectorySafe() {
        VirtualFile script;
        String workingDirectoryFromConfig = this.getWorkingDirectory();
        if (StringUtil.isNotEmpty((String)workingDirectoryFromConfig)) {
            String string = PythonScriptCommandLineState.getExpandedWorkingDir(this);
            if (string == null) {
                AbstractPythonLegacyTestRunConfiguration.$$$reportNull$$$0(0);
            }
            return string;
        }
        String folderName = this.myFolderName;
        if (!StringUtil.isEmptyOrSpaces((String)folderName)) {
            String string = folderName;
            if (string == null) {
                AbstractPythonLegacyTestRunConfiguration.$$$reportNull$$$0(1);
            }
            return string;
        }
        String scriptName = this.myScriptName;
        if (!StringUtil.isEmptyOrSpaces((String)scriptName) && (script = LocalFileSystem.getInstance().findFileByPath(scriptName)) != null) {
            String string = script.getParent().getPath();
            if (string == null) {
                AbstractPythonLegacyTestRunConfiguration.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = super.getWorkingDirectorySafe();
        if (string == null) {
            AbstractPythonLegacyTestRunConfiguration.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public void readExternal(@NotNull Element element2) throws InvalidDataException {
        if (element2 == null) {
            AbstractPythonLegacyTestRunConfiguration.$$$reportNull$$$0(4);
        }
        super.readExternal(element2);
        this.myScriptName = JDOMExternalizerUtil.readField((Element)element2, (String)"SCRIPT_NAME");
        this.myClassName = JDOMExternalizerUtil.readField((Element)element2, (String)"CLASS_NAME");
        this.myMethodName = JDOMExternalizerUtil.readField((Element)element2, (String)"METHOD_NAME");
        this.myFolderName = JDOMExternalizerUtil.readField((Element)element2, (String)"FOLDER_NAME");
        this.myPattern = JDOMExternalizerUtil.readField((Element)element2, (String)"PATTERN");
        this.usePattern = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element2, (String)"USE_PATTERN"));
        try {
            String testType = JDOMExternalizerUtil.readField((Element)element2, (String)"TEST_TYPE");
            this.myTestType = testType != null ? TestType.valueOf(testType) : TestType.TEST_SCRIPT;
        }
        catch (IllegalArgumentException e) {
            this.myTestType = TestType.TEST_SCRIPT;
        }
    }

    @Override
    public void writeExternal(@NotNull Element element2) throws WriteExternalException {
        if (element2 == null) {
            AbstractPythonLegacyTestRunConfiguration.$$$reportNull$$$0(5);
        }
        super.writeExternal(element2);
        JDOMExternalizerUtil.writeField((Element)element2, (String)"SCRIPT_NAME", (String)this.myScriptName);
        JDOMExternalizerUtil.writeField((Element)element2, (String)"CLASS_NAME", (String)this.myClassName);
        JDOMExternalizerUtil.writeField((Element)element2, (String)"METHOD_NAME", (String)this.myMethodName);
        JDOMExternalizerUtil.writeField((Element)element2, (String)"FOLDER_NAME", (String)this.myFolderName);
        JDOMExternalizerUtil.writeField((Element)element2, (String)"TEST_TYPE", (String)this.myTestType.toString());
        JDOMExternalizerUtil.writeField((Element)element2, (String)"PATTERN", (String)this.myPattern);
        JDOMExternalizerUtil.writeField((Element)element2, (String)"USE_PATTERN", (String)String.valueOf(this.usePattern));
    }

    @Override
    public AbstractPythonRunConfigurationParams getBaseParams() {
        return this;
    }

    @Override
    public String getClassName() {
        return this.myClassName;
    }

    @Override
    public void setClassName(String className) {
        this.myClassName = className;
    }

    @Override
    public String getFolderName() {
        return this.myFolderName;
    }

    @Override
    public void setFolderName(String folderName) {
        this.myFolderName = folderName;
    }

    @Override
    public String getScriptName() {
        return this.myScriptName;
    }

    @Override
    public void setScriptName(@NotNull String scriptName) {
        if (scriptName == null) {
            AbstractPythonLegacyTestRunConfiguration.$$$reportNull$$$0(6);
        }
        this.myScriptName = scriptName;
    }

    @Override
    public String getMethodName() {
        return this.myMethodName;
    }

    @Override
    public void setMethodName(String methodName) {
        this.myMethodName = methodName;
    }

    @Override
    public TestType getTestType() {
        return this.myTestType;
    }

    @Override
    public void setTestType(TestType testType) {
        this.myTestType = testType;
    }

    @Override
    public String getPattern() {
        return this.myPattern;
    }

    @Override
    public void setPattern(String pattern) {
        this.myPattern = pattern;
    }

    @Override
    public boolean usePattern() {
        return this.usePattern;
    }

    @Override
    public void usePattern(boolean usePattern) {
        this.usePattern = usePattern;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        if (StringUtil.isEmptyOrSpaces((String)this.myFolderName) && this.myTestType == TestType.TEST_FOLDER) {
            throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_folder_name", new Object[0]));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.getScriptName()) && this.myTestType != TestType.TEST_FOLDER) {
            throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_script_name", new Object[0]));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myClassName) && (this.myTestType == TestType.TEST_METHOD || this.myTestType == TestType.TEST_CLASS)) {
            throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_class_name", new Object[0]));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myMethodName) && (this.myTestType == TestType.TEST_METHOD || this.myTestType == TestType.TEST_FUNCTION)) {
            throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_method_name", new Object[0]));
        }
    }

    public boolean compareSettings(AbstractPythonLegacyTestRunConfiguration cfg) {
        if (cfg == null) {
            return false;
        }
        if (this.getTestType() != cfg.getTestType()) {
            return false;
        }
        return switch (this.getTestType().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.getFolderName().equals(cfg.getFolderName());
            case 1 -> {
                if (this.getScriptName().equals(cfg.getScriptName()) && this.getWorkingDirectory().equals(cfg.getWorkingDirectory())) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (this.getScriptName().equals(cfg.getScriptName()) && this.getWorkingDirectory().equals(cfg.getWorkingDirectory()) && this.getClassName().equals(cfg.getClassName())) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (this.getScriptName().equals(cfg.getScriptName()) && this.getWorkingDirectory().equals(cfg.getWorkingDirectory()) && this.getClassName().equals(cfg.getClassName()) && this.getMethodName().equals(cfg.getMethodName())) {
                    yield true;
                }
                yield false;
            }
            case 4 -> this.getScriptName().equals(cfg.getScriptName()) && this.getWorkingDirectory().equals(cfg.getWorkingDirectory()) && this.getMethodName().equals(cfg.getMethodName());
        };
    }

    public static void copyParams(AbstractPythonTestRunConfigurationParams source, AbstractPythonTestRunConfigurationParams target) {
        AbstractPythonRunConfiguration.copyParams(source.getBaseParams(), target.getBaseParams());
        target.setScriptName(source.getScriptName());
        target.setClassName(source.getClassName());
        target.setFolderName(source.getFolderName());
        target.setMethodName(source.getMethodName());
        target.setTestType(source.getTestType());
        target.setPattern(source.getPattern());
        target.usePattern(source.usePattern());
        target.setAddContentRoots(source.shouldAddContentRoots());
        target.setAddSourceRoots(source.shouldAddSourceRoots());
    }

    public AbstractPythonTestRunConfigurationParams getTestRunConfigurationParams() {
        return this;
    }

    public String suggestedName() {
        return switch (this.myTestType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> PyBundle.message("runcfg.unittest.suggest.name.in.class", this.getPluralTitle(), this.myClassName);
            case 3 -> this.getTitle() + " " + this.myClassName + "." + this.myMethodName;
            case 1 -> {
                String name = new File(this.getScriptName()).getName();
                name = StringUtil.trimEnd((String)name, (String)".py");
                yield PyBundle.message("runcfg.unittest.suggest.name.in.script", this.getPluralTitle(), name);
            }
            case 0 -> {
                String folderName = new File(this.myFolderName).getName();
                yield PyBundle.message("runcfg.unittest.suggest.name.in.folder", this.getPluralTitle(), folderName);
            }
            case 4 -> this.getTitle() + " " + this.myMethodName;
        };
    }

    @Nullable
    public String getActionName() {
        if (TestType.TEST_METHOD.equals((Object)this.myTestType)) {
            return this.getTitle() + " " + this.myMethodName;
        }
        return this.suggestedName();
    }

    @NlsActions.ActionText
    protected abstract String getTitle();

    @NlsActions.ActionText
    protected abstract String getPluralTitle();

    public RefactoringElementListener getRefactoringElementListener(PsiElement element2) {
        PsiFile containingFile;
        VirtualFile vFile;
        if (element2 instanceof PsiDirectory) {
            VirtualFile vFile2 = ((PsiDirectory)element2).getVirtualFile();
            if (this.myTestType == TestType.TEST_FOLDER && AbstractPythonLegacyTestRunConfiguration.pathsEqual(vFile2, this.myFolderName) || AbstractPythonLegacyTestRunConfiguration.pathsEqual(vFile2, PythonScriptCommandLineState.getExpandedWorkingDir(this))) {
                return new RefactoringElementAdapter(){

                    protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                        if (newElement == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        String newPath = FileUtil.toSystemDependentName((String)((PsiDirectory)newElement).getVirtualFile().getPath());
                        AbstractPythonLegacyTestRunConfiguration.this.setWorkingDirectory(newPath);
                        if (AbstractPythonLegacyTestRunConfiguration.this.myTestType == TestType.TEST_FOLDER) {
                            AbstractPythonLegacyTestRunConfiguration.this.myFolderName = newPath;
                        }
                    }

                    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                        if (newElement == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (oldQualifiedName == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        String systemDependant = FileUtil.toSystemDependentName((String)oldQualifiedName);
                        AbstractPythonLegacyTestRunConfiguration.this.setWorkingDirectory(systemDependant);
                        if (AbstractPythonLegacyTestRunConfiguration.this.myTestType == TestType.TEST_FOLDER) {
                            AbstractPythonLegacyTestRunConfiguration.this.myFolderName = systemDependant;
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "newElement";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "oldQualifiedName";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/python/testing/AbstractPythonLegacyTestRunConfiguration$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "elementRenamedOrMoved";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "undoElementMovedOrRenamed";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
            return null;
        }
        if (this.myTestType == TestType.TEST_FOLDER) {
            return null;
        }
        File scriptFile = new File(this.myScriptName);
        if (!scriptFile.isAbsolute()) {
            scriptFile = new File(PythonScriptCommandLineState.getExpandedWorkingDir(this), this.myScriptName);
        }
        VirtualFile virtualFile = vFile = (containingFile = element2.getContainingFile()) == null ? null : containingFile.getVirtualFile();
        if (vFile != null && Objects.equals(new File(vFile.getPath()).getAbsolutePath(), scriptFile.getAbsolutePath())) {
            if (element2 instanceof PsiFile) {
                return new RefactoringElementAdapter(){

                    protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                        VirtualFile virtualFile;
                        if (newElement == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if ((virtualFile = ((PsiFile)newElement).getVirtualFile()) != null) {
                            AbstractPythonLegacyTestRunConfiguration.this.myScriptName = FileUtil.toSystemDependentName((String)virtualFile.getPath());
                        }
                    }

                    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                        if (newElement == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (oldQualifiedName == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        AbstractPythonLegacyTestRunConfiguration.this.myScriptName = FileUtil.toSystemDependentName((String)oldQualifiedName);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "newElement";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "oldQualifiedName";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/python/testing/AbstractPythonLegacyTestRunConfiguration$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "elementRenamedOrMoved";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "undoElementMovedOrRenamed";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
            if (element2 instanceof PyClass && (this.myTestType == TestType.TEST_CLASS || this.myTestType == TestType.TEST_METHOD) && Objects.equals(((PyClass)element2).getName(), this.myClassName)) {
                return new RefactoringElementAdapter(){

                    protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                        if (newElement == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        AbstractPythonLegacyTestRunConfiguration.this.myClassName = ((PyClass)newElement).getName();
                    }

                    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                        if (newElement == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        if (oldQualifiedName == null) {
                            3.$$$reportNull$$$0(2);
                        }
                        AbstractPythonLegacyTestRunConfiguration.this.myClassName = oldQualifiedName;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "newElement";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "oldQualifiedName";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/python/testing/AbstractPythonLegacyTestRunConfiguration$3";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "elementRenamedOrMoved";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "undoElementMovedOrRenamed";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
            if (element2 instanceof PyFunction && Objects.equals(((PyFunction)element2).getName(), this.myMethodName)) {
                ScopeOwner scopeOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)element2, ScopeOwner.class);
                if (this.myTestType == TestType.TEST_FUNCTION && scopeOwner instanceof PyFile || this.myTestType == TestType.TEST_METHOD && scopeOwner instanceof PyClass && Objects.equals(scopeOwner.getName(), this.myClassName)) {
                    return new RefactoringElementAdapter(){

                        protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                            if (newElement == null) {
                                4.$$$reportNull$$$0(0);
                            }
                            AbstractPythonLegacyTestRunConfiguration.this.myMethodName = ((PyFunction)newElement).getName();
                        }

                        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                            int methodIdx;
                            if (newElement == null) {
                                4.$$$reportNull$$$0(1);
                            }
                            if (oldQualifiedName == null) {
                                4.$$$reportNull$$$0(2);
                            }
                            if ((methodIdx = oldQualifiedName.indexOf("#") + 1) > 0 && methodIdx < oldQualifiedName.length()) {
                                AbstractPythonLegacyTestRunConfiguration.this.myMethodName = oldQualifiedName.substring(methodIdx);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "newElement";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "oldQualifiedName";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/jetbrains/python/testing/AbstractPythonLegacyTestRunConfiguration$4";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "elementRenamedOrMoved";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "undoElementMovedOrRenamed";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                }
            }
        }
        return null;
    }

    private static boolean pathsEqual(VirtualFile vFile, String folderName) {
        return Objects.equals(new File(vFile.getPath()).getAbsolutePath(), new File(folderName).getAbsolutePath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/AbstractPythonLegacyTestRunConfiguration";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectorySafe";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/AbstractPythonLegacyTestRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setScriptName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    public static enum TestType {
        TEST_FOLDER,
        TEST_SCRIPT,
        TEST_CLASS,
        TEST_METHOD,
        TEST_FUNCTION;

    }
}

