/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyLanguageFacade;
import com.jetbrains.python.ast.PyAstFile;
import com.jetbrains.python.psi.LanguageLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH$\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/PyLanguageFacadeBase;", "Lcom/jetbrains/python/PyLanguageFacade;", "<init>", "()V", "getEffectiveLanguageLevel", "Lcom/jetbrains/python/psi/LanguageLevel;", "psiElement", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "doGetEffectiveLanguageLevel", "intellij.python.ast"})
@ApiStatus.Internal
public abstract class PyLanguageFacadeBase
extends PyLanguageFacade {
    @NotNull
    public final LanguageLevel getEffectiveLanguageLevel(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (psiElement instanceof PsiDirectory) {
            Project project = psiElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            VirtualFile virtualFile = ((PsiDirectory)psiElement).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            return this.getEffectiveLanguageLevel(project, virtualFile);
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile instanceof PyAstFile) {
            LanguageLevel languageLevel = ((PyAstFile)containingFile).getLanguageLevel();
            Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"getLanguageLevel(...)");
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"getDefault(...)");
        return languageLevel;
    }

    @NotNull
    public final LanguageLevel getEffectiveLanguageLevel(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        VirtualFile file = virtualFile;
        if (file instanceof VirtualFileWindow) {
            VirtualFile virtualFile2 = ((VirtualFileWindow)file).getDelegate();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getDelegate(...)");
            file = virtualFile2;
        }
        VirtualFile virtualFile3 = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getOriginFileIfBacked(...)");
        file = virtualFile3;
        return this.doGetEffectiveLanguageLevel(project, file);
    }

    @NotNull
    protected abstract LanguageLevel doGetEffectiveLanguageLevel(@NotNull Project var1, @NotNull VirtualFile var2);
}

