/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstCallSiteExpression;
import com.jetbrains.python.ast.PyAstCallable;
import com.jetbrains.python.ast.PyAstElement;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstFile;
import com.jetbrains.python.ast.PyAstQualifiedExpression;
import com.jetbrains.python.ast.PyAstReferenceOwner;
import com.jetbrains.python.ast.impl.PyPsiUtilsCore;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.PyElementType;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstBinaryExpression
extends PyAstQualifiedExpression,
PyAstCallSiteExpression,
PyAstReferenceOwner {
    default public PyAstExpression getLeftExpression() {
        return (PyAstExpression)PsiTreeUtil.getChildOfType((PsiElement)this, PyAstExpression.class);
    }

    @Nullable
    default public PyAstExpression getRightExpression() {
        return (PyAstExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)this.getLeftExpression(), PyAstExpression.class);
    }

    @Nullable
    default public PyElementType getOperator() {
        PsiElement psiOperator = this.getPsiOperator();
        return psiOperator != null ? (PyElementType)psiOperator.getNode().getElementType() : null;
    }

    @Nullable
    default public PsiElement getPsiOperator() {
        ASTNode node = this.getNode();
        ASTNode child = node.findChildByType(PyTokenTypes.BINARY_OPS);
        if (child != null) {
            return child.getPsi();
        }
        return null;
    }

    default public boolean isOperator(String chars) {
        StringBuilder buf = new StringBuilder();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType elType = child.getElementType();
            if (!(elType instanceof PyElementType) || !PyTokenTypes.BINARY_OPS.contains(elType)) continue;
            buf.append(child.getText());
        }
        return buf.toString().equals(chars);
    }

    @Nullable
    default public PyAstExpression getOppositeExpression(PyAstExpression expression) throws IllegalArgumentException {
        PyAstExpression right = this.getRightExpression();
        PyAstExpression left = this.getLeftExpression();
        if (expression.equals(left)) {
            return right;
        }
        if (expression.equals(right)) {
            return left;
        }
        throw new IllegalArgumentException("expression " + String.valueOf(expression) + " is neither left exp or right exp");
    }

    default public boolean isRightOperator(@Nullable PyAstCallable resolvedCallee) {
        return resolvedCallee != null && PyNames.isRightOperatorName((String)this.getReferencedName(), (String)resolvedCallee.getName());
    }

    @Override
    default public PyAstExpression getQualifier() {
        return this.getLeftExpression();
    }

    @Override
    @Nullable
    default public QualifiedName asQualifiedName() {
        return PyPsiUtilsCore.asQualifiedName(this);
    }

    @Override
    default public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    default public String getReferencedName() {
        PyElementType t = this.getOperator();
        if (t == PyTokenTypes.DIV && PyAstBinaryExpression.isTrueDivEnabled(this)) {
            return "__truediv__";
        }
        return t != null ? t.getSpecialMethodName() : null;
    }

    @Override
    default public ASTNode getNameElement() {
        PsiElement op = this.getPsiOperator();
        return op != null ? op.getNode() : null;
    }

    @Override
    @Nullable
    default public PyAstExpression getReceiver(@Nullable PyAstCallable resolvedCallee) {
        return this.isRightOperator(resolvedCallee) ? this.getRightExpression() : this.getChainedComparisonAwareLeftExpression();
    }

    @NotNull
    default public @NotNull List<@NotNull PyAstExpression> getArguments(@Nullable PyAstCallable resolvedCallee) {
        PyAstExpression operand = this.isRightOperator(resolvedCallee) ? this.getChainedComparisonAwareLeftExpression() : this.getRightExpression();
        List list = ContainerUtil.createMaybeSingletonList((Object)operand);
        if (list == null) {
            PyAstBinaryExpression.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    private PyAstExpression getChainedComparisonAwareLeftExpression() {
        PyAstBinaryExpression leftBinaryExpr;
        PyAstExpression leftOperand = this.getLeftExpression();
        if (PyTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)this.getOperator()) && (leftBinaryExpr = (PyAstBinaryExpression)ObjectUtils.tryCast((Object)leftOperand, PyAstBinaryExpression.class)) != null && PyTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)leftBinaryExpr.getOperator())) {
            return leftBinaryExpr.getRightExpression();
        }
        return leftOperand;
    }

    private static boolean isTrueDivEnabled(@NotNull PyAstElement anchor) {
        PsiFile file;
        if (anchor == null) {
            PyAstBinaryExpression.$$$reportNull$$$0(1);
        }
        if ((file = anchor.getContainingFile()) instanceof PyAstFile) {
            PyAstFile pyFile = (PyAstFile)file;
            return FutureFeature.DIVISION.requiredAt(pyFile.getLanguageLevel()) || pyFile.hasImportFromFuture(FutureFeature.DIVISION);
        }
        return false;
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyBinaryExpression(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/ast/PyAstBinaryExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/ast/PyAstBinaryExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTrueDivEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

