/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.ast.PyAstAssignmentStatement;
import com.jetbrains.python.ast.PyAstCallSiteExpression;
import com.jetbrains.python.ast.PyAstCallable;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstQualifiedExpression;
import com.jetbrains.python.ast.PyAstReferenceOwner;
import com.jetbrains.python.ast.impl.PyPsiUtilsCore;
import com.jetbrains.python.psi.AccessDirection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstSubscriptionExpression
extends PyAstQualifiedExpression,
PyAstCallSiteExpression,
PyAstReferenceOwner {
    @Override
    @Nullable
    default public PyAstExpression getReceiver(@Nullable PyAstCallable resolvedCallee) {
        return this.getOperand();
    }

    @NotNull
    default public @NotNull List<@NotNull PyAstExpression> getArguments(@Nullable PyAstCallable resolvedCallee) {
        PsiElement psiElement;
        ArrayList result = new ArrayList();
        ContainerUtil.addIfNotNull(result, (Object)this.getIndexExpression());
        if (AccessDirection.of(this) == AccessDirection.WRITE && (psiElement = this.getParent()) instanceof PyAstAssignmentStatement) {
            PyAstAssignmentStatement assignment = (PyAstAssignmentStatement)psiElement;
            ContainerUtil.addIfNotNull(result, (Object)assignment.getAssignedValue());
        }
        List<PyAstExpression> list = Collections.unmodifiableList(result);
        if (list == null) {
            PyAstSubscriptionExpression.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public PyAstExpression getRootOperand() {
        PyAstExpression operand = this.getOperand();
        while (operand instanceof PyAstSubscriptionExpression) {
            operand = ((PyAstSubscriptionExpression)operand).getOperand();
        }
        PyAstExpression pyAstExpression = operand;
        if (pyAstExpression == null) {
            PyAstSubscriptionExpression.$$$reportNull$$$0(1);
        }
        return pyAstExpression;
    }

    @NotNull
    default public PyAstExpression getOperand() {
        PyAstExpression pyAstExpression = (PyAstExpression)this.childToPsiNotNull(PythonDialectsTokenSetProvider.getInstance().getExpressionTokens(), 0);
        if (pyAstExpression == null) {
            PyAstSubscriptionExpression.$$$reportNull$$$0(2);
        }
        return pyAstExpression;
    }

    @Nullable
    default public PyAstExpression getIndexExpression() {
        return (PyAstExpression)this.childToPsi(PythonDialectsTokenSetProvider.getInstance().getExpressionTokens(), 1);
    }

    @Override
    default public PyAstExpression getQualifier() {
        return this.getOperand();
    }

    @Override
    @Nullable
    default public QualifiedName asQualifiedName() {
        return PyPsiUtilsCore.asQualifiedName(this);
    }

    @Override
    default public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    default public String getReferencedName() {
        return switch (AccessDirection.of(this)) {
            default -> throw new MatchException(null, null);
            case AccessDirection.READ -> "__getitem__";
            case AccessDirection.WRITE -> "__setitem__";
            case AccessDirection.DELETE -> "__delitem__";
        };
    }

    @Override
    default public ASTNode getNameElement() {
        return this.getNode().findChildByType((IElementType)PyTokenTypes.LBRACKET);
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPySubscriptionExpression(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/python/ast/PyAstSubscriptionExpression";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootOperand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperand";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

