/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.CompletionAssertions;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupValueWithPsiElement;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.CharPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.UnmodifiableIterator;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompletionUtil {
    private static final CompletionData ourGenericCompletionData = new CompletionData(){
        {
            CompletionVariant variant = new CompletionVariant(PsiElement.class, TrueFilter.INSTANCE);
            variant.addCompletionFilter(TrueFilter.INSTANCE, TailTypes.noneType());
            this.registerVariant(variant);
        }
    };
    @NonNls
    public static final String DUMMY_IDENTIFIER = "IntellijIdeaRulezzz ";
    @NonNls
    public static final String DUMMY_IDENTIFIER_TRIMMED = "IntellijIdeaRulezzz";

    @ApiStatus.Internal
    @Nullable
    public static CompletionData getCompletionDataByElement(@Nullable PsiElement position, @NotNull PsiFile originalFile) {
        if (originalFile == null) {
            CompletionUtil.$$$reportNull$$$0(0);
        }
        if (position == null) {
            return null;
        }
        return ourGenericCompletionData;
    }

    public static boolean shouldShowFeature(@NotNull CompletionParameters parameters, @NonNls String id) {
        if (parameters == null) {
            CompletionUtil.$$$reportNull$$$0(1);
        }
        return CompletionUtil.shouldShowFeature(parameters.getPosition().getProject(), id);
    }

    public static boolean shouldShowFeature(Project project, @NonNls String id) {
        if (FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup(id, project)) {
            FeatureUsageTracker.getInstance().triggerFeatureShown(id);
            return true;
        }
        return false;
    }

    @NotNull
    public static String findJavaIdentifierPrefix(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            CompletionUtil.$$$reportNull$$$0(2);
        }
        return CompletionUtil.findJavaIdentifierPrefix(parameters.getPosition(), parameters.getOffset());
    }

    @NotNull
    public static String findJavaIdentifierPrefix(@Nullable PsiElement position, int offsetInFile) {
        return CompletionUtil.findIdentifierPrefix(position, offsetInFile, (ElementPattern<Character>)CharPattern.javaIdentifierPartCharacter(), (ElementPattern<Character>)CharPattern.javaIdentifierStartCharacter());
    }

    @NotNull
    public static String findReferenceOrAlphanumericPrefix(@NotNull CompletionParameters parameters) {
        String prefix;
        if (parameters == null) {
            CompletionUtil.$$$reportNull$$$0(3);
        }
        String string = (prefix = CompletionUtil.findReferencePrefix(parameters)) == null ? CompletionUtil.findAlphanumericPrefix(parameters) : prefix;
        if (string == null) {
            CompletionUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String findAlphanumericPrefix(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            CompletionUtil.$$$reportNull$$$0(5);
        }
        return CompletionUtil.findIdentifierPrefix((PsiElement)parameters.getPosition().getContainingFile(), parameters.getOffset(), (ElementPattern<Character>)CharPattern.letterOrDigitCharacter(), (ElementPattern<Character>)CharPattern.letterOrDigitCharacter());
    }

    @NotNull
    public static String findIdentifierPrefix(@Nullable PsiElement position, int offsetInFile, @NotNull ElementPattern<Character> idPart, @NotNull ElementPattern<Character> idStart) {
        if (idPart == null) {
            CompletionUtil.$$$reportNull$$$0(6);
        }
        if (idStart == null) {
            CompletionUtil.$$$reportNull$$$0(7);
        }
        if (position == null) {
            return "";
        }
        int startOffset = position.getTextRange().getStartOffset();
        return CompletionUtil.findInText(offsetInFile, startOffset, idPart, idStart, position.getNode().getChars());
    }

    @NotNull
    public static String findIdentifierPrefix(@NotNull Document document, int offset, @NotNull ElementPattern<Character> idPart, @NotNull ElementPattern<Character> idStart) {
        if (document == null) {
            CompletionUtil.$$$reportNull$$$0(8);
        }
        if (idPart == null) {
            CompletionUtil.$$$reportNull$$$0(9);
        }
        if (idStart == null) {
            CompletionUtil.$$$reportNull$$$0(10);
        }
        CharSequence text = document.getImmutableCharSequence();
        return CompletionUtil.findInText(offset, 0, idPart, idStart, text);
    }

    @NotNull
    private static String findInText(int offset, int startOffset, @NotNull ElementPattern<Character> idPart, @NotNull ElementPattern<Character> idStart, @NotNull CharSequence text) {
        int start;
        if (idPart == null) {
            CompletionUtil.$$$reportNull$$$0(11);
        }
        if (idStart == null) {
            CompletionUtil.$$$reportNull$$$0(12);
        }
        if (text == null) {
            CompletionUtil.$$$reportNull$$$0(13);
        }
        int offsetInElement = offset - startOffset;
        for (start = offsetInElement - 1; start >= 0 && idPart.accepts((Object)Character.valueOf(text.charAt(start))); --start) {
        }
        while (start + 1 < offsetInElement && !idStart.accepts((Object)Character.valueOf(text.charAt(start + 1)))) {
            ++start;
        }
        String string = text.subSequence(start + 1, offsetInElement).toString().trim();
        if (string == null) {
            CompletionUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public static String findReferencePrefix(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            CompletionUtil.$$$reportNull$$$0(15);
        }
        return CompletionUtil.findReferencePrefix(parameters.getPosition(), parameters.getOffset());
    }

    @Nullable
    public static String findReferencePrefix(@NotNull PsiElement position, int offsetInFile) {
        if (position == null) {
            CompletionUtil.$$$reportNull$$$0(16);
        }
        try {
            PsiUtilCore.ensureValid((PsiElement)position);
            PsiReference ref = position.getContainingFile().findReferenceAt(offsetInFile);
            if (ref != null) {
                PsiElement element = ref.getElement();
                int offsetInElement = offsetInFile - element.getTextRange().getStartOffset();
                for (TextRange refRange : ReferenceRange.getRanges((PsiReference)ref)) {
                    if (!refRange.contains(offsetInElement)) continue;
                    int beginIndex = refRange.getStartOffset();
                    String text = element.getText();
                    if (beginIndex < 0 || beginIndex > offsetInElement || offsetInElement > text.length()) {
                        throw new AssertionError((Object)("Inconsistent reference range: ref=" + String.valueOf(ref.getClass()) + " element=" + String.valueOf(element.getClass()) + " ref.start=" + refRange.getStartOffset() + " offset=" + offsetInElement + " psi.length=" + text.length()));
                    }
                    return text.substring(beginIndex, offsetInElement);
                }
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public static InsertionContext emulateInsertion(@NotNull InsertionContext oldContext, int newStart, @NotNull LookupElement item) {
        if (oldContext == null) {
            CompletionUtil.$$$reportNull$$$0(17);
        }
        if (item == null) {
            CompletionUtil.$$$reportNull$$$0(18);
        }
        InsertionContext newContext = CompletionUtil.newContext(oldContext, item);
        CompletionUtil.emulateInsertion(item, newStart, newContext);
        InsertionContext insertionContext = newContext;
        if (insertionContext == null) {
            CompletionUtil.$$$reportNull$$$0(19);
        }
        return insertionContext;
    }

    @NotNull
    private static InsertionContext newContext(@NotNull InsertionContext oldContext, @NotNull LookupElement forElement) {
        if (oldContext == null) {
            CompletionUtil.$$$reportNull$$$0(20);
        }
        if (forElement == null) {
            CompletionUtil.$$$reportNull$$$0(21);
        }
        Editor editor = oldContext.getEditor();
        return new InsertionContext(new OffsetMap(editor.getDocument()), '\u0000', new LookupElement[]{forElement}, oldContext.getFile(), editor, oldContext.shouldAddCompletionChar());
    }

    @NotNull
    public static InsertionContext newContext(@NotNull InsertionContext oldContext, @NotNull LookupElement forElement, int startOffset, int tailOffset) {
        if (oldContext == null) {
            CompletionUtil.$$$reportNull$$$0(22);
        }
        if (forElement == null) {
            CompletionUtil.$$$reportNull$$$0(23);
        }
        InsertionContext context = CompletionUtil.newContext(oldContext, forElement);
        CompletionUtil.setOffsets(context, startOffset, tailOffset);
        InsertionContext insertionContext = context;
        if (insertionContext == null) {
            CompletionUtil.$$$reportNull$$$0(24);
        }
        return insertionContext;
    }

    public static void emulateInsertion(@NotNull LookupElement item, int offset, @NotNull InsertionContext context) {
        if (item == null) {
            CompletionUtil.$$$reportNull$$$0(25);
        }
        if (context == null) {
            CompletionUtil.$$$reportNull$$$0(26);
        }
        CompletionUtil.setOffsets(context, offset, offset);
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        String lookupString = item.getLookupString();
        document.insertString(offset, (CharSequence)lookupString);
        editor.getCaretModel().moveToOffset(context.getTailOffset());
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
        item.handleInsert(context);
        PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(document);
    }

    private static void setOffsets(@NotNull InsertionContext context, int offset, int tailOffset) {
        if (context == null) {
            CompletionUtil.$$$reportNull$$$0(27);
        }
        OffsetMap offsetMap = context.getOffsetMap();
        offsetMap.addOffset(CompletionInitializationContext.START_OFFSET, offset);
        offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, tailOffset);
        offsetMap.addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, tailOffset);
        context.setTailOffset(tailOffset);
    }

    @Nullable
    public static PsiElement getTargetElement(@NotNull LookupElement lookupElement) {
        LookupValueWithPsiElement value;
        PsiElement element;
        PsiElement psiElement;
        if (lookupElement == null) {
            CompletionUtil.$$$reportNull$$$0(28);
        }
        if ((psiElement = lookupElement.getPsiElement()) != null && psiElement.isValid()) {
            return CompletionUtil.getOriginalElement(psiElement);
        }
        Object object = lookupElement.getObject();
        if (object instanceof LookupValueWithPsiElement && (element = (value = (LookupValueWithPsiElement)object).getElement()) != null && element.isValid()) {
            return CompletionUtil.getOriginalElement(element);
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T getOriginalElement(@NotNull T psi) {
        if (psi == null) {
            CompletionUtil.$$$reportNull$$$0(29);
        }
        return (T)CompletionUtilCoreImpl.getOriginalElement(psi);
    }

    @NotNull
    public static <T extends PsiElement> T getOriginalOrSelf(@NotNull T psi) {
        T element;
        if (psi == null) {
            CompletionUtil.$$$reportNull$$$0(30);
        }
        T t = (element = CompletionUtil.getOriginalElement(psi)) == null ? psi : element;
        if (t == null) {
            CompletionUtil.$$$reportNull$$$0(31);
        }
        return t;
    }

    @NotNull
    public static Iterable<String> iterateLookupStrings(final @NotNull LookupElement element) {
        if (element == null) {
            CompletionUtil.$$$reportNull$$$0(32);
        }
        return new Iterable<String>(){

            @Override
            @NotNull
            public Iterator<String> iterator() {
                Iterator original = element.getAllLookupStrings().iterator();
                return new UnmodifiableIterator<String>(original){

                    public boolean hasNext() {
                        try {
                            return super.hasNext();
                        }
                        catch (ConcurrentModificationException e) {
                            throw this.handleCME(e);
                        }
                    }

                    public String next() {
                        try {
                            return (String)super.next();
                        }
                        catch (ConcurrentModificationException e) {
                            throw this.handleCME(e);
                        }
                    }

                    private RuntimeException handleCME(ConcurrentModificationException cme) {
                        RuntimeExceptionWithAttachments ewa = new RuntimeExceptionWithAttachments("Error while traversing lookup strings of " + String.valueOf(element) + " of " + String.valueOf(element.getClass()), new Attachment[]{new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString())});
                        ewa.initCause((Throwable)cme);
                        return ewa;
                    }
                };
            }
        };
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletionAssertions.WatchingInsertionContext createInsertionContext(@Nullable List<LookupElement> lookupItems, @NotNull LookupElement item, char completionChar, Editor editor, PsiFile psiFile, int caretOffset, int idEndOffset, OffsetMap offsetMap) {
        if (item == null) {
            CompletionUtil.$$$reportNull$$$0(33);
        }
        int initialStartOffset = Math.max(0, caretOffset - item.getLookupString().length());
        return CompletionUtil.createInsertionContext(lookupItems, completionChar, editor, psiFile, initialStartOffset, caretOffset, idEndOffset, offsetMap);
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletionAssertions.WatchingInsertionContext createInsertionContext(@Nullable List<LookupElement> lookupItems, char completionChar, @NotNull Editor editor, @NotNull PsiFile psiFile, int startOffset, int caretOffset, int idEndOffset, @NotNull OffsetMap offsetMap) {
        if (editor == null) {
            CompletionUtil.$$$reportNull$$$0(34);
        }
        if (psiFile == null) {
            CompletionUtil.$$$reportNull$$$0(35);
        }
        if (offsetMap == null) {
            CompletionUtil.$$$reportNull$$$0(36);
        }
        offsetMap.addOffset(CompletionInitializationContext.START_OFFSET, startOffset);
        offsetMap.addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, caretOffset);
        offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, idEndOffset);
        List<LookupElement> items = lookupItems == null ? Collections.emptyList() : lookupItems;
        return new CompletionAssertions.WatchingInsertionContext(offsetMap, psiFile, completionChar, items, editor);
    }

    @ApiStatus.Internal
    public static int calcIdEndOffset(@NotNull OffsetMap offsetMap, @NotNull Editor editor, @NotNull Integer initOffset) {
        if (offsetMap == null) {
            CompletionUtil.$$$reportNull$$$0(37);
        }
        if (editor == null) {
            CompletionUtil.$$$reportNull$$$0(38);
        }
        if (initOffset == null) {
            CompletionUtil.$$$reportNull$$$0(39);
        }
        return offsetMap.containsOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) ? offsetMap.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) : CompletionInitializationContext.calcDefaultIdentifierEnd((Editor)editor, (int)initOffset);
    }

    @ApiStatus.Internal
    public static int calcIdEndOffset(@NotNull CompletionProcessEx indicator) {
        if (indicator == null) {
            CompletionUtil.$$$reportNull$$$0(40);
        }
        return CompletionUtil.calcIdEndOffset(indicator.getOffsetMap(), indicator.getEditor(), indicator.getCaret().getOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 14, 19, 24, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: 
            case 14: 
            case 19: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionUtil";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idPart";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idStart";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 17: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldContext";
                break;
            }
            case 18: 
            case 25: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forElement";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElement";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetMap";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initOffset";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferenceOrAlphanumericPrefix";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findInText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "emulateInsertion";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "newContext";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalOrSelf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionDataByElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowFeature";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findJavaIdentifierPrefix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findReferenceOrAlphanumericPrefix";
                break;
            }
            case 4: 
            case 14: 
            case 19: 
            case 24: 
            case 31: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAlphanumericPrefix";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findIdentifierPrefix";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findInText";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findReferencePrefix";
                break;
            }
            case 17: 
            case 18: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "emulateInsertion";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "newContext";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setOffsets";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTargetElement";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalElement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalOrSelf";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "iterateLookupStrings";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createInsertionContext";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "calcIdEndOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 14, 19, 24, 31 -> new IllegalStateException(string);
        };
    }
}

