/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.impl.scopes.ScopeRootDescriptorBase;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkBridge;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.RootDescriptor;
import com.intellij.openapi.roots.impl.SdkRootDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\f\u0010\u0017\u001a\u00020\u000b*\u00020\u000bH\u0002R\u001d\u0010\n\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/module/impl/scopes/SdkScopeDescriptor;", "Lcom/intellij/openapi/module/impl/scopes/ScopeRootDescriptorBase;", "Lcom/intellij/openapi/roots/JdkOrderEntry;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "orderEntry", "orderIndex", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/roots/JdkOrderEntry;I)V", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "sdk$delegate", "Lkotlin/Lazy;", "correspondTo", "", "rootDescriptor", "Lcom/intellij/openapi/roots/impl/RootDescriptor;", "isEqualBackup", "sdk1", "sdk2", "unwrap", "intellij.platform.analysis.impl"})
final class SdkScopeDescriptor
extends ScopeRootDescriptorBase<JdkOrderEntry> {
    @NotNull
    private final Lazy sdk$delegate;

    public SdkScopeDescriptor(@NotNull VirtualFile root, @NotNull JdkOrderEntry orderEntry, int orderIndex) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)orderEntry, (String)"orderEntry");
        super(root, (OrderEntry)orderEntry, orderIndex);
        this.sdk$delegate = LazyKt.lazy(() -> SdkScopeDescriptor.sdk_delegate$lambda$0(orderEntry));
    }

    private final Sdk getSdk() {
        Lazy lazy = this.sdk$delegate;
        return (Sdk)lazy.getValue();
    }

    @Override
    public boolean correspondTo(@NotNull RootDescriptor rootDescriptor) {
        Intrinsics.checkNotNullParameter((Object)rootDescriptor, (String)"rootDescriptor");
        if (rootDescriptor instanceof SdkRootDescriptor) {
            Sdk sdk = this.getSdk();
            if (sdk == null) {
                return false;
            }
            Sdk orderEntrySdk = sdk;
            Sdk rootDescriptorSdk = ((SdkRootDescriptor)rootDescriptor).getSdk();
            return Intrinsics.areEqual((Object)orderEntrySdk, (Object)rootDescriptorSdk) || this.isEqualBackup(orderEntrySdk, rootDescriptorSdk);
        }
        return super.correspondTo(rootDescriptor);
    }

    private final boolean isEqualBackup(Sdk sdk1, Sdk sdk2) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        boolean result = Intrinsics.areEqual((Object)sdk1.getHomePath(), (Object)sdk2.getHomePath()) && Intrinsics.areEqual((Object)sdk1.getName(), (Object)sdk2.getName()) && Intrinsics.areEqual((Object)sdk1.getSdkType(), (Object)sdk2.getSdkType()) && Intrinsics.areEqual(this.unwrap(sdk1).getClass(), this.unwrap(sdk2).getClass());
        return result;
    }

    private final Sdk unwrap(Sdk $this$unwrap) {
        Sdk sdk;
        if ($this$unwrap instanceof ProjectJdkImpl) {
            SdkBridge sdkBridge = ((ProjectJdkImpl)$this$unwrap).getDelegate();
            Intrinsics.checkNotNullExpressionValue((Object)sdkBridge, (String)"getDelegate(...)");
            sdk = (Sdk)sdkBridge;
        } else {
            sdk = $this$unwrap;
        }
        return sdk;
    }

    private static final Sdk sdk_delegate$lambda$0(JdkOrderEntry $orderEntry) {
        return $orderEntry.getJdk();
    }
}

