/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.events;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.JulLogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RollingFileHandler;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.events.VfsEventsMerger;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.function.Supplier;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IndexingEventsLogger {
    private static final boolean DEBUG = FileBasedIndexEx.TRACE_STUB_INDEX_UPDATES || Boolean.getBoolean("log.index.vfs.events");
    private static final com.intellij.openapi.diagnostic.Logger LOG = MyLoggerFactory.getLoggerInstance();

    public static void tryLog(@NotNull String eventName, @NotNull VirtualFile file) {
        if (eventName == null) {
            IndexingEventsLogger.$$$reportNull$$$0(0);
        }
        if (file == null) {
            IndexingEventsLogger.$$$reportNull$$$0(1);
        }
        IndexingEventsLogger.tryLog(eventName, file, null);
    }

    public static void tryLog(@NotNull String eventName, int fileId) {
        if (eventName == null) {
            IndexingEventsLogger.$$$reportNull$$$0(2);
        }
        IndexingEventsLogger.tryLog(() -> "e=" + eventName + ",id=" + fileId);
    }

    public static void tryLog(@NotNull String eventName, @NotNull VirtualFile file, @Nullable Supplier<String> additionalMessage) {
        if (eventName == null) {
            IndexingEventsLogger.$$$reportNull$$$0(3);
        }
        if (file == null) {
            IndexingEventsLogger.$$$reportNull$$$0(4);
        }
        IndexingEventsLogger.tryLog(() -> {
            String string;
            if (file instanceof VirtualFileWithId) {
                VirtualFileWithId fileWithId = (VirtualFileWithId)file;
                string = ",id=" + fileWithId.getId();
            } else {
                string = ",f=" + file.getPath();
            }
            return "e=" + eventName + string + ",flen=" + file.getLength() + (String)(additionalMessage == null ? "" : "," + (String)additionalMessage.get());
        });
    }

    public static void tryLog(@NotNull String eventName, @NotNull IndexedFile indexedFile, @Nullable Supplier<String> additionalMessage) {
        if (eventName == null) {
            IndexingEventsLogger.$$$reportNull$$$0(5);
        }
        if (indexedFile == null) {
            IndexingEventsLogger.$$$reportNull$$$0(6);
        }
        VirtualFile file = indexedFile.getFile();
        IndexingEventsLogger.tryLog(eventName, file, () -> {
            String extra = "f@" + System.identityHashCode(indexedFile);
            if (indexedFile instanceof FileContentImpl) {
                FileContentImpl fileContentImpl = (FileContentImpl)indexedFile;
                extra = extra + ",tr=" + (fileContentImpl.isTransientContent() ? "t" : "f");
            }
            if (indexedFile instanceof FileContent) {
                FileContent fileContent = (FileContent)indexedFile;
                extra = extra + ",contLen(b)=" + fileContent.getContent().length;
                FileType fileType = fileContent.getFileType();
                extra = extra + ",bin=" + (fileType.isBinary() ? "t" : "f");
            }
            if (additionalMessage != null) {
                extra = extra + "," + (String)additionalMessage.get();
            }
            return extra;
        });
    }

    public static void tryLog(Supplier<String> message) {
        if (LOG != null) {
            try {
                LOG.info(message.get());
            }
            catch (Throwable t) {
                com.intellij.openapi.diagnostic.Logger.getInstance(IndexingEventsLogger.class).error("Could not evaluate log message (message.get())", t);
            }
        }
    }

    static {
        if (LOG != null) {
            LOG.info("-------------- VfsEventsMerger initialized --------------------");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "eventName";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "indexedFile";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/indexing/events/IndexingEventsLogger";
        objectArray[2] = "tryLog";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyLoggerFactory
    implements Logger.Factory {
        @Nullable
        private static final MyLoggerFactory ourFactory;
        @NotNull
        private final RollingFileHandler myAppender;

        MyLoggerFactory() throws IOException {
            Path indexingDiagnosticDir = Paths.get(PathManager.getLogPath(), new String[0]).resolve("indexing-diagnostic");
            Path logPath = indexingDiagnosticDir.resolve("index-vfs-events.log");
            this.myAppender = new RollingFileHandler(logPath, 20000000L, 50, false);
            this.myAppender.setFormatter(new Formatter(this){

                @Override
                public String format(LogRecord record) {
                    ZonedDateTime zdt = ZonedDateTime.ofInstant(record.getInstant(), ZoneId.systemDefault());
                    return String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL [%3$d] %2$s%n", zdt, record.getMessage(), record.getLongThreadID());
                }
            });
        }

        @NotNull
        public com.intellij.openapi.diagnostic.Logger getLoggerInstance(@NotNull String category) {
            if (category == null) {
                MyLoggerFactory.$$$reportNull$$$0(0);
            }
            Logger logger = Logger.getLogger(category);
            JulLogger.clearHandlers((Logger)logger);
            logger.addHandler((Handler)this.myAppender);
            logger.setUseParentHandlers(false);
            logger.setLevel(Level.INFO);
            return new JulLogger(logger);
        }

        @Nullable
        public static com.intellij.openapi.diagnostic.Logger getLoggerInstance() {
            return ourFactory == null ? null : ourFactory.getLoggerInstance("#" + VfsEventsMerger.class.getName());
        }

        static {
            MyLoggerFactory factory = null;
            try {
                if (DEBUG) {
                    factory = new MyLoggerFactory();
                }
            }
            catch (IOException e) {
                ((FileBasedIndexEx)FileBasedIndex.getInstance()).getLogger().error((Throwable)e);
            }
            ourFactory = factory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/util/indexing/events/IndexingEventsLogger$MyLoggerFactory", "getLoggerInstance"));
        }
    }
}

