/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeBundle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;

@ApiStatus.Experimental
public enum Region {
    NOT_SET("not_set", "title.region.not_set", 1000),
    AFRICA("africa", "title.region.africa", 0),
    AMERICAS("americas", "title.region.america", 1),
    APAC("apac", "title.region.asia", 2),
    CHINA("china", "title.region.china", 3),
    EUROPE("europe", "title.region.europe", 4),
    MIDDLE_EAST("middle_east", "title.region.middle_east", 5),
    OCEANIA("oceania", "title.region.oceania", 6);

    private final String extName;
    private final String displayKey;
    private final int displayOrdinal;

    private Region(String extName, String displayKey, int displayOrdinal) {
        this.extName = extName;
        this.displayKey = displayKey;
        this.displayOrdinal = displayOrdinal;
    }

    public String externalName() {
        return this.extName;
    }

    @Nls
    public String getDisplayName() {
        return IdeBundle.message(this.displayKey, new Object[0]);
    }

    public String getDisplayKey() {
        return this.displayKey;
    }

    public int getDisplayOrdinal() {
        return this.displayOrdinal;
    }

    public static Region fromExternalName(String extName) {
        for (Region value2 : Region.values()) {
            if (!value2.extName.equals(extName)) continue;
            return value2;
        }
        return NOT_SET;
    }
}

