/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields.valueEditors;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.components.fields.valueEditors.TextFieldValueEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommaSeparatedIntegersValueEditor
extends TextFieldValueEditor<List<Integer>> {
    private final int myMinValue;
    private final int myMaxValue;

    public CommaSeparatedIntegersValueEditor(@NotNull JTextField field, @Nullable String valueName, int minValue, int maxValue) {
        if (field == null) {
            CommaSeparatedIntegersValueEditor.$$$reportNull$$$0(0);
        }
        super(field, valueName, Collections.emptyList());
        this.myMinValue = minValue;
        this.myMaxValue = maxValue;
    }

    @Override
    @NotNull
    public List<Integer> parseValue(@Nullable String text) throws InvalidDataException {
        if (text == null || text.isEmpty()) {
            List<Integer> list = Collections.emptyList();
            if (list == null) {
                CommaSeparatedIntegersValueEditor.$$$reportNull$$$0(1);
            }
            return list;
        }
        String[] chunks = text.split("\\s*,\\s*");
        ArrayList<Integer> values = new ArrayList<Integer>(chunks.length);
        for (String chunk : chunks) {
            try {
                int value2 = Integer.parseInt(chunk);
                if (value2 < this.myMinValue || value2 > this.myMaxValue) {
                    throw new InvalidDataException("Value " + value2 + " is out of range " + this.myMinValue + ".." + this.myMaxValue);
                }
                values.add(value2);
            }
            catch (NumberFormatException nfe) {
                throw new InvalidDataException("Value '" + chunk + "' is not an integer number");
            }
        }
        Collections.sort(values);
        ArrayList<Integer> arrayList = values;
        if (arrayList == null) {
            CommaSeparatedIntegersValueEditor.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    public String valueToString(@NotNull List<Integer> valueList) {
        if (valueList == null) {
            CommaSeparatedIntegersValueEditor.$$$reportNull$$$0(3);
        }
        return CommaSeparatedIntegersValueEditor.intListToString(valueList);
    }

    @Override
    public boolean isValid(@NotNull List<Integer> value2) {
        if (value2 == null) {
            CommaSeparatedIntegersValueEditor.$$$reportNull$$$0(4);
        }
        return true;
    }

    @NlsSafe
    public static String intListToString(@NotNull List<Integer> valueList) {
        if (valueList == null) {
            CommaSeparatedIntegersValueEditor.$$$reportNull$$$0(5);
        }
        StringBuilder sb = new StringBuilder();
        for (Integer value2 : valueList) {
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            sb.append(value2);
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/fields/valueEditors/CommaSeparatedIntegersValueEditor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/fields/valueEditors/CommaSeparatedIntegersValueEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "valueToString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "intListToString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

