/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.panels;

import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b\u0016\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J$\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00140\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0016\u0010\u001d\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ui/components/panels/RowGridLayout;", "Ljava/awt/LayoutManager;", "columns", "", "rows", "gap", "alignment", "<init>", "(IIII)V", "addLayoutComponent", "", "name", "", "comp", "Ljava/awt/Component;", "removeLayoutComponent", "layoutContainer", "parent", "Ljava/awt/Container;", "preferredLayoutSize", "Ljava/awt/Dimension;", "minimumLayoutSize", "getSize", "function", "Lkotlin/Function1;", "getGrid", "count", "size", "getGridSize", "getCellSize", "sizes", "", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nRowGridLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RowGridLayout.kt\ncom/intellij/ui/components/panels/RowGridLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,103:1\n1#2:104\n11705#3:105\n12052#3,3:106\n*S KotlinDebug\n*F\n+ 1 RowGridLayout.kt\ncom/intellij/ui/components/panels/RowGridLayout\n*L\n69#1:105\n69#1:106,3\n*E\n"})
public class RowGridLayout
implements LayoutManager {
    private final int columns;
    private final int rows;
    private final int gap;
    private final int alignment;

    public RowGridLayout(int columns, int rows, int gap, int alignment) {
        this.columns = columns;
        this.rows = rows;
        this.gap = gap;
        this.alignment = alignment;
        if (!(this.columns > 0 || this.rows > 0)) {
            boolean $i$a$-require-RowGridLayout$32 = false;
            String $i$a$-require-RowGridLayout$32 = "unsupported columns and rows: " + this.columns + " x " + this.rows;
            throw new IllegalArgumentException($i$a$-require-RowGridLayout$32.toString());
        }
        if (!(this.alignment == 2 || this.alignment == 4 || this.alignment == 0)) {
            boolean bl = false;
            String string = "unsupported alignment: " + this.alignment;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ RowGridLayout(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        this(n, n2, n3, n4);
    }

    @Override
    public void addLayoutComponent(@NotNull String name, @NotNull Component comp) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
    }

    @Override
    public void removeLayoutComponent(@NotNull Component comp) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Object object = parent.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            Rectangle bounds = new Rectangle(parent.getWidth(), parent.getHeight());
            JBInsets.removeFrom((Rectangle)bounds, (Insets)parent.getInsets());
            int count = parent.getComponentCount();
            Dimension grid = this.getGridSize(count);
            if (grid.width > 0 && grid.height > 0) {
                int gap = this.gap <= 0 ? 0 : JBUI.scale((int)this.gap);
                int width = RangesKt.coerceAtLeast((int)((bounds.width + gap) / grid.width - gap), (int)0);
                int height = RangesKt.coerceAtLeast((int)((bounds.height + gap) / grid.height - gap), (int)0);
                int x = bounds.x - width - gap;
                int y = bounds.y - height - gap;
                for (int i = 0; i < count; ++i) {
                    if (i % grid.width != 0) {
                        x += width + gap;
                    } else {
                        int space;
                        y += height + gap;
                        x = bounds.x;
                        if (this.alignment != 2 && (space = i + grid.width - count) > 0) {
                            space *= width + gap;
                            if (this.alignment != 4) {
                                space /= 2;
                            }
                            x += space;
                        }
                    }
                    parent.getComponent(i).setBounds(x, y, width, height);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return this.getSize(parent, (Function1<? super Component, ? extends Dimension>)((Function1)RowGridLayout::preferredLayoutSize$lambda$0));
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return this.getSize(parent, (Function1<? super Component, ? extends Dimension>)((Function1)RowGridLayout::minimumLayoutSize$lambda$0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Dimension getSize(Container parent, Function1<? super Component, ? extends Dimension> function) {
        Dimension dimension;
        Dimension size = dimension = new Dimension();
        boolean bl = false;
        Object object = parent.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl2 = false;
            JBInsets.addTo((Dimension)size, (Insets)parent.getInsets());
            Component[] components = parent.getComponents();
            Dimension grid = this.getGridSize(components.length);
            if (grid.width > 0 && grid.height > 0) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNull((Object)components);
                Component[] componentArray = components;
                RowGridLayout rowGridLayout = this;
                boolean $i$f$map = false;
                void var13_16 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var19_22 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add((Dimension)function.invoke((Object)it));
                }
                Dimension cell = rowGridLayout.getCellSize((List)destination$iv$iv);
                if (cell.width > 0 && cell.height > 0) {
                    int gap = this.gap <= 0 ? 0 : JBUI.scale((int)this.gap);
                    size.width += (gap + cell.width) * grid.width - gap;
                    size.height += (gap + cell.height) * grid.height - gap;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        return dimension;
    }

    private final int getGrid(int count, int size) {
        return count <= 0 || size <= 0 ? 0 : (count % size == 0 ? count / size : 1 + count / size);
    }

    private final Dimension getGridSize(int count) {
        Dimension dimension;
        if (this.columns <= 0) {
            int it = RangesKt.coerceAtMost((int)this.rows, (int)count);
            boolean bl = false;
            dimension = new Dimension(this.getGrid(count, it), it);
        } else if (this.rows <= 0) {
            int it = RangesKt.coerceAtMost((int)this.columns, (int)count);
            boolean bl = false;
            dimension = new Dimension(it, this.getGrid(count, it));
        } else {
            dimension = this.columns * this.rows < count ? new Dimension(this.columns, this.getGrid(count, this.columns)) : new Dimension(this.columns, this.rows);
        }
        return dimension;
    }

    @NotNull
    protected Dimension getCellSize(@NotNull List<? extends Dimension> sizes) {
        Dimension dimension;
        Intrinsics.checkNotNullParameter(sizes, (String)"sizes");
        Dimension size = dimension = new Dimension();
        boolean bl = false;
        if (!((Collection)sizes).isEmpty()) {
            Iterable iterable = sizes;
            Dimension dimension2 = size;
            Iterator iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            Object it = (Dimension)iterator.next();
            boolean bl2 = false;
            it = ((Dimension)it).width;
            while (iterator.hasNext()) {
                Object it2 = (Dimension)iterator.next();
                $i$a$-maxOf-RowGridLayout$getCellSize$1$1 = false;
                it2 = ((Dimension)it2).width;
                if (it.compareTo(it2) >= 0) continue;
                it = it2;
            }
            dimension2.width = ((Number)it).intValue();
            iterable = sizes;
            dimension2 = size;
            iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            it = (Dimension)iterator.next();
            boolean bl3 = false;
            Comparable comparable = Integer.valueOf(((Dimension)it).height);
            while (iterator.hasNext()) {
                Dimension it3 = (Dimension)iterator.next();
                $i$a$-maxOf-RowGridLayout$getCellSize$1$2 = false;
                Comparable comparable2 = Integer.valueOf(it3.height);
                if (comparable.compareTo(comparable2) >= 0) continue;
                comparable = comparable2;
            }
            dimension2.height = ((Number)((Object)comparable)).intValue();
        }
        return dimension;
    }

    private static final Dimension preferredLayoutSize$lambda$0(Component it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Dimension dimension = it.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        return dimension;
    }

    private static final Dimension minimumLayoutSize$lambda$0(Component it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Dimension dimension = it.getMinimumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getMinimumSize(...)");
        return dimension;
    }
}

