/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.util.net.HttpProxyConfigurable;
import com.intellij.util.net.JdkProxyProvider;
import com.intellij.util.net.ProxyConfiguration;
import com.intellij.util.net.ProxyCredentialProvider;
import com.intellij.util.net.ProxyCredentialStore;
import com.intellij.util.net.ProxySettings;
import com.intellij.util.net.ProxyUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0016\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0002*\u00020\u0007\u001a \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u001a\u0016\u0010\n\u001a\u00020\u0001*\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u001a\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\t\u001a$\u0010\u0011\u001a\u00020\u0012*\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u0001\u001a&\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u001a0\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u001d*\u00020\u001f2\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010 \u001a\u00020!\u001a\"\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a0\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\t2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002\"\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"isRealProxy", "", "Ljava/net/Proxy;", "asJvmProperties", "", "", "asJavaProxy", "Lcom/intellij/util/net/ProxyConfiguration$StaticProxyConfiguration;", "credentialProvider", "Lcom/intellij/util/net/ProxyCredentialProvider;", "editConfigurable", "Lcom/intellij/util/net/ProxySettings;", "parent", "Ljavax/swing/JComponent;", "getStaticProxyCredentials", "Lcom/intellij/credentialStore/Credentials;", "credentialStore", "setStaticProxyCredentials", "", "Lcom/intellij/util/net/ProxyCredentialStore;", "value", "remember", "getHostNameReliably", "requestingHost", "requestingSite", "Ljava/net/InetAddress;", "requestingUrl", "Ljava/net/URL;", "NO_PROXY_LIST", "", "getApplicableProxiesAsJvmProperties", "Ljava/net/URI;", "proxySelector", "Ljava/net/ProxySelector;", "asJvmPropertiesWithCredentials", "getCredentialsAsJvmProperties", "host", "port", "", "proxyType", "Ljava/net/Proxy$Type;", "intellij.platform.ide"})
@JvmName(name="ProxyUtils")
@SourceDebugExtension(value={"SMAP\nproxyUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 proxyUtils.kt\ncom/intellij/util/net/ProxyUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n1586#2:140\n1661#2,3:141\n777#2:144\n873#2,2:145\n*S KotlinDebug\n*F\n+ 1 proxyUtils.kt\ncom/intellij/util/net/ProxyUtils\n*L\n101#1:140\n101#1:141,3\n104#1:144\n104#1:145,2\n*E\n"})
public final class ProxyUtils {
    @JvmField
    @NotNull
    public static final List<Proxy> NO_PROXY_LIST = CollectionsKt.listOf((Object)Proxy.NO_PROXY);

    public static final boolean isRealProxy(@NotNull Proxy $this$isRealProxy) {
        Intrinsics.checkNotNullParameter((Object)$this$isRealProxy, (String)"<this>");
        return !Intrinsics.areEqual((Object)Proxy.NO_PROXY, (Object)$this$isRealProxy) && Proxy.Type.DIRECT != $this$isRealProxy.type();
    }

    @NotNull
    public static final Map<String, String> asJvmProperties(@NotNull Proxy $this$asJvmProperties) {
        Intrinsics.checkNotNullParameter((Object)$this$asJvmProperties, (String)"<this>");
        if (!ProxyUtils.isRealProxy($this$asJvmProperties)) {
            return MapsKt.emptyMap();
        }
        SocketAddress address = $this$asJvmProperties.address();
        if (!(address instanceof InetSocketAddress)) {
            return MapsKt.emptyMap();
        }
        Proxy.Type type = $this$asJvmProperties.type();
        return switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> {
                Pair[] var2_2 = new Pair[]{TuplesKt.to((Object)"socksProxyHost", (Object)((InetSocketAddress)address).getHostString()), TuplesKt.to((Object)"socksProxyPort", (Object)String.valueOf(((InetSocketAddress)address).getPort()))};
                yield MapsKt.mapOf((Pair[])var2_2);
            }
            case 2 -> {
                Pair[] var2_3 = new Pair[]{TuplesKt.to((Object)"http.proxyHost", (Object)((InetSocketAddress)address).getHostString()), TuplesKt.to((Object)"http.proxyPort", (Object)String.valueOf(((InetSocketAddress)address).getPort())), TuplesKt.to((Object)"https.proxyHost", (Object)((InetSocketAddress)address).getHostString()), TuplesKt.to((Object)"https.proxyPort", (Object)String.valueOf(((InetSocketAddress)address).getPort()))};
                yield MapsKt.mapOf((Pair[])var2_3);
            }
            default -> MapsKt.emptyMap();
        };
    }

    @NotNull
    public static final Proxy asJavaProxy(@NotNull ProxyConfiguration.StaticProxyConfiguration $this$asJavaProxy) {
        Intrinsics.checkNotNullParameter((Object)$this$asJavaProxy, (String)"<this>");
        return new Proxy(switch (WhenMappings.$EnumSwitchMapping$1[$this$asJavaProxy.getProtocol().ordinal()]) {
            case 1 -> Proxy.Type.HTTP;
            case 2 -> Proxy.Type.SOCKS;
            default -> throw new NoWhenBranchMatchedException();
        }, InetSocketAddress.createUnresolved($this$asJavaProxy.getHost(), $this$asJavaProxy.getPort()));
    }

    @NotNull
    public static final Map<String, String> asJvmProperties(@NotNull ProxyConfiguration.StaticProxyConfiguration $this$asJvmProperties, @Nullable ProxyCredentialProvider credentialProvider) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)$this$asJvmProperties, (String)"<this>");
        Proxy javaProxy = ProxyUtils.asJavaProxy($this$asJvmProperties);
        Map jvmPropertiesWithCredentials = ProxyUtils.asJvmPropertiesWithCredentials(javaProxy, credentialProvider);
        if (jvmPropertiesWithCredentials.isEmpty() || ((CharSequence)$this$asJvmProperties.getExceptions()).length() == 0) {
            map = jvmPropertiesWithCredentials;
        } else {
            char[] cArray = new char[]{','};
            map = MapsKt.plus(jvmPropertiesWithCredentials, (Pair)TuplesKt.to((Object)"http.nonProxyHosts", (Object)CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)$this$asJvmProperties.getExceptions(), (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"|", null, null, (int)0, null, (Function1)asJvmProperties.1.INSTANCE, (int)30, null)));
        }
        return map;
    }

    @Deprecated(message="Use HttpProxyConfigurable.editConfigurable", replaceWith=@ReplaceWith(expression="HttpProxyConfigurable.editConfigurable(parent)", imports={}), level=DeprecationLevel.ERROR)
    public static final boolean editConfigurable(@NotNull ProxySettings $this$editConfigurable, @Nullable JComponent parent) {
        Intrinsics.checkNotNullParameter((Object)$this$editConfigurable, (String)"<this>");
        return HttpProxyConfigurable.editConfigurable(parent);
    }

    @Nullable
    public static final Credentials getStaticProxyCredentials(@NotNull ProxySettings $this$getStaticProxyCredentials, @NotNull ProxyCredentialProvider credentialStore) {
        Intrinsics.checkNotNullParameter((Object)$this$getStaticProxyCredentials, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)credentialStore, (String)"credentialStore");
        ProxyConfiguration conf = $this$getStaticProxyCredentials.getProxyConfiguration();
        if (!(conf instanceof ProxyConfiguration.StaticProxyConfiguration)) {
            return null;
        }
        return credentialStore.getCredentials(((ProxyConfiguration.StaticProxyConfiguration)conf).getHost(), ((ProxyConfiguration.StaticProxyConfiguration)conf).getPort());
    }

    public static final void setStaticProxyCredentials(@NotNull ProxySettings $this$setStaticProxyCredentials, @NotNull ProxyCredentialStore credentialStore, @Nullable Credentials value2, boolean remember) {
        Intrinsics.checkNotNullParameter((Object)$this$setStaticProxyCredentials, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)credentialStore, (String)"credentialStore");
        ProxyConfiguration conf = $this$setStaticProxyCredentials.getProxyConfiguration();
        if (!(conf instanceof ProxyConfiguration.StaticProxyConfiguration)) {
            return;
        }
        credentialStore.setCredentials(((ProxyConfiguration.StaticProxyConfiguration)conf).getHost(), ((ProxyConfiguration.StaticProxyConfiguration)conf).getPort(), value2, remember);
    }

    @Nullable
    public static final String getHostNameReliably(@Nullable String requestingHost, @Nullable InetAddress requestingSite, @Nullable URL requestingUrl) {
        String string = requestingHost;
        if (string == null) {
            InetAddress inetAddress = requestingSite;
            string = inetAddress != null ? inetAddress.getHostName() : null;
            if (string == null) {
                URL uRL = requestingUrl;
                string = uRL != null ? uRL.getHost() : null;
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Map<String, String>> getApplicableProxiesAsJvmProperties(@NotNull URI $this$getApplicableProxiesAsJvmProperties, @Nullable ProxyCredentialProvider credentialProvider, @NotNull ProxySelector proxySelector) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getApplicableProxiesAsJvmProperties, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)proxySelector, (String)"proxySelector");
        List<Proxy> list = proxySelector.select($this$getApplicableProxiesAsJvmProperties);
        Intrinsics.checkNotNullExpressionValue(list, (String)"select(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void proxy;
            Proxy proxy2 = (Proxy)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)proxy);
            collection.add(ProxyUtils.asJvmPropertiesWithCredentials((Proxy)proxy, credentialProvider));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map it = (Map)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !it.isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getApplicableProxiesAsJvmProperties$default(URI uRI, ProxyCredentialProvider proxyCredentialProvider, ProxySelector proxySelector, int n, Object object) {
        if ((n & 2) != 0) {
            proxySelector = JdkProxyProvider.Companion.getInstance().getProxySelector();
        }
        return ProxyUtils.getApplicableProxiesAsJvmProperties(uRI, proxyCredentialProvider, proxySelector);
    }

    private static final Map<String, String> asJvmPropertiesWithCredentials(Proxy $this$asJvmPropertiesWithCredentials, ProxyCredentialProvider credentialProvider) {
        Map<String, String> props = ProxyUtils.asJvmProperties($this$asJvmPropertiesWithCredentials);
        SocketAddress address = $this$asJvmPropertiesWithCredentials.address();
        if (props.isEmpty() || !(address instanceof InetSocketAddress) || credentialProvider == null) {
            return props;
        }
        String string = ((InetSocketAddress)address).getHostString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostString(...)");
        int n = ((InetSocketAddress)address).getPort();
        Proxy.Type type = $this$asJvmPropertiesWithCredentials.type();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)type), (String)"type(...)");
        return MapsKt.plus(props, ProxyUtils.getCredentialsAsJvmProperties(credentialProvider, string, n, type));
    }

    private static final Map<String, String> getCredentialsAsJvmProperties(ProxyCredentialProvider $this$getCredentialsAsJvmProperties, String host, int port, Proxy.Type proxyType) {
        Credentials credentials = $this$getCredentialsAsJvmProperties.getCredentials(host, port);
        if (credentials == null || !CredentialAttributesKt.isFulfilled(credentials)) {
            return MapsKt.emptyMap();
        }
        String string = credentials.getUserName();
        Intrinsics.checkNotNull((Object)string);
        String username = string;
        OneTimeString oneTimeString = credentials.getPassword();
        Intrinsics.checkNotNull((Object)oneTimeString);
        String password = oneTimeString.toString();
        return switch (WhenMappings.$EnumSwitchMapping$0[proxyType.ordinal()]) {
            case 1 -> {
                Pair[] var7_7 = new Pair[]{TuplesKt.to((Object)"java.net.socks.username", (Object)username), TuplesKt.to((Object)"java.net.socks.password", (Object)password)};
                yield MapsKt.mapOf((Pair[])var7_7);
            }
            case 2 -> {
                Pair[] var7_8 = new Pair[]{TuplesKt.to((Object)"http.proxyUser", (Object)username), TuplesKt.to((Object)"http.proxyPassword", (Object)password), TuplesKt.to((Object)"https.proxyUser", (Object)username), TuplesKt.to((Object)"https.proxyPassword", (Object)password)};
                yield MapsKt.mapOf((Pair[])var7_8);
            }
            default -> MapsKt.emptyMap();
        };
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Proxy.Type.values().length];
            try {
                nArray[Proxy.Type.SOCKS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proxy.Type.HTTP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProxyConfiguration.ProxyProtocol.values().length];
            try {
                nArray[ProxyConfiguration.ProxyProtocol.HTTP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProxyConfiguration.ProxyProtocol.SOCKS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

