/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.execService.impl;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000f\u001a\u00020\bH\u0016J \u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/intellij/python/community/execService/impl/LoggingInputStream;", "Ljava/io/InputStream;", "backingInputStream", "<init>", "(Ljava/io/InputStream;)V", "bytes", "Lcom/google/common/io/ByteArrayDataOutput;", "tail", "", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "byteArray", "", "getByteArray", "()[B", "read", "b", "off", "len", "close", "", "intellij.python.community.execService"})
final class LoggingInputStream
extends InputStream {
    @NotNull
    private final InputStream backingInputStream;
    @NotNull
    private final ByteArrayDataOutput bytes;
    private int tail;
    @NotNull
    private AtomicBoolean closed;

    public LoggingInputStream(@NotNull InputStream backingInputStream) {
        Intrinsics.checkNotNullParameter((Object)backingInputStream, (String)"backingInputStream");
        this.backingInputStream = backingInputStream;
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        Intrinsics.checkNotNullExpressionValue((Object)byteArrayDataOutput, (String)"newDataOutput(...)");
        this.bytes = byteArrayDataOutput;
        this.closed = new AtomicBoolean(false);
    }

    @NotNull
    public final byte[] getByteArray() {
        byte[] byArray = this.bytes.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @Override
    public int read() {
        if (this.closed.get()) {
            return -1;
        }
        int n = this.backingInputStream.read();
        if (this.tail < 100000 && n != -1) {
            this.bytes.write(n);
            ++this.tail;
        }
        return n;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (this.closed.get()) {
            return -1;
        }
        int finalLen = this.backingInputStream.read(b, off, len);
        if (finalLen != -1) {
            int truncatedLen;
            int n = truncatedLen = this.tail + finalLen > 100000 ? 100000 - this.tail : finalLen;
            if (truncatedLen > 0) {
                this.bytes.write(b, off, truncatedLen);
                this.tail += truncatedLen;
            }
        }
        return finalLen;
    }

    @Override
    public void close() {
        this.closed.set(true);
        super.close();
    }
}

