/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.settings.local;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.settings.JsonElementSettingSerializerDescriptor;
import com.intellij.platform.settings.RawSettingSerializerDescriptor;
import com.intellij.platform.settings.SettingSerializerDescriptor;
import com.intellij.platform.settings.SettingValueSerializer;
import com.intellij.platform.settings.local.InternalStateStorageServiceKt;
import com.intellij.platform.settings.local.Measurer;
import com.intellij.platform.settings.local.MvMapManager;
import com.intellij.util.xmlb.KotlinxSerializationBindingKt;
import io.opentelemetry.api.metrics.Meter;
import java.util.concurrent.CancellationException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.cbor.Cbor;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J5\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J=\u0010\u0015\u001a\u00020\u0016\"\b\b\u0000\u0010\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u0001H\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0018R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/settings/local/InternalStateStorageService;", "", "map", "Lcom/intellij/platform/settings/local/MvMapManager;", "telemetryScopeName", "", "<init>", "(Lcom/intellij/platform/settings/local/MvMapManager;Ljava/lang/String;)V", "meter", "Lio/opentelemetry/api/metrics/Meter;", "getMeasurer", "Lcom/intellij/platform/settings/local/Measurer;", "setMeasurer", "getValue", "T", "key", "serializer", "Lcom/intellij/platform/settings/SettingSerializerDescriptor;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "(Ljava/lang/String;Lcom/intellij/platform/settings/SettingSerializerDescriptor;Lcom/intellij/openapi/extensions/PluginId;)Ljava/lang/Object;", "setValue", "", "value", "(Ljava/lang/String;Ljava/lang/Object;Lcom/intellij/platform/settings/SettingSerializerDescriptor;Lcom/intellij/openapi/extensions/PluginId;)V", "intellij.platform.settings.local"})
@SourceDebugExtension(value={"SMAP\nInternalStateStorageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalStateStorageService.kt\ncom/intellij/platform/settings/local/InternalStateStorageService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,151:1\n23#2:152\n23#2:154\n205#3:153\n*S KotlinDebug\n*F\n+ 1 InternalStateStorageService.kt\ncom/intellij/platform/settings/local/InternalStateStorageService\n*L\n88#1:152\n120#1:154\n105#1:153\n*E\n"})
public final class InternalStateStorageService {
    @JvmField
    @NotNull
    public final MvMapManager map;
    @NotNull
    private final Meter meter;
    @NotNull
    private final Measurer getMeasurer;
    @NotNull
    private final Measurer setMeasurer;

    public InternalStateStorageService(@NotNull MvMapManager map, @NotNull String telemetryScopeName) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)telemetryScopeName, (String)"telemetryScopeName");
        this.map = map;
        this.meter = TelemetryManager.Companion.getMeter(new Scope(telemetryScopeName, PlatformScopesKt.PlatformMetrics, false, 4, null));
        this.getMeasurer = new Measurer(this.meter, "get");
        this.setMeasurer = new Measurer(this.meter, "set");
    }

    @Nullable
    public final <T> T getValue(@NotNull String key, @NotNull SettingSerializerDescriptor<T> serializer, @NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        long start = System.nanoTime();
        byte[] bytes = null;
        try {
            Object object;
            if (bytes != null) {
                byte[] it = bytes = this.map.get(key);
                boolean bl = false;
                if (serializer == RawSettingSerializerDescriptor.INSTANCE) {
                    Intrinsics.checkNotNull((Object)bytes, (String)"null cannot be cast to non-null type T of com.intellij.platform.settings.local.InternalStateStorageService.getValue");
                    object = bytes;
                } else if (serializer == JsonElementSettingSerializerDescriptor.INSTANCE) {
                    JsonElement jsonElement = KotlinxSerializationBindingKt.get__json().parseToJsonElement((String)InternalStateStorageServiceKt.getCborFormat().decodeFromByteArray((DeserializationStrategy)InternalStateStorageServiceKt.access$getStringSerializer(), bytes));
                    Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type T of com.intellij.platform.settings.local.InternalStateStorageService.getValue");
                    object = jsonElement;
                } else {
                    object = InternalStateStorageServiceKt.getCborFormat().decodeFromByteArray((DeserializationStrategy)((SettingValueSerializer)serializer).getSerializer(), bytes);
                }
            } else {
                object = null;
            }
            Object result = object;
            this.getMeasurer.add(System.nanoTime() - start);
            return (T)result;
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            byte[] byArray = bytes;
            String message = "Cannot deserialize value for key " + key + " (size=" + (byArray != null ? Integer.valueOf(byArray.length) : "null");
            try {
                this.map.remove(key);
                if (bytes == null || bytes.length == 0) {
                    message = message + ")";
                } else {
                    String keyForInvestigation = key + ".__corrupted__";
                    this.map.put(keyForInvestigation, bytes);
                    message = message + ", value will be stored under key " + keyForInvestigation + ")";
                }
            }
            catch (Throwable e2) {
                ExceptionsKt.addSuppressed((Throwable)e2, (Throwable)e2);
            }
            InternalStateStorageService $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(InternalStateStorageService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)new PluginException(message, e, pluginId));
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final <T> void setValue(@NotNull String key, @Nullable T value, @NotNull SettingSerializerDescriptor<T> serializer, @NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        long start = System.nanoTime();
        try {
            if (value == null) {
                this.map.remove(key);
            } else {
                byte[] byArray;
                if (serializer == RawSettingSerializerDescriptor.INSTANCE) {
                    byArray = (byte[])value;
                } else if (serializer == JsonElementSettingSerializerDescriptor.INSTANCE) {
                    void this_$iv;
                    Cbor cbor = InternalStateStorageServiceKt.getCborFormat();
                    SerializationStrategy serializationStrategy = (SerializationStrategy)InternalStateStorageServiceKt.access$getStringSerializer();
                    Json json = (Json)Json.Default;
                    JsonElement value$iv = (JsonElement)value;
                    boolean $i$f$encodeToString = false;
                    this_$iv.getSerializersModule();
                    byArray = cbor.encodeToByteArray(serializationStrategy, (Object)this_$iv.encodeToString((SerializationStrategy)JsonElement.Companion.serializer(), (Object)value$iv));
                } else {
                    byArray = InternalStateStorageServiceKt.getCborFormat().encodeToByteArray((SerializationStrategy)((SettingValueSerializer)serializer).getSerializer(), value);
                }
                byte[] serialized = byArray;
                this.map.put(key, serialized);
            }
            this.setMeasurer.add(System.nanoTime() - start);
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            InternalStateStorageService $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(InternalStateStorageService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)new PluginException("Cannot set value for key " + key, e, pluginId));
        }
    }
}

