/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilesProcessorWithNotificationImpl;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.VcsIgnoreManager;
import com.intellij.openapi.vcs.changes.ignore.IgnoreFilesProcessorImplKt;
import com.intellij.openapi.vcs.changes.ignore.psi.util.IgnoreFileUtilKt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.project.ProjectKt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001SB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001cH\u0002J\u001c\u0010\u001e\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001cH\u0096@\u00a2\u0006\u0002\u0010!J\u0016\u0010\"\u001a\u00020\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100#H\u0016J\b\u0010$\u001a\u00020\u0015H\u0016J\u001e\u0010%\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100#H\u0002J\u001a\u0010'\u001a\u00020(*\b\u0012\u0004\u0012\u00020(0)2\u0006\u0010*\u001a\u00020+H\u0002J\"\u0010,\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0010H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0014\u00101\u001a\u00020\u001a*\u00020\u00102\u0006\u00102\u001a\u00020\u0010H\u0002J\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100#H\u0016J\b\u00104\u001a\u00020\u0015H\u0014J\b\u0010H\u001a\u00020+H\u0016J\b\u0010I\u001a\u00020+H\u0016J\u001e\u0010J\u001a\u00020\u001a2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00100L2\u0006\u0010M\u001a\u00020\u0010H\u0002J\b\u0010N\u001a\u00020\u001aH\u0014J\u0012\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010Q\u001a\u00020 H\u0002J\b\u0010R\u001a\u00020\u001aH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\u00020+X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u00020+X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00107R\u0014\u0010:\u001a\u00020+X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u00107R\u0014\u0010<\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u00107R\u0014\u0010>\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u00107R\u0014\u0010@\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u00107R\u0014\u0010B\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u00107R\u0014\u0010D\u001a\u00020+X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u00107R\u0014\u0010F\u001a\u00020+X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u00107\u00a8\u0006T"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/IgnoreFilesProcessorImpl;", "Lcom/intellij/openapi/vcs/FilesProcessorWithNotificationImpl;", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "Lcom/intellij/openapi/vcs/changes/ChangeListListener;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/vcs/AbstractVcs;)V", "UNPROCESSED_FILES_LOCK", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "unprocessedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "vcsIgnoreManager", "Lcom/intellij/openapi/vcs/changes/VcsIgnoreManager;", "kotlin.jvm.PlatformType", "install", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "unchangedFileStatusChanged", "upToDate", "", "silentlyIgnoreFilesInsideConfigDir", "", "files", "filesChanged", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doActionOnChosenFiles", "", "dispose", "writeIgnores", "potentiallyIgnoredFiles", "getOrInitialize", "Lcom/intellij/openapi/vcs/changes/ignore/IgnoreFilesProcessorImpl$IgnoreGroupContent;", "", "group", "", "findOrCreateIgnoreFileByFile", "ignoredContentProvider", "Lcom/intellij/openapi/vcs/changes/IgnoredFileContentProvider;", "file", "findStoreDir", "underProjectStoreDir", "storeDir", "doFilterFiles", "rememberForAllProjects", "notificationDisplayId", "getNotificationDisplayId", "()Ljava/lang/String;", "askedBeforeProperty", "getAskedBeforeProperty", "doForCurrentProjectProperty", "getDoForCurrentProjectProperty", "showActionText", "getShowActionText", "forCurrentProjectActionText", "getForCurrentProjectActionText", "forAllProjectsActionText", "getForAllProjectsActionText", "muteActionText", "getMuteActionText", "viewFilesDialogTitle", "getViewFilesDialogTitle", "viewFilesDialogOkActionName", "getViewFilesDialogOkActionName", "notificationTitle", "notificationMessage", "isUnder", "parents", "", "child", "needDoForCurrentProject", "getAffectedFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "event", "needProcessIgnoredFiles", "IgnoreGroupContent", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nIgnoreFilesProcessorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IgnoreFilesProcessorImpl.kt\ncom/intellij/openapi/vcs/changes/ignore/IgnoreFilesProcessorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,247:1\n777#2:248\n873#2,2:249\n777#2:262\n873#2,2:263\n777#2:268\n873#2,2:269\n60#3,5:251\n8963#4,2:256\n9664#4,4:258\n37#5,2:265\n1#6:267\n1276#7,2:271\n*S KotlinDebug\n*F\n+ 1 IgnoreFilesProcessorImpl.kt\ncom/intellij/openapi/vcs/changes/ignore/IgnoreFilesProcessorImpl\n*L\n74#1:248\n74#1:249,2\n136#1:262\n136#1:263,2\n195#1:268\n195#1:269,2\n101#1:251,5\n129#1:256,2\n129#1:258,4\n152#1:265,2\n222#1:271,2\n*E\n"})
public final class IgnoreFilesProcessorImpl
extends FilesProcessorWithNotificationImpl
implements AsyncVfsEventsListener,
ChangeListListener {
    @NotNull
    private final AbstractVcs vcs;
    @NotNull
    private final ReentrantReadWriteLock UNPROCESSED_FILES_LOCK;
    @NotNull
    private final Set<VirtualFile> unprocessedFiles;
    private final VcsIgnoreManager vcsIgnoreManager;
    @NotNull
    private final String notificationDisplayId;
    @NotNull
    private final String askedBeforeProperty;
    @NotNull
    private final String doForCurrentProjectProperty;
    @NotNull
    private final String showActionText;
    @NotNull
    private final String forCurrentProjectActionText;
    @NotNull
    private final String forAllProjectsActionText;
    @NotNull
    private final String muteActionText;
    @NotNull
    private final String viewFilesDialogTitle;
    @NotNull
    private final String viewFilesDialogOkActionName;

    public IgnoreFilesProcessorImpl(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull AbstractVcs vcs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        super(project, parentDisposable);
        this.vcs = vcs;
        this.UNPROCESSED_FILES_LOCK = new ReentrantReadWriteLock();
        this.unprocessedFiles = new LinkedHashSet();
        this.vcsIgnoreManager = VcsIgnoreManager.getInstance((Project)project);
        this.notificationDisplayId = "manage.ignore.files.notification";
        this.askedBeforeProperty = "ASKED_MANAGE_IGNORE_FILES";
        this.doForCurrentProjectProperty = "MANAGE_IGNORE_FILES";
        String string = VcsBundle.message((String)"ignored.file.manage.view", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.showActionText = string;
        String string2 = VcsBundle.message((String)"ignored.file.manage.this.project", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.forCurrentProjectActionText = string2;
        String string3 = VcsBundle.message((String)"ignored.file.manage.all.project", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        this.forAllProjectsActionText = string3;
        String string4 = VcsBundle.message((String)"ignored.file.manage.notmanage", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        this.muteActionText = string4;
        String string5 = VcsBundle.message((String)"ignored.file.manage.view.dialog.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        this.viewFilesDialogTitle = string5;
        String string6 = VcsBundle.message((String)"ignored.file.manage.view.dialog.ignore.action", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        this.viewFilesDialogOkActionName = string6;
    }

    public final void install(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        SimpleMessageBusConnection simpleMessageBusConnection = this.getProject().getMessageBus().connect(coroutineScope);
        Topic topic = ChangeListListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        simpleMessageBusConnection.subscribe(topic, (Object)this);
        AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)this, coroutineScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unchangedFileStatusChanged(boolean upToDate) {
        if (!upToDate) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        List files = null;
        ReentrantReadWriteLock reentrantReadWriteLock = this.UNPROCESSED_FILES_LOCK;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            files = CollectionsKt.toList((Iterable)this.unprocessedFiles);
            this.unprocessedFiles.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        if (files.isEmpty()) {
            return;
        }
        List<VirtualFile> restFiles = this.silentlyIgnoreFilesInsideConfigDir(files);
        if (this.needProcessIgnoredFiles() && !((Collection)restFiles).isEmpty()) {
            this.processFiles((Collection<? extends VirtualFile>)restFiles);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> silentlyIgnoreFilesInsideConfigDir(List<? extends VirtualFile> files) {
        void $this$filterTo$iv$iv;
        Path path = ProjectKt.getStateStore((Project)this.getProject()).getDirectoryStorePath();
        if (path == null) {
            return files;
        }
        Path configDir = path;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByNioFile(configDir);
        if (virtualFile == null) {
            return files;
        }
        VirtualFile configDirFile = virtualFile;
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!VfsUtil.isAncestor((VirtualFile)configDirFile, (VirtualFile)it, (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filesInConfigDir = (List)destination$iv$iv;
        Collection unversionedFilesInConfigDir = this.doFilterFiles((Collection)filesInConfigDir);
        ActionsKt.runInEdt$default(null, () -> IgnoreFilesProcessorImpl.silentlyIgnoreFilesInsideConfigDir$lambda$1(this, (List)unversionedFilesInConfigDir), (int)1, null);
        return CollectionsKt.minus((Iterable)files, (Iterable)filesInConfigDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object filesChanged(@NotNull List<? extends VFileEvent> events, @NotNull Continuation<? super Unit> $completion) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Unit.INSTANCE;
        }
        List potentiallyIgnoredFiles = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)events), arg_0 -> IgnoreFilesProcessorImpl.filesChanged$lambda$0(this, arg_0)), IgnoreFilesProcessorImpl::filesChanged$lambda$1));
        if (potentiallyIgnoredFiles.isEmpty()) {
            return Unit.INSTANCE;
        }
        Logger $this$debug_u24default$iv = IgnoreFilesProcessorImplKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Got potentially ignored files from VFS events " + potentiallyIgnoredFiles, t$iv);
        }
        JobKt.ensureActive((Job)JobKt.getJob((CoroutineContext)$completion.getContext()));
        ReentrantReadWriteLock reentrantReadWriteLock = this.UNPROCESSED_FILES_LOCK;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.unprocessedFiles.addAll(potentiallyIgnoredFiles);
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return Unit.INSTANCE;
    }

    @Override
    public void doActionOnChosenFiles(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        ActionsKt.runInEdt$default(null, () -> IgnoreFilesProcessorImpl.doActionOnChosenFiles$lambda$0(this, files), (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        ReentrantReadWriteLock reentrantReadWriteLock = this.UNPROCESSED_FILES_LOCK;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.unprocessedFiles.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeIgnores(Project project, Collection<? extends VirtualFile> potentiallyIgnoredFiles) {
        void $this$associateTo$iv$iv;
        if (project.isDisposed()) {
            return;
        }
        if (potentiallyIgnoredFiles.isEmpty()) {
            return;
        }
        Object[] objectArray = new Object[]{potentiallyIgnoredFiles};
        IgnoreFilesProcessorImplKt.access$getLOG$p().debug("Try to write potential ignored files", objectArray);
        HashMap<Object, List> ignoreFileToContent = new HashMap<Object, List>();
        Object[] $this$associate$iv = IgnoredFileProvider.IGNORE_FILE.getExtensions();
        boolean bl = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv.length), (int)16);
        Object[] objectArray2 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (void element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Object it = (IgnoredFileProvider)element$iv$iv;
            boolean bl2 = false;
            it = TuplesKt.to((Object)it, (Object)it.getIgnoredFiles(project));
            map2.put(it.getFirst(), it.getSecond());
        }
        Map providerToDescriptorMap = destination$iv$iv;
        for (VirtualFile virtualFile : potentiallyIgnoredFiles) {
            IgnoredFileContentProvider ignoredContentProvider;
            AbstractVcs vcs;
            if (VcsUtil.getVcsFor((Project)project, (VirtualFile)virtualFile) == null) continue;
            boolean bl3 = false;
            if (VcsImplUtil.findIgnoredFileContentProvider(vcs) == null) continue;
            boolean bl2 = false;
            if (this.findOrCreateIgnoreFileByFile(project, ignoredContentProvider, virtualFile) == null) continue;
            boolean bl32 = false;
            for (Map.Entry entry : providerToDescriptorMap.entrySet()) {
                void $this$filterTo$iv$iv;
                IgnoredFileProvider ignoredFileProvider = (IgnoredFileProvider)entry.getKey();
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
                Set descriptors = (Set)v;
                Iterable $this$filter$iv = descriptors;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    IgnoredFileDescriptor it = (IgnoredFileDescriptor)element$iv$iv;
                    boolean bl4 = false;
                    if (!it.matchesFile(VcsUtil.getFilePath((VirtualFile)virtualFile))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                for (IgnoredFileDescriptor ignoredFileDescriptor : (List)destination$iv$iv2) {
                    String groupDescription;
                    List ignoreFileContent;
                    VirtualFile ignoreFile;
                    Intrinsics.checkNotNullExpressionValue((Object)ignoreFileToContent.computeIfAbsent(ignoreFile, arg_0 -> IgnoreFilesProcessorImpl.writeIgnores$lambda$1$0$0$2(IgnoreFilesProcessorImpl::writeIgnores$lambda$1$0$0$1, arg_0)), (String)"computeIfAbsent(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)ignoredContentProvider.buildIgnoreGroupDescription(ignoredFileProvider), (String)"buildIgnoreGroupDescription(...)");
                    IgnoreGroupContent ignoreFileGroupContent = this.getOrInitialize(ignoreFileContent, groupDescription);
                    Set<IgnoredFileDescriptor> set2 = ignoreFileGroupContent.getIgnoredDescriptors();
                    Intrinsics.checkNotNull((Object)ignoredFileDescriptor);
                    set2.add(ignoredFileDescriptor);
                }
            }
        }
        for (Map.Entry entry : ((Map)ignoreFileToContent).entrySet()) {
            VirtualFile ignoreFile = (VirtualFile)entry.getKey();
            List newContent = (List)entry.getValue();
            for (IgnoreGroupContent groupContent : newContent) {
                Set<IgnoredFileDescriptor> ignoredDescriptors = groupContent.getIgnoredDescriptors();
                IgnoreFilesProcessorImplKt.access$getLOG$p().debug("Write to ignore file " + ignoreFile + " ignores: " + ignoredDescriptors);
                Collection $this$toTypedArray$iv = ignoredDescriptors;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                IgnoredFileDescriptor[] ignoredFileDescriptorArray = thisCollection$iv.toArray(new IgnoredFileDescriptor[0]);
                IgnoreFileUtilKt.addNewElementsToIgnoreBlock(project, ignoreFile, groupContent.getGroup(), Arrays.copyOf(ignoredFileDescriptorArray, ignoredFileDescriptorArray.length));
            }
        }
    }

    private final IgnoreGroupContent getOrInitialize(List<IgnoreGroupContent> $this$getOrInitialize, String group) {
        IgnoreGroupContent ignoreGroupContent;
        Object v0;
        block2: {
            Iterable iterable = $this$getOrInitialize;
            for (Object t : iterable) {
                IgnoreGroupContent it = (IgnoreGroupContent)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getGroup(), (Object)group)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((ignoreGroupContent = (IgnoreGroupContent)v0) == null) {
            IgnoreGroupContent ignoreGroupContent2;
            IgnoreGroupContent $this$getOrInitialize_u24lambda_u241 = ignoreGroupContent2 = new IgnoreGroupContent(group, null, 2, null);
            boolean bl = false;
            $this$getOrInitialize.add($this$getOrInitialize_u24lambda_u241);
            ignoreGroupContent = ignoreGroupContent2;
        }
        return ignoreGroupContent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final VirtualFile findOrCreateIgnoreFileByFile(Project project, IgnoredFileContentProvider ignoredContentProvider, VirtualFile file) {
        VirtualFile virtualFile;
        VirtualFile storeDir = this.findStoreDir(project);
        if (storeDir != null && ignoredContentProvider.supportIgnoreFileNotInVcsRoot() && this.underProjectStoreDir(file, storeDir)) {
            if (!ignoredContentProvider.canCreateIgnoreFileInStateStoreDir()) return null;
            virtualFile = storeDir;
        } else {
            virtualFile = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)file);
            if (virtualFile == null) {
                return null;
            }
        }
        VirtualFile ignoreFileRoot = virtualFile;
        VirtualFile virtualFile2 = ignoreFileRoot.findChild(ignoredContentProvider.getFileName());
        if (virtualFile2 != null) return virtualFile2;
        Object object = ActionsKt.runWriteAction(() -> IgnoreFilesProcessorImpl.findOrCreateIgnoreFileByFile$lambda$0(ignoreFileRoot, this, ignoredContentProvider));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWriteAction(...)");
        virtualFile2 = (VirtualFile)object;
        return virtualFile2;
    }

    private final VirtualFile findStoreDir(Project project) {
        VirtualFile virtualFile;
        Path path = ProjectKt.getStateStore((Project)project).getDirectoryStorePath();
        if (path != null) {
            Path it = path;
            boolean bl = false;
            virtualFile = LocalFileSystem.getInstance().findFileByNioFile(it);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    private final boolean underProjectStoreDir(VirtualFile $this$underProjectStoreDir, VirtualFile storeDir) {
        return VfsUtilCore.isAncestor((VirtualFile)storeDir, (VirtualFile)$this$underProjectStoreDir, (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<VirtualFile> doFilterFiles(@NotNull Collection<? extends VirtualFile> files) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        HashSet parents = CollectionsKt.toHashSet((Iterable)files);
        List<VirtualFile> list = ChangeListManagerImpl.getInstanceImpl(this.getProject()).getUnversionedFiles();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getUnversionedFiles(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            Set set2 = parents;
            Intrinsics.checkNotNull((Object)it);
            if (!this.isUnder(set2, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    protected void rememberForAllProjects() {
        VcsApplicationSettings applicationSettings = VcsApplicationSettings.getInstance();
        applicationSettings.MANAGE_IGNORE_FILES = true;
    }

    @Override
    @NotNull
    public String getNotificationDisplayId() {
        return this.notificationDisplayId;
    }

    @Override
    @NotNull
    public String getAskedBeforeProperty() {
        return this.askedBeforeProperty;
    }

    @Override
    @NotNull
    public String getDoForCurrentProjectProperty() {
        return this.doForCurrentProjectProperty;
    }

    @Override
    @NotNull
    public String getShowActionText() {
        return this.showActionText;
    }

    @Override
    @NotNull
    public String getForCurrentProjectActionText() {
        return this.forCurrentProjectActionText;
    }

    @Override
    @NotNull
    public String getForAllProjectsActionText() {
        return this.forAllProjectsActionText;
    }

    @Override
    @NotNull
    public String getMuteActionText() {
        return this.muteActionText;
    }

    @Override
    @NotNull
    protected String getViewFilesDialogTitle() {
        return this.viewFilesDialogTitle;
    }

    @Override
    @NotNull
    protected String getViewFilesDialogOkActionName() {
        return this.viewFilesDialogOkActionName;
    }

    @Override
    @NotNull
    public String notificationTitle() {
        return "";
    }

    @Override
    @NotNull
    public String notificationMessage() {
        Object[] objectArray = new Object[2];
        objectArray[0] = ApplicationNamesInfo.getInstance().getFullProductName();
        Object object = VcsImplUtil.findIgnoredFileContentProvider(this.vcs);
        if (object == null || (object = object.getFileName()) == null) {
            String string = VcsBundle.message((String)"changes.ignore.file", (Object[])new Object[0]);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        }
        objectArray[1] = object;
        String string = VcsBundle.message((String)"ignored.file.manage.with.files.message", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final boolean isUnder(Set<? extends VirtualFile> parents, VirtualFile child) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.generateSequence((Object)child, IgnoreFilesProcessorImpl::isUnder$lambda$0);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl2 = false;
                if (!parents.contains(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    protected boolean needDoForCurrentProject() {
        VcsApplicationSettings appSettings = VcsApplicationSettings.getInstance();
        return !appSettings.DISABLE_MANAGE_IGNORE_FILES && (appSettings.MANAGE_IGNORE_FILES || super.needDoForCurrentProject());
    }

    private final FilePath getAffectedFilePath(VFileEvent event) {
        FilePath filePath;
        if (!(event.getFileSystem() instanceof LocalFileSystem)) {
            return null;
        }
        if (event instanceof VFileCreateEvent) {
            filePath = VcsUtil.getFilePath((String)((VFileCreateEvent)event).getPath(), (boolean)((VFileCreateEvent)event).isDirectory());
        } else if (event instanceof VFileMoveEvent || event instanceof VFileCopyEvent || event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).isRename()) {
            String string = event.getPath();
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNull((Object)virtualFile);
            filePath = VcsUtil.getFilePath((String)string, (boolean)virtualFile.isDirectory());
        } else {
            filePath = null;
        }
        return filePath;
    }

    private final boolean needProcessIgnoredFiles() {
        return Registry.Companion.is("vcs.ignorefile.generation");
    }

    private static final Unit silentlyIgnoreFilesInsideConfigDir$lambda$1(IgnoreFilesProcessorImpl this$0, List $unversionedFilesInConfigDir) {
        this$0.writeIgnores(this$0.getProject(), $unversionedFilesInConfigDir);
        return Unit.INSTANCE;
    }

    private static final boolean filesChanged$lambda$0(IgnoreFilesProcessorImpl this$0, VFileEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FilePath filePath = this$0.getAffectedFilePath(it);
        return filePath != null && this$0.vcsIgnoreManager.isPotentiallyIgnoredFile(filePath);
    }

    private static final VirtualFile filesChanged$lambda$1(VFileEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFile();
    }

    private static final Unit doActionOnChosenFiles$lambda$0(IgnoreFilesProcessorImpl this$0, Collection $files) {
        this$0.writeIgnores(this$0.getProject(), $files);
        return Unit.INSTANCE;
    }

    private static final List writeIgnores$lambda$1$0$0$1(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List writeIgnores$lambda$1$0$0$2(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final VirtualFile findOrCreateIgnoreFileByFile$lambda$0(VirtualFile $ignoreFileRoot, IgnoreFilesProcessorImpl this$0, IgnoredFileContentProvider $ignoredContentProvider) {
        return $ignoreFileRoot.createChildData((Object)this$0, $ignoredContentProvider.getFileName());
    }

    private static final VirtualFile isUnder$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/IgnoreFilesProcessorImpl$IgnoreGroupContent;", "", "group", "", "ignoredDescriptors", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;", "<init>", "(Ljava/lang/String;Ljava/util/Set;)V", "getGroup", "()Ljava/lang/String;", "getIgnoredDescriptors", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.vcs.impl"})
    private static final class IgnoreGroupContent {
        @NotNull
        private final String group;
        @NotNull
        private final Set<IgnoredFileDescriptor> ignoredDescriptors;

        public IgnoreGroupContent(@NotNull String group, @NotNull Set<IgnoredFileDescriptor> ignoredDescriptors) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter(ignoredDescriptors, (String)"ignoredDescriptors");
            this.group = group;
            this.ignoredDescriptors = ignoredDescriptors;
        }

        public /* synthetic */ IgnoreGroupContent(String string, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                set2 = new LinkedHashSet();
            }
            this(string, set2);
        }

        @NotNull
        public final String getGroup() {
            return this.group;
        }

        @NotNull
        public final Set<IgnoredFileDescriptor> getIgnoredDescriptors() {
            return this.ignoredDescriptors;
        }

        @NotNull
        public final String component1() {
            return this.group;
        }

        @NotNull
        public final Set<IgnoredFileDescriptor> component2() {
            return this.ignoredDescriptors;
        }

        @NotNull
        public final IgnoreGroupContent copy(@NotNull String group, @NotNull Set<IgnoredFileDescriptor> ignoredDescriptors) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter(ignoredDescriptors, (String)"ignoredDescriptors");
            return new IgnoreGroupContent(group, ignoredDescriptors);
        }

        public static /* synthetic */ IgnoreGroupContent copy$default(IgnoreGroupContent ignoreGroupContent, String string, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                string = ignoreGroupContent.group;
            }
            if ((n & 2) != 0) {
                set2 = ignoreGroupContent.ignoredDescriptors;
            }
            return ignoreGroupContent.copy(string, set2);
        }

        @NotNull
        public String toString() {
            return "IgnoreGroupContent(group=" + this.group + ", ignoredDescriptors=" + this.ignoredDescriptors + ")";
        }

        public int hashCode() {
            int result2 = this.group.hashCode();
            result2 = result2 * 31 + ((Object)this.ignoredDescriptors).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IgnoreGroupContent)) {
                return false;
            }
            IgnoreGroupContent ignoreGroupContent = (IgnoreGroupContent)other;
            if (!Intrinsics.areEqual((Object)this.group, (Object)ignoreGroupContent.group)) {
                return false;
            }
            return Intrinsics.areEqual(this.ignoredDescriptors, ignoreGroupContent.ignoredDescriptors);
        }
    }
}

