/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SmRunnerBundle;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.sm.runner.ui.SMPoolOfTestIcons;
import com.intellij.execution.testframework.sm.runner.ui.TestTreeRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestsPresentationUtil {
    @NonNls
    private static final String DOUBLE_SPACE = "  ";
    @NonNls
    private static final String UNKNOWN_TESTS_COUNT = "<...>";
    @ApiStatus.Internal
    @NonNls
    public static final String DEFAULT_TESTS_CATEGORY = "Tests";

    private TestsPresentationUtil() {
    }

    @Nls
    public static String getProgressStatus_Text(long startTime, long endTime, int testsTotal, int testsCount, int failuresCount, @Nullable Set<String> allCategories, boolean isFinished) {
        @Nls StringBuilder sb = new StringBuilder();
        if (endTime == 0L) {
            sb.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.running", new Object[0]));
        } else {
            sb.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.done", new Object[0]));
        }
        if (allCategories != null && TestsPresentationUtil.hasNonDefaultCategories(allCategories)) {
            sb.append(' ');
            boolean first = true;
            for (String category : allCategories) {
                if (StringUtil.isEmpty((String)category)) continue;
                if (!first) {
                    sb.append(", ");
                }
                char firstChar = category.charAt(0);
                sb.append(first ? firstChar : Character.toLowerCase(firstChar));
                sb.append(category.substring(1));
                first = false;
            }
        }
        sb.append(' ').append(testsCount).append(' ');
        sb.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.of", new Object[0]));
        sb.append(' ').append(testsTotal != 0 ? Integer.valueOf(testsTotal) : (!isFinished ? UNKNOWN_TESTS_COUNT : Integer.valueOf(0)));
        if (failuresCount > 0) {
            sb.append(DOUBLE_SPACE);
            sb.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.failed", new Object[0]));
            sb.append(' ').append(failuresCount);
        }
        if (endTime != 0L) {
            long time = endTime - startTime;
            sb.append(DOUBLE_SPACE);
            sb.append('(').append(NlsMessages.formatDurationApproximateNarrow((long)time)).append(')');
        }
        sb.append(DOUBLE_SPACE);
        return sb.toString();
    }

    public static boolean hasNonDefaultCategories(@Nullable Set<String> allCategories) {
        if (allCategories == null) {
            return false;
        }
        return allCategories.size() > 1 || allCategories.size() == 1 && !DEFAULT_TESTS_CATEGORY.equals(allCategories.iterator().next());
    }

    public static void formatRootNodeWithChildren(SMTestProxy.SMRootTestProxy testProxy, TestTreeRenderer renderer) {
        IconInfo iconInfo = TestsPresentationUtil.getIcon(testProxy, renderer.getConsoleProperties());
        renderer.setIcon(iconInfo.getIcon());
        String accessibleStatusText = renderer.getAccessibleStatus();
        if (accessibleStatusText == null) {
            accessibleStatusText = iconInfo.getStatusText();
        }
        renderer.setAccessibleStatusText(accessibleStatusText);
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        String presentableName = testProxy.getPresentation();
        String text = presentableName != null ? presentableName : (magnitude == TestStateInfo.Magnitude.RUNNING_INDEX ? SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.running.tests", new Object[0]) : (magnitude == TestStateInfo.Magnitude.TERMINATED_INDEX ? SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.was.terminated", new Object[0]) : SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.test.results", new Object[0])));
        renderer.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        String comment = testProxy.getComment();
        if (comment != null) {
            renderer.append(" (" + comment + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public static void formatRootNodeWithoutChildren(SMTestProxy.SMRootTestProxy testProxy, TestTreeRenderer renderer) {
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        if (magnitude == TestStateInfo.Magnitude.RUNNING_INDEX) {
            if (!testProxy.getChildren().isEmpty()) {
                TestsPresentationUtil.formatRootNodeWithChildren(testProxy, renderer);
            } else {
                IconInfo iconInfo = TestsPresentationUtil.getIcon(testProxy, renderer.getConsoleProperties());
                renderer.setIcon(iconInfo.getIcon());
                renderer.setAccessibleStatusText(iconInfo.getStatusText());
                renderer.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.instantiating.tests", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        } else if (magnitude == TestStateInfo.Magnitude.NOT_RUN_INDEX) {
            renderer.setIcon(PoolOfTestIcons.NOT_RAN);
            renderer.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.not.test.results", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        } else if (magnitude == TestStateInfo.Magnitude.TERMINATED_INDEX) {
            renderer.setIcon(PoolOfTestIcons.TERMINATED_ICON);
            renderer.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.was.terminated", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (magnitude == TestStateInfo.Magnitude.PASSED_INDEX) {
            renderer.setIcon(PoolOfTestIcons.PASSED_ICON);
            renderer.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.all.tests.passed", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (magnitude == TestStateInfo.Magnitude.IGNORED_INDEX && !testProxy.hasErrors()) {
            renderer.setIcon(PoolOfTestIcons.IGNORED_ICON);
            renderer.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.all.but.ignored.passed", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (!testProxy.getChildren().isEmpty()) {
            TestsPresentationUtil.formatRootNodeWithChildren(testProxy, renderer);
        } else {
            renderer.setIcon(PoolOfTestIcons.NOT_RAN);
            renderer.append(testProxy.isTestsReporterAttached() ? SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.no.tests.were.found", new Object[0]) : SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.test.reporter.not.attached", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    public static void formatTestProxy(SMTestProxy testProxy, TestTreeRenderer renderer) {
        IconInfo iconInfo = TestsPresentationUtil.getIcon(testProxy, renderer.getConsoleProperties());
        renderer.setIcon(iconInfo.getIcon());
        renderer.setAccessibleStatusText(iconInfo.getStatusText());
        renderer.append(testProxy.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @NotNull
    public static String getPresentableName(@NotNull SMTestProxy testProxy) {
        if (testProxy == null) {
            TestsPresentationUtil.$$$reportNull$$$0(0);
        }
        return TestsPresentationUtil.getPresentableName(testProxy, testProxy.getName());
    }

    @NotNull
    public static String getPresentableName(@NotNull SMTestProxy testProxy, @Nullable String name) {
        String parentName;
        if (testProxy == null) {
            TestsPresentationUtil.$$$reportNull$$$0(1);
        }
        if (name == null) {
            String string = Holder.getNoNameTest();
            if (string == null) {
                TestsPresentationUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        SMTestProxy parent = testProxy.getParent();
        String presentationCandidate = name;
        if (parent != null && !testProxy.isSuite() && (parentName = parent.getName()) != null) {
            String comment;
            String presentation;
            boolean parentStartsWith = name.startsWith(parentName);
            if (!parentStartsWith && parent instanceof SMTestProxy.SMRootTestProxy && (presentation = ((SMTestProxy.SMRootTestProxy)parent).getPresentation()) != null && !(parentStartsWith = name.startsWith(parentName = presentation)) && (comment = ((SMTestProxy.SMRootTestProxy)parent).getComment()) != null) {
                parentName = StringUtil.getQualifiedName((String)comment, (String)presentation);
                parentStartsWith = name.startsWith(parentName);
            }
            if (parentStartsWith) {
                presentationCandidate = name.substring(parentName.length());
                presentationCandidate = StringUtil.trimStart((String)presentationCandidate, (String)".");
            }
        }
        presentationCandidate = presentationCandidate.trim();
        if (StringUtil.isEmpty((String)(presentationCandidate = presentationCandidate.replaceAll("\\s+", " ")))) {
            String string = Holder.getNoNameTest();
            if (string == null) {
                TestsPresentationUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = presentationCandidate;
        if (string == null) {
            TestsPresentationUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String getPresentableNameTrimmedOnly(@Nullable String name) {
        String string = name == null || name.isBlank() ? Holder.getNoNameTest() : name.trim();
        if (string == null) {
            TestsPresentationUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static IconInfo getIcon(SMTestProxy testProxy, TestConsoleProperties consoleProperties) {
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        boolean hasErrors = testProxy.hasErrors();
        boolean hasPassedTests = testProxy.hasPassedTests();
        IconInfo iconInfo = switch (magnitude) {
            default -> throw new MatchException(null, null);
            case TestStateInfo.Magnitude.ERROR_INDEX -> IconInfo.wrap(SMPoolOfTestIcons.ERROR_ICON, SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.accessible.status.error", new Object[0]));
            case TestStateInfo.Magnitude.FAILED_INDEX -> {
                if (hasErrors) {
                    yield IconInfo.wrap(SMPoolOfTestIcons.FAILED_E_ICON, SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.accessible.status.failed.with.errors", new Object[0]));
                }
                yield IconInfo.wrap(SMPoolOfTestIcons.FAILED_ICON, SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.accessible.status.failed", new Object[0]));
            }
            case TestStateInfo.Magnitude.IGNORED_INDEX -> {
                if (hasErrors) {
                    yield IconInfo.wrap(SMPoolOfTestIcons.IGNORED_E_ICON, SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.accessible.status.ignored.with.errors", new Object[0]));
                }
                if (hasPassedTests) {
                    yield IconInfo.wrap(SMPoolOfTestIcons.PASSED_IGNORED, SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.accessible.status.passed.with.ignored", new Object[0]));
                }
                yield IconInfo.wrap(SMPoolOfTestIcons.IGNORED_ICON, SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.accessible.status.ignored", new Object[0]));
            }
            case TestStateInfo.Magnitude.NOT_RUN_INDEX -> IconInfo.wrap(SMPoolOfTestIcons.NOT_RAN, SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.accessible.status.not.ran", new Object[0]));
            case TestStateInfo.Magnitude.COMPLETE_INDEX, TestStateInfo.Magnitude.PASSED_INDEX -> {
                if (hasErrors) {
                    yield IconInfo.wrap(SMPoolOfTestIcons.PASSED_E_ICON, SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.accessible.status.passed.with.errors", new Object[0]));
                }
                yield IconInfo.wrap(SMPoolOfTestIcons.PASSED_ICON, SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.accessible.status.passed", new Object[0]));
            }
            case TestStateInfo.Magnitude.RUNNING_INDEX -> {
                if (consoleProperties.isPaused()) {
                    if (hasErrors) {
                        yield IconInfo.wrap(SMPoolOfTestIcons.PAUSED_E_ICON, SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.accessible.status.paused.with.errors", new Object[0]));
                    }
                    yield IconInfo.wrap(AllIcons.RunConfigurations.TestPaused, SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.accessible.status.paused", new Object[0]));
                }
                if (hasErrors) {
                    yield IconInfo.wrap(SMPoolOfTestIcons.RUNNING_E_ICON, SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.accessible.status.running.with.errors", new Object[0]));
                }
                yield IconInfo.wrap(SMPoolOfTestIcons.RUNNING_ICON, SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.accessible.status.running", new Object[0]));
            }
            case TestStateInfo.Magnitude.SKIPPED_INDEX -> {
                if (hasErrors) {
                    yield IconInfo.wrap(SMPoolOfTestIcons.SKIPPED_E_ICON, SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.accessible.status.skipped.with.errors", new Object[0]));
                }
                yield IconInfo.wrap(SMPoolOfTestIcons.SKIPPED_ICON, SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.accessible.status.skipped", new Object[0]));
            }
            case TestStateInfo.Magnitude.TERMINATED_INDEX -> hasErrors ? IconInfo.wrap(SMPoolOfTestIcons.TERMINATED_E_ICON, SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.accessible.status.terminated.with.errors", new Object[0])) : IconInfo.wrap(SMPoolOfTestIcons.TERMINATED_ICON, SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.accessible.status.terminated", new Object[0]));
        };
        if (iconInfo == null) {
            TestsPresentationUtil.$$$reportNull$$$0(6);
        }
        return iconInfo;
    }

    @Nullable
    public static String getTestStatusPresentation(SMTestProxy proxy) {
        return proxy.getMagnitudeInfo().getTitle();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/runner/ui/TestsPresentationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/runner/ui/TestsPresentationUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableNameTrimmedOnly";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    private static class IconInfo {
        private final Icon myIcon;
        @Nls
        private final String myStatusText;

        private IconInfo(Icon icon, @Nls String statusText) {
            this.myIcon = icon;
            this.myStatusText = statusText;
        }

        private Icon getIcon() {
            return this.myIcon;
        }

        @Nls
        private String getStatusText() {
            return this.myStatusText;
        }

        static IconInfo wrap(Icon icon, @Nls String statusText) {
            return new IconInfo(icon, statusText);
        }
    }

    private static class Holder {
        private Holder() {
        }

        private static String getNoNameTest() {
            return SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.test.noname", new Object[0]);
        }
    }
}

