/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.huggingFace.service;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.python.community.impl.huggingFace.cache.HuggingFaceCacheUpdateHandler;
import com.intellij.python.community.impl.huggingFace.service.HuggingFaceLibrariesTracker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/python/community/impl/huggingFace/service/HuggingFacePluginManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "libraryStatusChecker", "Lcom/intellij/python/community/impl/huggingFace/service/HuggingFaceLibrariesTracker;", "isActive", "", "dispose", "", "intellij.python.community.impl.huggingFace"})
@ApiStatus.Internal
public final class HuggingFacePluginManager
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private HuggingFaceLibrariesTracker libraryStatusChecker;

    public HuggingFacePluginManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Object object = this.project.getService(HuggingFaceLibrariesTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        this.libraryStatusChecker = (HuggingFaceLibrariesTracker)object;
        this.project.getService(HuggingFaceCacheUpdateHandler.class);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean isActive() {
        return this.libraryStatusChecker.isAnyHFLibraryInstalled() && Registry.Companion.is("python.enable.hugging.face.cards");
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.libraryStatusChecker);
    }
}

