/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EmptyQuery;
import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import java.util.Collections;

public final class FileSearchUtil {
    public static Query<VirtualFile> findFileRecursively(VirtualFile parentDirectory, String fileName, int levels, long timeout) {
        if (parentDirectory == null) {
            return new EmptyQuery<VirtualFile>();
        }
        QueryExecutor executor = (queryParameters, consumer) -> {
            long endTime = timeout < 0L ? -1L : System.currentTimeMillis() + timeout;
            return FileSearchUtil.processFileRecursively(parentDirectory, 1, levels, (Processor<? super VirtualFile>)((Processor)file -> {
                if (endTime > 0L && System.currentTimeMillis() > endTime) {
                    return false;
                }
                return !file.getName().equals(fileName) || consumer.process((Object)file);
            }));
        };
        return new ExecutorsQuery(fileName, Collections.singletonList(executor));
    }

    private static boolean processFileRecursively(VirtualFile parentDirectory, int curLevel, int maxLevel, Processor<? super VirtualFile> processor) {
        VirtualFile[] files = parentDirectory.getChildren();
        if (files != null) {
            for (VirtualFile file : files) {
                if (!(file.isDirectory() ? curLevel < maxLevel && !FileSearchUtil.processFileRecursively(file, curLevel + 1, maxLevel, processor) : !processor.process((Object)file))) continue;
                return false;
            }
        }
        return true;
    }
}

