/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.DescriptorBasedMessageBusConnection;
import com.intellij.util.messages.impl.MessageBusImpl;
import com.intellij.util.messages.impl.PluginListenerDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\u001aD\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0000\u001aF\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0000\u001a.\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0019H\u0002\u00a8\u0006\u001a"}, d2={"subscribeLazyListeners", "", "topic", "Lcom/intellij/util/messages/Topic;", "topicClassToListenerDescriptor", "", "", "", "Lcom/intellij/util/messages/impl/PluginListenerDescriptor;", "subscribers", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/intellij/util/messages/impl/MessageBusImpl$MessageHandlerHolder;", "owner", "Lcom/intellij/util/messages/MessageBusOwner;", "unsubscribeLazyListeners", "", "module", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "listenerDescriptors", "", "Lcom/intellij/util/messages/ListenerDescriptor;", "computeNewHandlers", "", "handlers", "excludeClassNames", "", "intellij.platform.core"})
public final class LazyListenerKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void subscribeLazyListeners(@NotNull Topic<?> topic, @NotNull Map<String, List<PluginListenerDescriptor>> topicClassToListenerDescriptor, @NotNull ConcurrentLinkedQueue<MessageBusImpl.MessageHandlerHolder> subscribers, @NotNull MessageBusOwner owner) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter(topicClassToListenerDescriptor, (String)"topicClassToListenerDescriptor");
        Intrinsics.checkNotNullParameter(subscribers, (String)"subscribers");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        AutoCloseable autoCloseable = (AutoCloseable)Cancellation.withNonCancelableSection();
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            List<PluginListenerDescriptor> list = topicClassToListenerDescriptor.remove(topic.getListenerClass().getName());
            if (list != null) {
                List<PluginListenerDescriptor> listenerDescriptors = list;
                LinkedHashMap<Object, List> listenerMap = new LinkedHashMap<Object, List>();
                for (PluginListenerDescriptor listenerDescriptor : listenerDescriptors) {
                    try {
                        Object object = owner.createListener(listenerDescriptor);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createListener(...)");
                        listenerMap.computeIfAbsent(listenerDescriptor.getPluginDescriptor(), arg_0 -> LazyListenerKt.subscribeLazyListeners$lambda$0$1(LazyListenerKt::subscribeLazyListeners$lambda$0$0, arg_0)).add(object);
                    }
                    catch (ExtensionNotApplicableException extensionNotApplicableException) {
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        MessageBusImpl.LOG.error("Cannot create listener", e);
                    }
                }
                listenerMap.forEach((arg_0, arg_1) -> LazyListenerKt.subscribeLazyListeners$lambda$0$2(subscribers, topic, arg_0, arg_1));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static final boolean unsubscribeLazyListeners(@NotNull IdeaPluginDescriptor module, @NotNull List<ListenerDescriptor> listenerDescriptors, @NotNull Map<String, List<PluginListenerDescriptor>> topicClassToListenerDescriptor, @NotNull ConcurrentLinkedQueue<MessageBusImpl.MessageHandlerHolder> subscribers) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(listenerDescriptors, (String)"listenerDescriptors");
        Intrinsics.checkNotNullParameter(topicClassToListenerDescriptor, (String)"topicClassToListenerDescriptor");
        Intrinsics.checkNotNullParameter(subscribers, (String)"subscribers");
        topicClassToListenerDescriptor.values().removeIf(arg_0 -> LazyListenerKt.unsubscribeLazyListeners$lambda$0(module, arg_0));
        if (listenerDescriptors.isEmpty() || subscribers.isEmpty()) {
            return false;
        }
        HashMap<Object, Set> topicToDescriptors = new HashMap<Object, Set>();
        for (ListenerDescriptor descriptor : listenerDescriptors) {
            topicToDescriptors.computeIfAbsent(descriptor.topicClassName, arg_0 -> LazyListenerKt.unsubscribeLazyListeners$lambda$2(LazyListenerKt::unsubscribeLazyListeners$lambda$1, arg_0)).add(descriptor.listenerClassName);
        }
        boolean isChanged = false;
        List newSubscribers = null;
        Iterator<MessageBusImpl.MessageHandlerHolder> iterator = subscribers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<MessageBusImpl.MessageHandlerHolder> connectionIterator = iterator;
        while (connectionIterator.hasNext()) {
            List<Object> newHandlers;
            Set listenerClassNames;
            DescriptorBasedMessageBusConnection connection;
            MessageBusImpl.MessageHandlerHolder messageHandlerHolder = connectionIterator.next();
            if ((messageHandlerHolder instanceof DescriptorBasedMessageBusConnection ? (DescriptorBasedMessageBusConnection)messageHandlerHolder : null) == null) continue;
            connection = connection;
            if (module != connection.module || (Set)topicToDescriptors.get(connection.topic.getListenerClass().getName()) == null || LazyListenerKt.computeNewHandlers(connection.handlers, listenerClassNames) == null) continue;
            isChanged = true;
            connectionIterator.remove();
            if (!(!((Collection)newHandlers).isEmpty())) continue;
            if (newSubscribers == null) {
                newSubscribers = new ArrayList();
            }
            newSubscribers.add(new DescriptorBasedMessageBusConnection(module, connection.topic, newHandlers));
        }
        if (newSubscribers != null) {
            subscribers.addAll(newSubscribers);
        }
        return isChanged;
    }

    private static final List<Object> computeNewHandlers(List<? extends Object> handlers2, Set<String> excludeClassNames) {
        List newHandlers = null;
        int size = handlers2.size();
        for (int i = 0; i < size; ++i) {
            Object handler = handlers2.get(i);
            if (excludeClassNames.contains(handler.getClass().getName())) {
                if (newHandlers != null) continue;
                newHandlers = i == 0 ? (List)new ArrayList() : CollectionsKt.toMutableList((Collection)handlers2.subList(0, i));
                continue;
            }
            List list = newHandlers;
            if (list == null) continue;
            list.add(handler);
        }
        return newHandlers;
    }

    private static final List subscribeLazyListeners$lambda$0$0(PluginDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List subscribeLazyListeners$lambda$0$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final void subscribeLazyListeners$lambda$0$2(ConcurrentLinkedQueue $subscribers, Topic $topic, PluginDescriptor key, List listeners) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)listeners, (String)"listeners");
        $subscribers.add(new DescriptorBasedMessageBusConnection(key, $topic, listeners));
    }

    private static final boolean unsubscribeLazyListeners$lambda$0$0(IdeaPluginDescriptor $module, PluginListenerDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPluginDescriptor() == $module;
    }

    private static final boolean unsubscribeLazyListeners$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean unsubscribeLazyListeners$lambda$0(IdeaPluginDescriptor $module, List descriptors) {
        Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
        if (descriptors.removeIf(arg_0 -> LazyListenerKt.unsubscribeLazyListeners$lambda$0$1(arg_0 -> LazyListenerKt.unsubscribeLazyListeners$lambda$0$0($module, arg_0), arg_0))) {
            return descriptors.isEmpty();
        }
        return false;
    }

    private static final Set unsubscribeLazyListeners$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashSet();
    }

    private static final Set unsubscribeLazyListeners$lambda$2(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }
}

