/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.exporters.meters;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.platform.diagnostic.telemetry.exporters.RollingFileSupplier;
import com.intellij.platform.diagnostic.telemetry.exporters.meters.TelemetryMeterJsonExporterKt;
import com.intellij.platform.diagnostic.telemetry.exporters.meters.models.MetricDataMixIn;
import com.intellij.platform.diagnostic.telemetry.exporters.meters.models.PointDataMixIn;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/exporters/meters/TelemetryMeterJsonExporter;", "Lio/opentelemetry/sdk/metrics/export/MetricExporter;", "writeToFileSupplier", "Lcom/intellij/platform/diagnostic/telemetry/exporters/RollingFileSupplier;", "<init>", "(Lcom/intellij/platform/diagnostic/telemetry/exporters/RollingFileSupplier;)V", "getAggregationTemporality", "Lio/opentelemetry/sdk/metrics/data/AggregationTemporality;", "instrumentType", "Lio/opentelemetry/sdk/metrics/InstrumentType;", "export", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "metrics", "", "Lio/opentelemetry/sdk/metrics/data/MetricData;", "flush", "shutdown", "intellij.platform.diagnostic.telemetry.exporters"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTelemetryMeterJsonExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelemetryMeterJsonExporter.kt\ncom/intellij/platform/diagnostic/telemetry/exporters/meters/TelemetryMeterJsonExporter\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,66:1\n182#2:67\n182#2:68\n*S KotlinDebug\n*F\n+ 1 TelemetryMeterJsonExporter.kt\ncom/intellij/platform/diagnostic/telemetry/exporters/meters/TelemetryMeterJsonExporter\n*L\n49#1:67\n50#1:68\n*E\n"})
public final class TelemetryMeterJsonExporter
implements MetricExporter {
    @NotNull
    private final RollingFileSupplier writeToFileSupplier;

    public TelemetryMeterJsonExporter(@NotNull RollingFileSupplier writeToFileSupplier) {
        Intrinsics.checkNotNullParameter((Object)writeToFileSupplier, (String)"writeToFileSupplier");
        this.writeToFileSupplier = writeToFileSupplier;
        RollingFileSupplier.init$intellij_platform_diagnostic_telemetry_exporters$default(this.writeToFileSupplier, null, 1, null);
    }

    @NotNull
    public AggregationTemporality getAggregationTemporality(@NotNull InstrumentType instrumentType) {
        Intrinsics.checkNotNullParameter((Object)instrumentType, (String)"instrumentType");
        return AggregationTemporality.DELTA;
    }

    @NotNull
    public CompletableResultCode export(@NotNull Collection<? extends MetricData> metrics) {
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        if (metrics.isEmpty()) {
            CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
            Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
            return completableResultCode;
        }
        CompletableResultCode result = new CompletableResultCode();
        Path writeToFile = this.writeToFileSupplier.get(true);
        try {
            ObjectMapper $this$addMixIn$iv;
            Object object = ExtensionsKt.jacksonObjectMapper();
            boolean $i$f$addMixIn = false;
            ObjectMapper objectMapper = $this$addMixIn$iv.addMixIn(MetricData.class, MetricDataMixIn.class);
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"addMixIn(...)");
            $this$addMixIn$iv = objectMapper;
            $i$f$addMixIn = false;
            ObjectMapper objectMapper2 = $this$addMixIn$iv.addMixIn(PointData.class, PointDataMixIn.class);
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"addMixIn(...)");
            object = writeToFile;
            OpenOption[] $i$f$addMixIn2 = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
            OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf($i$f$addMixIn2, $i$f$addMixIn2.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            objectMapper2.writeValue(outputStream, metrics);
            result.succeed();
        }
        catch (IOException e) {
            TelemetryMeterJsonExporterKt.access$getLOG().warn("Can't write metrics into " + writeToFile.toAbsolutePath(), (Throwable)e);
            result.fail();
        }
        return result;
    }

    @NotNull
    public CompletableResultCode flush() {
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
        return completableResultCode;
    }

    @NotNull
    public CompletableResultCode shutdown() {
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
        return completableResultCode;
    }
}

