/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.workspace.storage.EntityPointer;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.workspaceModel.core.fileIndex.EntityStorageKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.MultipleStoredWorkspaceFileSets;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSetCollection;
import com.intellij.workspaceModel.core.fileIndex.impl.TwoWorkspaceFileSets;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImplKt;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileInternalInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B?\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0016J(\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0006H\u0016J\u0018\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020'2\b\u0010,\u001a\u0004\u0018\u00010\u0006J&\u0010/\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00012\u0016\u00100\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0001\u0012\u0004\u0012\u00020\u001001H\u0016J*\u00102\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010 2\u0016\u00100\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0001\u0012\u0004\u0012\u00020\u001001H\u0016J\n\u00103\u001a\u000204H\u0096\u0080\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u000e\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00065"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetImpl;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetWithCustomData;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetData;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSet;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileInternalInfo;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "kind", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileKind;", "entityPointer", "Lcom/intellij/platform/workspace/storage/EntityPointer;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "entityStorageKind", "Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "data", "recursive", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileKind;Lcom/intellij/platform/workspace/storage/EntityPointer;Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetData;Z)V", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getKind", "()Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileKind;", "getEntityPointer", "()Lcom/intellij/platform/workspace/storage/EntityPointer;", "getEntityStorageKind", "()Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "getData", "()Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetData;", "getRecursive", "()Z", "fileSets", "", "getFileSets", "()Ljava/util/List;", "add", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSetCollection;", "fileSet", "computeMasks", "", "currentMasks", "project", "Lcom/intellij/openapi/project/Project;", "honorExclusion", "file", "accepts", "acceptedKindMask", "findFileSet", "condition", "Lkotlin/Function1;", "findFileSets", "toString", "", "intellij.platform.projectModel.impl"})
public final class WorkspaceFileSetImpl
implements WorkspaceFileSetWithCustomData<WorkspaceFileSetData>,
StoredFileSet,
WorkspaceFileInternalInfo {
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final WorkspaceFileKind kind;
    @NotNull
    private final EntityPointer<WorkspaceEntity> entityPointer;
    @NotNull
    private final EntityStorageKind entityStorageKind;
    @NotNull
    private final WorkspaceFileSetData data;
    private final boolean recursive;

    public WorkspaceFileSetImpl(@NotNull VirtualFile root, @NotNull WorkspaceFileKind kind, @NotNull EntityPointer<? extends WorkspaceEntity> entityPointer, @NotNull EntityStorageKind entityStorageKind, @NotNull WorkspaceFileSetData data, boolean recursive) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter(entityPointer, (String)"entityPointer");
        Intrinsics.checkNotNullParameter((Object)((Object)entityStorageKind), (String)"entityStorageKind");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.root = root;
        this.kind = kind;
        this.entityPointer = entityPointer;
        this.entityStorageKind = entityStorageKind;
        this.data = data;
        this.recursive = recursive;
    }

    public /* synthetic */ WorkspaceFileSetImpl(VirtualFile virtualFile, WorkspaceFileKind workspaceFileKind, EntityPointer entityPointer, EntityStorageKind entityStorageKind, WorkspaceFileSetData workspaceFileSetData, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        this(virtualFile, workspaceFileKind, (EntityPointer<? extends WorkspaceEntity>)entityPointer, entityStorageKind, workspaceFileSetData, bl);
    }

    @Override
    @NotNull
    public VirtualFile getRoot() {
        return this.root;
    }

    @Override
    @NotNull
    public WorkspaceFileKind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public EntityPointer<WorkspaceEntity> getEntityPointer() {
        return this.entityPointer;
    }

    @Override
    @NotNull
    public EntityStorageKind getEntityStorageKind() {
        return this.entityStorageKind;
    }

    @Override
    @NotNull
    public WorkspaceFileSetData getData() {
        return this.data;
    }

    @Override
    public boolean getRecursive() {
        return this.recursive;
    }

    @Override
    @NotNull
    public List<WorkspaceFileSetWithCustomData<?>> getFileSets() {
        return CollectionsKt.listOf((Object)this);
    }

    @Override
    @NotNull
    public StoredFileSetCollection add(@NotNull StoredFileSet fileSet) {
        StoredFileSetCollection storedFileSetCollection;
        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
        if (fileSet instanceof WorkspaceFileSetImpl) {
            storedFileSetCollection = new TwoWorkspaceFileSets(this, (WorkspaceFileSetImpl)fileSet);
        } else {
            Object[] objectArray = new StoredFileSet[]{fileSet, this};
            storedFileSetCollection = new MultipleStoredWorkspaceFileSets(CollectionsKt.mutableListOf((Object[])objectArray));
        }
        return storedFileSetCollection;
    }

    @Override
    public int computeMasks(int currentMasks, @NotNull Project project, boolean honorExclusion, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        int acceptedKindMask = currentMasks >> 2 & 0x1F;
        int update = this.accepts(acceptedKindMask, file) ? 1 : 2;
        return currentMasks | update;
    }

    public final boolean accepts(int acceptedKindMask, @Nullable VirtualFile file) {
        return (acceptedKindMask & WorkspaceFileIndexDataImplKt.toMask(this.getKind())) != 0 && (this.getRecursive() || Intrinsics.areEqual((Object)this.getRoot(), (Object)file));
    }

    @Override
    @Nullable
    public WorkspaceFileSetWithCustomData<?> findFileSet(@NotNull Function1<? super WorkspaceFileSetWithCustomData<?>, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        WorkspaceFileSetImpl workspaceFileSetImpl = this;
        return (Boolean)condition.invoke((Object)workspaceFileSetImpl) != false ? workspaceFileSetImpl : null;
    }

    @Override
    @NotNull
    public List<WorkspaceFileSetWithCustomData<?>> findFileSets(@NotNull Function1<? super WorkspaceFileSetWithCustomData<?>, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        return CollectionsKt.listOfNotNull(this.findFileSet(condition));
    }

    @Override
    @NotNull
    public String toString() {
        return "WorkspaceFileSet{root=" + this.getRoot() + ", kind=" + this.getKind() + "}";
    }
}

