/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigElementTypes;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigHeader;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.ec4j.core.model.Ec4jPath;
import org.ec4j.core.model.Glob;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.editor.EditorConfigPreviewManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0003\u000f\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0019\u0010\u0005\u001a\u00130\u0006\u00a2\u0006\u000e\b\u0007\u0012\n\b\b\u0012\u0006\b\n0\t8\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/editorconfig/configmanagement/editor/EditorConfigPreviewMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getName", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Sentence", "getLineMarkerInfo", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "element", "Lcom/intellij/psi/PsiElement;", "SectionLineMarkerInfo", "ChooseFileAction", "Handler", "intellij.editorconfig.backend"})
public final class EditorConfigPreviewMarkerProvider
extends LineMarkerProviderDescriptor
implements DumbAware {
    @NotNull
    public String getName() {
        return EditorConfigBundle.message((String)"line.marker.name.code.preview");
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof EditorConfigHeader && Handler.INSTANCE.isEditorConfigEnabled(element)) {
            ActionGroup actionGroup = Handler.INSTANCE.createActions((EditorConfigHeader)element);
            PsiElement child = element.getFirstChild();
            if (child != null && child.getNode().getElementType() == EditorConfigElementTypes.L_BRACKET) {
                TextRange textRange = element.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                return new SectionLineMarkerInfo(actionGroup, child, textRange, null);
            }
        }
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/editorconfig/configmanagement/editor/EditorConfigPreviewMarkerProvider$ChooseFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "myHeader", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigHeader;", "<init>", "(Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigHeader;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.editorconfig.backend"})
    public static final class ChooseFileAction
    extends DumbAwareAction {
        @NotNull
        private final EditorConfigHeader myHeader;

        public ChooseFileAction(@NotNull EditorConfigHeader myHeader) {
            Intrinsics.checkNotNullParameter((Object)myHeader, (String)"myHeader");
            super(EditorConfigBundle.message((String)"editor.preview.open"));
            this.myHeader = myHeader;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.myHeader.isValid()) {
                Project project = this.myHeader.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                VirtualFile virtualFile = Handler.INSTANCE.getRootDir(this.myHeader);
                String string = this.myHeader.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                VirtualFile previewFile = Handler.INSTANCE.choosePreviewFile(project, virtualFile, Handler.INSTANCE.getPattern(string));
                if (previewFile != null) {
                    VirtualFile editorConfigFile = this.myHeader.getContainingFile().getVirtualFile();
                    Project project2 = this.myHeader.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                    Intrinsics.checkNotNull((Object)editorConfigFile);
                    Handler.INSTANCE.openPreview(project2, editorConfigFile, previewFile);
                }
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\rJ \u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\rJ \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f\u00a8\u0006\u001b"}, d2={"Lorg/editorconfig/configmanagement/editor/EditorConfigPreviewMarkerProvider$Handler;", "", "<init>", "()V", "isEditorConfigEnabled", "", "element", "Lcom/intellij/psi/PsiElement;", "createActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "header", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigHeader;", "getPattern", "", "choosePreviewFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "rootDir", "pattern", "matchesPattern", "filePath", "getRootDir", "openPreview", "", "editorConfigFile", "previewFile", "intellij.editorconfig.backend"})
    @SourceDebugExtension(value={"SMAP\nEditorConfigPreviewMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigPreviewMarkerProvider.kt\norg/editorconfig/configmanagement/editor/EditorConfigPreviewMarkerProvider$Handler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
    private static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();

        private Handler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isEditorConfigEnabled(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (!element.isValid()) return false;
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (!Utils.isEnabled(project)) return false;
            return true;
        }

        @NotNull
        public final ActionGroup createActions(@NotNull EditorConfigHeader header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            return (ActionGroup)new DefaultActionGroup(CollectionsKt.listOf((Object)((Object)new ChooseFileAction(header))));
        }

        @NotNull
        public final String getPattern(@NotNull String header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            char[] cArray = new char[]{'['};
            String string = StringsKt.trimStart((String)header, (char[])cArray);
            cArray = new char[]{']'};
            return StringsKt.trimEnd((String)string, (char[])cArray);
        }

        @Nullable
        public final VirtualFile choosePreviewFile(@NotNull Project project, @NotNull VirtualFile rootDir, @NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor[]{rootDir};
            FileChooserDescriptor $this$choosePreviewFile_u24lambda_u242 = fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withFileFilter(arg_0 -> Handler.choosePreviewFile$lambda$1(arg_0 -> Handler.choosePreviewFile$lambda$0(rootDir, pattern, arg_0), arg_0)).withRoots((VirtualFile[])fileChooserDescriptor);
            boolean bl = false;
            $this$choosePreviewFile_u24lambda_u242.setForcedToUseIdeaFileChooser(true);
            FileChooserDescriptor descriptor = fileChooserDescriptor;
            FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser(descriptor, project, null);
            Intrinsics.checkNotNullExpressionValue((Object)fileChooserDialog, (String)"createFileChooser(...)");
            FileChooserDialog fileChooser = fileChooserDialog;
            VirtualFile[] virtualFileArray = VirtualFile.EMPTY_ARRAY;
            VirtualFile[] virtualFileArray2 = fileChooser.choose(project, Arrays.copyOf(virtualFileArray, virtualFileArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"choose(...)");
            VirtualFile[] virtualFiles = virtualFileArray2;
            return !(virtualFiles.length == 0) ? virtualFiles[0] : null;
        }

        private final boolean matchesPattern(VirtualFile rootDir, String pattern, String filePath) {
            Glob glob = new Glob(pattern);
            return glob.match(Ec4jPath.Ec4jPaths.of(rootDir.getPath()).relativize(Ec4jPath.Ec4jPaths.of(filePath)));
        }

        @NotNull
        public final VirtualFile getRootDir(@NotNull EditorConfigHeader header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            PsiFile psiFile = header.getContainingFile();
            VirtualFile virtualFile = psiFile.getVirtualFile().getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
            return virtualFile;
        }

        public final void openPreview(@NotNull Project project, @NotNull VirtualFile editorConfigFile, @NotNull VirtualFile previewFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editorConfigFile, (String)"editorConfigFile");
            Intrinsics.checkNotNullParameter((Object)previewFile, (String)"previewFile");
            FileEditorManager.getInstance((Project)project).closeFile(editorConfigFile);
            EditorConfigPreviewManager.getInstance(project).associateWithPreviewFile(editorConfigFile, previewFile);
            FileEditorManager.getInstance((Project)project).openFile(editorConfigFile, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean choosePreviewFile$lambda$0(VirtualFile $rootDir, String $pattern, VirtualFile file) {
            if (Intrinsics.areEqual((Object)".editorconfig", (Object)file.getName())) return false;
            if (file.getLength() > 10000L) return false;
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (!INSTANCE.matchesPattern($rootDir, $pattern, string)) return false;
            return true;
        }

        private static final boolean choosePreviewFile$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/editorconfig/configmanagement/editor/EditorConfigPreviewMarkerProvider$SectionLineMarkerInfo;", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "myActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "element", "range", "Lcom/intellij/openapi/util/TextRange;", "tooltipProvider", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/openapi/actionSystem/ActionGroup;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Lkotlin/jvm/functions/Function1;)V", "createGutterRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "intellij.editorconfig.backend"})
    private static final class SectionLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        @NotNull
        private final ActionGroup myActionGroup;

        public SectionLineMarkerInfo(@NotNull ActionGroup myActionGroup, @NotNull PsiElement element, @NotNull TextRange range, @Nullable Function1<? super PsiElement, String> tooltipProvider) {
            Intrinsics.checkNotNullParameter((Object)myActionGroup, (String)"myActionGroup");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Function1<? super PsiElement, String> function1 = tooltipProvider;
            super(element, range, AllIcons.General.InspectionsEye, (Function)(function1 != null ? arg_0 -> SectionLineMarkerInfo._init_$lambda$0(function1, arg_0) : null), null, GutterIconRenderer.Alignment.LEFT);
            this.myActionGroup = myActionGroup;
        }

        @NotNull
        public GutterIconRenderer createGutterRenderer() {
            return (GutterIconRenderer)new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>(this){
                final /* synthetic */ SectionLineMarkerInfo this$0;
                {
                    this.this$0 = $receiver;
                    super((LineMarkerInfo)$receiver);
                }

                public AnAction getClickAction() {
                    return null;
                }

                public boolean isNavigateAction() {
                    return true;
                }

                public ActionGroup getPopupMenuActions() {
                    return SectionLineMarkerInfo.access$getMyActionGroup$p(this.this$0);
                }
            };
        }

        private static final String _init_$lambda$0(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ ActionGroup access$getMyActionGroup$p(SectionLineMarkerInfo $this) {
            return $this.myActionGroup;
        }
    }
}

