/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.core;

import com.intellij.editorconfig.common.syntax.psi.EditorConfigHeader;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigPattern;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicOperations;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.editorconfig.configmanagement.GlobVisibilityWorkaround;
import org.editorconfig.core.EditorConfigAutomatonBuilderVisitor;
import org.editorconfig.language.util.EditorConfigGlobUtilsKt;
import org.editorconfig.language.util.EditorConfigPresentationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012J\u0018\u0010\u0015\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0012J\u0010\u0010\u0018\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\t0\u0019R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/editorconfig/core/EditorConfigAutomatonBuilder;", "", "<init>", "()V", "KEY_EDITORCONFIG_ELEMENT_RUN_AUTOMATON", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Ldk/brics/automaton/RunAutomaton;", "KEY_EDITORCONFIG_ELEMENT_AUTOMATON", "Ldk/brics/automaton/Automaton;", "getCachedHeaderRunAutomaton", "header", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigHeader;", "getCachedHeaderAutomaton", "getCachedPatternAutomaton", "pattern", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigPattern;", "sanitizeGlob", "", "text", "path", "globToAutomaton", "Log", "Lcom/intellij/openapi/diagnostic/Logger;", "unionOptimized", "", "intellij.editorconfig.backend"})
@SourceDebugExtension(value={"SMAP\nEditorConfigAutomatonBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigAutomatonBuilder.kt\norg/editorconfig/core/EditorConfigAutomatonBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,208:1\n2829#2,5:209\n2835#2:215\n1#3:214\n13#4:216\n*S KotlinDebug\n*F\n+ 1 EditorConfigAutomatonBuilder.kt\norg/editorconfig/core/EditorConfigAutomatonBuilder\n*L\n104#1:209,5\n104#1:215\n96#1:216\n*E\n"})
public final class EditorConfigAutomatonBuilder {
    @NotNull
    public static final EditorConfigAutomatonBuilder INSTANCE = new EditorConfigAutomatonBuilder();
    @NotNull
    private static final Key<CachedValue<RunAutomaton>> KEY_EDITORCONFIG_ELEMENT_RUN_AUTOMATON = new Key("KEY_EDITORCONFIG_ELEMENT_RUN_AUTOMATON");
    @NotNull
    private static final Key<CachedValue<Automaton>> KEY_EDITORCONFIG_ELEMENT_AUTOMATON = new Key("KEY_EDITORCONFIG_ELEMENT_AUTOMATON");
    @NotNull
    private static final Logger Log;

    private EditorConfigAutomatonBuilder() {
    }

    @NotNull
    public final RunAutomaton getCachedHeaderRunAutomaton(@NotNull EditorConfigHeader header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)header), KEY_EDITORCONFIG_ELEMENT_RUN_AUTOMATON, () -> EditorConfigAutomatonBuilder.getCachedHeaderRunAutomaton$lambda$0(header));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (RunAutomaton)object;
    }

    @NotNull
    public final Automaton getCachedHeaderAutomaton(@NotNull EditorConfigHeader header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)header), KEY_EDITORCONFIG_ELEMENT_AUTOMATON, () -> EditorConfigAutomatonBuilder.getCachedHeaderAutomaton$lambda$0(header));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Automaton)object;
    }

    @NotNull
    public final Automaton getCachedPatternAutomaton(@NotNull EditorConfigPattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)pattern), KEY_EDITORCONFIG_ELEMENT_AUTOMATON, () -> EditorConfigAutomatonBuilder.getCachedPatternAutomaton$lambda$0(pattern));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Automaton)object;
    }

    @NotNull
    public final String sanitizeGlob(@NotNull String text, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object source = StringsKt.replace$default((String)text, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        source = StringsKt.replace$default((String)source, (String)"\\\\#", (String)"#", (boolean)false, (int)4, null);
        source = StringsKt.replace$default((String)source, (String)"\\\\;", (String)";", (boolean)false, (int)4, null);
        int separator = StringsKt.indexOf$default((CharSequence)((CharSequence)source), (String)"/", (int)0, (boolean)false, (int)6, null);
        if (separator >= 0) {
            Object object;
            String string = StringsKt.replace$default((String)path, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
            if (separator == 0) {
                String string2 = ((String)source).substring(1);
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                object = source;
            }
            source = string + "/" + (String)object;
        } else {
            source = "**/" + (String)source;
        }
        String string = GlobVisibilityWorkaround.globToRegEx((String)source);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"globToRegEx(...)");
        source = string;
        return StringsKt.replace$default((String)source, (String)"(?:", (String)"(", (boolean)false, (int)4, null);
    }

    @NotNull
    public final Automaton globToAutomaton(@Nullable EditorConfigPattern pattern, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (pattern == null) {
            Automaton automaton = new RegExp("").toAutomaton();
            Intrinsics.checkNotNullExpressionValue((Object)automaton, (String)"toAutomaton(...)");
            return automaton;
        }
        Object prefix = "**/";
        String string = pattern.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        int separator = StringsKt.indexOf$default((CharSequence)string, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (separator >= 0) {
            char[] cArray = new char[]{'/'};
            prefix = StringsKt.trimEnd((String)StringsKt.replace$default((String)path, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null), (char[])cArray) + (separator == 0 ? "" : "/");
        }
        return EditorConfigAutomatonBuilderVisitor.Companion.buildAutomatonFrom((String)prefix, pattern);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Automaton unionOptimized(@NotNull List<? extends Automaton> $this$unionOptimized) {
        Intrinsics.checkNotNullParameter($this$unionOptimized, (String)"<this>");
        Iterable $this$reduce$iv = $this$unionOptimized;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b;
            Automaton automaton;
            Automaton automaton2 = (Automaton)iterator$iv.next();
            Automaton a = (Automaton)accumulator$iv;
            boolean bl = false;
            ProgressIndicatorProvider.checkCanceled();
            Automaton it = automaton = BasicOperations.union((Automaton)a, (Automaton)b);
            boolean bl2 = false;
            it.minimize();
            Intrinsics.checkNotNullExpressionValue((Object)automaton, (String)"also(...)");
        }
        return (Automaton)accumulator$iv;
    }

    private static final CachedValueProvider.Result getCachedHeaderRunAutomaton$lambda$0(EditorConfigHeader $header) {
        RunAutomaton runAutomaton = new RunAutomaton(INSTANCE.getCachedHeaderAutomaton($header));
        Object[] objectArray = new Object[]{$header};
        return CachedValueProvider.Result.create((Object)runAutomaton, (Object[])objectArray);
    }

    private static final CachedValueProvider.Result getCachedHeaderAutomaton$lambda$0(EditorConfigHeader $header) {
        String text = $header.getText();
        Log.assertTrue(EditorConfigGlobUtilsKt.isValidGlob($header), (Object)("builder was given invalid header: " + text));
        Log.assertTrue(text.length() >= 3, (Object)("builder was given a header of insufficient length: " + text));
        String path = EditorConfigPresentationUtil.path((PsiElement)$header);
        Automaton automaton = INSTANCE.globToAutomaton($header.getPattern(), path);
        Object[] objectArray = new Object[]{$header};
        return CachedValueProvider.Result.create((Object)automaton, (Object[])objectArray);
    }

    private static final CachedValueProvider.Result getCachedPatternAutomaton$lambda$0(EditorConfigPattern $pattern) {
        String text = $pattern.getText();
        EditorConfigHeader header = $pattern.getHeader();
        Log.assertTrue(EditorConfigGlobUtilsKt.isValidGlob(header), (Object)("builder was given a pattern in invalid header: " + text + " in " + header.getText()));
        Log.assertTrue(header.getTextLength() >= 3, (Object)("builder was given a pattern in header of insufficient length: " + text + " in " + header.getText()));
        String path = EditorConfigPresentationUtil.path((PsiElement)$pattern);
        Automaton automaton = INSTANCE.globToAutomaton($pattern, path);
        Object[] objectArray = new Object[]{$pattern};
        return CachedValueProvider.Result.create((Object)automaton, (Object[])objectArray);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EditorConfigAutomatonBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Log = logger;
    }
}

