/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.Location;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestProxyRoot;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.sm.SMStacktraceParser;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.events.TestDurationStrategy;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.states.AbstractState;
import com.intellij.execution.testframework.sm.runner.states.CompoundTestFailedState;
import com.intellij.execution.testframework.sm.runner.states.NotRunState;
import com.intellij.execution.testframework.sm.runner.states.SuiteFinishedState;
import com.intellij.execution.testframework.sm.runner.states.SuiteInProgressState;
import com.intellij.execution.testframework.sm.runner.states.TerminatedState;
import com.intellij.execution.testframework.sm.runner.states.TestComparisonFailedState;
import com.intellij.execution.testframework.sm.runner.states.TestErrorState;
import com.intellij.execution.testframework.sm.runner.states.TestFailedState;
import com.intellij.execution.testframework.sm.runner.states.TestIgnoredState;
import com.intellij.execution.testframework.sm.runner.states.TestInProgressState;
import com.intellij.execution.testframework.sm.runner.states.TestPassedState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeViewProvider;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.ide.DataManager;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ExecutionDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.pom.Navigatable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class SMTestProxy
extends AbstractTestProxy
implements Navigatable {
    public static final Key<String> NODE_ID = Key.create((String)"test.proxy.id");
    private static final Logger LOG = Logger.getInstance((String)SMTestProxy.class.getName());
    private final String myName;
    private boolean myIsSuite;
    private final String myLocationUrl;
    private volatile String myMetainfo;
    private final boolean myPreservePresentableName;
    private List<SMTestProxy> myChildren;
    private SMTestProxy myParent;
    private volatile AbstractState myState = NotRunState.getInstance();
    private Long myDuration = null;
    @ApiStatus.Experimental
    @Nullable
    volatile Long myStartTime = null;
    @ApiStatus.Experimental
    @Nullable
    volatile Long myEndTime = null;
    private boolean myDurationIsCached = false;
    private boolean myHasCriticalErrors = false;
    private boolean myHasPassedTests = false;
    private boolean myHasPassedTestsCached = false;
    private String myStacktrace;
    private String myErrorMessage;
    private boolean myIsEmptyIsCached = false;
    private boolean myIsEmpty = true;
    private SMTestLocator myLocator = null;
    private Printer myPreferredPrinter = null;
    private String myPresentableName;
    private boolean myConfig = false;
    private boolean myTreeBuildBeforeStart = false;
    private CachedValue<Map<GlobalSearchScope, Ref<Location>>> myLocationMapCachedValue;
    @Nullable
    private TestDurationStrategy myDurationStrategyCached = null;

    public SMTestProxy(String testName, boolean isSuite, @Nullable String locationUrl) {
        this(testName, isSuite, locationUrl, false);
    }

    public SMTestProxy(String testName, boolean isSuite, @Nullable String locationUrl, boolean preservePresentableName) {
        this(testName, isSuite, locationUrl, null, preservePresentableName);
    }

    public SMTestProxy(String testName, boolean isSuite, @Nullable String locationUrl, @Nullable String metainfo, boolean preservePresentableName) {
        this.myName = testName;
        this.myIsSuite = isSuite;
        this.myLocationUrl = locationUrl;
        this.myMetainfo = metainfo;
        this.myPreservePresentableName = preservePresentableName;
    }

    public boolean isPreservePresentableName() {
        return this.myPreservePresentableName;
    }

    public void setLocator(@NotNull SMTestLocator testLocator) {
        if (testLocator == null) {
            SMTestProxy.$$$reportNull$$$0(0);
        }
        this.myLocator = testLocator;
        this.myLocationMapCachedValue = null;
    }

    public void setConfig(boolean config) {
        this.myConfig = config;
    }

    public void setPreferredPrinter(@NotNull Printer preferredPrinter) {
        if (preferredPrinter == null) {
            SMTestProxy.$$$reportNull$$$0(1);
        }
        this.myPreferredPrinter = preferredPrinter;
    }

    public boolean isInProgress() {
        return this.myState.isInProgress();
    }

    public boolean isDefect() {
        return this.myState.isDefect();
    }

    public boolean shouldRun() {
        return true;
    }

    public int getMagnitude() {
        return this.getMagnitudeInfo().getValue();
    }

    public TestStateInfo.Magnitude getMagnitudeInfo() {
        return this.myState.getMagnitude();
    }

    public boolean hasErrors() {
        return this.myHasCriticalErrors;
    }

    public boolean isFinal() {
        return this.myState.isFinal();
    }

    private void setStacktraceIfNotSet(@Nullable String stacktrace) {
        if (this.myStacktrace == null) {
            this.myStacktrace = stacktrace;
        }
    }

    @Nullable
    @NlsSafe
    public String getStacktrace() {
        return this.myStacktrace;
    }

    @Nullable
    @NlsSafe
    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    public SMTestLocator getLocator() {
        return this.myLocator;
    }

    public boolean isLeaf() {
        return this.myChildren == null || this.myChildren.isEmpty();
    }

    public boolean hasPassedTests() {
        boolean canCache;
        if (this.myHasPassedTestsCached) {
            return this.myHasPassedTests;
        }
        boolean hasPassedTests = this.calcPassedTests();
        boolean bl = canCache = !this.myState.isInProgress() && this.myState.wasLaunched();
        if (canCache) {
            this.myHasPassedTests = hasPassedTests;
            this.myHasPassedTestsCached = true;
        }
        return hasPassedTests;
    }

    public boolean isInterrupted() {
        return this.myState.wasTerminated();
    }

    private boolean calcPassedTests() {
        if (this.isPassed()) {
            return true;
        }
        for (SMTestProxy sMTestProxy : this.getChildren()) {
            if (!sMTestProxy.hasPassedTests()) continue;
            return true;
        }
        return false;
    }

    public boolean isIgnored() {
        return this.myState.getMagnitude() == TestStateInfo.Magnitude.IGNORED_INDEX;
    }

    public boolean isPassed() {
        return this.myState.getMagnitude() == TestStateInfo.Magnitude.SKIPPED_INDEX || this.myState.getMagnitude() == TestStateInfo.Magnitude.COMPLETE_INDEX || this.myState.getMagnitude() == TestStateInfo.Magnitude.PASSED_INDEX;
    }

    public void addChild(@NotNull SMTestProxy child) {
        boolean printOwnContentOnly;
        if (child == null) {
            SMTestProxy.$$$reportNull$$$0(2);
        }
        if (this.myChildren == null) {
            this.myChildren = new CopyOnWriteArrayList<SMTestProxy>();
        }
        this.myChildren.add(child);
        this.addLast((Printable)child);
        child.setParent(this);
        boolean bl = printOwnContentOnly = this instanceof SMRootTestProxy && ((SMRootTestProxy)this).shouldPrintOwnContentOnly();
        if (!printOwnContentOnly) {
            child.setPrinter(this.myPrinter);
        }
        if (this.myPreferredPrinter != null && child.myPreferredPrinter == null) {
            child.setPreferredPrinter(this.myPreferredPrinter);
        }
    }

    @Nullable
    private Printer getRightPrinter(@Nullable Printer printer) {
        if (this.myPreferredPrinter != null && printer != null) {
            return this.myPreferredPrinter;
        }
        return printer;
    }

    public void setPrinter(Printer printer) {
        super.setPrinter(this.getRightPrinter(printer));
    }

    public String getName() {
        return this.myName;
    }

    public boolean isConfig() {
        return this.myConfig;
    }

    private Navigatable getNavigatable() {
        SMRootTestProxy root = this.getRoot();
        if (root == null) {
            return null;
        }
        return TestsUIUtil.getOpenFileDescriptor((AbstractTestProxy)this, (TestConsoleProperties)root.myTestConsoleProperties);
    }

    @Nullable
    public NavigationRequest navigationRequest() {
        Navigatable navigatable = this.getNavigatable();
        return navigatable == null ? null : navigatable.navigationRequest();
    }

    public void navigate(boolean requestFocus) {
        ReadAction.nonBlocking(() -> this.getNavigatable()).expireWith((Disposable)this).coalesceBy(new Object[]{this}).finishOnUiThread(ModalityState.nonModal(), navigatable -> {
            if (navigatable != null) {
                navigatable.navigate(requestFocus);
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    public boolean canNavigate() {
        Navigatable navigatable = this.getNavigatable();
        return navigatable != null && navigatable.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Nullable
    public Location getLocation(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        String locationUrl;
        if (project == null) {
            SMTestProxy.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            SMTestProxy.$$$reportNull$$$0(4);
        }
        if ((locationUrl = this.getLocationUrl()) == null || this.myLocator == null) {
            return null;
        }
        if (this.myLocationMapCachedValue == null) {
            this.myLocationMapCachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
                ConcurrentHashMap<GlobalSearchScope, Ref> value = new ConcurrentHashMap<GlobalSearchScope, Ref>(1);
                value.put(searchScope, Ref.create((Object)this.computeLocation(project, searchScope, locationUrl)));
                return CachedValueProvider.Result.create(value, (Object[])new Object[]{this.myLocator.getLocationCacheModificationTracker(project)});
            }, false);
        }
        Map value = (Map)this.myLocationMapCachedValue.getValue();
        Ref ref = value.computeIfAbsent(searchScope, scope -> Ref.create((Object)this.computeLocation(project, searchScope, locationUrl)));
        return (Location)ref.get();
    }

    @Nullable
    private Location computeLocation(@NotNull Project project, @NotNull GlobalSearchScope searchScope, @NotNull String locationUrl) {
        if (project == null) {
            SMTestProxy.$$$reportNull$$$0(5);
        }
        if (searchScope == null) {
            SMTestProxy.$$$reportNull$$$0(6);
        }
        if (locationUrl == null) {
            SMTestProxy.$$$reportNull$$$0(7);
        }
        SMTestLocator locator = Objects.requireNonNull(this.myLocator);
        String protocolId = VirtualFileManager.extractProtocol((String)locationUrl);
        if (protocolId != null) {
            String path = VirtualFileManager.extractPath((String)locationUrl);
            if (DumbService.getInstance((Project)project).isUsableInCurrentContext((Object)locator)) {
                return (Location)DumbService.getInstance((Project)project).computeWithAlternativeResolveEnabled(() -> {
                    List<Location> locations = locator.getLocation(protocolId, path, this.myMetainfo, project, searchScope);
                    return (Location)ContainerUtil.getFirstItem(locations);
                });
            }
        }
        return null;
    }

    @Nullable
    public Navigatable getDescriptor(@Nullable Location location, @NotNull TestConsoleProperties properties) {
        Navigatable result;
        if (properties == null) {
            SMTestProxy.$$$reportNull$$$0(8);
        }
        if (location == null) {
            return null;
        }
        String stacktrace = this.myStacktrace;
        if (stacktrace != null && properties instanceof SMStacktraceParser && this.isLeaf() && (result = ((SMStacktraceParser)properties).getErrorNavigatable(location, stacktrace)) != null) {
            return result;
        }
        return location.getNavigatable();
    }

    public boolean isSuite() {
        return this.myIsSuite;
    }

    public SMTestProxy getParent() {
        return this.myParent;
    }

    public List<? extends SMTestProxy> getChildren() {
        return this.myChildren != null ? this.myChildren : Collections.emptyList();
    }

    public List<SMTestProxy> getAllTests() {
        ArrayList<SMTestProxy> allTests = new ArrayList<SMTestProxy>();
        allTests.add(this);
        for (SMTestProxy sMTestProxy : this.getChildren()) {
            allTests.addAll(sMTestProxy.getAllTests());
        }
        return allTests;
    }

    public void setStarted() {
        this.myState = this.myIsSuite ? new SuiteInProgressState(this) : TestInProgressState.TEST;
        if (this.myStartTime == null) {
            this.myStartTime = System.currentTimeMillis();
        }
        this.myState = !this.myIsSuite ? TestInProgressState.TEST : new SuiteInProgressState(this);
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    @Nullable
    public Long getStartTimeMillis() {
        return this.myStartTime;
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    @Nullable
    public Long getEndTimeMillis() {
        return this.myEndTime;
    }

    public void setSuiteStarted() {
        if (this.myStartTime == null) {
            this.myStartTime = System.currentTimeMillis();
        }
        this.myState = new SuiteInProgressState(this);
        if (!this.myIsSuite) {
            this.myIsSuite = true;
        }
    }

    @Nullable
    public Long getDuration() {
        if (this.myDurationIsCached || this.durationShouldBeSetExplicitly()) {
            return this.myDuration;
        }
        this.myDuration = this.calcSuiteDuration();
        this.myDurationIsCached = true;
        return this.myDuration;
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    @Nullable
    public Long getCustomizedDuration(@NotNull TestConsoleProperties testConsoleProperties) {
        SMTRunnerTestTreeViewProvider provider;
        SMTRunnerTestTreeView view;
        if (testConsoleProperties == null) {
            SMTestProxy.$$$reportNull$$$0(9);
        }
        if (testConsoleProperties instanceof SMTRunnerTestTreeViewProvider && (view = (provider = (SMTRunnerTestTreeViewProvider)testConsoleProperties).createSMTRunnerTestTreeView()) instanceof SMTRunnerTestTreeViewProvider.CustomizedDurationProvider) {
            SMTRunnerTestTreeViewProvider.CustomizedDurationProvider customizedDurationProvider = (SMTRunnerTestTreeViewProvider.CustomizedDurationProvider)((Object)view);
            return customizedDurationProvider.getCustomizedDuration(this);
        }
        return this.myDuration;
    }

    @Nls
    @Nullable
    public String getDurationString(TestConsoleProperties consoleProperties) {
        return switch (this.getMagnitudeInfo()) {
            case TestStateInfo.Magnitude.PASSED_INDEX -> {
                if (!this.isSubjectToHide(consoleProperties)) {
                    yield this.getDurationString();
                }
                yield null;
            }
            case TestStateInfo.Magnitude.RUNNING_INDEX -> {
                if (!this.isSubjectToHide(consoleProperties)) {
                    yield this.getDurationPaddedString();
                }
                yield null;
            }
            case TestStateInfo.Magnitude.COMPLETE_INDEX, TestStateInfo.Magnitude.FAILED_INDEX, TestStateInfo.Magnitude.ERROR_INDEX, TestStateInfo.Magnitude.IGNORED_INDEX, TestStateInfo.Magnitude.SKIPPED_INDEX, TestStateInfo.Magnitude.TERMINATED_INDEX -> this.getDurationString();
            default -> null;
        };
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    public boolean isSubjectToHide(TestConsoleProperties consoleProperties) {
        return TestConsoleProperties.HIDE_PASSED_TESTS.value((AbstractProperty.AbstractPropertyContainer)consoleProperties) && this.getParent() != null && !this.isDefect();
    }

    @Nls
    private String getDurationString() {
        Long duration = this.getDuration();
        return duration != null ? NlsMessages.formatDurationApproximateNarrow((long)duration) : null;
    }

    @Nls
    private String getDurationPaddedString() {
        Long duration = this.getDuration();
        return duration != null ? NlsMessages.formatDurationPadded((long)duration) : null;
    }

    public boolean shouldSkipRootNodeForExport() {
        return true;
    }

    private boolean durationShouldBeSetExplicitly() {
        return !this.myIsSuite || this.getDurationStrategy() == TestDurationStrategy.MANUAL;
    }

    @NotNull
    public TestDurationStrategy getDurationStrategy() {
        TestDurationStrategy parentDurationStrategy;
        TestDurationStrategy strategy = this.myDurationStrategyCached;
        if (strategy != null) {
            TestDurationStrategy testDurationStrategy = strategy;
            if (testDurationStrategy == null) {
                SMTestProxy.$$$reportNull$$$0(10);
            }
            return testDurationStrategy;
        }
        SMRootTestProxy root = this.getRoot();
        if (root == null) {
            TestDurationStrategy testDurationStrategy = TestDurationStrategy.AUTOMATIC;
            if (testDurationStrategy == null) {
                SMTestProxy.$$$reportNull$$$0(11);
            }
            return testDurationStrategy;
        }
        this.myDurationStrategyCached = parentDurationStrategy = root.getDurationStrategy();
        TestDurationStrategy testDurationStrategy = parentDurationStrategy;
        if (testDurationStrategy == null) {
            SMTestProxy.$$$reportNull$$$0(12);
        }
        return testDurationStrategy;
    }

    public void setDuration(long duration) {
        if (this.durationShouldBeSetExplicitly()) {
            this.invalidateCachedDurationForContainerSuites(duration - (this.myDuration != null ? this.myDuration : 0L));
            this.myDurationIsCached = true;
            this.myDuration = duration >= 0L ? Long.valueOf(duration) : null;
            return;
        }
        this.invalidateCachedDurationForContainerSuites(-1L);
        LOG.warn("Unsupported operation");
    }

    public void setMetainfo(@Nullable String metainfo) {
        this.myMetainfo = metainfo;
    }

    public void setFinished() {
        if (this.myState.isFinal()) {
            return;
        }
        if (this.myEndTime == null) {
            this.myEndTime = System.currentTimeMillis();
        }
        this.myState = !this.isSuite() ? TestPassedState.INSTANCE : this.determineSuiteStateOnFinished();
        this.fireOnNewPrintable(this.myState);
    }

    public void setTestFailed(@Nullable String localizedMessage, @Nullable String stackTrace, boolean testError) {
        if (this.myEndTime == null) {
            this.myEndTime = System.currentTimeMillis();
        }
        this.setStacktraceIfNotSet(stackTrace);
        this.myErrorMessage = localizedMessage;
        TestFailedState failedState = testError ? new TestErrorState(localizedMessage, stackTrace) : new TestFailedState(localizedMessage, stackTrace);
        this.updateFailedState(failedState);
        this.fireOnNewPrintable(failedState);
    }

    private void updateFailedState(TestFailedState failedState) {
        if (this.myState instanceof CompoundTestFailedState) {
            ((CompoundTestFailedState)this.myState).addFailure(failedState);
        } else if (this.myState instanceof TestFailedState) {
            CompoundTestFailedState states = new CompoundTestFailedState();
            states.addFailure((TestFailedState)this.myState);
            states.addFailure(failedState);
            this.myState = states;
        } else {
            this.myState = failedState;
        }
    }

    public void setTestComparisonFailed(@Nullable String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText) {
        if (actualText == null) {
            SMTestProxy.$$$reportNull$$$0(13);
        }
        if (expectedText == null) {
            SMTestProxy.$$$reportNull$$$0(14);
        }
        this.setTestComparisonFailed(localizedMessage, stackTrace, actualText, expectedText, null, null, true);
    }

    public void setTestComparisonFailed(@Nullable String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText, @NotNull TestFailedEvent event) {
        if (actualText == null) {
            SMTestProxy.$$$reportNull$$$0(15);
        }
        if (expectedText == null) {
            SMTestProxy.$$$reportNull$$$0(16);
        }
        if (event == null) {
            SMTestProxy.$$$reportNull$$$0(17);
        }
        TestComparisonFailedState comparisonFailedState = this.setTestComparisonFailed(localizedMessage, stackTrace, actualText, expectedText, event.getActualFilePath(), event.getExpectedFilePath(), event.shouldPrintExpectedAndActualValues());
        comparisonFailedState.setToDeleteExpectedFile(event.isExpectedFileTemp());
        comparisonFailedState.setToDeleteActualFile(event.isActualFileTemp());
    }

    @ApiStatus.Internal
    public TestComparisonFailedState setTestComparisonFailed(@Nullable String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText, @Nullable String actualFilePath, @Nullable String expectedFilePath, boolean printExpectedAndActualValues) {
        if (actualText == null) {
            SMTestProxy.$$$reportNull$$$0(18);
        }
        if (expectedText == null) {
            SMTestProxy.$$$reportNull$$$0(19);
        }
        this.setStacktraceIfNotSet(stackTrace);
        this.myErrorMessage = localizedMessage;
        TestComparisonFailedState comparisonFailedState = new TestComparisonFailedState(localizedMessage, stackTrace, actualText, expectedText, printExpectedAndActualValues, expectedFilePath, actualFilePath);
        DiffHyperlink hyperlink = comparisonFailedState.getHyperlink();
        hyperlink.setTestProxy((AbstractTestProxy)this);
        this.updateFailedState(comparisonFailedState);
        this.fireOnNewPrintable(comparisonFailedState);
        return comparisonFailedState;
    }

    public void dispose() {
        if (this.myState instanceof TestFailedState) {
            Disposer.dispose((Disposable)((TestFailedState)this.myState));
        }
        super.dispose();
    }

    public void setTestIgnored(@Nullable String ignoreComment, @Nullable String stackTrace) {
        this.setStacktraceIfNotSet(stackTrace);
        this.myState = new TestIgnoredState(ignoreComment, stackTrace);
        this.fireOnNewPrintable(this.myState);
    }

    public void setParent(@Nullable SMTestProxy parent) {
        this.myParent = parent;
    }

    public List<? extends SMTestProxy> collectChildren(@Nullable Filter<? super SMTestProxy> filter) {
        return SMTestProxy.filterChildren(filter, this.collectChildren());
    }

    public List<? extends SMTestProxy> collectChildren() {
        List<? extends SMTestProxy> allChildren = this.getChildren();
        ArrayList<? extends SMTestProxy> result = new ArrayList<SMTestProxy>(allChildren);
        for (SMTestProxy sMTestProxy : allChildren) {
            result.addAll(sMTestProxy.collectChildren());
        }
        return result;
    }

    public List<? extends SMTestProxy> getChildren(@Nullable Filter<? super SMTestProxy> filter) {
        return SMTestProxy.filterChildren(filter, this.getChildren());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAfterLastPassed(Printable printable) {
        if (this.myTreeBuildBeforeStart) {
            int idx = 0;
            List list = this.myNestedPrintables;
            synchronized (list) {
                Printable proxy;
                Iterator iterator = this.myNestedPrintables.iterator();
                while (iterator.hasNext() && (!((proxy = (Printable)iterator.next()) instanceof SMTestProxy) || ((SMTestProxy)proxy).isFinal())) {
                    ++idx;
                }
            }
            this.insert(printable, idx);
        } else {
            this.addLast(printable);
        }
    }

    public void setTreeBuildBeforeStart() {
        this.myTreeBuildBeforeStart = true;
    }

    private static List<? extends SMTestProxy> filterChildren(@Nullable Filter<? super SMTestProxy> filter, List<? extends SMTestProxy> allChildren) {
        if (filter == Filter.NO_FILTER || filter == null) {
            return allChildren;
        }
        ArrayList<SMTestProxy> selectedChildren = new ArrayList<SMTestProxy>();
        for (SMTestProxy sMTestProxy : allChildren) {
            if (!filter.shouldAccept((AbstractTestProxy)sMTestProxy)) continue;
            selectedChildren.add(sMTestProxy);
        }
        if (selectedChildren.isEmpty()) {
            return Collections.emptyList();
        }
        return selectedChildren;
    }

    public boolean wasLaunched() {
        return this.myState.wasLaunched();
    }

    public void printOn(Printer printer) {
        Printer rightPrinter = this.getRightPrinter(printer);
        super.printOn(rightPrinter);
        SMTestProxy.printState(this.myState, rightPrinter);
    }

    public void printOwnPrintablesOn(Printer printer) {
        if (this.isLeaf()) {
            super.printOn(printer);
        } else {
            super.printOwnPrintablesOn(printer);
        }
        SMTestProxy.printState(this.myState, printer);
    }

    private static void printState(AbstractState oldState, Printer rightPrinter) {
        SMTestProxy.invokeInAlarm(() -> oldState.printOn(rightPrinter));
    }

    public final void addStdOutput(@NotNull String output) {
        if (output == null) {
            SMTestProxy.$$$reportNull$$$0(20);
        }
        this.addOutput(output, ProcessOutputTypes.STDOUT);
    }

    public final void addStdErr(@NotNull String output) {
        if (output == null) {
            SMTestProxy.$$$reportNull$$$0(21);
        }
        this.addOutput(output, ProcessOutputTypes.STDERR);
    }

    public final void addSystemOutput(String output) {
        this.addOutput(output, ProcessOutputTypes.SYSTEM);
    }

    public void addOutput(final @NotNull String output, final @NotNull Key outputType) {
        if (output == null) {
            SMTestProxy.$$$reportNull$$$0(22);
        }
        if (outputType == null) {
            SMTestProxy.$$$reportNull$$$0(23);
        }
        this.addAfterLastPassed(new Printable(){

            public void printOn(@NotNull Printer printer) {
                if (printer == null) {
                    1.$$$reportNull$$$0(0);
                }
                printer.printWithAnsiColoring(output, outputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/intellij/execution/testframework/sm/runner/SMTestProxy$1", "printOn"));
            }
        });
    }

    public void addError(final String output, final @Nullable String stackTrace, boolean isCritical) {
        this.myHasCriticalErrors = isCritical;
        if (isCritical) {
            this.invalidateCachedHasErrorMark();
        }
        this.setStacktraceIfNotSet(stackTrace);
        this.addAfterLastPassed(new Printable(){

            public void printOn(Printer printer) {
                new TestFailedState(output, stackTrace).printOn(printer);
            }
        });
    }

    private void invalidateCachedHasErrorMark() {
        this.myHasCriticalErrors = true;
        SMTestProxy containerSuite = this.getParent();
        if (containerSuite != null && !containerSuite.hasErrors()) {
            containerSuite.invalidateCachedHasErrorMark();
        }
    }

    @NotNull
    @NlsSafe
    public String getPresentableName() {
        if (this.myPresentableName == null) {
            this.setPresentableName(this.getName());
        }
        String string = this.myPresentableName;
        if (string == null) {
            SMTestProxy.$$$reportNull$$$0(24);
        }
        return string;
    }

    public void setPresentableName(@Nullable String name) {
        this.myPresentableName = SMTestProxy.calculatePresentableName(this, name);
    }

    @NotNull
    private static String calculatePresentableName(@NotNull SMTestProxy proxy, @Nullable String name) {
        if (proxy == null) {
            SMTestProxy.$$$reportNull$$$0(25);
        }
        String string = proxy.isPreservePresentableName() ? TestsPresentationUtil.getPresentableNameTrimmedOnly(name) : TestsPresentationUtil.getPresentableName(proxy, name);
        if (string == null) {
            SMTestProxy.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Nullable
    public DiffHyperlink getDiffViewerProvider() {
        AbstractState state = this.myState;
        if (state instanceof TestComparisonFailedState) {
            return ((TestComparisonFailedState)state).getHyperlink();
        }
        if (state instanceof CompoundTestFailedState) {
            return (DiffHyperlink)ContainerUtil.getFirstItem(((CompoundTestFailedState)state).getHyperlinks());
        }
        return null;
    }

    @NotNull
    public @Unmodifiable List<DiffHyperlink> getDiffViewerProviders() {
        AbstractState state = this.myState;
        if (state instanceof CompoundTestFailedState) {
            List<DiffHyperlink> list = ((CompoundTestFailedState)state).getHyperlinks();
            if (list == null) {
                SMTestProxy.$$$reportNull$$$0(27);
            }
            return list;
        }
        List list = super.getDiffViewerProviders();
        if (list == null) {
            SMTestProxy.$$$reportNull$$$0(28);
        }
        return list;
    }

    public String toString() {
        return this.getPresentableName();
    }

    private void setTerminated(long endTime) {
        boolean beforeIsFinal = this.myState.isFinal();
        if (this.myEndTime == null) {
            this.myEndTime = endTime;
        }
        if (!beforeIsFinal) {
            this.myState = TerminatedState.INSTANCE;
            Long startTime = this.myStartTime;
            if (!this.myIsSuite && startTime != null) {
                this.setDuration(endTime - startTime);
            } else if (!this.myIsSuite) {
                this.setDuration(0L);
            }
        }
        List<? extends SMTestProxy> children = this.getChildren();
        for (SMTestProxy sMTestProxy : children) {
            sMTestProxy.setTerminated(endTime);
        }
        if (!beforeIsFinal) {
            this.fireOnNewPrintable(this.myState);
        }
    }

    public void setTerminated() {
        this.setTerminated(System.currentTimeMillis());
    }

    public boolean wasTerminated() {
        return this.myState.wasTerminated();
    }

    @Nullable
    public String getLocationUrl() {
        return this.myLocationUrl;
    }

    @Nullable
    public String getMetainfo() {
        return this.myMetainfo;
    }

    private boolean containsErrorTests() {
        List<? extends SMTestProxy> children = this.getChildren();
        for (SMTestProxy sMTestProxy : children) {
            if (sMTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.ERROR_INDEX) continue;
            return true;
        }
        return false;
    }

    private boolean containsFailedTests() {
        List<? extends SMTestProxy> children = this.getChildren();
        for (SMTestProxy sMTestProxy : children) {
            if (sMTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.FAILED_INDEX) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    protected AbstractState determineSuiteStateOnFinished() {
        SuiteFinishedState state = this.isLeaf() ? SuiteFinishedState.EMPTY_SUITE : (this.isDefect() ? (this.containsErrorTests() ? SuiteFinishedState.ERROR_SUITE : (this.containsFailedTests() ? SuiteFinishedState.FAILED_SUITE : SuiteFinishedState.WITH_IGNORED_TESTS_SUITE)) : (this.isEmptySuite() ? SuiteFinishedState.EMPTY_SUITE : SuiteFinishedState.PASSED_SUITE));
        return state;
    }

    public boolean isEmptySuite() {
        if (this.myIsEmptyIsCached) {
            return this.myIsEmpty;
        }
        if (!this.isSuite()) {
            this.myIsEmpty = true;
            this.myIsEmptyIsCached = true;
            return true;
        }
        this.myIsEmpty = true;
        List<? extends SMTestProxy> allTestCases = this.getChildren();
        for (SMTestProxy sMTestProxy : allTestCases) {
            if (sMTestProxy.isSuite()) {
                if (!sMTestProxy.isEmptySuite()) {
                    this.myIsEmpty = false;
                    this.myIsEmptyIsCached = true;
                    break;
                }
                this.myIsEmpty = true;
                this.myIsEmptyIsCached = this.myState.isFinal();
                continue;
            }
            this.myIsEmpty = false;
            this.myIsEmptyIsCached = true;
            break;
        }
        return this.myIsEmpty;
    }

    @Nullable
    private Long calcSuiteDuration() {
        long partialDuration = 0L;
        boolean durationOfChildrenIsUnknown = true;
        for (SMTestProxy sMTestProxy : this.getChildren()) {
            Long duration = sMTestProxy.getDuration();
            if (duration == null) continue;
            durationOfChildrenIsUnknown = false;
            partialDuration += duration.longValue();
        }
        return durationOfChildrenIsUnknown ? null : Long.valueOf(partialDuration);
    }

    private void invalidateCachedDurationForContainerSuites(long duration) {
        SMTestProxy containerSuite;
        if (!this.durationShouldBeSetExplicitly()) {
            if (duration >= 0L) {
                this.myDuration = this.myDuration == null ? Long.valueOf(duration) : Long.valueOf(this.myDuration + duration);
            } else {
                this.myDuration = null;
                this.myDurationIsCached = false;
            }
        }
        if ((containerSuite = this.getParent()) != null) {
            containerSuite.invalidateCachedDurationForContainerSuites(duration);
        }
    }

    public SMRootTestProxy getRoot() {
        return (SMRootTestProxy)SMTestProxy.getTestRoot((AbstractTestProxy)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 24, 26, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testLocator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredPrinter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationUrl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testConsoleProperties";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/runner/SMTestProxy";
                break;
            }
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualText";
                break;
            }
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedText";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/runner/SMTestProxy";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDurationStrategy";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePresentableName";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffViewerProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setLocator";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setPreferredPrinter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeLocation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCustomizedDuration";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setTestComparisonFailed";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addStdOutput";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addStdErr";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addOutput";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "calculatePresentableName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 24, 26, 27, 28 -> new IllegalStateException(string);
        };
    }

    public static class SMRootTestProxy
    extends SMTestProxy
    implements TestProxyRoot {
        private final JComponent myConsole;
        private boolean myTestsReporterAttached;
        private String myPresentation;
        private String myComment;
        private String myRootLocationUrl;
        private ProcessHandler myHandler;
        private boolean myShouldPrintOwnContentOnly = false;
        private long myExecutionId = -1L;
        @NotNull
        private TestDurationStrategy myDurationStrategy = TestDurationStrategy.AUTOMATIC;
        private TestConsoleProperties myTestConsoleProperties;

        public SMRootTestProxy() {
            this(false, null);
        }

        public SMRootTestProxy(boolean preservePresentableName, @Nullable JComponent console) {
            super("[root]", true, null, preservePresentableName);
            this.myConsole = console;
        }

        public void setTestsReporterAttached() {
            this.myTestsReporterAttached = true;
        }

        final void setDurationStrategy(@NotNull TestDurationStrategy strategy) {
            if (strategy == null) {
                SMRootTestProxy.$$$reportNull$$$0(0);
            }
            this.myDurationStrategy = strategy;
        }

        @Override
        @NotNull
        public final TestDurationStrategy getDurationStrategy() {
            TestDurationStrategy testDurationStrategy = this.myDurationStrategy;
            if (testDurationStrategy == null) {
                SMRootTestProxy.$$$reportNull$$$0(1);
            }
            return testDurationStrategy;
        }

        public boolean isTestsReporterAttached() {
            return this.myTestsReporterAttached;
        }

        public String getPresentation() {
            return this.myPresentation;
        }

        public void setPresentation(String presentation) {
            this.myPresentation = presentation;
        }

        public void setComment(String comment) {
            this.myComment = comment;
        }

        @RequiresEdt
        public long getExecutionId() {
            ThreadingAssertions.assertEventDispatchThread();
            long result = this.myExecutionId;
            if (result == -1L) {
                ViewContext viewContext;
                DataContext consoleContext;
                ExecutionEnvironment executionEnvironment = null;
                if (this.myConsole != null && (executionEnvironment = (ExecutionEnvironment)ExecutionDataKeys.EXECUTION_ENVIRONMENT.getData(consoleContext = DataManager.getInstance().getDataContext((Component)this.myConsole))) == null && (viewContext = (ViewContext)ViewContext.CONTEXT_KEY.getData(consoleContext)) != null) {
                    JComponent tabsComponent = viewContext.getContentManager().getComponent();
                    executionEnvironment = (ExecutionEnvironment)ExecutionDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext((Component)tabsComponent));
                }
                result = executionEnvironment != null ? executionEnvironment.getExecutionId() : 0L;
                this.myExecutionId = result;
            }
            return result;
        }

        public void setExecutionId(long id) {
            this.myExecutionId = id;
        }

        @NlsSafe
        public String getComment() {
            return this.myComment;
        }

        public void setRootLocationUrl(String locationUrl) {
            this.myRootLocationUrl = locationUrl;
            this.myLocationMapCachedValue = null;
        }

        @Override
        @Nullable
        public String getLocationUrl() {
            return this.myRootLocationUrl;
        }

        public ProcessHandler getHandler() {
            return this.myHandler;
        }

        public void setHandler(ProcessHandler handler) {
            this.myHandler = handler;
        }

        @Override
        @ApiStatus.Internal
        protected AbstractState determineSuiteStateOnFinished() {
            if (this.isLeaf() && !this.isTestsReporterAttached()) {
                return SuiteFinishedState.TESTS_REPORTER_NOT_ATTACHED;
            }
            return super.determineSuiteStateOnFinished();
        }

        public void testingRestarted() {
            if (!this.getChildren().isEmpty()) {
                this.getChildren().clear();
            }
            this.myStartTime = null;
            this.myEndTime = null;
            this.clear();
        }

        boolean shouldPrintOwnContentOnly() {
            return this.myShouldPrintOwnContentOnly;
        }

        public void setShouldPrintOwnContentOnly(boolean shouldPrintOwnContentOnly) {
            this.myShouldPrintOwnContentOnly = shouldPrintOwnContentOnly;
        }

        @Override
        public void printOn(@NotNull Printer printer) {
            if (printer == null) {
                SMRootTestProxy.$$$reportNull$$$0(2);
            }
            if (this.myShouldPrintOwnContentOnly) {
                this.printOwnPrintablesOn(printer, false);
            } else {
                super.printOn(printer);
            }
        }

        public void setTestConsoleProperties(TestConsoleProperties properties) {
            this.myTestConsoleProperties = properties;
        }

        public TestConsoleProperties getTestConsoleProperties() {
            return this.myTestConsoleProperties;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strategy";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/sm/runner/SMTestProxy$SMRootTestProxy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/sm/runner/SMTestProxy$SMRootTestProxy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDurationStrategy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setDurationStrategy";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "printOn";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

