/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteThread;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.EDT;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class WriteAction<T>
extends BaseActionRunnable<T> {
    private static final Logger LOG = Logger.getInstance(WriteAction.class);

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public WriteAction() {
    }

    @Override
    @Deprecated
    @NotNull
    public RunResult<T> execute() {
        RunResult result = new RunResult(this);
        Application application = ApplicationManager.getApplication();
        if (application.isWriteIntentLockAcquired()) {
            application.runWriteAction(() -> result.run());
            RunResult runResult = result;
            if (runResult == null) {
                WriteAction.$$$reportNull$$$0(0);
            }
            return runResult;
        }
        if (application.isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
        }
        WriteThread.invokeAndWait(() -> application.runWriteAction(() -> result.run()));
        result.throwException();
        RunResult runResult = result;
        if (runResult == null) {
            WriteAction.$$$reportNull$$$0(1);
        }
        return runResult;
    }

    @RequiresEdt
    public static <E extends Throwable> void run(@NotNull ThrowableRunnable<E> action) throws E {
        if (action == null) {
            WriteAction.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ApplicationManager.getApplication().runWriteAction(() -> {
            action.run();
            return null;
        });
    }

    @RequiresEdt
    public static <T, E extends Throwable> T compute(@NotNull ThrowableComputable<T, E> action) throws E {
        if (action == null) {
            WriteAction.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        return ApplicationManager.getApplication().runWriteAction(action);
    }

    @Override
    @Deprecated
    protected abstract void run(@NotNull Result<? super T> var1) throws Throwable;

    public static <E extends Throwable> void runAndWait(@NotNull ThrowableRunnable<E> action) throws E {
        if (action == null) {
            WriteAction.$$$reportNull$$$0(4);
        }
        WriteAction.computeAndWait(() -> {
            action.run();
            return null;
        });
    }

    public static <T, E extends Throwable> T computeAndWait(@NotNull ThrowableComputable<T, E> action) throws E {
        if (action == null) {
            WriteAction.$$$reportNull$$$0(5);
        }
        return WriteAction.computeAndWait(action, ModalityState.defaultModalityState());
    }

    public static <T, E extends Throwable> T computeAndWait(@NotNull ThrowableComputable<T, E> action, ModalityState modalityState) throws E {
        Application application;
        if (action == null) {
            WriteAction.$$$reportNull$$$0(6);
        }
        if ((application = ApplicationManager.getApplication()).isWriteIntentLockAcquired()) {
            return application.runWriteAction(action);
        }
        if (EDT.isCurrentThreadEdt()) {
            return application.runWriteIntentReadAction(() -> application.runWriteAction(action));
        }
        if (application.holdsReadLock()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
        }
        AtomicReference result = new AtomicReference();
        AtomicReference exception = new AtomicReference();
        WriteThread.invokeAndWait(() -> {
            try {
                result.set(WriteAction.compute(action));
            }
            catch (Throwable e) {
                exception.set(e);
            }
        }, modalityState);
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            t.addSuppressed(new RuntimeException());
            ExceptionUtil.rethrowUnchecked((Throwable)t);
            throw t;
        }
        return (T)result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/WriteAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/WriteAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runAndWait";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeAndWait";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

