/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.LocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerContentLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.index.ContentVersion;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitStageLineStatusTracker;
import git4idea.index.GitStageManagerKt;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerKt;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001a\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u001c\u0010\u0016\u001a\u00020\u00172\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\u0014\u0010\u0019\u001a\u00020\u00172\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016\u00a8\u0006\u001d"}, d2={"Lgit4idea/index/GitStageLineStatusTrackerProvider;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader;", "<init>", "()V", "isMyTracker", "", "tracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "isTrackedFile", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createTracker", "getContentInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "shouldBeUpdated", "oldInfo", "newInfo", "loadContent", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$TrackerContent;", "info", "setLoadedContent", "", "content", "handleLoadingError", "StagedContentInfo", "StagedTrackerContent", "Companion", "intellij.vcs.git"})
public final class GitStageLineStatusTrackerProvider
implements LineStatusTrackerContentLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public boolean isMyTracker(@NotNull LocalLineStatusTracker<?> tracker) {
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        return tracker instanceof GitStageLineStatusTracker;
    }

    public boolean isTrackedFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isInLocalFileSystem()) {
            return false;
        }
        if (!GitStageManagerKt.isStagingAreaAvailable(project)) {
            return false;
        }
        if (!GitStageManagerKt.stageLineStatusTrackerRegistryOption().asBoolean()) {
            return false;
        }
        GitRepository repository2 = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFileQuick(file);
        return repository2 != null;
    }

    @Nullable
    public LocalLineStatusTracker<?> createTracker(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GitStageTracker gitStageTracker = GitStageTracker.Companion.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)gitStageTracker, (String)"getInstance(...)");
        GitFileStatus gitFileStatus = GitStageTrackerKt.status(gitStageTracker, file);
        if (gitFileStatus == null) {
            return null;
        }
        GitFileStatus status = gitFileStatus;
        if (!(status.isTracked() && GitFileStatusKt.has(status, ContentVersion.STAGED) && GitFileStatusKt.has(status, ContentVersion.LOCAL))) {
            return null;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        FilePath filePath2 = filePath;
        if (GitContentRevision.getRepositoryIfSubmodule(project, filePath2) != null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        return new GitStageLineStatusTracker(project, file, document2);
    }

    @Nullable
    public LineStatusTrackerContentLoader.ContentInfo getContentInfo(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFile(file);
        if (gitRepository == null) {
            return null;
        }
        GitRepository repository2 = gitRepository;
        String string = repository2.getCurrentRevision();
        Charset charset = file.getCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCharset(...)");
        return new StagedContentInfo(string, charset, file);
    }

    public boolean shouldBeUpdated(@Nullable LineStatusTrackerContentLoader.ContentInfo oldInfo, @NotNull LineStatusTrackerContentLoader.ContentInfo newInfo) {
        Intrinsics.checkNotNullParameter((Object)newInfo, (String)"newInfo");
        StagedContentInfo cfr_ignored_0 = (StagedContentInfo)newInfo;
        return oldInfo == null || !(oldInfo instanceof StagedContentInfo) || !Intrinsics.areEqual((Object)((StagedContentInfo)oldInfo).getCurrentRevision(), (Object)((StagedContentInfo)newInfo).getCurrentRevision()) || !Intrinsics.areEqual((Object)((StagedContentInfo)oldInfo).getCharset(), (Object)((StagedContentInfo)newInfo).getCharset());
    }

    @Nullable
    public LineStatusTrackerContentLoader.TrackerContent loadContent(@NotNull Project project, @NotNull LineStatusTrackerContentLoader.ContentInfo info) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        StagedContentInfo cfr_ignored_0 = (StagedContentInfo)info;
        VirtualFile file = ((StagedContentInfo)info).getVirtualFile();
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        FilePath filePath2 = filePath;
        GitStageTracker gitStageTracker = GitStageTracker.Companion.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)gitStageTracker, (String)"getInstance(...)");
        GitFileStatus gitFileStatus = GitStageTrackerKt.status(gitStageTracker, file);
        if (gitFileStatus == null) {
            return null;
        }
        GitFileStatus status = gitFileStatus;
        if (GitContentRevision.getRepositoryIfSubmodule(project, filePath2) != null) {
            return null;
        }
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFile(file);
        if (gitRepository == null) {
            return null;
        }
        GitRepository repository2 = gitRepository;
        GitIndexFileSystemRefresher indexFileRefresher = GitIndexFileSystemRefresher.Companion.getInstance(project);
        VirtualFile virtualFile = repository2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        GitIndexVirtualFile gitIndexVirtualFile = indexFileRefresher.createFile(virtualFile, GitFileStatusKt.path(status, ContentVersion.STAGED));
        if (gitIndexVirtualFile == null) {
            return null;
        }
        GitIndexVirtualFile indexFile = gitIndexVirtualFile;
        Document document = (Document)ActionsKt.runReadAction(() -> GitStageLineStatusTrackerProvider.loadContent$lambda$0(indexFile));
        if (document == null) {
            return null;
        }
        Document indexDocument = document;
        indexDocument.putUserData(LineStatusTrackerBase.Companion.getSEPARATE_UNDO_STACK(), (Object)Registry.Companion.is("git.stage.separate.undo.stack"));
        if (!GitFileStatusKt.has(status, ContentVersion.HEAD)) {
            return new StagedTrackerContent("", indexDocument);
        }
        try {
            byte[] byArray = GitFileUtils.getFileContent(project, repository2.getRoot(), "HEAD", VcsFileUtil.relativePath((VirtualFile)repository2.getRoot(), (FilePath)GitFileStatusKt.path(status, ContentVersion.HEAD)));
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getFileContent(...)");
            byte[] bytes = byArray;
            String string = VcsImplUtil.loadTextFromBytes((Project)project, (byte[])bytes, (FilePath)filePath2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadTextFromBytes(...)");
            String headContent = string;
            String string2 = StringUtil.convertLineSeparators((String)headContent);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"convertLineSeparators(...)");
            String correctedText = string2;
            return new StagedTrackerContent(correctedText, indexDocument);
        }
        catch (VcsException e) {
            LOG.warn("Can't load base revision content for " + file.getPath() + " with status " + status, (Throwable)e);
            return null;
        }
    }

    public void setLoadedContent(@NotNull LocalLineStatusTracker<?> tracker, @NotNull LineStatusTrackerContentLoader.TrackerContent content) {
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        GitStageLineStatusTracker cfr_ignored_0 = (GitStageLineStatusTracker)tracker;
        StagedTrackerContent cfr_ignored_1 = (StagedTrackerContent)content;
        ((GitStageLineStatusTracker)tracker).setBaseRevision(((StagedTrackerContent)content).getVcsContent(), ((StagedTrackerContent)content).getStagedDocument());
    }

    public void handleLoadingError(@NotNull LocalLineStatusTracker<?> tracker) {
        Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        GitStageLineStatusTracker cfr_ignored_0 = (GitStageLineStatusTracker)tracker;
        ((GitStageLineStatusTracker)tracker).dropBaseRevision();
    }

    private static final Document loadContent$lambda$0(GitIndexVirtualFile $indexFile) {
        return FileDocumentManager.getInstance().getDocument((VirtualFile)$indexFile);
    }

    static {
        Logger logger = Logger.getInstance(GitStageLineStatusTrackerProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lgit4idea/index/GitStageLineStatusTrackerProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lgit4idea/index/GitStageLineStatusTrackerProvider$StagedContentInfo;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "currentRevision", "", "charset", "Ljava/nio/charset/Charset;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Ljava/lang/String;Ljava/nio/charset/Charset;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getCurrentRevision", "()Ljava/lang/String;", "getCharset", "()Ljava/nio/charset/Charset;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.git"})
    private static final class StagedContentInfo
    implements LineStatusTrackerContentLoader.ContentInfo {
        @Nullable
        private final String currentRevision;
        @NotNull
        private final Charset charset;
        @NotNull
        private final VirtualFile virtualFile;

        public StagedContentInfo(@Nullable String currentRevision, @NotNull Charset charset, @NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            this.currentRevision = currentRevision;
            this.charset = charset;
            this.virtualFile = virtualFile;
        }

        @Nullable
        public final String getCurrentRevision() {
            return this.currentRevision;
        }

        @NotNull
        public final Charset getCharset() {
            return this.charset;
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lgit4idea/index/GitStageLineStatusTrackerProvider$StagedTrackerContent;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$TrackerContent;", "vcsContent", "", "stagedDocument", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Ljava/lang/CharSequence;Lcom/intellij/openapi/editor/Document;)V", "getVcsContent", "()Ljava/lang/CharSequence;", "getStagedDocument", "()Lcom/intellij/openapi/editor/Document;", "intellij.vcs.git"})
    private static final class StagedTrackerContent
    implements LineStatusTrackerContentLoader.TrackerContent {
        @NotNull
        private final CharSequence vcsContent;
        @NotNull
        private final Document stagedDocument;

        public StagedTrackerContent(@NotNull CharSequence vcsContent, @NotNull Document stagedDocument) {
            Intrinsics.checkNotNullParameter((Object)vcsContent, (String)"vcsContent");
            Intrinsics.checkNotNullParameter((Object)stagedDocument, (String)"stagedDocument");
            this.vcsContent = vcsContent;
            this.stagedDocument = stagedDocument;
        }

        @NotNull
        public final CharSequence getVcsContent() {
            return this.vcsContent;
        }

        @NotNull
        public final Document getStagedDocument() {
            return this.stagedDocument;
        }
    }
}

