/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.config.GitConfigUtil;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.rebase.GitInteractiveRebaseFile;
import git4idea.rebase.GitRebaseEntry;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001e\u0010\u0006\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgit4idea/rebase/GitAutomaticRebaseEditor;", "Lgit4idea/rebase/GitInteractiveRebaseEditorHandler;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "entriesEditor", "Lkotlin/Function1;", "", "Lgit4idea/rebase/GitRebaseEntry;", "plainTextEditor", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "editCommits", "", "file", "Ljava/io/File;", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitAutomaticRebaseEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitAutomaticRebaseEditor.kt\ngit4idea/rebase/GitAutomaticRebaseEditor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,56:1\n13#2:57\n*S KotlinDebug\n*F\n+ 1 GitAutomaticRebaseEditor.kt\ngit4idea/rebase/GitAutomaticRebaseEditor\n*L\n31#1:57\n*E\n"})
public final class GitAutomaticRebaseEditor
extends GitInteractiveRebaseEditorHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final Function1<List<? extends GitRebaseEntry>, List<GitRebaseEntry>> entriesEditor;
    @NotNull
    private final Function1<String, String> plainTextEditor;
    @NotNull
    private static final Logger LOG;

    public GitAutomaticRebaseEditor(@NotNull Project project, @NotNull VirtualFile root, @NotNull Function1<? super List<? extends GitRebaseEntry>, ? extends List<? extends GitRebaseEntry>> entriesEditor, @NotNull Function1<? super String, String> plainTextEditor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(entriesEditor, (String)"entriesEditor");
        Intrinsics.checkNotNullParameter(plainTextEditor, (String)"plainTextEditor");
        super(project, root);
        this.project = project;
        this.root = root;
        this.entriesEditor = entriesEditor;
        this.plainTextEditor = plainTextEditor;
    }

    @Override
    public int editCommits(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            if (!this.myRebaseEditorShown) {
                this.myRebaseEditorShown = true;
                GitInteractiveRebaseFile rebaseFile = new GitInteractiveRebaseFile(this.project, this.root, file);
                List<GitRebaseEntry> list = rebaseFile.load();
                Intrinsics.checkNotNullExpressionValue(list, (String)"load(...)");
                List<GitRebaseEntry> entries = list;
                rebaseFile.save((List)this.entriesEditor.invoke(entries));
            } else {
                Charset charset = GitConfigUtil.getCommitEncodingCharset(this.project, this.root);
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCommitEncodingCharset(...)");
                Charset encoding = charset;
                String string = FileUtil.loadFile((File)file, (Charset)encoding);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(...)");
                String originalMessage = string;
                String modifiedMessage = (String)this.plainTextEditor.invoke((Object)originalMessage);
                byte[] byArray = modifiedMessage.getBytes(encoding);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                FileUtil.writeToFile((File)file, (byte[])byArray);
            }
            return 0;
        }
        catch (Exception ex) {
            LOG.error("Editor failed: ", (Throwable)ex);
            return 2;
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitAutomaticRebaseEditor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/rebase/GitAutomaticRebaseEditor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

