/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log.changes;

import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.config.GitVcsSettings;
import git4idea.history.GitLogUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.interactive.GitInteractiveRebaseUsingLogKt;
import git4idea.rebase.log.GitCommitEditingOperation;
import git4idea.rebase.log.GitCommitEditingOperationResult;
import git4idea.rebase.log.changes.GitDropSelectedChangesOperation;
import git4idea.rebase.log.squash.GitSquashOperation;
import git4idea.repo.GitRepository;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitFileUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\r\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u001eH\u0082@\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lgit4idea/rebase/log/changes/GitDropSelectedChangesOperation;", "Lgit4idea/rebase/log/GitCommitEditingOperation;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "<init>", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsCommitMetadata;Ljava/util/List;)V", "initialHeadPosition", "", "execute", "Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "canDropViaAmend", "", "dropViaAmend", "dropViaRebase", "createFixupCommit", "restoreChanges", "notifyGitCommandFailed", "", "result", "Lgit4idea/commands/GitCommandResult;", "notifyOperationFailed", "exception", "Lcom/intellij/openapi/vcs/VcsException;", "createGitChangesSaver", "Lgit4idea/stash/GitChangesSaver;", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitDropSelectedChangesOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitDropSelectedChangesOperation.kt\ngit4idea/rebase/log/changes/GitDropSelectedChangesOperation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n1586#2:183\n1661#2,3:184\n*S KotlinDebug\n*F\n+ 1 GitDropSelectedChangesOperation.kt\ngit4idea/rebase/log/changes/GitDropSelectedChangesOperation\n*L\n133#1:183\n133#1:184,3\n*E\n"})
public final class GitDropSelectedChangesOperation
extends GitCommitEditingOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsCommitMetadata commit;
    @NotNull
    private final List<Change> changes;
    private String initialHeadPosition;
    @NonNls
    @NotNull
    private static final String FIXUP_COMMIT_MESSAGE_SUFFIX = "\n\nCreated by IntelliJ Git plugin for drop selected changes operation";

    public GitDropSelectedChangesOperation(@NotNull GitRepository repository2, @NotNull VcsCommitMetadata commit, @NotNull List<? extends Change> changes) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        super(repository2);
        this.commit = commit;
        this.changes = changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object execute(@NotNull Continuation<? super GitCommitEditingOperationResult> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ GitDropSelectedChangesOperation this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute((Continuation<? super GitCommitEditingOperationResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getRepository().update();
                v0 = this.getRepository().getCurrentRevision();
                Intrinsics.checkNotNull((Object)v0);
                this.initialHeadPosition = v0;
                $continuation.label = 1;
                v1 = this.createGitChangesSaver((Continuation<? super GitChangesSaver>)$continuation);
                if (v1 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl24
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl24:
                // 2 sources

                if (!(changesSaver = (GitChangesSaver)v1).trySaveLocalChanges(CollectionsKt.listOf((Object)this.getRepository().getRoot()))) {
                    return GitCommitEditingOperationResult.Incomplete.INSTANCE;
                }
                result = GitCommitEditingOperationResult.Incomplete.INSTANCE;
                if (!this.canDropViaAmend()) ** GOTO lbl32
                result = this.dropViaAmend();
                ** GOTO lbl54
lbl32:
                // 1 sources

                logManager = VcsProjectLog.Companion.getInstance(this.getProject()).getLogManager();
                v2 = logManager;
                if (v2 == null) ** GOTO lbl52
                $continuation.L$0 = changesSaver;
                $continuation.L$1 = result;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)logManager);
                $continuation.label = 2;
                v3 = v2.runWithFreezing((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$0(git4idea.rebase.log.changes.GitDropSelectedChangesOperation ), ()Lgit4idea/rebase/log/GitCommitEditingOperationResult;)((GitDropSelectedChangesOperation)this), (Continuation)$continuation);
                ** if (v3 != var9_4) goto lbl42
lbl41:
                // 1 sources

                return var9_4;
lbl42:
                // 1 sources

                ** GOTO lbl51
            }
            case 2: {
                logManager = (VcsLogManager)$continuation.L$2;
                result = (GitCommitEditingOperationResult)$continuation.L$1;
                changesSaver = (GitChangesSaver)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl51:
                    // 2 sources

                    if ((v2 = (GitCommitEditingOperationResult)v3) != null) ** GOTO lbl53
lbl52:
                    // 2 sources

                    v2 = this.dropViaRebase();
lbl53:
                    // 2 sources

                    result = v2;
lbl54:
                    // 2 sources

                    var4_7 = result;
                    return var4_7;
                }
                catch (Throwable var5_9) {
                    throw var5_9;
                }
                finally {
                    var5_8 = result;
                    if (var5_8 instanceof GitCommitEditingOperationResult.Complete) {
                        changesSaver.load();
                    } else if (var5_8 instanceof GitCommitEditingOperationResult.Incomplete) {
                        changesSaver.notifyLocalChangesAreNotRestored(GitBundle.message("rebase.log.changes.action.operation.drop.name", new Object[0]));
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean canDropViaAmend() {
        String string = ((Hash)this.commit.getId()).asString();
        String string2 = this.initialHeadPosition;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"initialHeadPosition");
            string2 = null;
        }
        return Intrinsics.areEqual((Object)string, (Object)string2);
    }

    private final GitCommitEditingOperationResult dropViaAmend() {
        GitLineHandler gitLineHandler;
        if (!this.restoreChanges()) {
            return GitCommitEditingOperationResult.Incomplete.INSTANCE;
        }
        GitLineHandler $this$dropViaAmend_u24lambda_u240 = gitLineHandler = new GitLineHandler(this.getProject(), this.getRepository().getRoot(), GitCommand.COMMIT);
        boolean bl = false;
        String[] stringArray = new String[]{"--amend", "--no-verify", "--no-edit"};
        $this$dropViaAmend_u24lambda_u240.addParameters(stringArray);
        GitLineHandler handler = gitLineHandler;
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        GitCommandResult result2 = gitCommandResult;
        this.getRepository().update();
        if (result2.success()) {
            GitRebaseParams.RebaseUpstream upstream = GitInteractiveRebaseUsingLogKt.getRebaseUpstreamFor((VcsShortCommitDetails)this.commit);
            GitRepository gitRepository = this.getRepository();
            String string = this.initialHeadPosition;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"initialHeadPosition");
                string = null;
            }
            String string2 = this.getRepository().getCurrentRevision();
            Intrinsics.checkNotNull((Object)string2);
            String string3 = this.getRepository().getCurrentRevision();
            Intrinsics.checkNotNull((Object)string3);
            return new GitCommitEditingOperationResult.Complete(gitRepository, upstream, string, string2, HashImpl.build((String)string3), (Hash)this.commit.getId());
        }
        this.notifyGitCommandFailed(result2);
        return GitCommitEditingOperationResult.Incomplete.INSTANCE;
    }

    private final GitCommitEditingOperationResult dropViaRebase() {
        GitCommitEditingOperationResult result2;
        VcsCommitMetadata vcsCommitMetadata;
        if (!this.createFixupCommit()) {
            return GitCommitEditingOperationResult.Incomplete.INSTANCE;
        }
        try {
            List<? extends VcsCommitMetadata> list = GitLogUtil.collectMetadata(this.getProject(), this.getRepository().getRoot(), CollectionsKt.listOf((Object)"HEAD"));
            Intrinsics.checkNotNullExpressionValue(list, (String)"collectMetadata(...)");
            vcsCommitMetadata = (VcsCommitMetadata)CollectionsKt.single(list);
        }
        catch (VcsException e) {
            this.notifyOperationFailed(e);
            return GitCommitEditingOperationResult.Incomplete.INSTANCE;
        }
        VcsCommitMetadata fixupCommit = vcsCommitMetadata;
        Object[] e = new VcsCommitMetadata[]{fixupCommit, this.commit};
        List commitsToSquash = CollectionsKt.listOf((Object[])e);
        GitSquashOperation gitSquashOperation = new GitSquashOperation(this.getRepository());
        String string = this.commit.getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullMessage(...)");
        String string2 = this.initialHeadPosition;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"initialHeadPosition");
            string2 = null;
        }
        if ((result2 = gitSquashOperation.execute(commitsToSquash, string, string2)) instanceof GitCommitEditingOperationResult.Complete) {
            return ((GitCommitEditingOperationResult.Complete)result2).withFocusCommits(((GitCommitEditingOperationResult.Complete)result2).getFirstChangedHash(), (Hash)this.commit.getId());
        }
        return result2;
    }

    private final boolean createFixupCommit() {
        boolean bl;
        GitLineHandler gitLineHandler;
        if (!this.restoreChanges()) {
            return false;
        }
        GitLineHandler $this$createFixupCommit_u24lambda_u240 = gitLineHandler = new GitLineHandler(this.getProject(), this.getRepository().getRoot(), GitCommand.COMMIT);
        boolean bl2 = false;
        String[] stringArray = new String[]{"--no-verify", "-m", "fixup! " + this.commit.getId() + FIXUP_COMMIT_MESSAGE_SUFFIX};
        $this$createFixupCommit_u24lambda_u240.addParameters(stringArray);
        GitLineHandler handler = gitLineHandler;
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        GitCommandResult result2 = gitCommandResult;
        if (result2.success()) {
            bl = true;
        } else {
            this.notifyGitCommandFailed(result2);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean restoreChanges() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.changes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void change;
            Change change2 = (Change)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = change.getBeforeRevision();
            if (object == null || (object = object.getFile()) == null) {
                ContentRevision contentRevision = change.getAfterRevision();
                object = contentRevision != null ? contentRevision.getFile() : null;
                if (object == null) {
                    throw new IllegalStateException("Can't get a path from a change".toString());
                }
            }
            collection.add(object);
        }
        List paths = (List)destination$iv$iv;
        try {
            List list = this.commit.getParents();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParents(...)");
            if (!((Collection)list).isEmpty()) {
                GitFileUtils.restoreStagedAndWorktree(this.getProject(), this.getRepository().getRoot(), paths, this.commit.getId() + "~1");
            } else {
                GitFileUtils.deletePaths(this.getProject(), this.getRepository().getRoot(), paths, new String[0]);
            }
            return true;
        }
        catch (VcsException e) {
            this.notifyOperationFailed(e);
            return false;
        }
    }

    private final void notifyGitCommandFailed(GitCommandResult result2) {
        VcsNotifier.getInstance((Project)this.getProject()).notifyError("git.rebase.log.changes.drop.failed", GitBundle.message("rebase.log.changes.drop.failed.title", new Object[0]), result2.getErrorOutputAsHtmlString());
    }

    private final void notifyOperationFailed(VcsException exception) {
        VcsNotifier.getInstance((Project)this.getProject()).notifyError("git.rebase.log.changes.drop.failed", GitBundle.message("rebase.log.changes.drop.failed.title", new Object[0]), exception.getMessage());
    }

    /*
     * Unable to fully structure code
     */
    private final Object createGitChangesSaver(Continuation<? super GitChangesSaver> $completion) {
        if (!($completion instanceof createGitChangesSaver.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ GitDropSelectedChangesOperation this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GitDropSelectedChangesOperation.access$createGitChangesSaver(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                gitSettings = GitVcsSettings.getInstance(this.getProject());
                v0 = gitSettings.getSaveChangesPolicy();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getSaveChangesPolicy(...)");
                savePolicy = v0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)gitSettings);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)savePolicy);
                $continuation.label = 1;
                v1 = CoroutinesKt.coroutineToIndicator((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, createGitChangesSaver$lambda$0(git4idea.rebase.log.changes.GitDropSelectedChangesOperation git4idea.config.GitSaveChangesPolicy com.intellij.openapi.progress.ProgressIndicator ), (Lcom/intellij/openapi/progress/ProgressIndicator;)Lgit4idea/stash/GitChangesSaver;)((GitDropSelectedChangesOperation)this, (GitSaveChangesPolicy)savePolicy), (Continuation)$continuation);
                if (v1 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                savePolicy = (GitSaveChangesPolicy)$continuation.L$1;
                gitSettings = (GitVcsSettings)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl28:
                // 2 sources

                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"coroutineToIndicator(...)");
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final GitCommitEditingOperationResult execute$lambda$0(GitDropSelectedChangesOperation this$0) {
        return this$0.dropViaRebase();
    }

    private static final GitChangesSaver createGitChangesSaver$lambda$0(GitDropSelectedChangesOperation this$0, GitSaveChangesPolicy $savePolicy, ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Object[] objectArray = new Object[]{GitBundle.message("rebase.log.changes.action.operation.drop.name", new Object[0])};
        return GitChangesSaver.getSaver(this$0.getProject(), Git.getInstance(), indicator, VcsBundle.message((String)"stash.changes.message", (Object[])objectArray), $savePolicy);
    }

    public static final /* synthetic */ Object access$createGitChangesSaver(GitDropSelectedChangesOperation $this, Continuation $completion) {
        return $this.createGitChangesSaver((Continuation<? super GitChangesSaver>)$completion);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/rebase/log/changes/GitDropSelectedChangesOperation$Companion;", "", "<init>", "()V", "FIXUP_COMMIT_MESSAGE_SUFFIX", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

