/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.cleanup;

import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.table.JBTable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import git4idea.GitDisposable;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.branch.DeepComparator;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitBranchesCollection;
import git4idea.branch.GitNewBranchDialog;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.cleanup.CleanupBranchesDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultRowSorter;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f*\u0001\u001d\b\u0000\u0018\u00002\u00020\u0001:\b456789:;B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0013\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0 H\u0014\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020\u0017H\u0002J\u0016\u0010%\u001a\u00020\u00172\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007H\u0002J\b\u0010'\u001a\u00020\u0017H\u0002J\b\u0010(\u001a\u00020\u0017H\u0002J\b\u0010)\u001a\u00020\u0017H\u0002J\b\u0010*\u001a\u00020\u0017H\u0002J\b\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020\u0017H\u0002J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020\u0017H\u0002J\b\u00102\u001a\u00020\u0017H\u0002J\u000e\u00103\u001a\u0004\u0018\u00010\f*\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001e\u00a8\u0006<"}, d2={"Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "repositories", "", "Lgit4idea/repo/GitRepository;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "localBranchNames", "", "targetBranchField", "Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "branchPrefixes", "prefixField", "tableModel", "Lcom/intellij/util/ui/ListTableModel;", "Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog$BranchRow;", "table", "Lcom/intellij/ui/table/JBTable;", "installLastCommitDateColumnRenderer", "", "headerCheckBox", "Lcom/intellij/util/ui/ThreeStateCheckBox;", "deleteActionRef", "Ljavax/swing/Action;", "tableCopyProvider", "git4idea/ui/branch/cleanup/CleanupBranchesDialog$tableCopyProvider$1", "Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog$tableCopyProvider$1;", "createActions", "", "()[Ljavax/swing/Action;", "createCenterPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "refreshBranches", "populateLastCommitDates", "rows", "deleteSelectedBranches", "updateDeleteButtonEnabled", "calculateMergeStatus", "installHeaderCheckbox", "getSelectedColumnViewIndex", "", "setSelectedColumnMinimalWidth", "setAllRowsSelected", "value", "", "updateHeaderCheckboxState", "installSpaceToggleForSelectedRows", "getDefaultTargetBranchSuggestion", "DeleteBranchesAction", "CalculateMergeStatusAction", "BranchRow", "SelectedColumn", "NameColumn", "LastCommitDateColumn", "TrackedBranchColumn", "MergedStatusColumn", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nCleanupBranchesDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CleanupBranchesDialog.kt\ngit4idea/ui/branch/cleanup/CleanupBranchesDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,626:1\n1#2:627\n672#3:628\n756#3,4:629\n777#4:633\n873#4,2:634\n1512#4:636\n1538#4,3:637\n1541#4,3:647\n1266#4,2:652\n1586#4:654\n1661#4,3:655\n1269#4:658\n1807#4,3:659\n777#4:662\n873#4,2:663\n1300#4,2:665\n1315#4,4:667\n1915#4,2:671\n1834#4,4:673\n383#5,7:640\n466#5:650\n415#5:651\n*S KotlinDebug\n*F\n+ 1 CleanupBranchesDialog.kt\ngit4idea/ui/branch/cleanup/CleanupBranchesDialog\n*L\n224#1:628\n224#1:629,4\n319#1:633\n319#1:634,2\n327#1:636\n327#1:637,3\n327#1:647,3\n327#1:652,2\n327#1:654\n327#1:655,3\n327#1:658\n336#1:659,3\n351#1:662\n351#1:663,2\n351#1:665,2\n351#1:667,4\n509#1:671,2\n519#1:673,4\n327#1:640,7\n327#1:650\n327#1:651\n*E\n"})
public final class CleanupBranchesDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final List<GitRepository> repositories;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final List<String> localBranchNames;
    @NotNull
    private final TextFieldWithCompletion targetBranchField;
    @NotNull
    private final List<String> branchPrefixes;
    @NotNull
    private final TextFieldWithCompletion prefixField;
    @NotNull
    private final ListTableModel<BranchRow> tableModel;
    @NotNull
    private final JBTable table;
    @NotNull
    private final ThreeStateCheckBox headerCheckBox;
    private Action deleteActionRef;
    @NotNull
    private final tableCopyProvider.1 tableCopyProvider;

    /*
     * WARNING - void declaration
     */
    public CleanupBranchesDialog(@NotNull Project project) {
        void $this$headerCheckBox_u24lambda_u240;
        void $this$table_u24lambda_u240_u240;
        JBTable $this$table_u24lambda_u240;
        JBTable $this$prefixField_u24lambda_u240;
        JBTable jBTable;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, true);
        this.project = project;
        List<GitRepository> list = GitRepositoryManager.getInstance(this.project).getRepositories();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
        this.repositories = list;
        this.cs = GitDisposable.Companion.getInstance(this.project).childScope("CleanupBranchesDialog");
        this.localBranchNames = SequencesKt.toList((Sequence)SequencesKt.sorted((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.repositories), CleanupBranchesDialog::localBranchNames$lambda$0), (Function1)((Function1)localBranchNames.2.INSTANCE)))));
        TextCompletionProvider textCompletionProvider = (TextCompletionProvider)new GitNewBranchDialog.BranchNamesCompletion(this.localBranchNames, this.localBranchNames);
        String string = this.getDefaultTargetBranchSuggestion(this.project);
        if (string == null) {
            string = "";
        }
        this.targetBranchField = new TextFieldWithCompletion(this.project, textCompletionProvider, string, true, true, false, false);
        this.branchPrefixes = CollectionsKt.toList((Iterable)GitNewBranchDialog.Companion.collectDirectories$intellij_vcs_git((Iterable<String>)this.localBranchNames, false));
        JBTable jBTable2 = jBTable = new TextFieldWithCompletion(this.project, (TextCompletionProvider)new GitNewBranchDialog.BranchNamesCompletion(this.branchPrefixes, this.branchPrefixes), "", true, true, false, false);
        CleanupBranchesDialog cleanupBranchesDialog = this;
        boolean bl = false;
        $this$prefixField_u24lambda_u240.setMinimumSize((Dimension)JBUI.size((int)200, (int)0));
        cleanupBranchesDialog.prefixField = jBTable;
        jBTable = new JBTable[]{new SelectedColumn(), new NameColumn(), new LastCommitDateColumn(), new TrackedBranchColumn(), new MergedStatusColumn()};
        this.tableModel = new ListTableModel((ColumnInfo[])jBTable, (List)new ArrayList(), 1);
        $this$prefixField_u24lambda_u240 = jBTable = new JBTable((TableModel)this.tableModel);
        cleanupBranchesDialog = this;
        boolean bl2 = false;
        $this$table_u24lambda_u240.setShowGrid(false);
        $this$table_u24lambda_u240.setAutoCreateRowSorter(false);
        $this$table_u24lambda_u240.getTableHeader().setReorderingAllowed(true);
        TableRowSorter<TableModel> tableRowSorter = new TableRowSorter<TableModel>($this$table_u24lambda_u240.getModel());
        RowSorter rowSorter = tableRowSorter;
        void var7_8 = $this$table_u24lambda_u240;
        boolean bl3 = false;
        $this$table_u24lambda_u240_u240.setSortsOnUpdates(true);
        var7_8.setRowSorter((RowSorter)tableRowSorter);
        $this$table_u24lambda_u240.setDefaultRenderer(Boolean.TYPE, (TableCellRenderer)new BooleanTableCellRenderer());
        $this$table_u24lambda_u240.setDefaultEditor(Boolean.TYPE, (TableCellEditor)new BooleanTableCellEditor());
        $this$table_u24lambda_u240.setDefaultRenderer(Long.TYPE, (TableCellRenderer)new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
                Long l = value instanceof Long ? (Long)value : null;
                long ts = l != null ? l : Long.MIN_VALUE;
                String string = ts != Long.MIN_VALUE ? DateFormatUtil.formatDateTime((long)ts) : "";
                Intrinsics.checkNotNull((Object)string);
                String text2 = string;
                Component component2 = super.getTableCellRendererComponent(table2, text2, isSelected, hasFocus, row, column);
                Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getTableCellRendererComponent(...)");
                return component2;
            }
        });
        rowSorter = $this$table_u24lambda_u240.getRowSorter();
        RowSorter rowSorter2 = rowSorter instanceof TableRowSorter ? rowSorter : null;
        if (rowSorter2 != null) {
            ((DefaultRowSorter)rowSorter2).setSortable(0, false);
        }
        rowSorter = $this$table_u24lambda_u240.getRowSorter();
        TableRowSorter tableRowSorter2 = rowSorter instanceof TableRowSorter ? (TableRowSorter)rowSorter : null;
        if (tableRowSorter2 != null) {
            tableRowSorter2.setSortable(2, true);
        }
        $this$table_u24lambda_u240.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)900, (int)300));
        $this$table_u24lambda_u240.getSelectionModel().setSelectionMode(2);
        cleanupBranchesDialog.table = jBTable;
        $this$table_u24lambda_u240 = jBTable = new ThreeStateCheckBox();
        cleanupBranchesDialog = this;
        boolean bl4 = false;
        $this$headerCheckBox_u24lambda_u240.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        $this$headerCheckBox_u24lambda_u240.setOpaque(false);
        cleanupBranchesDialog.headerCheckBox = jBTable;
        this.setTitle(GitBundle.message("git.cleanup.branches.dialog.title", new Object[0]));
        this.setOKButtonText(GitBundle.message("git.cleanup.branches.close", new Object[0]));
        this.setModal(false);
        this.init();
        this.tableModel.addTableModelListener(arg_0 -> CleanupBranchesDialog._init_$lambda$0(this, arg_0));
        this.installHeaderCheckbox();
        this.installLastCommitDateColumnRenderer();
        this.installSpaceToggleForSelectedRows();
        this.refreshBranches();
        this.tableCopyProvider = new CopyProvider(this){
            final /* synthetic */ CleanupBranchesDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public void performCopy(DataContext dataContext) {
                Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                int[] selected = CleanupBranchesDialog.access$getTable$p(this.this$0).getSelectedRows();
                Intrinsics.checkNotNull((Object)selected);
                if (selected.length == 0) {
                    return;
                }
                StringBuilder sb = new StringBuilder();
                int[] nArray = selected;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    String tracked;
                    int i2 = i;
                    int viewRow = nArray[i];
                    int modelRow = CleanupBranchesDialog.access$getTable$p(this.this$0).convertRowIndexToModel(viewRow);
                    boolean bl = 0 <= modelRow ? modelRow < CleanupBranchesDialog.access$getTableModel$p(this.this$0).getRowCount() : false;
                    if (!bl) continue;
                    BranchRow row = (BranchRow)CleanupBranchesDialog.access$getTableModel$p(this.this$0).getItems().get(modelRow);
                    String name = row.getBranch().getName();
                    long ts = row.getLastCommitDate();
                    String string = ts != Long.MIN_VALUE ? DateFormatUtil.formatDateTime((long)ts) : "";
                    Intrinsics.checkNotNull((Object)string);
                    String date = string;
                    String string2 = row.getTrackedBranch();
                    if (string2 == null) {
                        string2 = tracked = "";
                    }
                    if (i2 > 0) {
                        sb.append('\n');
                    }
                    sb.append(name).append('\t').append(date).append('\t').append(tracked);
                }
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(sb.toString()));
            }

            public boolean isCopyEnabled(DataContext dataContext) {
                Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                return CleanupBranchesDialog.access$getTable$p(this.this$0).getSelectedRowCount() > 0;
            }

            public boolean isCopyVisible(DataContext dataContext) {
                Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                return true;
            }
        };
    }

    private final void installLastCommitDateColumnRenderer() {
        int modelIndex = 2;
        int viewIndex = this.table.convertColumnIndexToView(modelIndex);
        if (viewIndex < 0) {
            return;
        }
        TableColumn column = this.table.getColumnModel().getColumn(viewIndex);
        column.setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
                Long l = value instanceof Long ? (Long)value : null;
                long ts = l != null ? l : Long.MIN_VALUE;
                String string = ts != Long.MIN_VALUE ? DateFormatUtil.formatDateTime((long)ts) : "";
                Intrinsics.checkNotNull((Object)string);
                String text2 = string;
                Component component2 = super.getTableCellRendererComponent(table2, text2, isSelected, hasFocus, row, column);
                Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getTableCellRendererComponent(...)");
                return component2;
            }
        });
    }

    @NotNull
    protected Action[] createActions() {
        String string = GitBundle.message("git.cleanup.branches.delete", new Object[0]);
        DialogWrapper.DialogWrapperAction deleteAction2 = new DialogWrapper.DialogWrapperAction(this, string){
            final /* synthetic */ CleanupBranchesDialog this$0;
            {
                this.this$0 = $receiver;
                super((DialogWrapper)$receiver, $super_call_param$1);
            }

            protected void doAction(ActionEvent e) {
                ActionUtil.performAction((AnAction)this.this$0.new DeleteBranchesAction(), (AnActionEvent)ActionUtil.createEmptyEvent());
            }
        };
        this.deleteActionRef = (Action)deleteAction2;
        deleteAction2.setEnabled(false);
        Action[] actionArray = GitBundle.message("git.cleanup.branches.calculate", new Object[0]);
        DialogWrapper.DialogWrapperAction calcAction2 = new DialogWrapper.DialogWrapperAction(this, (String)actionArray){
            final /* synthetic */ CleanupBranchesDialog this$0;
            {
                this.this$0 = $receiver;
                super((DialogWrapper)$receiver, $super_call_param$1);
            }

            protected void doAction(ActionEvent e) {
                ActionUtil.performAction((AnAction)this.this$0.new CalculateMergeStatusAction(), (AnActionEvent)ActionUtil.createEmptyEvent());
            }
        };
        actionArray = new Action[3];
        actionArray[0] = deleteAction2;
        actionArray[1] = calcAction2;
        Intrinsics.checkNotNullExpressionValue((Object)this.getOKAction(), (String)"getOKAction(...)");
        return actionArray;
    }

    @NotNull
    protected DialogPanel createCenterPanel() {
        DialogPanel dialogPanel;
        DialogPanel $this$createCenterPanel_u24lambda_u241 = dialogPanel = BuilderKt.panel(arg_0 -> CleanupBranchesDialog.createCenterPanel$lambda$0(this, arg_0));
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u241.setPreferredSize((Dimension)JBUI.size((int)900, (int)400));
        return dialogPanel;
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshBranches() {
        void $this$associateTo$iv$iv;
        String string = this.prefixField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String prefix = ((Object)StringsKt.trim((CharSequence)string)).toString();
        List list = this.tableModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        Sequence $this$associate$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), CleanupBranchesDialog::refreshBranches$lambda$0);
        boolean $i$f$associate = false;
        Sequence sequence = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            BranchRow it = (BranchRow)element$iv$iv;
            boolean bl = false;
            it = TuplesKt.to((Object)TuplesKt.to((Object)it.getRepository(), (Object)it.getBranch().getName()), (Object)it.getMergedStatus());
            map2.put(it.getFirst(), it.getSecond());
        }
        Map prevMergeStatuses = destination$iv$iv;
        List rows = new ArrayList();
        for (GitRepository repo : this.repositories) {
            Collection<GitLocalBranch> locals;
            Intrinsics.checkNotNullExpressionValue(repo.getBranches().getLocalBranches(), (String)"getLocalBranches(...)");
            for (GitLocalBranch branch : locals) {
                String string2;
                Object tracked;
                String name = branch.getName();
                if (((CharSequence)prefix).length() > 0 && !StringsKt.startsWith$default((String)name, (String)prefix, (boolean)false, (int)2, null)) continue;
                Object object = branch.findTrackedBranch(repo);
                if (object == null || (object = ((GitReference)object).getName()) == null) {
                    object = tracked = "";
                }
                if ((string2 = (String)prevMergeStatuses.get(TuplesKt.to((Object)repo, (Object)name))) == null) {
                    string2 = "";
                }
                String merged = string2;
                Collection collection = rows;
                Intrinsics.checkNotNull((Object)branch);
                collection.add(new BranchRow(repo, branch, false, Long.MIN_VALUE, (String)tracked, merged));
            }
        }
        this.tableModel.setItems(rows);
        this.updateHeaderCheckboxState();
        this.table.getTableHeader().repaint();
        this.setSelectedColumnMinimalWidth();
        this.updateDeleteButtonEnabled();
        this.populateLastCommitDates(rows);
    }

    private final void populateLastCommitDates(List<BranchRow> rows) {
        if (rows.isEmpty()) {
            return;
        }
        VcsProjectLog.Companion.runWhenLogIsReady(this.project, arg_0 -> CleanupBranchesDialog.populateLastCommitDates$lambda$0(this, rows, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteSelectedBranches() {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map.Entry $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Object[] $this$filterTo$iv$iv;
        List list = this.tableModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            BranchRow it = (BranchRow)t;
            boolean bl = false;
            if (!it.getSelected()) continue;
            destination$iv$iv.add(t);
        }
        List toDelete = (List)destination$iv$iv;
        if (toDelete.isEmpty()) {
            return;
        }
        String branchNames = CollectionsKt.joinToString$default((Iterable)toDelete, (CharSequence)"\n", null, null, (int)0, null, CleanupBranchesDialog::deleteSelectedBranches$lambda$1, (int)30, null);
        $this$filterTo$iv$iv = new Object[]{toDelete.size(), branchNames};
        int result2 = Messages.showYesNoDialog((Project)this.project, (String)GitBundle.message("git.cleanup.branches.delete.confirm.text", $this$filterTo$iv$iv), (String)GitBundle.message("git.cleanup.branches.delete.confirm.title", new Object[0]), (String)GitBundle.message("git.cleanup.branches.delete.confirm.yes", new Object[0]), (String)GitBundle.message("git.cleanup.branches.delete.confirm.no", new Object[0]), null);
        if (result2 != 0) {
            return;
        }
        Object $this$groupBy$iv = toDelete;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map map2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            BranchRow it = (BranchRow)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getBranch().getName();
            Map map3 = map2;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = map2;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        Map map4 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable bl = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = map4;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void it$iv$iv;
            $this$getOrPut$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map5 = destination$iv$iv$iv;
            boolean bl3 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map6 = map5;
            boolean bl4 = false;
            List rows = (List)entry.getValue();
            Iterable $this$map$iv = rows;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BranchRow branchRow = (BranchRow)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl5 = false;
                collection.add(it.getRepository());
            }
            List list2 = (List)destination$iv$iv3;
            map6.put(k, list2);
        }
        Map branchesToRepos = destination$iv$iv$iv;
        GitBrancher brancher = GitBrancher.getInstance(this.project);
        brancher.deleteBranches(branchesToRepos, this::refreshBranches);
    }

    private final void updateDeleteButtonEnabled() {
        if (this.deleteActionRef != null) {
            Action action;
            boolean anySelected;
            block5: {
                List list = this.tableModel.getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BranchRow it = (BranchRow)element$iv;
                        boolean bl = false;
                        if (!it.getSelected()) continue;
                        v1 = true;
                        break block5;
                    }
                    v1 = anySelected = false;
                }
            }
            if ((action = this.deleteActionRef) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"deleteActionRef");
                action = null;
            }
            action.setEnabled(anySelected);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateMergeStatus() {
        void $this$associateWithTo$iv$iv;
        void $this$filterTo$iv$iv;
        String string;
        String string2 = this.targetBranchField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String it = string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        boolean $i$a$-takeIf-CleanupBranchesDialog$calculateMergeStatus$targetBranch$22 = false;
        String string3 = ((CharSequence)it).length() > 0 ? string : null;
        if (string3 == null) {
            return;
        }
        String targetBranch = string3;
        Iterable $this$filter$iv = this.repositories;
        boolean $i$f$filter = false;
        Iterable $i$a$-takeIf-CleanupBranchesDialog$calculateMergeStatus$targetBranch$22 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GitRepository it2 = (GitRepository)element$iv$iv;
            boolean bl = false;
            if (!(it2.getBranches().findLocalBranch(targetBranch) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        destination$iv$iv = $this$associateWith$iv;
        Map destination$iv$iv2 = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            GitRepository bl = (GitRepository)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl2 = false;
            String string4 = targetBranch;
            map2.put(t, string4);
        }
        Map reposWithTarget = destination$iv$iv2;
        ModalTaskOwner modalTaskOwner = ModalTaskOwner.component((Component)this.getContentPane());
        Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"component(...)");
        String string5 = GitBundle.message("git.cleanup.branches.calculate.progress", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        TasksKt.runWithModalProgressBlocking((ModalTaskOwner)modalTaskOwner, (String)string5, (TaskCancellation)((TaskCancellation)TaskCancellation.Companion.cancellable()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (Map<GitRepository, String>)reposWithTarget, null){
            int label;
            final /* synthetic */ CleanupBranchesDialog this$0;
            final /* synthetic */ Map<GitRepository, String> $reposWithTarget;
            {
                this.this$0 = $receiver;
                this.$reposWithTarget = $reposWithTarget;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.coroutineToIndicator(arg_0 -> calculateMergeStatus.1.invokeSuspend$lambda$0(this.this$0, this.$reposWithTarget, arg_0), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Boolean invokeSuspend$lambda$0$1$0(ProgressIndicator $indicator, CleanupBranchesDialog this$0, VcsLogData $dataProvider, Map $reposWithTarget, BranchRow $row, Ref.IntRef $processed, int $total) {
                String string;
                boolean merged;
                $indicator.checkCanceled();
                DeepComparator comparator = new DeepComparator(CleanupBranchesDialog.access$getProject$p(this$0), $dataProvider, $dataProvider.getGraphData(), $reposWithTarget, $row.getBranch().getName());
                DeepComparator.ComparatorResult result2 = comparator.compare();
                $indicator.checkCanceled();
                boolean bl = merged = result2.getException() == null && result2.getNonPickedCommits().isEmpty();
                if (merged) {
                    String string2 = GitBundle.message("git.cleanup.branches.status.merged", new Object[0]);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                } else {
                    String string3 = GitBundle.message("git.cleanup.branches.status.not.merged", new Object[0]);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                }
                $row.setMergedStatus(string);
                int n = $processed.element;
                $processed.element = n + 1;
                Object[] objectArray = new Object[]{$processed.element, $total};
                $indicator.setText(GitBundle.message("find.merged.local.branches.progress.processed", objectArray));
                $indicator.setFraction((double)$processed.element / (double)$total);
                return merged;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private static final Unit invokeSuspend$lambda$0(CleanupBranchesDialog this$0, Map $reposWithTarget, ProgressIndicator indicator) {
                VcsLogData vcsLogData = VcsProjectLog.Companion.getInstance(CleanupBranchesDialog.access$getProject$p(this$0)).getDataManager();
                if (vcsLogData == null) {
                    return Unit.INSTANCE;
                }
                VcsLogData dataProvider = vcsLogData;
                int threadsCount = RangesKt.coerceAtMost((int)Runtime.getRuntime().availableProcessors(), (int)5);
                ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Cleanup Branches Status", (int)threadsCount);
                Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
                ExecutorService pool = executorService;
                try {
                    void $this$mapTo$iv$iv;
                    Object element$iv$iv2;
                    void $this$filterTo$iv$iv;
                    List list = CleanupBranchesDialog.access$getTableModel$p(this$0).getItems();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
                    Iterable $this$filter$iv = list;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                        BranchRow it = (BranchRow)element$iv$iv2;
                        boolean bl = false;
                        if (!StringsKt.isBlank((CharSequence)it.getMergedStatus())) continue;
                        destination$iv$iv.add(element$iv$iv2);
                    }
                    List rows = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                    int total = rows.size();
                    Ref.IntRef processed = new Ref.IntRef();
                    ExecutorCompletionService<Boolean> completion = new ExecutorCompletionService<Boolean>(pool);
                    Iterable $this$map$iv = rows;
                    boolean $i$f$map = false;
                    element$iv$iv2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void row;
                        BranchRow branchRow = (BranchRow)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl = false;
                        collection.add(completion.submit(() -> calculateMergeStatus.1.invokeSuspend$lambda$0$1$0(indicator, this$0, dataProvider, $reposWithTarget, (BranchRow)row, processed, total)));
                    }
                    List tasks = (List)destination$iv$iv2;
                    try {
                        int completed = 0;
                        while (completed < tasks.size()) {
                            indicator.checkCanceled();
                            Future<V> finished = completion.poll(100L, TimeUnit.MILLISECONDS);
                            if (finished == null) continue;
                            finished.get();
                            ++completed;
                        }
                    }
                    catch (ProcessCanceledException e) {
                        Iterable $this$forEach$iv = tasks;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Future it = (Future)element$iv;
                            boolean bl = false;
                            it.cancel(true);
                        }
                        pool.shutdownNow();
                        throw e;
                    }
                    pool.shutdown();
                }
                catch (Throwable throwable) {
                    pool.shutdown();
                    BuildersKt.launch$default((CoroutineScope)CleanupBranchesDialog.access$getCs$p(this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
                        int label;
                        final /* synthetic */ CleanupBranchesDialog this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    CoroutineContext coroutineContext = com.intellij.openapi.application.CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                                    ModalityState modalityState = ModalityState.any();
                                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                                    this.label = 1;
                                    Object object2 = BuildersKt.withContext((CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                        int label;
                                        final /* synthetic */ CleanupBranchesDialog this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(2, $completion);
                                        }

                                        public final Object invokeSuspend(Object $result) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    if (!this.this$0.getContentPane().isShowing()) {
                                                        return Unit.INSTANCE;
                                                    }
                                                    if (CleanupBranchesDialog.access$getTableModel$p(this.this$0).getRowCount() > 0) {
                                                        CleanupBranchesDialog.access$getTableModel$p(this.this$0).fireTableRowsUpdated(0, CleanupBranchesDialog.access$getTableModel$p(this.this$0).getRowCount() - 1);
                                                    }
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation)((Continuation)this));
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    throw throwable;
                }
                BuildersKt.launch$default((CoroutineScope)CleanupBranchesDialog.access$getCs$p(this$0), null, null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)3, null);
                return Unit.INSTANCE;
            }
        }));
    }

    private final void installHeaderCheckbox() {
        this.tableModel.addTableModelListener(arg_0 -> CleanupBranchesDialog.installHeaderCheckbox$lambda$0(this, arg_0));
        JTableHeader header = this.table.getTableHeader();
        CleanupBranchesDialog.installHeaderCheckbox$applyHeaderRenderer(this, header);
        header.addMouseListener(new MouseAdapter(this, header){
            final /* synthetic */ CleanupBranchesDialog this$0;
            final /* synthetic */ JTableHeader $header;
            {
                this.this$0 = $receiver;
                this.$header = $header;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int viewIndex = CleanupBranchesDialog.access$getSelectedColumnViewIndex(this.this$0);
                if (viewIndex < 0) {
                    return;
                }
                int colAtX = this.$header.getColumnModel().getColumnIndexAtX(e.getX());
                if (colAtX != viewIndex) {
                    return;
                }
                boolean selectAll = CleanupBranchesDialog.access$getHeaderCheckBox$p(this.this$0).getState() != ThreeStateCheckBox.State.SELECTED;
                CleanupBranchesDialog.access$setAllRowsSelected(this.this$0, selectAll);
                CleanupBranchesDialog.access$updateHeaderCheckboxState(this.this$0);
                this.$header.repaint(this.$header.getHeaderRect(viewIndex));
            }
        });
        header.getColumnModel().addColumnModelListener(new TableColumnModelListener(this, header){
            final /* synthetic */ CleanupBranchesDialog this$0;
            final /* synthetic */ JTableHeader $header;
            {
                this.this$0 = $receiver;
                this.$header = $header;
            }

            public void columnAdded(TableColumnModelEvent e) {
                CleanupBranchesDialog.access$installHeaderCheckbox$applyHeaderRenderer(this.this$0, this.$header);
            }

            public void columnRemoved(TableColumnModelEvent e) {
                CleanupBranchesDialog.access$installHeaderCheckbox$applyHeaderRenderer(this.this$0, this.$header);
            }

            public void columnMoved(TableColumnModelEvent e) {
                CleanupBranchesDialog.access$installHeaderCheckbox$applyHeaderRenderer(this.this$0, this.$header);
            }

            public void columnMarginChanged(ChangeEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    private final int getSelectedColumnViewIndex() {
        return this.table.convertColumnIndexToView(0);
    }

    private final void setSelectedColumnMinimalWidth() {
        int n;
        int viewIndex = this.getSelectedColumnViewIndex();
        if (viewIndex < 0) {
            return;
        }
        TableColumn column = this.table.getColumnModel().getColumn(viewIndex);
        if (this.tableModel.getRowCount() > 0) {
            TableCellRenderer cellRenderer = this.table.getDefaultRenderer(Boolean.TYPE);
            Component comp = cellRenderer.getTableCellRendererComponent((JTable)this.table, false, false, false, 0, viewIndex);
            n = comp.getPreferredSize().width;
        } else {
            n = new JCheckBox().getPreferredSize().width;
        }
        int cellWidth = n;
        int headerWidth = this.headerCheckBox.getPreferredSize().width;
        int padding = JBUI.scale((int)12);
        int width = Math.max(cellWidth, headerWidth) + padding;
        column.setMinWidth(width);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
    }

    private final void setAllRowsSelected(boolean value) {
        if (this.tableModel.getRowCount() == 0) {
            return;
        }
        List list = this.tableModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BranchRow it = (BranchRow)element$iv;
            boolean bl = false;
            it.setSelected(value);
        }
        this.tableModel.fireTableRowsUpdated(0, this.tableModel.getRowCount() - 1);
    }

    private final void updateHeaderCheckboxState() {
        int selectedCount;
        int n;
        int total = this.tableModel.getRowCount();
        if (total == 0) {
            this.headerCheckBox.setState(ThreeStateCheckBox.State.NOT_SELECTED);
            return;
        }
        List list = this.tableModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        Iterable $this$count$iv = list;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                BranchRow it = (BranchRow)element$iv;
                boolean bl = false;
                if (!it.getSelected() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n2 = selectedCount = n;
        this.headerCheckBox.setState(n2 == 0 ? ThreeStateCheckBox.State.NOT_SELECTED : (n2 == total ? ThreeStateCheckBox.State.SELECTED : ThreeStateCheckBox.State.DONT_CARE));
    }

    private final void installSpaceToggleForSelectedRows() {
        InputMap im = this.table.getInputMap(1);
        ActionMap am = this.table.getActionMap();
        String actionKey = "toggle-selected-rows";
        im.put(KeyStroke.getKeyStroke("SPACE"), actionKey);
        am.put(actionKey, new AbstractAction(this){
            final /* synthetic */ CleanupBranchesDialog this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(ActionEvent e) {
                boolean bl;
                int[] rowsToAffect;
                block10: {
                    void $this$all$iv;
                    int n;
                    CleanupBranchesDialog $this$filterTo$iv$iv;
                    int $i$f$filterTo;
                    TableCellEditor editor;
                    if (CleanupBranchesDialog.access$getTable$p(this.this$0).isEditing() && (editor = CleanupBranchesDialog.access$getTable$p(this.this$0).getCellEditor()) != null && !editor.stopCellEditing()) {
                        editor.cancelCellEditing();
                    }
                    int[] selectedViewRows = CleanupBranchesDialog.access$getTable$p(this.this$0).getSelectedRows();
                    Intrinsics.checkNotNull((Object)selectedViewRows);
                    if (!(selectedViewRows.length == 0)) {
                        v0 = selectedViewRows;
                    } else {
                        int[] nArray = new int[]{CleanupBranchesDialog.access$getTable$p(this.this$0).getSelectionModel().getLeadSelectionIndex()};
                        int[] $this$filter$iv = nArray;
                        boolean $i$f$filter = false;
                        int[] nArray2 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = 0;
                        int n2 = ((CleanupBranchesDialog)$this$filterTo$iv$iv).length;
                        for (n = 0; n < n2; ++n) {
                            CleanupBranchesDialog element$iv$iv;
                            CleanupBranchesDialog it = element$iv$iv = $this$filterTo$iv$iv[n];
                            boolean bl2 = false;
                            if (!(it >= 0)) continue;
                            destination$iv$iv.add((int)element$iv$iv);
                        }
                        v0 = rowsToAffect = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
                    }
                    if (rowsToAffect.length == 0) {
                        return;
                    }
                    int[] $i$f$filter = rowsToAffect;
                    $this$filterTo$iv$iv = this.this$0;
                    boolean $i$f$all = false;
                    n = ((void)$this$all$iv).length;
                    for ($i$f$filterTo = 0; $i$f$filterTo < n; ++$i$f$filterTo) {
                        void element$iv;
                        void viewRow = element$iv = $this$all$iv[$i$f$filterTo];
                        boolean bl3 = false;
                        int modelRow = CleanupBranchesDialog.access$getTable$p($this$filterTo$iv$iv).convertRowIndexToModel((int)viewRow);
                        if ((0 <= modelRow ? modelRow < CleanupBranchesDialog.access$getTableModel$p($this$filterTo$iv$iv).getRowCount() : false) && ((BranchRow)CleanupBranchesDialog.access$getTableModel$p($this$filterTo$iv$iv).getItems().get(modelRow)).getSelected()) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
                boolean allChecked = bl;
                boolean target = !allChecked;
                int minChanged = Integer.MAX_VALUE;
                int maxChanged = Integer.MIN_VALUE;
                for (int viewRow : rowsToAffect) {
                    BranchRow item;
                    int modelRow = CleanupBranchesDialog.access$getTable$p(this.this$0).convertRowIndexToModel(viewRow);
                    boolean bl4 = 0 <= modelRow ? modelRow < CleanupBranchesDialog.access$getTableModel$p(this.this$0).getRowCount() : false;
                    if (!bl4 || (item = (BranchRow)CleanupBranchesDialog.access$getTableModel$p(this.this$0).getItems().get(modelRow)).getSelected() == target) continue;
                    item.setSelected(target);
                    minChanged = Math.min(minChanged, modelRow);
                    maxChanged = Math.max(maxChanged, modelRow);
                }
                if (minChanged != Integer.MAX_VALUE) {
                    CleanupBranchesDialog.access$getTableModel$p(this.this$0).fireTableRowsUpdated(minChanged, maxChanged);
                }
                CleanupBranchesDialog.access$updateHeaderCheckboxState(this.this$0);
                int viewIndex = CleanupBranchesDialog.access$getSelectedColumnViewIndex(this.this$0);
                if (viewIndex >= 0) {
                    CleanupBranchesDialog.access$getTable$p(this.this$0).getTableHeader().repaint(CleanupBranchesDialog.access$getTable$p(this.this$0).getTableHeader().getHeaderRect(viewIndex));
                } else {
                    CleanupBranchesDialog.access$getTable$p(this.this$0).getTableHeader().repaint();
                }
            }
        });
    }

    private final String getDefaultTargetBranchSuggestion(Project $this$getDefaultTargetBranchSuggestion) {
        Object object;
        block5: {
            Object object2;
            GitRepository repo;
            block4: {
                Object v2;
                block3: {
                    List<GitRepository> list = GitRepositoryManager.getInstance($this$getDefaultTargetBranchSuggestion).getRepositories();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
                    repo = (GitRepository)CollectionsKt.firstOrNull(list);
                    object = repo;
                    if (object == null || (object = object.getBranches()) == null || (object = ((GitBranchesCollection)object).getLocalBranches()) == null) break block4;
                    Iterable iterable = (Iterable)object;
                    for (Object t : iterable) {
                        GitLocalBranch it = (GitLocalBranch)t;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"master") || Intrinsics.areEqual((Object)it.getName(), (Object)"main"))) continue;
                        v2 = t;
                        break block3;
                    }
                    v2 = null;
                }
                if ((object = (GitLocalBranch)v2) != null && (object = ((GitReference)object).getName()) != null) break block5;
            }
            object = (object2 = repo) != null && (object2 = object2.getCurrentBranch()) != null ? ((GitReference)object2).getName() : null;
        }
        return object;
    }

    private static final Sequence localBranchNames$lambda$0(GitRepository it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Collection<GitLocalBranch> collection = it.getBranches().getLocalBranches();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getLocalBranches(...)");
        return CollectionsKt.asSequence((Iterable)collection);
    }

    private static final void _init_$lambda$0(CleanupBranchesDialog this$0, TableModelEvent tableModelEvent) {
        this$0.updateDeleteButtonEnabled();
    }

    private static final Unit createCenterPanel$lambda$0$0$0(TextFieldWithCompletion $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.selectAll();
        return Unit.INSTANCE;
    }

    private static final void createCenterPanel$lambda$0$1$0(CleanupBranchesDialog this$0, ActionEvent it) {
        this$0.refreshBranches();
    }

    private static final void createCenterPanel$lambda$0$2$0(CleanupBranchesDialog this$0, DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = PlatformDataKeys.COPY_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"COPY_PROVIDER");
        sink.set(dataKey, (Object)this$0.tableCopyProvider);
    }

    private static final Unit createCenterPanel$lambda$0$0(CleanupBranchesDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell.comment$default((Cell)$this$row.cell((JComponent)this$0.targetBranchField).align((Align)AlignX.FILL.INSTANCE).focused().applyToComponent(CleanupBranchesDialog::createCenterPanel$lambda$0$0$0), (String)GitBundle.message("find.merged.local.branches.target.comment", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1(CleanupBranchesDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell.comment$default((Cell)$this$row.cell((JComponent)this$0.prefixField).align((Align)AlignX.FILL.INSTANCE), (String)GitBundle.message("git.cleanup.branches.filter.prefix.comment", new Object[0]), (int)0, null, (int)6, null);
        JButton filter = new JButton(GitBundle.message("git.cleanup.branches.filter", new Object[0]));
        filter.addActionListener(arg_0 -> CleanupBranchesDialog.createCenterPanel$lambda$0$1$0(this$0, arg_0));
        $this$row.cell((JComponent)filter);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2(CleanupBranchesDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)((JTable)this$0.table)).disableAddAction().disableRemoveAction();
        Intrinsics.checkNotNullExpressionValue((Object)toolbarDecorator, (String)"disableRemoveAction(...)");
        ToolbarDecorator decorator = toolbarDecorator;
        JPanel jPanel = decorator.createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel tablePanel = jPanel;
        JComponent wrapped = UiDataProvider.Companion.wrapComponent((JComponent)tablePanel, arg_0 -> CleanupBranchesDialog.createCenterPanel$lambda$0$2$0(this$0, arg_0));
        $this$row.cell(wrapped).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0(CleanupBranchesDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = GitBundle.message("find.merged.local.branches.target.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> CleanupBranchesDialog.createCenterPanel$lambda$0$0(this$0, arg_0));
        String string2 = GitBundle.message("git.cleanup.branches.filter.prefix.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> CleanupBranchesDialog.createCenterPanel$lambda$0$1(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CleanupBranchesDialog.createCenterPanel$lambda$0$2(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final boolean refreshBranches$lambda$0(BranchRow it) {
        return !StringsKt.isBlank((CharSequence)it.getMergedStatus());
    }

    private static final Unit populateLastCommitDates$lambda$0(CleanupBranchesDialog this$0, List $rows, VcsLogManager logManager) {
        Intrinsics.checkNotNullParameter((Object)logManager, (String)"logManager");
        VcsLogData dataProvider = logManager.getDataManager();
        BuildersKt.launch$default((CoroutineScope)this$0.cs, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<BranchRow>)$rows, dataProvider, this$0, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ List<BranchRow> $rows;
            final /* synthetic */ VcsLogData $dataProvider;
            final /* synthetic */ CleanupBranchesDialog this$0;
            {
                this.$rows = $rows;
                this.$dataProvider = $dataProvider;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        HashMap<BranchRow, Long> tsByRow = new HashMap<BranchRow, Long>(this.$rows.size());
                        HashMap<K, V> indexByRow = new HashMap<K, V>(this.$rows.size());
                        ArrayList<Integer> missing = new ArrayList<Integer>();
                        for (BranchRow row : this.$rows) {
                            Hash hash;
                            if (row.getRepository().getBranches().getHash(row.getBranch()) == null) continue;
                            VcsLogStorage vcsLogStorage = this.$dataProvider.getStorage();
                            VirtualFile virtualFile = row.getRepository().getRoot();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                            int index = vcsLogStorage.getCommitIndex(hash, virtualFile);
                            ((Map)indexByRow).put(row, Boxing.boxInt((int)index));
                            VcsCommitMetadata cached = (VcsCommitMetadata)this.$dataProvider.getCommitMetadataCache().getCachedData(index);
                            if (cached != null) {
                                ((Map)tsByRow).put(row, Boxing.boxLong((long)cached.getTimestamp()));
                                continue;
                            }
                            Boxing.boxBoolean((boolean)missing.add(Boxing.boxInt((int)index)));
                        }
                        if (!((Collection)missing).isEmpty()) {
                            try {
                                HashMap<K, V> collected = new HashMap<K, V>(missing.size());
                                this.$dataProvider.getMiniDetailsGetter().loadCommitsDataSynchronously((Iterable)missing, (ProgressIndicator)new EmptyProgressIndicator(), (arg_0, arg_1) -> populateLastCommitDates.1.1.invokeSuspend$lambda$0(collected, arg_0, arg_1));
                                for (Map.Entry<K, V> entry : ((Map)indexByRow).entrySet()) {
                                    BranchRow row = (BranchRow)entry.getKey();
                                    int idx = ((Number)entry.getValue()).intValue();
                                    Long ts = (Long)collected.get(Boxing.boxInt((int)idx));
                                    if (ts == null) continue;
                                    ((Map)tsByRow).put(row, ts);
                                }
                            }
                            catch (VcsException vcsException) {
                                // empty catch block
                            }
                        }
                        CoroutineContext coroutineContext = com.intellij.openapi.application.CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                        ModalityState modalityState = ModalityState.any();
                        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                        this.L$0 = SpillingKt.nullOutSpilledVariable(tsByRow);
                        this.L$1 = SpillingKt.nullOutSpilledVariable(indexByRow);
                        this.L$2 = SpillingKt.nullOutSpilledVariable(missing);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$rows, tsByRow, null){
                            int label;
                            final /* synthetic */ CleanupBranchesDialog this$0;
                            final /* synthetic */ List<BranchRow> $rows;
                            final /* synthetic */ HashMap<BranchRow, Long> $tsByRow;
                            {
                                this.this$0 = $receiver;
                                this.$rows = $rows;
                                this.$tsByRow = $tsByRow;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (!this.this$0.getContentPane().isShowing()) {
                                            return Unit.INSTANCE;
                                        }
                                        List list = CleanupBranchesDialog.access$getTableModel$p(this.this$0).getItems();
                                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
                                        List currentItems = list;
                                        for (BranchRow row : this.$rows) {
                                            if (!currentItems.contains(row)) continue;
                                            Long l = this.$tsByRow.get(row);
                                            row.setLastCommitDate(l != null ? l : Long.MIN_VALUE);
                                        }
                                        if (CleanupBranchesDialog.access$getTableModel$p(this.this$0).getRowCount() > 0) {
                                            CleanupBranchesDialog.access$getTableModel$p(this.this$0).fireTableRowsUpdated(0, CleanupBranchesDialog.access$getTableModel$p(this.this$0).getRowCount() - 1);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ArrayList missing = (ArrayList)this.L$2;
                        HashMap indexByRow = (HashMap)this.L$1;
                        HashMap tsByRow = (HashMap)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(HashMap $collected, int commitIndex, VcsCommitMetadata details) {
                ((Map)$collected).put(commitIndex, details.getTimestamp());
                return Unit.INSTANCE;
            }
        }), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final CharSequence deleteSelectedBranches$lambda$1(BranchRow it) {
        return it.getBranch().getName();
    }

    private static final Component installHeaderCheckbox$applyHeaderRenderer$lambda$1(JTableHeader $header, CleanupBranchesDialog this$0, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        GridBagConstraints gridBagConstraints;
        JPanel jPanel;
        JPanel $this$installHeaderCheckbox_u24applyHeaderRenderer_u24lambda_u241_u240 = jPanel = new JPanel(new GridBagLayout());
        boolean bl3 = false;
        $this$installHeaderCheckbox_u24applyHeaderRenderer_u24lambda_u241_u240.setOpaque(true);
        $this$installHeaderCheckbox_u24applyHeaderRenderer_u24lambda_u241_u240.setBackground($header.getBackground());
        $this$installHeaderCheckbox_u24applyHeaderRenderer_u24lambda_u241_u240.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        GridBagConstraints gridBagConstraints2 = gridBagConstraints = new GridBagConstraints();
        Component component2 = (Component)this$0.headerCheckBox;
        JPanel jPanel2 = $this$installHeaderCheckbox_u24applyHeaderRenderer_u24lambda_u241_u240;
        boolean bl4 = false;
        $this$installHeaderCheckbox_u24applyHeaderRenderer_u24lambda_u241_u240_u240.anchor = 10;
        Unit unit = Unit.INSTANCE;
        jPanel2.add(component2, gridBagConstraints);
        return jPanel;
    }

    private static final void installHeaderCheckbox$lambda$0(CleanupBranchesDialog this$0, TableModelEvent e) {
        if (e == null) {
            return;
        }
        if (e.getType() == 0 && e.getColumn() != 0 && e.getColumn() != -1) {
            return;
        }
        this$0.updateHeaderCheckboxState();
        this$0.table.getTableHeader().repaint();
    }

    private static final void installHeaderCheckbox$applyHeaderRenderer(CleanupBranchesDialog this$0, JTableHeader header) {
        int viewIndex = this$0.getSelectedColumnViewIndex();
        if (viewIndex >= 0) {
            TableColumn column = header.getColumnModel().getColumn(viewIndex);
            column.setHeaderRenderer((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> CleanupBranchesDialog.installHeaderCheckbox$applyHeaderRenderer$lambda$1(header, this$0, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5));
            this$0.setSelectedColumnMinimalWidth();
        }
    }

    public static final /* synthetic */ Project access$getProject$p(CleanupBranchesDialog $this) {
        return $this.project;
    }

    public static final /* synthetic */ ListTableModel access$getTableModel$p(CleanupBranchesDialog $this) {
        return $this.tableModel;
    }

    public static final /* synthetic */ CoroutineScope access$getCs$p(CleanupBranchesDialog $this) {
        return $this.cs;
    }

    public static final /* synthetic */ int access$getSelectedColumnViewIndex(CleanupBranchesDialog $this) {
        return $this.getSelectedColumnViewIndex();
    }

    public static final /* synthetic */ ThreeStateCheckBox access$getHeaderCheckBox$p(CleanupBranchesDialog $this) {
        return $this.headerCheckBox;
    }

    public static final /* synthetic */ void access$setAllRowsSelected(CleanupBranchesDialog $this, boolean value) {
        $this.setAllRowsSelected(value);
    }

    public static final /* synthetic */ void access$updateHeaderCheckboxState(CleanupBranchesDialog $this) {
        $this.updateHeaderCheckboxState();
    }

    public static final /* synthetic */ void access$installHeaderCheckbox$applyHeaderRenderer(CleanupBranchesDialog this$0, JTableHeader header) {
        CleanupBranchesDialog.installHeaderCheckbox$applyHeaderRenderer(this$0, header);
    }

    public static final /* synthetic */ JBTable access$getTable$p(CleanupBranchesDialog $this) {
        return $this.table;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\r\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f\u0012\u000b\u0010\r\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\tH\u00c6\u0003J\u0010\u0010%\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\fH\u00c6\u0003J\u000e\u0010&\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u00c6\u0003JQ\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u000f\b\u0002\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f2\r\b\u0002\u0010\r\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u00c6\u0001J\u0014\u0010(\u001a\u00020\u00072\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010*\u001a\u00020+H\u00d6\u0081\u0004J\n\u0010,\u001a\u00020\u000bH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0018\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001f\u0010\r\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001d\"\u0004\b\u001f\u0010 \u00a8\u0006-"}, d2={"Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog$BranchRow;", "", "repository", "Lgit4idea/repo/GitRepository;", "branch", "Lgit4idea/GitLocalBranch;", "selected", "", "lastCommitDate", "", "trackedBranch", "", "Lcom/intellij/openapi/util/NlsSafe;", "mergedStatus", "<init>", "(Lgit4idea/repo/GitRepository;Lgit4idea/GitLocalBranch;ZJLjava/lang/String;Ljava/lang/String;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "getBranch", "()Lgit4idea/GitLocalBranch;", "getSelected", "()Z", "setSelected", "(Z)V", "getLastCommitDate", "()J", "setLastCommitDate", "(J)V", "getTrackedBranch", "()Ljava/lang/String;", "getMergedStatus", "setMergedStatus", "(Ljava/lang/String;)V", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class BranchRow {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final GitLocalBranch branch;
        private boolean selected;
        private long lastCommitDate;
        @Nullable
        private final String trackedBranch;
        @NotNull
        private String mergedStatus;

        public BranchRow(@NotNull GitRepository repository2, @NotNull GitLocalBranch branch, boolean selected, long lastCommitDate, @Nullable String trackedBranch, @NotNull String mergedStatus) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
            Intrinsics.checkNotNullParameter((Object)mergedStatus, (String)"mergedStatus");
            this.repository = repository2;
            this.branch = branch;
            this.selected = selected;
            this.lastCommitDate = lastCommitDate;
            this.trackedBranch = trackedBranch;
            this.mergedStatus = mergedStatus;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final GitLocalBranch getBranch() {
            return this.branch;
        }

        public final boolean getSelected() {
            return this.selected;
        }

        public final void setSelected(boolean bl) {
            this.selected = bl;
        }

        public final long getLastCommitDate() {
            return this.lastCommitDate;
        }

        public final void setLastCommitDate(long l) {
            this.lastCommitDate = l;
        }

        @Nullable
        public final String getTrackedBranch() {
            return this.trackedBranch;
        }

        @NotNull
        public final String getMergedStatus() {
            return this.mergedStatus;
        }

        public final void setMergedStatus(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.mergedStatus = string;
        }

        @NotNull
        public final GitRepository component1() {
            return this.repository;
        }

        @NotNull
        public final GitLocalBranch component2() {
            return this.branch;
        }

        public final boolean component3() {
            return this.selected;
        }

        public final long component4() {
            return this.lastCommitDate;
        }

        @Nullable
        public final String component5() {
            return this.trackedBranch;
        }

        @NotNull
        public final String component6() {
            return this.mergedStatus;
        }

        @NotNull
        public final BranchRow copy(@NotNull GitRepository repository2, @NotNull GitLocalBranch branch, boolean selected, long lastCommitDate, @Nullable String trackedBranch, @NotNull String mergedStatus) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
            Intrinsics.checkNotNullParameter((Object)mergedStatus, (String)"mergedStatus");
            return new BranchRow(repository2, branch, selected, lastCommitDate, trackedBranch, mergedStatus);
        }

        public static /* synthetic */ BranchRow copy$default(BranchRow branchRow, GitRepository gitRepository, GitLocalBranch gitLocalBranch, boolean bl, long l, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                gitRepository = branchRow.repository;
            }
            if ((n & 2) != 0) {
                gitLocalBranch = branchRow.branch;
            }
            if ((n & 4) != 0) {
                bl = branchRow.selected;
            }
            if ((n & 8) != 0) {
                l = branchRow.lastCommitDate;
            }
            if ((n & 0x10) != 0) {
                string = branchRow.trackedBranch;
            }
            if ((n & 0x20) != 0) {
                string2 = branchRow.mergedStatus;
            }
            return branchRow.copy(gitRepository, gitLocalBranch, bl, l, string, string2);
        }

        @NotNull
        public String toString() {
            return "BranchRow(repository=" + this.repository + ", branch=" + this.branch + ", selected=" + this.selected + ", lastCommitDate=" + this.lastCommitDate + ", trackedBranch=" + this.trackedBranch + ", mergedStatus=" + this.mergedStatus + ")";
        }

        public int hashCode() {
            int result2 = this.repository.hashCode();
            result2 = result2 * 31 + this.branch.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.selected);
            result2 = result2 * 31 + Long.hashCode(this.lastCommitDate);
            result2 = result2 * 31 + (this.trackedBranch == null ? 0 : this.trackedBranch.hashCode());
            result2 = result2 * 31 + this.mergedStatus.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BranchRow)) {
                return false;
            }
            BranchRow branchRow = (BranchRow)other;
            if (!Intrinsics.areEqual((Object)this.repository, (Object)branchRow.repository)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.branch, (Object)branchRow.branch)) {
                return false;
            }
            if (this.selected != branchRow.selected) {
                return false;
            }
            if (this.lastCommitDate != branchRow.lastCommitDate) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.trackedBranch, (Object)branchRow.trackedBranch)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.mergedStatus, (Object)branchRow.mergedStatus);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog$CalculateMergeStatusAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isDumbAware", "", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    public final class CalculateMergeStatusAction
    extends AnAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isDumbAware() {
            return true;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            CleanupBranchesDialog.this.calculateMergeStatus();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog$DeleteBranchesAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isDumbAware", "", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    public final class DeleteBranchesAction
    extends AnAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isDumbAware() {
            return true;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            CleanupBranchesDialog.this.deleteSelectedBranches();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ\f\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016\u00a8\u0006\u000b"}, d2={"Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog$LastCommitDateColumn;", "Lcom/intellij/util/ui/ColumnInfo;", "Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog$BranchRow;", "", "<init>", "()V", "valueOf", "item", "(Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog$BranchRow;)Ljava/lang/Long;", "getColumnClass", "Ljava/lang/Class;", "intellij.vcs.git"})
    private static final class LastCommitDateColumn
    extends ColumnInfo<BranchRow, Long> {
        public LastCommitDateColumn() {
            super(GitBundle.message("git.cleanup.branches.col.last.commit", new Object[0]));
        }

        @NotNull
        public Long valueOf(@NotNull BranchRow item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return item.getLastCommitDate();
        }

        @NotNull
        public Class<?> getColumnClass() {
            return Long.TYPE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog$MergedStatusColumn;", "Lcom/intellij/util/ui/ColumnInfo;", "Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog$BranchRow;", "", "<init>", "()V", "valueOf", "item", "intellij.vcs.git"})
    private static final class MergedStatusColumn
    extends ColumnInfo<BranchRow, String> {
        public MergedStatusColumn() {
            super(GitBundle.message("git.cleanup.branches.col.merged.status", new Object[0]));
        }

        @NotNull
        public String valueOf(@NotNull BranchRow item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return item.getMergedStatus();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog$NameColumn;", "Lcom/intellij/util/ui/ColumnInfo;", "Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog$BranchRow;", "", "<init>", "()V", "valueOf", "item", "intellij.vcs.git"})
    private static final class NameColumn
    extends ColumnInfo<BranchRow, String> {
        public NameColumn() {
            super(GitBundle.message("git.cleanup.branches.col.name", new Object[0]));
        }

        @NotNull
        public String valueOf(@NotNull BranchRow item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return item.getBranch().getName();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ\f\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u0012\u0010\u000b\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog$SelectedColumn;", "Lcom/intellij/util/ui/ColumnInfo;", "Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog$BranchRow;", "", "<init>", "()V", "valueOf", "item", "(Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog$BranchRow;)Ljava/lang/Boolean;", "getColumnClass", "Ljava/lang/Class;", "isCellEditable", "setValue", "", "value", "getComparator", "Ljava/util/Comparator;", "intellij.vcs.git"})
    private static final class SelectedColumn
    extends ColumnInfo<BranchRow, Boolean> {
        public SelectedColumn() {
            super(GitBundle.message("git.cleanup.branches.col.selected", new Object[0]));
        }

        @NotNull
        public Boolean valueOf(@NotNull BranchRow item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return item.getSelected();
        }

        @NotNull
        public Class<?> getColumnClass() {
            return Boolean.TYPE;
        }

        public boolean isCellEditable(@Nullable BranchRow item) {
            return true;
        }

        public void setValue(@NotNull BranchRow item, boolean value) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            item.setSelected(value);
        }

        @NotNull
        public Comparator<BranchRow> getComparator() {
            return new Comparator(){

                public final int compare(T a, T b) {
                    BranchRow it = (BranchRow)a;
                    boolean bl = false;
                    Comparable comparable = Boolean.valueOf(it.getSelected());
                    it = (BranchRow)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(it.getSelected()));
                }
            };
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog$TrackedBranchColumn;", "Lcom/intellij/util/ui/ColumnInfo;", "Lgit4idea/ui/branch/cleanup/CleanupBranchesDialog$BranchRow;", "", "<init>", "()V", "valueOf", "item", "intellij.vcs.git"})
    private static final class TrackedBranchColumn
    extends ColumnInfo<BranchRow, String> {
        public TrackedBranchColumn() {
            super(GitBundle.message("git.cleanup.branches.col.tracked", new Object[0]));
        }

        @NotNull
        public String valueOf(@NotNull BranchRow item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            String string = item.getTrackedBranch();
            if (string == null) {
                string = "";
            }
            return string;
        }
    }
}

