/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.codeInsight.controlflow.CallInstruction;
import com.jetbrains.python.codeInsight.controlflow.FlowContext;
import com.jetbrains.python.codeInsight.controlflow.PyControlFlow;
import com.jetbrains.python.codeInsight.controlflow.PyUnreachableInstruction;
import com.jetbrains.python.codeInsight.controlflow.PyWithContextExitInstruction;
import com.jetbrains.python.codeInsight.controlflow.Reachability;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.psi.types.PyNeverType;
import com.jetbrains.python.psi.types.PyType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J+\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0012J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJF\u0010\u001b\u001a:\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u000f0\u000f \u001c*\u001c\u0012\u000e\b\u0001\u0012\n \u001c*\u0004\u0018\u00010\u000f0\u000f0\t\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b\u001e0\t\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b\u001eH\u0096\u0001\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/jetbrains/python/codeInsight/controlflow/PyDataFlow;", "Lcom/intellij/codeInsight/controlflow/ControlFlow;", "controlFlow", "Lcom/jetbrains/python/codeInsight/controlflow/PyControlFlow;", "context", "Lcom/jetbrains/python/codeInsight/controlflow/FlowContext;", "<init>", "(Lcom/jetbrains/python/codeInsight/controlflow/PyControlFlow;Lcom/jetbrains/python/codeInsight/controlflow/FlowContext;)V", "reachability", "", "Lcom/jetbrains/python/codeInsight/controlflow/Reachability;", "[Lcom/jetbrains/python/codeInsight/controlflow/Reachability;", "computeReachability", "", "instructions", "Lcom/intellij/codeInsight/controlflow/Instruction;", "includeUnreachableForTypeChecking", "", "([Lcom/intellij/codeInsight/controlflow/Instruction;ZLcom/jetbrains/python/codeInsight/controlflow/FlowContext;)[Z", "getReachableSuccessors", "", "instruction", "getReachability", "getInstruction", "", "element", "Lcom/intellij/psi/PsiElement;", "getInstructions", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "()[Lcom/intellij/codeInsight/controlflow/Instruction;", "intellij.python.psi.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPyDataFlow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDataFlow.kt\ncom/jetbrains/python/codeInsight/controlflow/PyDataFlow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n777#2:203\n873#2,2:204\n*S KotlinDebug\n*F\n+ 1 PyDataFlow.kt\ncom/jetbrains/python/codeInsight/controlflow/PyDataFlow\n*L\n81#1:203\n81#1:204,2\n*E\n"})
public final class PyDataFlow
implements ControlFlow {
    @NotNull
    private final PyControlFlow controlFlow;
    @NotNull
    private final Reachability[] reachability;

    public PyDataFlow(@NotNull PyControlFlow controlFlow, @NotNull FlowContext context) {
        Intrinsics.checkNotNullParameter((Object)controlFlow, (String)"controlFlow");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.controlFlow = controlFlow;
        Instruction[] instructionArray = this.getInstructions();
        Intrinsics.checkNotNullExpressionValue((Object)instructionArray, (String)"getInstructions(...)");
        boolean[] reachabilityStrict = this.computeReachability(instructionArray, false, context);
        Instruction[] instructionArray2 = this.getInstructions();
        Intrinsics.checkNotNullExpressionValue((Object)instructionArray2, (String)"getInstructions(...)");
        boolean[] reachabilitySoft = this.computeReachability(instructionArray2, true, context);
        int n = this.getInstructions().length;
        Reachability[] reachabilityArray = new Reachability[n];
        PyDataFlow pyDataFlow = this;
        for (int i = 0; i < n; ++i) {
            Reachability reachability;
            int n2 = i;
            if (reachabilityStrict[n2]) {
                boolean bl = reachabilitySoft[n2];
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                reachability = Reachability.REACHABLE;
            } else {
                reachability = reachabilitySoft[n2] ? Reachability.UNREACHABLE_FOR_TYPE_CHECKING : Reachability.UNREACHABLE;
            }
            reachabilityArray[n2] = reachability;
        }
        pyDataFlow.reachability = reachabilityArray;
    }

    private final boolean[] computeReachability(Instruction[] instructions, boolean includeUnreachableForTypeChecking, FlowContext context) {
        boolean[] reachability = new boolean[instructions.length];
        ArrayDeque<Instruction> stack = new ArrayDeque<Instruction>();
        stack.push(instructions[0]);
        while (!((Collection)stack).isEmpty()) {
            Instruction instruction = (Instruction)stack.pop();
            int instructionNum = instruction.num();
            if (reachability[instructionNum]) continue;
            reachability[instructionNum] = true;
            Intrinsics.checkNotNull((Object)instruction);
            for (Instruction successor : this.getReachableSuccessors(instruction, includeUnreachableForTypeChecking, context)) {
                if (reachability[successor.num()]) continue;
                stack.push(successor);
            }
        }
        return reachability;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Instruction> getReachableSuccessors(Instruction instruction, boolean includeUnreachableForTypeChecking, FlowContext context) {
        void $this$filterTo$iv$iv;
        if (context.getCheckNoReturnCalls() && instruction instanceof CallInstruction && ((CallInstruction)instruction).isNoReturnCall(context.getTypeEvalContext())) {
            return CollectionsKt.emptyList();
        }
        if (instruction instanceof PyWithContextExitInstruction && !((PyWithContextExitInstruction)instruction).isSuppressingExceptions(context.getTypeEvalContext())) {
            return CollectionsKt.emptyList();
        }
        Collection collection = instruction.allSucc();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"allSucc(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Ref<PyType> type;
            Instruction it = (Instruction)element$iv$iv;
            boolean bl = false;
            boolean bl2 = it instanceof PyUnreachableInstruction ? includeUnreachableForTypeChecking && ((PyUnreachableInstruction)it).isUnreachableForTypeChecking() : (it instanceof ReadWriteInstruction && ((ReadWriteInstruction)it).getAccess().isAssertTypeAccess() ? (type = ((ReadWriteInstruction)it).getType(context.getTypeEvalContext(), null)) == null || !(type.get() instanceof PyNeverType) : true);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Reachability getReachability(@NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        if (instruction.num() >= this.reachability.length) {
            return Reachability.REACHABLE;
        }
        return this.reachability[instruction.num()];
    }

    public final int getInstruction(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.controlFlow.getInstruction(element);
    }

    @NotNull
    public Instruction[] getInstructions() {
        return this.controlFlow.getInstructions();
    }
}

