/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyConvertToRawStringQuickFix;
import com.jetbrains.python.inspections.quickfix.PyEscapeBackslashQuickFix;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyStringLiteralDecoder;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/inspections/PyInvalidEscapeSequenceInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.psi.impl"})
public final class PyInvalidEscapeSequenceInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return (PsiElementVisitor)new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/python/inspections/PyInvalidEscapeSequenceInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPyStringLiteralExpression", "", "node", "Lcom/jetbrains/python/psi/PyStringLiteralExpression;", "processString", "element", "Lcom/jetbrains/python/psi/PyStringElement;", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyInvalidEscapeSequenceInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyInvalidEscapeSequenceInspection.kt\ncom/jetbrains/python/inspections/PyInvalidEscapeSequenceInspection$Visitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1915#2,2:93\n1#3:95\n*S KotlinDebug\n*F\n+ 1 PyInvalidEscapeSequenceInspection.kt\ncom/jetbrains/python/inspections/PyInvalidEscapeSequenceInspection$Visitor\n*L\n29#1:93,2\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            List list = node.getStringElements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStringElements(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyStringElement it = (PyStringElement)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                this.processString(it, node);
            }
        }

        private final void processString(PyStringElement element, PyStringLiteralExpression node) {
            Sequence sequence;
            String string = element.getPrefix();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrefix(...)");
            if (StringsKt.contains((CharSequence)string, (CharSequence)"r", (boolean)true)) {
                return;
            }
            String string2 = element.getContentRange().substring(element.getText());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String content = string2;
            int offsetInNode = element.getTextRange().getStartOffset() + element.getContentRange().getStartOffset() - node.getTextRange().getStartOffset();
            if (element instanceof PyFormattedStringElement) {
                List list = ((PyFormattedStringElement)element).getLiteralPartRanges();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLiteralPartRanges(...)");
                sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), arg_0 -> Visitor.processString$lambda$0(element, arg_0));
            } else {
                sequence = SequencesKt.sequenceOf((Object)new TextRange(0, content.length()));
            }
            Sequence fstringRanges = sequence;
            Iterator validEscapes = SequencesKt.flatMap((Sequence)fstringRanges, arg_0 -> Visitor.processString$lambda$1(content, arg_0)).iterator();
            boolean hasValidEscapes = validEscapes.hasNext();
            IntRange curValidEscape = hasValidEscapes ? (IntRange)validEscapes.next() : null;
            for (TextRange range : fstringRanges) {
                int charIndex = 0;
                charIndex = range.getStartOffset();
                while (charIndex < range.getEndOffset() - 1) {
                    LocalQuickFix[] fixes;
                    if (content.charAt(charIndex) != '\\') {
                        int n = charIndex;
                        charIndex = n + 1;
                        continue;
                    }
                    while (true) {
                        boolean bl;
                        if (curValidEscape != null) {
                            IntRange it;
                            boolean bl2 = false;
                            bl = it.getLast() < charIndex;
                        } else {
                            bl = false;
                        }
                        if (!bl) break;
                        curValidEscape = validEscapes.hasNext() ? (IntRange)validEscapes.next() : null;
                    }
                    IntRange intRange = curValidEscape;
                    boolean bl = intRange != null ? intRange.contains(charIndex) : false;
                    if (bl) {
                        charIndex = curValidEscape.getLast() + 1;
                        continue;
                    }
                    int problemOffset = offsetInNode + charIndex;
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new PyEscapeBackslashQuickFix(problemOffset), !hasValidEscapes ? new PyConvertToRawStringQuickFix(problemOffset) : null};
                    Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.notNullElements((LocalQuickFix[])localQuickFixArray), (String)"notNullElements(...)");
                    Object[] objectArray = new Object[]{"\\" + content.charAt(charIndex + 1)};
                    this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.invalid.escape.sequence", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, new TextRange(problemOffset, problemOffset + 2), Arrays.copyOf(fixes, fixes.length));
                    charIndex += 2;
                }
            }
        }

        private static final boolean processString$lambda$1$0(TextRange $range, MatchResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getRange().getLast() < $range.getEndOffset();
        }

        private static final IntRange processString$lambda$1$1(MatchResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getRange();
        }

        private static final TextRange processString$lambda$0(PyStringElement $element, TextRange it) {
            return it.shiftLeft(((PyFormattedStringElement)$element).getContentRange().getStartOffset());
        }

        private static final Sequence processString$lambda$1(String $content, TextRange range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Pattern pattern = PyStringLiteralDecoder.PATTERN_ESCAPE;
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"PATTERN_ESCAPE");
            Pattern pattern2 = pattern;
            return SequencesKt.map((Sequence)SequencesKt.takeWhile((Sequence)new Regex(pattern2).findAll((CharSequence)$content, range.getStartOffset()), arg_0 -> Visitor.processString$lambda$1$0(range, arg_0)), Visitor::processString$lambda$1$1);
        }
    }
}

